/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class ExtendsActionItem
extends ActionItem {
    public GraphTargetItem subclass;
    public GraphTargetItem superclass;

    public ExtendsActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem subclass, GraphTargetItem superclass) {
        super(instruction, lineStartIns, 0);
        this.subclass = subclass;
        this.superclass = superclass;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.subclass.toString(writer, localData);
        writer.append(" extends ");
        return this.stripQuotes(this.superclass, localData, writer);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.subclass.getNeededSources());
        ret.addAll(this.superclass.getNeededSources());
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.subclass);
        hash = 29 * hash + Objects.hashCode(this.superclass);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendsActionItem other = (ExtendsActionItem)obj;
        if (!Objects.equals(this.subclass, other.subclass)) {
            return false;
        }
        return Objects.equals(this.superclass, other.superclass);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendsActionItem other = (ExtendsActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.subclass, other.subclass)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.superclass, other.superclass);
    }
}

