/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionGetProperty;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class GetPropertyActionItem
extends ActionItem {
    public GraphTargetItem target;
    public int propertyIndex;
    public boolean useGetPropertyFunction = true;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.target);
    }

    public GetPropertyActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem target, int propertyIndex) {
        super(instruction, lineStartIns, 0);
        this.target = target;
        this.propertyIndex = propertyIndex;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.isEmptyString(this.target)) {
            return writer.append(Action.propertyNames[this.propertyIndex]);
        }
        writer.append("getProperty");
        writer.spaceBeforeCallParenthesis(2);
        writer.append("(");
        this.target.toString(writer, localData);
        writer.append(", ");
        writer.append(Action.propertyNames[this.propertyIndex]);
        writer.append(")");
        return writer;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.target);
        hash = 79 * hash + this.propertyIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetPropertyActionItem other = (GetPropertyActionItem)obj;
        if (this.propertyIndex != other.propertyIndex) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetPropertyActionItem other = (GetPropertyActionItem)obj;
        if (this.propertyIndex != other.propertyIndex) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.target, other.target);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.target.getNeededSources());
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        String charset = asGenerator.getCharset();
        return GetPropertyActionItem.toSourceMerge(localData, generator, this.target, new ActionPush(this.propertyIndex, charset), new ActionGetProperty());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

