/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionTypeOf;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class TypeOfActionItem
extends ActionItem {
    public TypeOfActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value) {
        super(instruction, lineStartIns, 2, value);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("typeof ");
        writer.spaceBeforeCallParenthesis(1);
        if (this.value.getPrecedence() > this.getPrecedence()) {
            writer.append("(");
        }
        this.value.toString(writer, localData);
        if (this.value.getPrecedence() > this.getPrecedence()) {
            writer.append(")");
        }
        return writer;
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public Object getResult() {
        return TypeOfActionItem.getResult(this.value.getResult());
    }

    public static String getResult(Object obj) {
        Object res = obj;
        EcmaType type = EcmaScript.type(res);
        switch (type) {
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case NUMBER: {
                return "number";
            }
            case OBJECT: {
                return "object";
            }
            case UNDEFINED: {
                return "undefined";
            }
            case NULL: {
                return "null";
            }
        }
        return "object";
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        if (!(this.value instanceof SimpleValue) || !((SimpleValue)((Object)this.value)).isSimpleValue()) {
            dependencies.add(this.value);
        }
        return this.value.isCompileTime(dependencies);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return TypeOfActionItem.toSourceMerge(localData, generator, this.value, new ActionTypeOf());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphTargetItem other = (GraphTargetItem)obj;
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphTargetItem other = obj;
        return GraphTargetItem.objectsValueEquals(this.value, other.value);
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }
}

