/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.amf.amf3.types;

import com.jpexs.decompiler.flash.amf.amf3.ListMap;
import com.jpexs.decompiler.flash.amf.amf3.Traits;
import com.jpexs.decompiler.flash.amf.amf3.WithSubValues;
import com.jpexs.decompiler.flash.amf.amf3.types.Amf3ValueType;
import com.jpexs.decompiler.flash.exporters.amf.amf3.Amf3Exporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectType
implements WithSubValues,
Amf3ValueType,
Map<String, Object> {
    private Map<String, Object> sealedMembers;
    private Map<String, Object> dynamicMembers;
    private Map<String, Object> serializedMembers;
    private byte[] serializedData = null;
    private boolean serialized;
    private Traits traits;

    public boolean isSerialized() {
        return this.serialized;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public ObjectType(Traits traits, byte[] serializedData, Map<String, Object> serializedMembers) {
        this.traits = traits;
        this.serializedData = serializedData;
        this.serializedMembers = new ListMap<String, Object>(serializedMembers);
        this.dynamicMembers = new ListMap<String, Object>();
        this.sealedMembers = new ListMap<String, Object>();
        this.serialized = true;
    }

    public ObjectType(Traits traits) {
        this(traits, new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    public ObjectType(Traits traits, Map<String, Object> sealedMembers, Map<String, Object> dynamicMembers) {
        this.sealedMembers = new ListMap<String, Object>(sealedMembers);
        this.dynamicMembers = new ListMap<String, Object>(dynamicMembers);
        this.serializedMembers = new ListMap<String, Object>();
        this.serialized = false;
        this.traits = traits;
    }

    public boolean isDynamic() {
        return this.traits.isDynamic();
    }

    public String getClassName() {
        return this.traits.getClassName();
    }

    @Override
    public List<Object> getSubValues() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.addAll(this.dynamicMembers.keySet());
        ret.addAll(this.dynamicMembers.values());
        ret.addAll(this.sealedMembers.keySet());
        ret.addAll(this.sealedMembers.values());
        ret.addAll(this.serializedMembers.keySet());
        ret.addAll(this.serializedMembers.values());
        return ret;
    }

    public String toString() {
        return Amf3Exporter.amfToString(this);
    }

    public void setSerializedData(byte[] serializedData) {
        this.serializedData = serializedData;
    }

    public byte[] getSerializedData() {
        return this.serializedData;
    }

    public void setSerializedMembers(Map<String, Object> serializedMembers) {
        this.serializedMembers = new ListMap<String, Object>(serializedMembers);
    }

    public Map<String, Object> getSerializedMembers() {
        return new ListMap<String, Object>(this.serializedMembers);
    }

    public void setSealedMembers(Map<String, Object> sealedMembers) {
        this.sealedMembers = new ListMap<String, Object>(sealedMembers);
    }

    public void setDynamicMembers(Map<String, Object> dynamicMembers) {
        this.dynamicMembers = new ListMap<String, Object>(dynamicMembers);
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    public int sealedMembersSize() {
        return this.sealedMembers.size();
    }

    public int dynamicMembersSize() {
        return this.dynamicMembers.size();
    }

    public int serializedMembersSize() {
        return this.serializedMembers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dynamicMembers.isEmpty() && this.sealedMembers.isEmpty() && this.serializedMembers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        String keyString = (String)key;
        return this.containsDynamicMember(keyString) || this.containsSealedMember(keyString) || this.containsSerializedMember(keyString);
    }

    public boolean containsSealedMember(String name) {
        return this.sealedMembers.containsKey(name);
    }

    public boolean containsDynamicMember(String name) {
        return this.dynamicMembers.containsKey(name);
    }

    public boolean containsSerializedMember(String name) {
        return this.serializedMembers.containsKey(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dynamicMembers.containsValue(value) || this.sealedMembers.containsValue(value) || this.serializedMembers.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String stringKey = (String)key;
        if (this.dynamicMembers.containsKey(stringKey)) {
            return this.dynamicMembers.get(stringKey);
        }
        if (this.sealedMembers.containsKey(stringKey)) {
            return this.sealedMembers.get(stringKey);
        }
        if (this.serializedMembers.containsKey(stringKey)) {
            return this.serializedMembers.get(stringKey);
        }
        return null;
    }

    public Object getSealedMember(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String stringKey = (String)key;
        return this.sealedMembers.get(stringKey);
    }

    public Object getDynamicMember(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String stringKey = (String)key;
        return this.dynamicMembers.get(stringKey);
    }

    public Object getSerializedMember(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String stringKey = (String)key;
        return this.serializedMembers.get(stringKey);
    }

    @Override
    public Object put(String key, Object value) {
        return this.putDynamicMember(key, value);
    }

    public Object putDynamicMember(String key, Object value) {
        this.remove(key);
        return this.dynamicMembers.put(key, value);
    }

    public Object putSealedMember(String key, Object value) {
        this.remove(key);
        return this.sealedMembers.put(key, value);
    }

    public Object putSerializedMember(String key, Object value) {
        this.remove(key);
        return this.serializedMembers.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String stringKey = (String)key;
        if (this.dynamicMembers.containsKey(stringKey)) {
            return this.dynamicMembers.remove(stringKey);
        }
        if (this.sealedMembers.containsKey(stringKey)) {
            return this.sealedMembers.remove(stringKey);
        }
        if (this.serializedMembers.containsKey(stringKey)) {
            return this.serializedMembers.remove(stringKey);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void putAllDynamicMember(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.putDynamicMember(e.getKey(), e.getValue());
        }
    }

    public void putAllSealedMember(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.putSealedMember(e.getKey(), e.getValue());
        }
    }

    public void putAllSerializedMember(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> e : m.entrySet()) {
            this.putSerializedMember(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.clearDynamicMembers();
        this.clearSealedMembers();
        this.clearSerializedMembers();
    }

    public void clearDynamicMembers() {
        this.dynamicMembers.clear();
    }

    public void clearSealedMembers() {
        this.sealedMembers.clear();
    }

    public void clearSerializedMembers() {
        this.serializedMembers.clear();
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        ret.addAll(this.sealedMembers.keySet());
        ret.addAll(this.dynamicMembers.keySet());
        ret.addAll(this.serializedMembers.keySet());
        return ret;
    }

    public Set<String> sealedMembersKeySet() {
        return new LinkedHashSet<String>(this.sealedMembers.keySet());
    }

    public Set<String> dynamicMembersKeySet() {
        return new LinkedHashSet<String>(this.dynamicMembers.keySet());
    }

    public Set<String> serializedMembersKeySet() {
        return new LinkedHashSet<String>(this.serializedMembers.keySet());
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        Set<String> keys = this.keySet();
        for (String key : keys) {
            if (this.dynamicMembers.containsKey(key)) {
                values.add(this.dynamicMembers.get(key));
                continue;
            }
            if (this.sealedMembers.containsKey(key)) {
                values.add(this.sealedMembers.get(key));
                continue;
            }
            values.add(this.serializedMembers.get(key));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<String> keys = this.keySet();
        LinkedHashSet<Map.Entry<String, Object>> ret = new LinkedHashSet<Map.Entry<String, Object>>();
        for (String key : keys) {
            ret.add(new ListMap.MyEntry<String, Object>(key, this.get(key)));
        }
        return ret;
    }
}

