/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import java.io.File;
import java.util.Locale;

public class AppDirectoryProvider {
    private static final File UNSPECIFIED_FILE;
    private static File directory;

    private static OSId getOSId() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0) {
            return OSId.OSX;
        }
        if (OS.indexOf("win") >= 0) {
            return OSId.WINDOWS;
        }
        return OSId.UNIX;
    }

    public static String getFFDecHome() {
        String ret;
        if (directory == UNSPECIFIED_FILE) {
            directory = null;
            String userHome = null;
            try {
                userHome = System.getProperty("user.home");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (userHome != null) {
                String applicationId = "FFDec";
                OSId osId = AppDirectoryProvider.getOSId();
                if (osId == OSId.WINDOWS) {
                    File appDataDir = null;
                    try {
                        String appDataEV = System.getenv("APPDATA");
                        if (appDataEV != null && appDataEV.length() > 0) {
                            appDataDir = new File(appDataEV);
                        }
                    }
                    catch (SecurityException appDataEV) {
                        // empty catch block
                    }
                    String vendorId = "JPEXS";
                    if (appDataDir != null && appDataDir.isDirectory()) {
                        String path = vendorId + "\\" + applicationId + "\\";
                        directory = new File(appDataDir, path);
                    } else {
                        String path = "Application Data\\" + vendorId + "\\" + applicationId + "\\";
                        directory = new File(userHome, path);
                    }
                } else if (osId == OSId.OSX) {
                    String path = "Library/Application Support/" + applicationId + "/";
                    directory = new File(userHome, path);
                } else {
                    String path;
                    File xdgConfigHome = null;
                    File oldConfigDir = new File(userHome, "." + applicationId + "/");
                    try {
                        String xdgConfigHomeEV = System.getenv("XDG_CONFIG_HOME");
                        if (xdgConfigHomeEV != null && xdgConfigHomeEV.length() > 0) {
                            xdgConfigHome = new File(xdgConfigHomeEV);
                        }
                    }
                    catch (SecurityException xdgConfigHomeEV) {
                        // empty catch block
                    }
                    if (xdgConfigHome != null && xdgConfigHome.isDirectory()) {
                        path = applicationId + "/";
                        directory = new File(xdgConfigHome, path);
                    } else if (oldConfigDir.isDirectory()) {
                        directory = oldConfigDir;
                    } else {
                        path = ".config/" + applicationId + "/";
                        directory = new File(userHome, path);
                    }
                }
            } else {
                directory = new File(".");
            }
        }
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            directory = new File(".");
        }
        if (!(ret = directory.getAbsolutePath()).endsWith(File.separator)) {
            ret = ret + File.separator;
        }
        return ret;
    }

    static {
        directory = UNSPECIFIED_FILE = new File("unspecified");
    }

    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }
}

