/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.AppDirectoryProvider;
import com.jpexs.decompiler.flash.configuration.ConfigurationCategory;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultBoolean;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultCalendar;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultColor;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultDouble;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultInt;
import com.jpexs.decompiler.flash.configuration.ConfigurationDefaultString;
import com.jpexs.decompiler.flash.configuration.ConfigurationDirectory;
import com.jpexs.decompiler.flash.configuration.ConfigurationFile;
import com.jpexs.decompiler.flash.configuration.ConfigurationInternal;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationName;
import com.jpexs.decompiler.flash.configuration.ConfigurationRemoved;
import com.jpexs.decompiler.flash.configuration.ConfigurationStorage;
import com.jpexs.decompiler.flash.configuration.LegacyConfigurationStorage;
import com.jpexs.decompiler.flash.configuration.SwfSpecificConfiguration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.configuration.TomlConfigurationStorage;
import com.jpexs.decompiler.flash.configuration.enums.GridSnapAccuracy;
import com.jpexs.decompiler.flash.configuration.enums.GuidesSnapAccuracy;
import com.jpexs.decompiler.flash.exporters.modes.ExeExportMode;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.FontHelper;
import com.jpexs.decompiler.flash.importers.TextImportResizeTextBoundsMode;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Configuration {
    private static final ConfigurationStorage legacyStorage = new LegacyConfigurationStorage();
    private static final ConfigurationStorage storage = new TomlConfigurationStorage();
    public static final Level logLevel;
    public static boolean showStat;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> openMultipleFiles;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> decompile;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="decompilation")
    public static ConfigurationItem<Boolean> parallelSpeedUp;
    @ConfigurationDefaultInt(value=0)
    @ConfigurationCategory(value="decompilation")
    public static ConfigurationItem<Integer> parallelSpeedUpThreadCount;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoDeobfuscate;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="")
    public static ConfigurationItem<Boolean> cacheOnDisk;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="")
    public static ConfigurationItem<Boolean> cacheImages;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    @ConfigurationRemoved
    public static ConfigurationItem<Boolean> useAdobeFlashPlayerForPreviews;
    @ConfigurationDefaultInt(value=1000)
    @ConfigurationCategory(value="display")
    @ConfigurationRemoved
    public static ConfigurationItem<Integer> setMovieDelay;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> dumpView;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> useHexColorFormat;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> showOldTextDuringTextEditing;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> gotoMainClassOnStartup;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoRenameIdentifiers;
    @ConfigurationDefaultBoolean(value=false)
    public static ConfigurationItem<Boolean> offeredAssociation;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> decimalAddress;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> showAllAddresses;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> useFrameCache;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> useRibbonInterface;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> overwriteExistingFiles;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> openFolderAfterFlaExport;
    @ConfigurationCategory(value="export")
    @ConfigurationDefaultString(value="")
    public static ConfigurationItem<String> overrideTextExportFileName;
    @ConfigurationDefaultBoolean(value=false)
    public static ConfigurationItem<Boolean> useDetailedLogging;
    @ConfigurationDefaultBoolean(value=true)
    public static ConfigurationItem<Boolean> warningOpeningReadOnly;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> _debugMode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> _showDebugMenu;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> resolveConstants;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> showFileOffsetInPcodeHex;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> showOriginalBytesInPcodeHex;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Boolean> padAs3PCodeInstructionName;
    @ConfigurationDefaultInt(value=500)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> sublimiter;
    @ConfigurationDefaultInt(value=1800)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> exportTimeout;
    @ConfigurationDefaultInt(value=300)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> decompilationTimeoutFile;
    @ConfigurationDefaultInt(value=10000)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> as12DeobfuscatorExecutionLimit;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> paramNamesEnable;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> displayFileName;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> _debugCopy;
    @ConfigurationDefaultBoolean(value=false)
    public static ConfigurationItem<Boolean> dumpTags;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> setFFDecVersionInExportedFont;
    @ConfigurationDefaultInt(value=60)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> decompilationTimeoutSingleMethod;
    @ConfigurationDefaultInt(value=1)
    public static ConfigurationItem<Integer> lastRenameType;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static ConfigurationItem<String> lastSaveDir;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static ConfigurationItem<String> lastOpenDir;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static ConfigurationItem<String> lastExportDir;
    @ConfigurationDefaultString(value="en")
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<String> locale;
    @ConfigurationDefaultString(value="_loc%d_")
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<String> registerNameFormat;
    @ConfigurationDefaultInt(value=15)
    public static ConfigurationItem<Integer> maxRecentFileCount;
    public static ConfigurationItem<String> recentFiles;
    public static ConfigurationItem<HashMap<String, String>> fontPairingMap;
    public static ConfigurationItem<HashMap<String, SwfSpecificConfiguration>> swfSpecificConfigs;
    public static ConfigurationItem<HashMap<String, SwfSpecificCustomConfiguration>> swfSpecificCustomConfigs;
    @ConfigurationDefaultCalendar(value=0L)
    public static ConfigurationItem<Calendar> lastUpdatesCheckDate;
    @ConfigurationDefaultInt(value=1000)
    @ConfigurationName(value="gui.window.width")
    public static ConfigurationItem<Integer> guiWindowWidth;
    @ConfigurationDefaultInt(value=700)
    @ConfigurationName(value="gui.window.height")
    public static ConfigurationItem<Integer> guiWindowHeight;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="gui.window.maximized.horizontal")
    public static ConfigurationItem<Boolean> guiWindowMaximizedHorizontal;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="gui.window.maximized.vertical")
    public static ConfigurationItem<Boolean> guiWindowMaximizedVertical;
    @ConfigurationDefaultDouble(value=1.0)
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="gui.fontSizeMultiplier")
    public static ConfigurationItem<Double> guiFontSizeMultiplier;
    @ConfigurationDefaultString(value="Monospaced-Plain-12")
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="gui.sourceFont")
    public static ConfigurationItem<String> sourceFontString;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.avm2.splitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiAvm2SplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.actionSplitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiActionSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.previewSplitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiPreviewSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.3333333333)
    @ConfigurationName(value="gui.splitPane1.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPane1DividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.splitPane2.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPane2DividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.5)
    @ConfigurationName(value="gui.timeLineSplitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiTimeLineSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.dump.splitPane.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiDumpSplitPaneDividerLocationPercent;
    @ConfigurationDefaultString(value="com.jpexs.decompiler.flash.gui.OceanicSkin")
    @ConfigurationName(value="gui.skin")
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<String> guiSkin;
    @ConfigurationDefaultInt(value=3)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Integer> saveAsExeScaleMode;
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<ExeExportMode> exeExportMode;
    @ConfigurationDefaultInt(value=0x100000)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> syntaxHighlightLimit;
    public static ConfigurationItem<Integer> guiFontPreviewSampleText;
    @ConfigurationName(value="gui.fontPreviewWindow.width")
    public static ConfigurationItem<Integer> guiFontPreviewWidth;
    @ConfigurationName(value="gui.fontPreviewWindow.height")
    public static ConfigurationItem<Integer> guiFontPreviewHeight;
    @ConfigurationName(value="gui.fontPreviewWindow.posX")
    public static ConfigurationItem<Integer> guiFontPreviewPosX;
    @ConfigurationName(value="gui.fontPreviewWindow.posY")
    public static ConfigurationItem<Integer> guiFontPreviewPosY;
    @ConfigurationDefaultInt(value=3)
    @ConfigurationName(value="formatting.indent.size")
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Integer> indentSize;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="formatting.indent.useTabs")
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Boolean> indentUseTabs;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Boolean> beginBlockOnNewLine;
    @ConfigurationDefaultInt(value=86400000)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.delay")
    public static ConfigurationItem<Integer> checkForUpdatesDelay;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.stable")
    public static ConfigurationItem<Boolean> checkForUpdatesStable;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.nightly")
    public static ConfigurationItem<Boolean> checkForUpdatesNightly;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="update")
    @ConfigurationName(value="check.updates.enabled")
    public static ConfigurationItem<Boolean> checkForUpdatesAuto;
    @ConfigurationCategory(value="update")
    public static ConfigurationItem<String> updateProxyAddress;
    @ConfigurationDefaultString(value="")
    @ConfigurationName(value="export.formats")
    public static ConfigurationItem<String> lastSelectedExportFormats;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> textExportSingleFile;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> scriptExportSingleFile;
    @ConfigurationDefaultString(value="--- SEPARATOR ---")
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<String> textExportSingleFileSeparator;
    @ConfigurationDefaultString(value="--- RECORDSEPARATOR ---")
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<String> textExportSingleFileRecordSeparator;
    @ConfigurationCategory(value="import")
    public static ConfigurationItem<TextImportResizeTextBoundsMode> textImportResizeTextBoundsMode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="import")
    public static ConfigurationItem<Boolean> resetLetterSpacingOnTextImport;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.experimental.as12edit")
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningExperimentalAS12Edit;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.experimental.as3edit")
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningExperimentalAS3Edit;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> showCodeSavedMessage;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> showTraitSavedMessage;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> packJavaScripts;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> textExportExportFontFace;
    @ConfigurationDefaultInt(value=128)
    public static ConfigurationItem<Integer> lzmaFastBytes;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> showMethodBodyId;
    @ConfigurationDefaultDouble(value=1.0)
    @ConfigurationName(value="export.zoom")
    public static ConfigurationItem<Double> lastSelectedExportZoom;
    public static ConfigurationItem<String> pluginPath;
    @ConfigurationDefaultInt(value=55556)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Integer> debuggerPort;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> randomDebuggerPackage;
    @ConfigurationDefaultBoolean(value=true)
    public static ConfigurationItem<Boolean> displayDebuggerInfo;
    @ConfigurationDefaultString(value="debugConsole")
    public static ConfigurationItem<String> lastDebuggerReplaceFunction;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> getLocalNamesFromDebugInfo;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> tagTreeShowEmptyFolders;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> autoLoadEmbeddedSwfs;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showCloseConfirmation;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> editorMode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> autoSaveTagModifications;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> saveSessionOnExit;
    public static ConfigurationItem<String> lastSessionFiles;
    public static ConfigurationItem<String> lastSessionFileTitles;
    public static ConfigurationItem<String> lastSessionSelection;
    public static ConfigurationItem<String> lastSessionTagListSelection;
    @ConfigurationDefaultInt(value=0)
    public static ConfigurationItem<Integer> lastView;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> loopMedia;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> allowOnlyOneInstance;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> ignoreCLikePackages;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> smartNumberFormatting;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationRemoved
    public static ConfigurationItem<Boolean> enableScriptInitializerDisplay;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> autoOpenLoadedSWFs;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile
    public static ConfigurationItem<String> playerLocation;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile
    public static ConfigurationItem<String> playerDebugLocation;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile(value=".*\\.swc$")
    public static ConfigurationItem<String> playerLibLocation;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationDirectory
    public static ConfigurationItem<String> flexSdkLocation;
    @ConfigurationDefaultDouble(value=0.7)
    @ConfigurationName(value="gui.avm2.splitPane.vars.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiAvm2VarsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.7)
    @ConfigurationName(value="gui.action.splitPane.vars.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiActionVarsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> debugHalt;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.svgImport")
    @ConfigurationCategory(value="import")
    public static ConfigurationItem<Boolean> warningSvgImport;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.hexViewNotUpToDate")
    @ConfigurationCategory(value="import")
    public static ConfigurationItem<Boolean> warningHexViewNotUpToDate;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationName(value="shapeImport.useNonSmoothedFill")
    @ConfigurationCategory(value="import")
    public static ConfigurationItem<Boolean> shapeImportUseNonSmoothedFill;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="internalFlashViewer.execute.as12")
    public static ConfigurationItem<Boolean> internalFlashViewerExecuteAs12;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> displayDupInstructions;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> useRegExprLiteral;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> handleSkinPartsAutomatically;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> _ignoreAdditionalFlexClasses;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> _enableFlexExport;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> simplifyExpressions;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> hwAcceleratedGraphics;
    @ConfigurationDefaultDouble(value=0.85)
    @ConfigurationName(value="gui.avm2.splitPane.docs.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiAvm2DocsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> useFlexAs3Compiler;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showSetAdvanceValuesMessage;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile
    public static ConfigurationItem<String> graphVizDotLocation;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> showLineNumbersInPCodeGraphvizGraph;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Boolean> indentAs3PCode;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Boolean> labelOnSeparateLineAs3PCode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> useOldStyleGetSetLocalsAs3PCode;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> useOldStyleLookupSwitchAs3PCode;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> checkForModifications;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.initializers")
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningInitializers;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> parametersPanelInSearchResults;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> displayAs3PCodeDocsPanel;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> displayAs3TraitsListAndConstantsPanel;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> useAsTypeIcons;
    @ConfigurationDefaultInt(value=20000)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> limitAs3PCodeOffsetMatching;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> showSlowRenderingWarning;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoCloseQuotes;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoCloseDoubleQuotes;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoCloseBrackets;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoCloseParenthesis;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> showDialogOnError;
    @ConfigurationDefaultInt(value=20)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> limitSameChars;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportScriptsInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportTextInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportSymbolClassInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportXmlInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportImageInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> autoPlaySwfs;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> expandFirstLevelOfTreeOnLoad;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> allowPlacingDefinesIntoSprites;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> allowDragAndDropInTagListTree;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    @ConfigurationRemoved
    public static ConfigurationItem<Boolean> allowMiterClipLinestyle;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> animateSubsprites;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> autoPlayPreviews;
    @ConfigurationDefaultInt(value=300000)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> maxCachedTime;
    @ConfigurationDefaultInt(value=500)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> maxCachedNum;
    @ConfigurationDefaultString(value="")
    @ConfigurationCategory(value="paths")
    @ConfigurationFile(value=".*\\.swc$")
    public static ConfigurationItem<String> airLibLocation;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportShapeInfo;
    @ConfigurationDefaultString(value="")
    public static ConfigurationItem<String> pinnedItemsTagTreePaths;
    @ConfigurationDefaultString(value="")
    public static ConfigurationItem<String> pinnedItemsTagListPaths;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> flattenASPackages;
    @ConfigurationDefaultDouble(value=1.0)
    @ConfigurationCategory(value="display")
    @ConfigurationName(value="gui.scale")
    public static ConfigurationItem<Double> uiScale;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.video.vlc")
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> warningVideoVlc;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> playFrameSounds;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    @ConfigurationRemoved
    public static ConfigurationItem<Boolean> fixAntialiasConflation;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> autoPlaySounds;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> deobfuscateAs12RemoveInvalidNamesAssignments;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.splitPanePlace.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPanePlaceDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.splitPaneTransform1.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPaneTransform1DividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.6)
    @ConfigurationName(value="gui.splitPaneTransform2.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPaneTransform2DividerLocationPercent;
    @ConfigurationDefaultString(value="")
    @ConfigurationName(value="gui.transform.lastExpandedCards")
    @ConfigurationInternal
    public static ConfigurationItem<String> guiTransformLastExpandedCards;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> doubleClickNodeToEdit;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningDeobfuscation;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningRenameIdentifiers;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportMovieInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportSoundInfo;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> svgRetainBounds;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> disableBitmapSmoothing;
    @ConfigurationDefaultString(value="")
    public static ConfigurationItem<String> pinnedItemsScrollPos;
    @ConfigurationDefaultInt(value=30)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Integer> maxRememberedScrollposItems;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> rememberScriptsScrollPos;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> rememberFoldersScrollPos;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.initializers.class")
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningInitializersClass;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.cannotencrypt")
    public static ConfigurationItem<Boolean> warningCannotEncrypt;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> lastExportEnableEmbed;
    @ConfigurationDefaultString(value="CS6")
    public static ConfigurationItem<String> lastFlaExportVersion;
    @ConfigurationDefaultBoolean(value=true)
    public static ConfigurationItem<Boolean> lastFlaExportCompressed;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> showImportSpriteInfo;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> displayAs12PCodeDocsPanel;
    @ConfigurationDefaultDouble(value=0.85)
    @ConfigurationName(value="gui.action.splitPane.docs.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiActionDocsSplitPaneDividerLocationPercent;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> rememberLastScreen;
    @ConfigurationDefaultInt(value=-1)
    @ConfigurationInternal
    public static ConfigurationItem<Integer> lastMainWindowScreenIndex;
    @ConfigurationDefaultInt(value=-1)
    @ConfigurationInternal
    public static ConfigurationItem<Integer> lastMainWindowScreenX;
    @ConfigurationDefaultInt(value=-1)
    @ConfigurationInternal
    public static ConfigurationItem<Integer> lastMainWindowScreenY;
    @ConfigurationDefaultInt(value=-1)
    @ConfigurationInternal
    public static ConfigurationItem<Integer> lastMainWindowScreenWidth;
    @ConfigurationDefaultInt(value=-1)
    @ConfigurationInternal
    public static ConfigurationItem<Integer> lastMainWindowScreenHeight;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> displayAs12PCodePanel;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> displayAs3PCodePanel;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> flaExportUseMappedFontLayout;
    @ConfigurationDefaultInt(value=3)
    @ConfigurationName(value="formatting.tab.size")
    @ConfigurationCategory(value="format")
    public static ConfigurationItem<Integer> tabSize;
    @ConfigurationDefaultInt(value=1000)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> boxBlurPixelsLimit;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> as3ExportNamesUseClassNamesOnly;
    @ConfigurationDefaultString(value="")
    @ConfigurationDirectory
    public static ConfigurationItem<String> jnaTempDirectory;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> flaExportFixShapes;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    @ConfigurationRemoved
    public static ConfigurationItem<Boolean> lastExportResampleWav;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    @ConfigurationRemoved
    public static ConfigurationItem<Boolean> previewResampleSound;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> lastExportTransparentBackground;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningAbcClean;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningAddFunction;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="export")
    public static ConfigurationItem<Boolean> linkAllClasses;
    @ConfigurationDefaultString(value="")
    @ConfigurationInternal
    public static ConfigurationItem<String> recentColors;
    @ConfigurationDefaultDouble(value=0.7)
    @ConfigurationName(value="gui.splitPaneEasyVertical.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPaneEasyVerticalDividerLocationPercent;
    @ConfigurationDefaultDouble(value=0.7)
    @ConfigurationName(value="gui.splitPaneEasyHorizontal.dividerLocationPercent")
    @ConfigurationInternal
    public static ConfigurationItem<Double> guiSplitPaneEasyHorizontalDividerLocationPercent;
    public static ConfigurationItem<String> lastSessionEasySwf;
    @ConfigurationDefaultInt(value=1000)
    @ConfigurationCategory(value="limit")
    public static ConfigurationItem<Integer> maxScriptLineLength;
    @ConfigurationDefaultString(value=".")
    @ConfigurationDirectory
    public static ConfigurationItem<String> lastSolEditorDirectory;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> halfTransparentParentLayersEasy;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> showRuler;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapToGuides;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapToObjects;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapToPixels;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapAlign;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> showGuides;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> lockGuides;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> showGrid;
    @ConfigurationDefaultInt(value=10)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Integer> gridVerticalSpace;
    @ConfigurationDefaultInt(value=10)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Integer> gridHorizontalSpace;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapToGrid;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> gridOverObjects;
    @ConfigurationDefaultColor(value="#949494")
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Color> gridColor;
    @ConfigurationDefaultColor(value="#00FF00")
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Color> guidesColor;
    @ConfigurationCategory(value="display")
    @ConfigurationDefaultString(value="NORMAL")
    public static ConfigurationItem<GridSnapAccuracy> gridSnapAccuracy;
    @ConfigurationCategory(value="display")
    @ConfigurationDefaultString(value="NORMAL")
    public static ConfigurationItem<GuidesSnapAccuracy> guidesSnapAccuracy;
    @ConfigurationDefaultInt(value=0)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Integer> snapAlignObjectHorizontalSpace;
    @ConfigurationDefaultInt(value=0)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Integer> snapAlignObjectVerticalSpace;
    @ConfigurationDefaultInt(value=0)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Integer> snapAlignStageBorder;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapAlignCenterAlignmentHorizontal;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="display")
    public static ConfigurationItem<Boolean> snapAlignCenterAlignmentVertical;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationName(value="warning.linkTypes")
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> warningLinkTypes;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> showCodeCompletionOnDot;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> skipDetectionOfUninitializedClassFields;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationInternal
    public static ConfigurationItem<Boolean> showHeapStatusWidget;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> autoDeobfuscateIdentifiers;
    @ConfigurationDefaultBoolean(value=false)
    @ConfigurationCategory(value="script")
    public static ConfigurationItem<Boolean> showVarsWithDontEnumerateFlag;
    @ConfigurationDefaultBoolean(value=true)
    @ConfigurationCategory(value="ui")
    public static ConfigurationItem<Boolean> allowDragAndDropFromResourcesTree;
    private static Map<String, String> configurationDescriptions;
    private static Map<String, String> configurationTitles;

    public static void setConfigurationDescriptions(Map<String, String> configurationDescriptions) {
        Configuration.configurationDescriptions = configurationDescriptions;
    }

    public static void setConfigurationTitles(Map<String, String> configurationTitles) {
        Configuration.configurationTitles = configurationTitles;
    }

    public static String getConfigurationTitle(String configurationName) {
        return configurationTitles.get(configurationName);
    }

    public static String getConfigurationDescription(String configurationName) {
        return configurationDescriptions.get(configurationName);
    }

    public static Font getSourceFont() {
        return FontHelper.stringToFont(sourceFontString.get());
    }

    public static List<String> getRecentFiles() {
        String files = recentFiles.get();
        if (files == null || files.isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(files.split("::"));
    }

    public static void addRecentFile(String path) {
        ArrayList<String> recentFilesArray = new ArrayList<String>(Configuration.getRecentFiles());
        int idx = recentFilesArray.indexOf(path);
        if (idx != -1) {
            recentFilesArray.remove(idx);
        }
        recentFilesArray.add(path);
        while (recentFilesArray.size() > maxRecentFileCount.get()) {
            recentFilesArray.remove(0);
        }
        recentFiles.set(Helper.joinStrings(recentFilesArray, "::"));
    }

    public static void removeRecentFile(String path) {
        ArrayList<String> recentFilesArray = new ArrayList<String>(Configuration.getRecentFiles());
        int idx = recentFilesArray.indexOf(path);
        if (idx != -1) {
            recentFilesArray.remove(idx);
        }
        recentFiles.set(Helper.joinStrings(recentFilesArray, "::"));
    }

    public static Map<String, String> getFontToNameMap() {
        HashMap<String, String> map = fontPairingMap.get();
        if (map == null) {
            map = new HashMap();
            fontPairingMap.set(map);
        }
        return map;
    }

    public static void addFontPair(String fileName, int fontId, String fontName, String installedName) {
        Map<String, String> fontPairs = Configuration.getFontToNameMap();
        fontPairs.put(fontName, installedName);
        SwfSpecificConfiguration swfConf = Configuration.getOrCreateSwfSpecificConfiguration(fileName);
        swfConf.fontPairingMap.put(fontId + "_" + fontName, installedName);
    }

    public static SwfSpecificConfiguration getSwfSpecificConfiguration(String fileName) {
        HashMap<String, SwfSpecificConfiguration> map = swfSpecificConfigs.get();
        if (map == null) {
            map = new HashMap();
            swfSpecificConfigs.set(map);
        }
        return map.get(fileName);
    }

    public static SwfSpecificConfiguration getOrCreateSwfSpecificConfiguration(String fileName) {
        SwfSpecificConfiguration swfConf = Configuration.getSwfSpecificConfiguration(fileName);
        if (swfConf == null) {
            swfConf = new SwfSpecificConfiguration();
            swfSpecificConfigs.get().put(fileName, swfConf);
        }
        return swfConf;
    }

    public static SwfSpecificCustomConfiguration getSwfSpecificCustomConfiguration(String fileName) {
        HashMap<String, SwfSpecificCustomConfiguration> map = swfSpecificCustomConfigs.get();
        if (map == null) {
            map = new HashMap();
            swfSpecificCustomConfigs.set(map);
        }
        return map.get(fileName);
    }

    public static SwfSpecificCustomConfiguration getSwfSpecificCustomConfiguration(SWF swf) {
        return Configuration.getSwfSpecificCustomConfiguration(swf.getShortPathTitle());
    }

    public static SwfSpecificCustomConfiguration getOrCreateSwfSpecificCustomConfiguration(String fileName) {
        SwfSpecificCustomConfiguration swfConf = Configuration.getSwfSpecificCustomConfiguration(fileName);
        if (swfConf == null) {
            swfConf = new SwfSpecificCustomConfiguration();
            swfSpecificCustomConfigs.get().put(fileName, swfConf);
        }
        return swfConf;
    }

    public static SwfSpecificCustomConfiguration getOrCreateSwfSpecificCustomConfiguration(SWF swf) {
        return Configuration.getOrCreateSwfSpecificCustomConfiguration(swf.getShortPathTitle());
    }

    private static String getConfigFile() throws IOException {
        return AppDirectoryProvider.getFFDecHome() + storage.getConfigName();
    }

    private static String getLegacyConfigFile() throws IOException {
        return AppDirectoryProvider.getFFDecHome() + legacyStorage.getConfigName();
    }

    public static void saveConfig() {
        Logger.getLogger(Configuration.class.getName()).fine("Saving configuration...");
        try {
            storage.saveToFile(Configuration.getConfigFile());
            Logger.getLogger(Configuration.class.getName()).fine("TOML configuration saved.");
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, "Cannot save TOML configuration", ex);
        }
        try {
            legacyStorage.saveToFile(Configuration.getLegacyConfigFile());
            Logger.getLogger(Configuration.class.getName()).fine("Legacy configuration saved.");
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.WARNING, "Cannot save legacy configuration", ex);
        }
    }

    private static void loadFromMap(Map<String, Object> config) {
        File swcFile;
        try {
            for (Map.Entry<String, Field> entry : Configuration.getConfigurationFields(false, true).entrySet()) {
                String name = entry.getKey();
                Field field = entry.getValue();
                Object defaultValue = Configuration.getDefaultValue(field);
                Object value = null;
                if (config.containsKey(name)) {
                    value = config.get(name);
                    Class<?> type = ConfigurationItem.getConfigurationFieldType(field);
                    if (value != null && !type.isAssignableFrom(value.getClass())) {
                        System.out.println("Configuration item has a wrong type: " + name + " expected: " + type.getSimpleName() + " actual: " + value.getClass().getSimpleName());
                        value = null;
                    }
                }
                if (value != null) {
                    field.set(null, new ConfigurationItem<Object>(name, defaultValue, value));
                    continue;
                }
                field.set(null, new ConfigurationItem<Object>(name, defaultValue));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw new Error(ex.getMessage());
        }
        if (playerLibLocation.get("").isEmpty() && (swcFile = Configuration.getPlayerSwcOld()) != null) {
            playerLibLocation.set(swcFile.getAbsolutePath());
        }
        if (airLibLocation.get("").isEmpty() && (swcFile = Configuration.getAirSwcOld()) != null) {
            airLibLocation.set(swcFile.getAbsolutePath());
        }
    }

    public static void loadFromFile(String file) {
        Map<String, Object> config = file.toLowerCase(Locale.ENGLISH).endsWith(".bin") ? legacyStorage.loadFromFile(file) : storage.loadFromFile(file);
        Configuration.loadFromMap(config);
    }

    public static void setConfigurationFields() {
        Logger.getLogger(Configuration.class.getName()).log(Level.FINE, "Setting configuration fields...");
        try {
            Map<String, Object> config;
            if (new File(Configuration.getConfigFile()).exists()) {
                Logger.getLogger(Configuration.class.getName()).log(Level.FINE, "Using TOML file.");
                config = storage.loadFromFile(Configuration.getConfigFile());
            } else {
                Logger.getLogger(Configuration.class.getName()).log(Level.FINE, "Using legacy file.");
                config = legacyStorage.loadFromFile(Configuration.getLegacyConfigFile());
            }
            Configuration.loadFromMap(config);
            Logger.getLogger(Configuration.class.getName()).log(Level.FINE, "Configuration fields set.");
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Object getDefaultValue(Field field) {
        ConfigurationDefaultColor aColor;
        ConfigurationDefaultCalendar aCalendar;
        ConfigurationDefaultDouble aDouble;
        ConfigurationDefaultString aString;
        ConfigurationDefaultInt aInt;
        Object defaultValue = null;
        ConfigurationDefaultBoolean aBool = field.getAnnotation(ConfigurationDefaultBoolean.class);
        if (aBool != null) {
            defaultValue = aBool.value();
        }
        if ((aInt = field.getAnnotation(ConfigurationDefaultInt.class)) != null) {
            defaultValue = aInt.value();
        }
        if ((aString = field.getAnnotation(ConfigurationDefaultString.class)) != null) {
            defaultValue = aString.value();
            Class<?> type = ConfigurationItem.getConfigurationFieldType(field);
            if (type.isEnum()) {
                return Enum.valueOf(type.asSubclass(Enum.class), (String)defaultValue);
            }
        }
        if ((aDouble = field.getAnnotation(ConfigurationDefaultDouble.class)) != null) {
            defaultValue = aDouble.value();
        }
        if ((aCalendar = field.getAnnotation(ConfigurationDefaultCalendar.class)) != null) {
            GregorianCalendar mingc = new GregorianCalendar();
            mingc.setTime(new Date(aCalendar.value()));
            defaultValue = mingc;
        }
        if ((aColor = field.getAnnotation(ConfigurationDefaultColor.class)) != null) {
            Pattern p = Pattern.compile("#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})$");
            Matcher m = p.matcher(aColor.value());
            defaultValue = m.matches() ? new Color(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16)) : Color.black;
        }
        if (defaultValue == null) {
            Class<?> type = ConfigurationItem.getConfigurationFieldType(field);
            if (type.isEnum()) {
                Class<?> enumClass = type;
                defaultValue = ((Enum[])enumClass.getEnumConstants())[0];
            }
            if (type == String.class) {
                defaultValue = "";
            }
        }
        return defaultValue;
    }

    public static Map<String, Field> getConfigurationFields(boolean lowerCaseNames, boolean alsoRemoved) {
        Field[] fields = Configuration.class.getDeclaredFields();
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Field field : fields) {
            ConfigurationRemoved removedAnnotation;
            if (!alsoRemoved && (removedAnnotation = field.getAnnotation(ConfigurationRemoved.class)) != null || !ConfigurationItem.class.isAssignableFrom(field.getType())) continue;
            String name = ConfigurationItem.getName(field);
            if (lowerCaseNames) {
                name = name.toLowerCase();
            }
            result.put(name, field);
        }
        return result;
    }

    public static CodeFormatting getCodeFormatting() {
        CodeFormatting ret = new CodeFormatting();
        String indentString = "";
        for (int i = 0; i < indentSize.get(); ++i) {
            indentString = indentString + (indentUseTabs.get() != false ? "\t" : " ");
        }
        ret.indentString = indentString;
        ret.beginBlockOnNewLine = beginBlockOnNewLine.get();
        return ret;
    }

    public static int getParallelThreadCount() {
        int processorCount = Runtime.getRuntime().availableProcessors();
        int threadCount = parallelSpeedUpThreadCount.get();
        if (threadCount <= 0) {
            threadCount = processorCount - 1;
        }
        if (threadCount < 2) {
            threadCount = 2;
        }
        return threadCount;
    }

    public static File getPath(String folder) {
        String home = AppDirectoryProvider.getFFDecHome();
        File dir = new File(home + folder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File getFlashLibPath() {
        return Configuration.getPath("flashlib");
    }

    public static File getProjectorPath() {
        return Configuration.getPath("projector");
    }

    private static String getDownloadsHtml() throws IOException {
        String html = Helper.downloadUrlString("https://www.adobe.com/support/flashplayer/downloads.html");
        return html;
    }

    private static String getUrlFromDownloadsHtml(String urlPatternString) {
        try {
            String html = Configuration.getDownloadsHtml();
            Pattern urlPattern = Pattern.compile(urlPatternString, 32);
            Matcher matcher = urlPattern.matcher(html);
            if (matcher.matches()) {
                String url = matcher.group(1);
                int a = url.length();
                return url;
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static String getLatestPlayerGlobalUrl() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*playerglobal[^\"]*\\.swc)\".*");
    }

    private static String getLatestProjectorUrlWin() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*flashplayer[^\"]*_sa\\.exe)\".*");
    }

    private static String getLatestProjectorUrlMac() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*flashplayer[^\"]*_sa\\.dmg)\".*");
    }

    private static String getLatestProjectorUrlLinux() {
        return Configuration.getUrlFromDownloadsHtml(".*<a href=\"([^\"]*flashplayer[^\"]*_sa\\.i386\\.tar\\.gz)\".*");
    }

    private static File getFFDecFlashLib(String name) {
        try {
            File ffdecLibJarFile = new File(Configuration.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            File ffdecDirectory = null;
            if (ffdecLibJarFile.getAbsolutePath().endsWith(".jar")) {
                ffdecDirectory = ffdecLibJarFile.getParentFile().getParentFile();
            } else if (ffdecLibJarFile.getAbsolutePath().replace("\\", "/").endsWith("libsrc/ffdec_lib/build/classes")) {
                ffdecDirectory = ffdecLibJarFile.getParentFile().getParentFile().getParentFile().getParentFile();
                ffdecDirectory = new File(Path.combine(ffdecDirectory.getAbsolutePath(), "resources"));
            } else {
                return null;
            }
            File flashLibDirectory = new File(Path.combine(ffdecDirectory.getAbsolutePath(), "flashlib"));
            File flashLib = new File(Path.combine(flashLibDirectory.getAbsolutePath(), name));
            if (!flashLib.exists()) {
                return null;
            }
            return flashLib;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static File getPlayerSWC() {
        String libLocation = playerLibLocation.get("");
        File ret = null;
        if (!libLocation.isEmpty()) {
            ret = new File(libLocation);
        }
        if (ret == null || !ret.exists()) {
            ret = Configuration.getPlayerSwcOld();
            if (ret != null) {
                playerLibLocation.set(ret.getAbsolutePath());
            }
            if (ret == null) {
                ret = Configuration.getFFDecFlashLib("playerglobal32_0.swc");
            }
        }
        return ret;
    }

    public static File getAirSWC() {
        String libLocation = airLibLocation.get("");
        File ret = null;
        if (!libLocation.isEmpty()) {
            ret = new File(libLocation);
        }
        if (ret == null || !ret.exists()) {
            ret = Configuration.getAirSwcOld();
            if (ret != null) {
                airLibLocation.set(ret.getAbsolutePath());
            }
            if (ret == null) {
                ret = Configuration.getFFDecFlashLib("airglobal.swc");
            }
        }
        return ret;
    }

    private static File getAirSwcOld() {
        File airFile;
        File libsDir = Configuration.getFlashLibPath();
        if (libsDir != null && libsDir.exists() && (airFile = new File(Path.combine(libsDir.getAbsolutePath(), "airglobal.swc"))).exists()) {
            return airFile;
        }
        return null;
    }

    private static File getPlayerSwcOld() {
        File libsDir = Configuration.getFlashLibPath();
        if (libsDir != null && libsDir.exists()) {
            File[] libs = libsDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().startsWith("playerglobal");
                }
            });
            ArrayList<String> libNames = new ArrayList<String>();
            for (File f : libs) {
                libNames.add(f.getName());
            }
            Collections.sort(libNames);
            if (!libNames.isEmpty()) {
                return new File(libsDir.getAbsolutePath() + File.separator + (String)libNames.get(libNames.size() - 1));
            }
            return null;
        }
        return null;
    }

    public static File getProjectorFile(final ExeExportMode exportMode) {
        File projectoDir = Configuration.getProjectorPath();
        if (projectoDir != null && projectoDir.exists()) {
            File[] projectors = projectoDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    switch (exportMode) {
                        case PROJECTOR_WIN: {
                            return name.toLowerCase().endsWith(".exe");
                        }
                        case PROJECTOR_MAC: {
                            return name.toLowerCase().endsWith(".dmg");
                        }
                        case PROJECTOR_LINUX: {
                            return name.toLowerCase().endsWith(".gz");
                        }
                    }
                    return false;
                }
            });
            ArrayList<String> projectorNames = new ArrayList<String>();
            for (File f : projectors) {
                projectorNames.add(f.getName());
            }
            Collections.sort(projectorNames);
            if (!projectorNames.isEmpty()) {
                return new File(projectoDir.getAbsolutePath() + File.separator + (String)projectorNames.get(projectorNames.size() - 1));
            }
            return null;
        }
        return null;
    }

    static {
        openMultipleFiles = null;
        decompile = null;
        parallelSpeedUp = null;
        parallelSpeedUpThreadCount = null;
        autoDeobfuscate = null;
        cacheOnDisk = null;
        cacheImages = null;
        useAdobeFlashPlayerForPreviews = null;
        setMovieDelay = null;
        dumpView = null;
        useHexColorFormat = null;
        showOldTextDuringTextEditing = null;
        gotoMainClassOnStartup = null;
        autoRenameIdentifiers = null;
        offeredAssociation = null;
        decimalAddress = null;
        showAllAddresses = null;
        useFrameCache = null;
        useRibbonInterface = null;
        overwriteExistingFiles = null;
        openFolderAfterFlaExport = null;
        overrideTextExportFileName = null;
        useDetailedLogging = null;
        warningOpeningReadOnly = null;
        _debugMode = null;
        _showDebugMenu = null;
        resolveConstants = null;
        showFileOffsetInPcodeHex = null;
        showOriginalBytesInPcodeHex = null;
        padAs3PCodeInstructionName = null;
        sublimiter = null;
        exportTimeout = null;
        decompilationTimeoutFile = null;
        as12DeobfuscatorExecutionLimit = null;
        paramNamesEnable = null;
        displayFileName = null;
        _debugCopy = null;
        dumpTags = null;
        setFFDecVersionInExportedFont = null;
        decompilationTimeoutSingleMethod = null;
        lastRenameType = null;
        lastSaveDir = null;
        lastOpenDir = null;
        lastExportDir = null;
        locale = null;
        registerNameFormat = null;
        maxRecentFileCount = null;
        recentFiles = null;
        fontPairingMap = null;
        swfSpecificConfigs = null;
        swfSpecificCustomConfigs = null;
        lastUpdatesCheckDate = null;
        guiWindowWidth = null;
        guiWindowHeight = null;
        guiWindowMaximizedHorizontal = null;
        guiWindowMaximizedVertical = null;
        guiFontSizeMultiplier = null;
        sourceFontString = null;
        guiAvm2SplitPaneDividerLocationPercent = null;
        guiActionSplitPaneDividerLocationPercent = null;
        guiPreviewSplitPaneDividerLocationPercent = null;
        guiSplitPane1DividerLocationPercent = null;
        guiSplitPane2DividerLocationPercent = null;
        guiTimeLineSplitPaneDividerLocationPercent = null;
        guiDumpSplitPaneDividerLocationPercent = null;
        guiSkin = null;
        saveAsExeScaleMode = null;
        exeExportMode = null;
        syntaxHighlightLimit = null;
        guiFontPreviewSampleText = null;
        guiFontPreviewWidth = null;
        guiFontPreviewHeight = null;
        guiFontPreviewPosX = null;
        guiFontPreviewPosY = null;
        indentSize = null;
        indentUseTabs = null;
        beginBlockOnNewLine = null;
        checkForUpdatesDelay = null;
        checkForUpdatesStable = null;
        checkForUpdatesNightly = null;
        checkForUpdatesAuto = null;
        updateProxyAddress = null;
        lastSelectedExportFormats = null;
        textExportSingleFile = null;
        scriptExportSingleFile = null;
        textExportSingleFileSeparator = null;
        textExportSingleFileRecordSeparator = null;
        textImportResizeTextBoundsMode = null;
        resetLetterSpacingOnTextImport = null;
        warningExperimentalAS12Edit = null;
        warningExperimentalAS3Edit = null;
        showCodeSavedMessage = null;
        showTraitSavedMessage = null;
        packJavaScripts = null;
        textExportExportFontFace = null;
        lzmaFastBytes = null;
        showMethodBodyId = null;
        lastSelectedExportZoom = null;
        pluginPath = null;
        debuggerPort = null;
        randomDebuggerPackage = null;
        displayDebuggerInfo = null;
        lastDebuggerReplaceFunction = null;
        getLocalNamesFromDebugInfo = null;
        tagTreeShowEmptyFolders = null;
        autoLoadEmbeddedSwfs = null;
        showCloseConfirmation = null;
        editorMode = null;
        autoSaveTagModifications = null;
        saveSessionOnExit = null;
        lastSessionFiles = null;
        lastSessionFileTitles = null;
        lastSessionSelection = null;
        lastSessionTagListSelection = null;
        lastView = null;
        loopMedia = null;
        allowOnlyOneInstance = null;
        ignoreCLikePackages = null;
        smartNumberFormatting = null;
        enableScriptInitializerDisplay = null;
        autoOpenLoadedSWFs = null;
        playerLocation = null;
        playerDebugLocation = null;
        playerLibLocation = null;
        flexSdkLocation = null;
        guiAvm2VarsSplitPaneDividerLocationPercent = null;
        guiActionVarsSplitPaneDividerLocationPercent = null;
        debugHalt = null;
        warningSvgImport = null;
        warningHexViewNotUpToDate = null;
        shapeImportUseNonSmoothedFill = null;
        internalFlashViewerExecuteAs12 = null;
        displayDupInstructions = null;
        useRegExprLiteral = null;
        handleSkinPartsAutomatically = null;
        _ignoreAdditionalFlexClasses = null;
        _enableFlexExport = null;
        simplifyExpressions = null;
        hwAcceleratedGraphics = null;
        guiAvm2DocsSplitPaneDividerLocationPercent = null;
        useFlexAs3Compiler = null;
        showSetAdvanceValuesMessage = null;
        graphVizDotLocation = null;
        showLineNumbersInPCodeGraphvizGraph = null;
        indentAs3PCode = null;
        labelOnSeparateLineAs3PCode = null;
        useOldStyleGetSetLocalsAs3PCode = null;
        useOldStyleLookupSwitchAs3PCode = null;
        checkForModifications = null;
        warningInitializers = null;
        parametersPanelInSearchResults = null;
        displayAs3PCodeDocsPanel = null;
        displayAs3TraitsListAndConstantsPanel = null;
        useAsTypeIcons = null;
        limitAs3PCodeOffsetMatching = null;
        showSlowRenderingWarning = null;
        autoCloseQuotes = null;
        autoCloseDoubleQuotes = null;
        autoCloseBrackets = null;
        autoCloseParenthesis = null;
        showDialogOnError = null;
        limitSameChars = null;
        showImportScriptsInfo = null;
        showImportTextInfo = null;
        showImportSymbolClassInfo = null;
        showImportXmlInfo = null;
        showImportImageInfo = null;
        autoPlaySwfs = null;
        expandFirstLevelOfTreeOnLoad = null;
        allowPlacingDefinesIntoSprites = null;
        allowDragAndDropInTagListTree = null;
        allowMiterClipLinestyle = null;
        animateSubsprites = null;
        autoPlayPreviews = null;
        maxCachedTime = null;
        maxCachedNum = null;
        airLibLocation = null;
        showImportShapeInfo = null;
        pinnedItemsTagTreePaths = null;
        pinnedItemsTagListPaths = null;
        flattenASPackages = null;
        uiScale = null;
        warningVideoVlc = null;
        playFrameSounds = null;
        fixAntialiasConflation = null;
        autoPlaySounds = null;
        deobfuscateAs12RemoveInvalidNamesAssignments = null;
        guiSplitPanePlaceDividerLocationPercent = null;
        guiSplitPaneTransform1DividerLocationPercent = null;
        guiSplitPaneTransform2DividerLocationPercent = null;
        guiTransformLastExpandedCards = null;
        doubleClickNodeToEdit = null;
        warningDeobfuscation = null;
        warningRenameIdentifiers = null;
        showImportMovieInfo = null;
        showImportSoundInfo = null;
        svgRetainBounds = null;
        disableBitmapSmoothing = null;
        pinnedItemsScrollPos = null;
        maxRememberedScrollposItems = null;
        rememberScriptsScrollPos = null;
        rememberFoldersScrollPos = null;
        warningInitializersClass = null;
        warningCannotEncrypt = null;
        lastExportEnableEmbed = null;
        lastFlaExportVersion = null;
        lastFlaExportCompressed = null;
        showImportSpriteInfo = null;
        displayAs12PCodeDocsPanel = null;
        guiActionDocsSplitPaneDividerLocationPercent = null;
        rememberLastScreen = null;
        lastMainWindowScreenIndex = null;
        lastMainWindowScreenX = null;
        lastMainWindowScreenY = null;
        lastMainWindowScreenWidth = null;
        lastMainWindowScreenHeight = null;
        displayAs12PCodePanel = null;
        displayAs3PCodePanel = null;
        flaExportUseMappedFontLayout = null;
        tabSize = null;
        boxBlurPixelsLimit = null;
        as3ExportNamesUseClassNamesOnly = null;
        jnaTempDirectory = null;
        flaExportFixShapes = null;
        lastExportResampleWav = null;
        previewResampleSound = null;
        lastExportTransparentBackground = null;
        warningAbcClean = null;
        warningAddFunction = null;
        linkAllClasses = null;
        recentColors = null;
        guiSplitPaneEasyVerticalDividerLocationPercent = null;
        guiSplitPaneEasyHorizontalDividerLocationPercent = null;
        lastSessionEasySwf = null;
        maxScriptLineLength = null;
        lastSolEditorDirectory = null;
        halfTransparentParentLayersEasy = null;
        showRuler = null;
        snapToGuides = null;
        snapToObjects = null;
        snapToPixels = null;
        snapAlign = null;
        showGuides = null;
        lockGuides = null;
        showGrid = null;
        gridVerticalSpace = null;
        gridHorizontalSpace = null;
        snapToGrid = null;
        gridOverObjects = null;
        gridColor = null;
        guidesColor = null;
        gridSnapAccuracy = null;
        guidesSnapAccuracy = null;
        snapAlignObjectHorizontalSpace = null;
        snapAlignObjectVerticalSpace = null;
        snapAlignStageBorder = null;
        snapAlignCenterAlignmentHorizontal = null;
        snapAlignCenterAlignmentVertical = null;
        warningLinkTypes = null;
        showCodeCompletionOnDot = null;
        skipDetectionOfUninitializedClassFields = null;
        showHeapStatusWidget = null;
        autoDeobfuscateIdentifiers = null;
        showVarsWithDontEnumerateFlag = null;
        allowDragAndDropFromResourcesTree = null;
        configurationDescriptions = new LinkedHashMap<String, String>();
        configurationTitles = new LinkedHashMap<String, String>();
        Configuration.setConfigurationFields();
        logLevel = useDetailedLogging.get() != false ? Level.FINEST : (_debugMode.get() != false ? Level.INFO : Level.WARNING);
    }
}

