/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationStorage;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class LegacyConfigurationStorage
implements ConfigurationStorage {
    @Override
    public String getConfigName() {
        return "config.bin";
    }

    @Override
    public Map<String, Object> loadFromFile(String file) {
        HashMap hashMap;
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        try {
            HashMap cfg;
            hashMap = cfg = (HashMap)ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException exception) {
                return new HashMap<String, Object>();
            }
        }
        ois.close();
        return hashMap;
    }

    @Override
    public void saveToFile(String file) {
        HashMap config = new HashMap();
        for (Map.Entry<String, Field> entry : Configuration.getConfigurationFields(false, true).entrySet()) {
            try {
                String name = entry.getKey();
                Field field = entry.getValue();
                ConfigurationItem item = (ConfigurationItem)field.get(null);
                if (!item.hasValue) continue;
                config.put(name, item.get());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Configuration.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            oos.writeObject(config);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Cannot save configuration.", "Error", 0);
            Logger.getLogger(Configuration.class.getName()).severe("Configuration directory is read only.");
        }
    }
}

