/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.dumpview;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSwfNode;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagStub;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DumpInfo
implements TreeItem {
    public String name;
    public String type;
    public TagStub tagToResolve = null;
    public Tag resolvedTag = null;
    public Object previewValue;
    public long startByte;
    public int startBit;
    public long lengthBytes;
    public int lengthBits;
    public DumpInfo parent;
    private List<DumpInfo> childInfos;

    public DumpInfo(String name, String type, Object value, long startByte, long lengthBytes) {
        this.name = name;
        this.type = type;
        this.previewValue = value;
        this.startByte = startByte;
        this.lengthBytes = lengthBytes;
    }

    public DumpInfo(String name, String type, Object value, long startByte, int startBit, long lengthBytes, int lengthBits) {
        this.name = name;
        this.type = type;
        this.previewValue = value;
        this.startByte = startByte;
        this.lengthBytes = lengthBytes;
        this.startBit = startBit;
        this.lengthBits = lengthBits;
    }

    public int getChildCount() {
        return this.childInfos == null ? 0 : this.childInfos.size();
    }

    public List<DumpInfo> getChildInfos() {
        if (this.childInfos == null) {
            this.childInfos = new ArrayList<DumpInfo>();
        }
        return this.childInfos;
    }

    public void sortChildren() {
        if (this.childInfos == null) {
            return;
        }
        Collections.sort(this.childInfos, new Comparator<DumpInfo>(){

            @Override
            public int compare(DumpInfo o1, DumpInfo o2) {
                int res = Long.compare(o1.startByte, o2.startByte);
                if (res != 0) {
                    return res;
                }
                return Integer.compare(o1.startBit, o1.startBit);
            }
        });
    }

    public long getEndByte() {
        int end = (int)this.startByte;
        if (this.lengthBytes != 0L) {
            end = (int)((long)end + this.lengthBytes);
        } else {
            int bits = this.startBit + this.lengthBits;
            end += bits / 8;
            if (bits % 8 != 0) {
                ++end;
            }
        }
        return end - 1;
    }

    public String toString() {
        String value = this.previewValue == null ? "" : this.previewValue.toString();
        return this.name + " : " + this.type + (value.isEmpty() ? "" : " = " + value);
    }

    public void resolveTag() {
        if (this.tagToResolve != null) {
            TagStub tagStub = this.tagToResolve;
            try {
                SWFInputStream sis = tagStub.getDataStream();
                sis.seek(tagStub.getDataPos());
                sis.dumpInfo = this;
                this.resolvedTag = SWFInputStream.resolveTag(tagStub, 0, false, true, false, false);
            }
            catch (IOException | InterruptedException ex) {
                Logger.getLogger(DumpInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.tagToResolve = null;
        }
    }

    public Tag getTag() {
        this.resolveTag();
        return this.resolvedTag;
    }

    @Override
    public Openable getOpenable() {
        Tag tag;
        Tag tag2 = tag = this.tagToResolve != null ? this.tagToResolve : this.resolvedTag;
        if (tag != null) {
            return tag.getOpenable();
        }
        return DumpInfoSwfNode.getSwfNode(this).getOpenable();
    }

    @Override
    public boolean isModified() {
        return false;
    }
}

