/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFHeader;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParser;
import com.jpexs.decompiler.flash.action.parser.script.ActionScript2Parser;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineMorphShapeTag;
import com.jpexs.decompiler.flash.tags.DefineShapeTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineTextTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.SoundStreamFrameRange;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.decompiler.graph.CompilationException;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreviewExporter {
    public static final int MORPH_SHAPE_ANIMATION_LENGTH = 2;
    public static final int MORPH_SHAPE_ANIMATION_FRAME_RATE = 30;
    private static final double WIDTH_DIVISOR = 1000.0;

    private void updateProgressBar(int xmin, int ymin, SWF swf, SWFOutputStream sos2, int width, int height, int progressBarHeight, int currentFrame, int totalFrames) throws IOException {
        Matrix m = new Matrix();
        m.translate(xmin, ymin + height - progressBarHeight * 20);
        m.scale((double)width / 1000.0 * (double)currentFrame / (double)totalFrames, progressBarHeight * 20);
        new PlaceObject2Tag(swf, true, 2, -1, m.toMATRIX(), null, -1, null, -1, null).writeTag(sos2);
    }

    private void addControls(int xmin, int ymin, int progressBarHeight, SWF swf, SWFOutputStream sos2, int width, int numFrames, int height) throws IOException {
        int progressBarShapeId = swf.getNextCharacterId();
        int overVideoButtonId = progressBarShapeId + 1;
        int progressBarButtonId = overVideoButtonId + 1;
        Color progressBarColor = Color.red;
        DefineShapeTag dsh = new DefineShapeTag(swf);
        dsh.shapeBounds = new RECT(0, (int)Math.round(20000.0), 0, 20 * progressBarHeight);
        dsh.shapeId = progressBarShapeId;
        dsh.shapes.fillStyles.fillStyles = new FILLSTYLE[1];
        dsh.shapes.fillStyles.fillStyles[0] = new FILLSTYLE();
        dsh.shapes.fillStyles.fillStyles[0].fillStyleType = 0;
        dsh.shapes.fillStyles.fillStyles[0].color = new RGB(progressBarColor);
        dsh.shapes.shapeRecords.clear();
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.stateFillStyle0 = true;
        scr.fillStyle0 = 1;
        scr.stateMoveTo = true;
        scr.moveDeltaX = 0;
        scr.moveDeltaY = 0;
        dsh.shapes.shapeRecords.add(scr);
        StraightEdgeRecord ser = new StraightEdgeRecord();
        ser.vertLineFlag = true;
        ser.deltaY = 1;
        dsh.shapes.shapeRecords.add(ser);
        ser = new StraightEdgeRecord();
        ser.deltaX = (int)Math.round(1000.0);
        dsh.shapes.shapeRecords.add(ser);
        ser = new StraightEdgeRecord();
        ser.vertLineFlag = true;
        ser.deltaY = -1;
        dsh.shapes.shapeRecords.add(ser);
        ser = new StraightEdgeRecord();
        ser.deltaX = (int)Math.round(-1000.0);
        dsh.shapes.shapeRecords.add(ser);
        dsh.shapes.shapeRecords.add(new EndShapeRecord());
        dsh.writeTag(sos2);
        DefineButton2Tag overVideoButton = new DefineButton2Tag(swf);
        overVideoButton.buttonId = overVideoButtonId;
        BUTTONRECORD br = new BUTTONRECORD();
        br.buttonStateUp = false;
        br.buttonStateDown = false;
        br.buttonStateOver = false;
        br.buttonStateHitTest = true;
        br.characterId = progressBarShapeId;
        br.placeDepth = 1;
        br.colorTransform = new CXFORMWITHALPHA();
        br.placeMatrix = new MATRIX();
        overVideoButton.characters.add(br);
        BUTTONCONDACTION bca = new BUTTONCONDACTION(swf, overVideoButton);
        bca.isLast = true;
        ActionScript2Parser ap = new ActionScript2Parser(swf, bca);
        try {
            bca.setActions(ap.actionsFromString("on(press){stopped = !stopped; if(stopped) {stop();}else{play();}}", swf.getCharset()));
        }
        catch (CompilationException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ActionParseException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        overVideoButton.actions.add(bca);
        overVideoButton.writeTag(sos2);
        DefineButton2Tag progressBarButton = new DefineButton2Tag(swf);
        progressBarButton.buttonId = progressBarButtonId;
        progressBarButton.characters.add(br);
        bca = new BUTTONCONDACTION(swf, overVideoButton);
        bca.isLast = true;
        ap = new ActionScript2Parser(swf, bca);
        try {
            bca.setActions(ap.actionsFromString("on(press){var f = Math.round(_root._xmouse*" + numFrames + "/" + (double)width / 20.0 + ");if(stopped){gotoAndStop(f);}else{gotoAndPlay(f);}}", swf.getCharset()));
        }
        catch (CompilationException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ActionParseException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        progressBarButton.actions.add(bca);
        progressBarButton.writeTag(sos2);
        Matrix m = new Matrix();
        m.translate(xmin, ymin + height - progressBarHeight * 20);
        m.scale(1.0, progressBarHeight * 20);
        new PlaceObject2Tag(swf, false, 2, progressBarShapeId, m.toMATRIX(), null, -1, null, -1, null).writeTag(sos2);
        m = new Matrix();
        m.scale((double)width / 1000.0, height - progressBarHeight * 20);
        new PlaceObject2Tag(swf, false, 3, overVideoButtonId, m.toMATRIX(), null, -1, null, -1, null).writeTag(sos2);
        m = new Matrix();
        m.translate(xmin, ymin + height - progressBarHeight * 20);
        m.scale((double)width / 1000.0, progressBarHeight * 20);
        new PlaceObject2Tag(swf, false, 4, progressBarButtonId, m.toMATRIX(), null, -1, null, -1, null).writeTag(sos2);
        DoActionTag doAction = new DoActionTag(swf);
        ap = new ActionScript2Parser(swf, doAction);
        try {
            doAction.setActions(ap.actionsFromString("var stopped = false;", swf.getCharset()));
        }
        catch (CompilationException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ActionParseException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PreviewExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        doAction.writeTag(sos2);
    }

    /*
     * WARNING - void declaration
     */
    public SWFHeader exportSwf(OutputStream os, TreeItem treeItem, Color backgroundColor, int fontPageNum, boolean showControls) throws IOException, ActionParseException {
        byte[] data;
        SWF swf = (SWF)treeItem.getOpenable();
        if (treeItem instanceof TagScript) {
            treeItem = ((TagScript)treeItem).getTag();
        }
        int frameCount = 1;
        float frameRate = swf.frameRate;
        HashMap<Integer, VideoFrameTag> videoFrames = new HashMap<Integer, VideoFrameTag>();
        if (treeItem instanceof DefineVideoStreamTag) {
            DefineVideoStreamTag vs = (DefineVideoStreamTag)treeItem;
            SWF.populateVideoFrames(vs.getCharacterId(), swf.getTags(), videoFrames);
            frameCount = videoFrames.size();
        }
        List<Object> soundFrames = new ArrayList();
        if (treeItem instanceof SoundStreamHeadTypeTag) {
            SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)treeItem;
            for (SoundStreamFrameRange range : head.getRanges()) {
                soundFrames.addAll(range.blocks);
            }
        }
        if (treeItem instanceof SoundStreamFrameRange) {
            soundFrames = ((SoundStreamFrameRange)treeItem).blocks;
            frameCount = soundFrames.size();
        }
        if (treeItem instanceof DefineMorphShapeTag || treeItem instanceof DefineMorphShape2Tag) {
            frameRate = 30.0f;
            frameCount = (int)(2.0f * frameRate);
        }
        if (treeItem instanceof DefineSoundTag) {
            frameCount = 1;
        }
        if (treeItem instanceof DefineSpriteTag) {
            frameCount = ((DefineSpriteTag)treeItem).frameCount;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            SetBackgroundColorTag setBgColorTag;
            SWFOutputStream sos2 = new SWFOutputStream(baos, 10, swf.getCharset());
            RECT outrect = new RECT(swf.displayRect);
            RECT treeItemBounds = null;
            if (treeItem instanceof FontTag) {
                outrect.Xmin = 0;
                outrect.Ymin = 0;
                outrect.Xmax = 10000;
                outrect.Ymax = 10000;
            } else if (treeItem instanceof BoundedTag) {
                treeItemBounds = ((BoundedTag)((Object)treeItem)).getRect();
            } else if (treeItem instanceof Frame) {
                treeItemBounds = ((Frame)treeItem).timeline.timelined.getRect();
            }
            if (showControls) {
                outrect = new RECT(treeItemBounds);
            } else if (treeItemBounds != null) {
                if (outrect.getWidth() < treeItemBounds.getWidth()) {
                    outrect.Xmax += treeItemBounds.getWidth() - outrect.getWidth();
                }
                if (outrect.getHeight() < treeItemBounds.getHeight()) {
                    outrect.Ymax += treeItemBounds.getHeight() - outrect.getHeight();
                }
            }
            if (!(treeItem instanceof DefineVideoStreamTag) && !(treeItem instanceof MorphShapeTag)) {
                showControls = false;
            }
            int progressBarHeight = 20;
            if (showControls) {
                outrect.Ymax += progressBarHeight * 20;
            }
            int width = outrect.getWidth();
            int height = outrect.getHeight();
            sos2.writeRECT(outrect);
            sos2.writeUFIXED8(frameRate);
            sos2.writeUI16(frameCount);
            FileAttributesTag fa = swf.getFileAttributes();
            if (fa != null) {
                try {
                    FileAttributesTag fa2 = (FileAttributesTag)fa.cloneTag();
                    fa2.actionScript3 = false;
                    fa2.setModified(true);
                    fa2.writeTag(sos2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((setBgColorTag = swf.getBackgroundColor()) == null && backgroundColor != null) {
                setBgColorTag = new SetBackgroundColorTag(swf, new RGB(backgroundColor));
            }
            if (setBgColorTag != null) {
                setBgColorTag.writeTag(sos2);
            }
            LinkedHashSet<Integer> doneCharacters = new LinkedHashSet<Integer>();
            if (treeItem instanceof Frame) {
                Frame fn = (Frame)treeItem;
                Timelined parent = fn.timeline.timelined;
                for (Object t : parent.getTags()) {
                    int characterId;
                    if (t instanceof FileAttributesTag || t instanceof SetBackgroundColorTag || t instanceof DoActionTag || t instanceof DoInitActionTag || t instanceof ABCContainerTag || t instanceof SymbolClassTag || t instanceof ExportAssetsTag) continue;
                    LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>();
                    ((Tag)t).getNeededCharactersDeep(linkedHashSet);
                    Iterator iterator = linkedHashSet.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        if (doneCharacters.contains(n)) continue;
                        PreviewExporter.writeTag(swf.getCharacter(n), sos2, doneCharacters);
                    }
                    if (!(t instanceof CharacterTag) || (characterId = ((CharacterTag)t).getCharacterId()) == -1) continue;
                    PreviewExporter.writeTag((Tag)t, sos2, doneCharacters);
                }
                RECT r = parent.getRect();
                for (Map.Entry entry : fn.layers.entrySet()) {
                    PlaceObjectTypeTag pot = ((DepthState)entry.getValue()).toPlaceObjectTag((Integer)entry.getKey());
                    MATRIX mATRIX = new MATRIX(pot.getMatrix());
                    mATRIX.translateX += width / 2 - r.getWidth() / 2;
                    mATRIX.translateY += height / 2 - r.getHeight() / 2;
                    pot.setMatrix(mATRIX);
                    pot.writeTag(sos2);
                }
                new ShowFrameTag(swf).writeTag(sos2);
            } else {
                int n;
                boolean isSprite = false;
                if (treeItem instanceof DefineSpriteTag) {
                    isSprite = true;
                }
                int chtId = -1;
                if (treeItem instanceof CharacterTag) {
                    chtId = ((CharacterTag)treeItem).getCharacterId();
                }
                if (treeItem instanceof DefineBitsTag) {
                    JPEGTablesTag jtt = swf.getJtt();
                    if (jtt != null) {
                        jtt.writeTag(sos2);
                    }
                } else if (!(treeItem instanceof AloneTag)) {
                    HashSet<Integer> needed = new HashSet<Integer>();
                    ((Tag)treeItem).getNeededCharactersDeep(needed);
                    Iterator t = needed.iterator();
                    while (t.hasNext()) {
                        JPEGTablesTag jPEGTablesTag;
                        int n2 = (Integer)t.next();
                        if (isSprite && chtId == n2) continue;
                        CharacterTag characterTag = swf.getCharacter(n2);
                        if (characterTag instanceof DefineBitsTag && (jPEGTablesTag = swf.getJtt()) != null) {
                            jPEGTablesTag.writeTag(sos2);
                        }
                        PreviewExporter.writeTag(characterTag, sos2, doneCharacters);
                    }
                }
                PreviewExporter.writeTag((Tag)treeItem, sos2, doneCharacters);
                MATRIX mat = new MATRIX();
                mat.hasRotate = false;
                mat.hasScale = false;
                mat.translateX = 0;
                mat.translateY = 0;
                int rxmin = 0;
                boolean bl = false;
                if (treeItem instanceof BoundedTag) {
                    RECT r = ((BoundedTag)((Object)treeItem)).getRect();
                    rxmin = r.Xmin;
                    n = r.Ymin;
                    mat.translateX = -r.Xmin;
                    mat.translateY = -r.Ymin;
                    mat.translateX = mat.translateX + width / 2 - r.getWidth() / 2;
                    mat.translateY = mat.translateY + (showControls ? height - progressBarHeight * 20 : height) / 2 - r.getHeight() / 2;
                } else {
                    mat.translateX = width / 4;
                    mat.translateY = height / 4;
                }
                if (treeItem instanceof FontTag) {
                    FontTag ft = (FontTag)PreviewExporter.classicTag((Tag)treeItem);
                    int n3 = ft.getGlyphShapeTable().size();
                    int countGlyphs = Math.min(400, n3);
                    int fontId = swf.getCharacterId(ft);
                    int cols = (int)Math.ceil(Math.sqrt(countGlyphs));
                    int rows = (int)Math.ceil((float)countGlyphs / (float)cols);
                    if (rows == 0) {
                        rows = 1;
                        cols = 1;
                    }
                    int x = 0;
                    int y = 0;
                    int firstGlyphIndex = fontPageNum * 400;
                    countGlyphs = Math.min(400, n3 - firstGlyphIndex);
                    List<SHAPE> shapes = ft.getGlyphShapeTable();
                    int maxw = 0;
                    for (int f = firstGlyphIndex; f < firstGlyphIndex + countGlyphs; ++f) {
                        RECT b = shapes.get(f).getBounds(1);
                        if (b.Xmin == Integer.MAX_VALUE || b.Ymin == Integer.MAX_VALUE) continue;
                        int w = (int)((double)b.getWidth() / ft.getDivider());
                        if (w > maxw) {
                            maxw = w;
                        }
                        ++x;
                    }
                    x = 0;
                    int BORDER = 60;
                    int textHeight = height / rows;
                    while ((double)(maxw * textHeight) / 1024.0 > (double)(width / cols - 2 * BORDER)) {
                        --textHeight;
                    }
                    MATRIX tmat = new MATRIX();
                    for (int f = firstGlyphIndex; f < firstGlyphIndex + countGlyphs; ++f) {
                        if (x >= cols) {
                            x = 0;
                            ++y;
                        }
                        ArrayList<TEXTRECORD> rec = new ArrayList<TEXTRECORD>();
                        TEXTRECORD tr = new TEXTRECORD();
                        RECT b = shapes.get(f).getBounds(1);
                        int xmin = b.Xmin == Integer.MAX_VALUE ? 0 : (int)((double)b.Xmin / ft.getDivider());
                        xmin = (int)((double)xmin * ((double)textHeight / 1024.0));
                        int ymin = b.Ymin == Integer.MAX_VALUE ? 0 : (int)((double)b.Ymin / ft.getDivider());
                        ymin = (int)((double)ymin * ((double)textHeight / 1024.0));
                        int w = (int)((double)b.getWidth() / ft.getDivider());
                        w = (int)((double)w * ((double)textHeight / 1024.0));
                        int h = (int)((double)b.getHeight() / ft.getDivider());
                        h = (int)((double)h * ((double)textHeight / 1024.0));
                        tr.fontId = fontId;
                        tr.styleFlagsHasFont = true;
                        tr.textHeight = textHeight;
                        tr.xOffset = -xmin;
                        tr.yOffset = 0;
                        tr.styleFlagsHasXOffset = true;
                        tr.styleFlagsHasYOffset = true;
                        tr.glyphEntries = new ArrayList<GLYPHENTRY>(1);
                        tr.styleFlagsHasColor = true;
                        tr.textColor = new RGB(0, 0, 0);
                        GLYPHENTRY ge = new GLYPHENTRY();
                        double ga = ft.getGlyphAdvance(f);
                        int cw = ga == -1.0 ? w : (int)(ga / ft.getDivider() * (double)textHeight / 1024.0);
                        ge.glyphAdvance = 0;
                        ge.glyphIndex = f;
                        tr.glyphEntries.add(ge);
                        rec.add(tr);
                        tmat.translateX = x * width / cols + width / cols / 2 - w / 2;
                        tmat.translateY = y * height / rows + height / rows / 2;
                        new DefineTextTag(swf, 999 + f, new RECT(0, cw, ymin, ymin + h), new MATRIX(), rec).writeTag(sos2);
                        new PlaceObject2Tag(swf, false, 1 + f, 999 + f, tmat, null, 0, null, -1, null).writeTag(sos2);
                        ++x;
                    }
                    new ShowFrameTag(swf).writeTag(sos2);
                } else if (treeItem instanceof DefineMorphShapeTag || treeItem instanceof DefineMorphShape2Tag) {
                    if (showControls) {
                        this.addControls(rxmin, n, progressBarHeight, swf, sos2, width, 65536, height);
                    }
                    new PlaceObject2Tag(swf, false, 1, chtId, mat, null, 0, null, -1, null).writeTag(sos2);
                    new ShowFrameTag(swf).writeTag(sos2);
                    for (int ratio = 0; ratio < 65536; ratio += 65536 / frameCount) {
                        new PlaceObject2Tag(swf, true, 1, chtId, mat, null, ratio, null, -1, null).writeTag(sos2);
                        if (showControls) {
                            this.updateProgressBar(rxmin, n, swf, sos2, width, height, progressBarHeight, ratio, 65536);
                        }
                        new ShowFrameTag(swf).writeTag(sos2);
                    }
                } else if (treeItem instanceof SoundStreamHeadTypeTag) {
                    for (SoundStreamBlockTag soundStreamBlockTag : soundFrames) {
                        soundStreamBlockTag.writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                    }
                } else if (treeItem instanceof DefineSoundTag) {
                    ExportAssetsTag ea = new ExportAssetsTag(swf);
                    DefineSoundTag defineSoundTag = (DefineSoundTag)treeItem;
                    ea.tags.add(defineSoundTag.soundId);
                    ea.names.add("my_define_sound");
                    ea.writeTag(sos2);
                    DoActionTag doa = new DoActionTag(swf, null);
                    ActionList actions = ASMParser.parse(0L, false, "ConstantPool \"_root\" \"my_sound\" \"Sound\" \"my_define_sound\" \"attachSound\" \"start\"\nStopSounds\nPush \"_root\"\nGetVariable\nPush \"my_sound\" 0.0 \"Sound\"\nNewObject\nSetMember\nPush \"my_define_sound\" 1 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"attachSound\"\nCallMethod\nPop\nPush 9999 0.0 2 \"_root\"\nGetVariable\nPush \"my_sound\"\nGetMember\nPush \"start\"\nCallMethod\nPop\nStop", swf.version, false, swf.getCharset());
                    doa.setActions(actions);
                    doa.writeTag(sos2);
                    new ShowFrameTag(swf).writeTag(sos2);
                } else if (treeItem instanceof DefineVideoStreamTag) {
                    DefineVideoStreamTag dv = (DefineVideoStreamTag)treeItem;
                    ArrayList<VideoFrameTag> arrayList = new ArrayList<VideoFrameTag>(videoFrames.values());
                    Collections.sort(arrayList, new Comparator<VideoFrameTag>(){

                        @Override
                        public int compare(VideoFrameTag o1, VideoFrameTag o2) {
                            return o1.frameNum - o2.frameNum;
                        }
                    });
                    if (showControls) {
                        this.addControls(rxmin, n, progressBarHeight, swf, sos2, width, videoFrames.size(), height);
                    }
                    new PlaceObject2Tag(swf, false, 1, chtId, mat, null, -1, null, -1, null).writeTag(sos2);
                    boolean first = true;
                    int ratio = 0;
                    for (VideoFrameTag f : arrayList) {
                        if (!first) {
                            ratio = f.frameNum;
                            new PlaceObject2Tag(swf, true, 1, -1, null, null, ratio, null, -1, null).writeTag(sos2);
                            if (showControls) {
                                this.updateProgressBar(rxmin, n, swf, sos2, width, height, progressBarHeight, ratio, videoFrames.size());
                            }
                        }
                        f.writeTag(sos2);
                        new ShowFrameTag(swf).writeTag(sos2);
                        first = false;
                    }
                } else if (treeItem instanceof DefineSpriteTag) {
                    void var28_53;
                    DefineSpriteTag s = (DefineSpriteTag)treeItem;
                    Object var28_52 = null;
                    for (Tag t : s.getTags()) {
                        if (t instanceof EndTag) break;
                        if (t instanceof PlaceObjectTypeTag) {
                            PlaceObjectTypeTag pt = (PlaceObjectTypeTag)t;
                            MATRIX m = pt.getMatrix();
                            MATRIX m2 = new Matrix(m).preConcatenate(new Matrix(mat)).toMATRIX();
                            pt.writeTagWithMatrix(sos2, m2);
                            Tag tag = t;
                            continue;
                        }
                        if (t instanceof DoActionTag) continue;
                        t.writeTagNoScripts(sos2);
                        Tag tag = t;
                    }
                    if (!s.getTags().isEmpty() && var28_53 != null && !(var28_53 instanceof ShowFrameTag)) {
                        new ShowFrameTag(swf).writeTag(sos2);
                    }
                } else {
                    new PlaceObject2Tag(swf, false, 1, chtId, mat, null, 0, null, -1, null).writeTag(sos2);
                    new ShowFrameTag(swf).writeTag(sos2);
                }
            }
            new EndTag(swf).writeTag(sos2);
            data = baos.toByteArray();
        }
        SWFHeader result = new SWFHeader();
        result.version = Math.max(10, swf.version);
        result.frameRate = frameRate;
        SWFOutputStream sos = new SWFOutputStream(os, result.version, swf.getCharset());
        sos.write("FWS".getBytes());
        sos.write(swf.version);
        result.fileSize = sos.getPos() + (long)data.length + 4L;
        sos.writeUI32(result.fileSize);
        sos.write(data);
        os.flush();
        return result;
    }

    private static Tag classicTag(Tag t) {
        if (t instanceof DefineCompactedFont) {
            return ((DefineCompactedFont)t).toClassicFont();
        }
        return t;
    }

    private static void writeTag(Tag t, SWFOutputStream sos, Set<Integer> doneCharacters) throws IOException {
        List<CharacterIdTag> chIdTags;
        if ((t = PreviewExporter.classicTag(t)) instanceof CharacterIdTag) {
            int chId = ((CharacterIdTag)((Object)t)).getCharacterId();
            if (doneCharacters.contains(chId)) {
                return;
            }
            doneCharacters.add(chId);
        }
        t.writeTagNoScripts(sos);
        if (t instanceof CharacterIdTag && (chIdTags = t.getSwf().getCharacterIdTags(((CharacterIdTag)((Object)t)).getCharacterId())) != null) {
            for (CharacterIdTag chIdTag : chIdTags) {
                if (chIdTag instanceof PlaceObjectTypeTag || chIdTag instanceof RemoveTag) continue;
                LinkedHashSet<Integer> needed = new LinkedHashSet<Integer>();
                ((Tag)((Object)chIdTag)).getNeededCharactersDeep(needed);
                Iterator iterator = needed.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (doneCharacters.contains(n)) continue;
                    PreviewExporter.writeTag(((Tag)((Object)chIdTag)).getSwf().getCharacter(n), sos, doneCharacters);
                }
                ((Tag)((Object)chIdTag)).writeTagNoScripts(sos);
            }
        }
    }
}

