/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.commonshape;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.RequiresNormalizedFonts;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.modes.FontExportMode;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.helpers.Helper;
import java.awt.Color;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGExporter
implements RequiresNormalizedFonts {
    protected static final String sNamespace = "http://www.w3.org/2000/svg";
    protected static final String xlinkNamespace = "http://www.w3.org/1999/xlink";
    protected static final String ffdecNamespace = "https://www.free-decompiler.com/flash";
    protected Document _svg;
    protected Element _svgDefs;
    protected CDATASection _svgStyle;
    protected Stack<Element> _svgGs = new Stack();
    public List<Element> gradients;
    protected int lastPatternId;
    protected int lastClipId;
    public Map<ExportKey, String> exportedTags = new HashMap<ExportKey, String>();
    public Map<Tag, Map<Integer, String>> exportedChars = new HashMap<Tag, Map<Integer, String>>();
    private final Map<String, Integer> lastIds = new HashMap<String, Integer>();
    private final HashSet<String> fontFaces = new HashSet();
    public boolean useTextTag = Configuration.textExportExportFontFace.get();
    private double zoom;
    private Map<Integer, FontTag> normalizedFonts = new LinkedHashMap<Integer, FontTag>();
    private Map<Integer, TextTag> normalizedTexts = new LinkedHashMap<Integer, TextTag>();

    @Override
    public void setNormalizedFonts(Map<Integer, FontTag> normalizedFonts, Map<Integer, TextTag> normalizedTexts) {
        this.normalizedFonts = normalizedFonts;
        this.normalizedTexts = normalizedTexts;
    }

    @Override
    public Map<Integer, FontTag> getNormalizedFonts() {
        return this.normalizedFonts;
    }

    @Override
    public Map<Integer, TextTag> getNormalizedTexts() {
        return this.normalizedTexts;
    }

    public SVGExporter(ExportRectangle bounds, double zoom, String objectType) {
        this(bounds, zoom, objectType, null);
    }

    public SVGExporter(ExportRectangle bounds, double zoom, String objectType, Color backgroundColor) {
        this.zoom = zoom;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            DOMImplementation impl = docBuilder.getDOMImplementation();
            DocumentType svgDocType = impl.createDocumentType("svg", "-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
            this._svg = impl.createDocument(sNamespace, "svg", svgDocType);
            Element svgRoot = this._svg.getDocumentElement();
            svgRoot.setAttribute("xmlns:xlink", xlinkNamespace);
            svgRoot.setAttribute("xmlns:ffdec", ffdecNamespace);
            if (bounds != null) {
                if (Configuration.svgRetainBounds.get().booleanValue()) {
                    svgRoot.setAttribute("width", bounds.xMax / 20.0 + "px");
                    svgRoot.setAttribute("height", bounds.yMax / 20.0 + "px");
                } else {
                    svgRoot.setAttribute("width", bounds.getWidth() / 20.0 + "px");
                    svgRoot.setAttribute("height", bounds.getHeight() / 20.0 + "px");
                }
                this.createDefGroup(bounds, null, zoom);
                if (backgroundColor != null) {
                    Element rect = this._svg.createElement("rect");
                    rect.setAttribute("fill", new RGBA(backgroundColor).toHexRGB());
                    if (Configuration.svgRetainBounds.get().booleanValue()) {
                        rect.setAttribute("width", bounds.xMax / 20.0 + "px");
                        rect.setAttribute("height", bounds.yMax / 20.0 + "px");
                    } else {
                        rect.setAttribute("width", bounds.getWidth() / 20.0 + "px");
                        rect.setAttribute("height", bounds.getHeight() / 20.0 + "px");
                    }
                    this._svgGs.peek().appendChild(rect);
                }
            }
            svgRoot.setAttribute("ffdec:objectType", objectType);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(SVGExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.gradients = new ArrayList<Element>();
    }

    public double getZoom() {
        return this.zoom;
    }

    private Element getDefs() {
        if (this._svgDefs == null) {
            this._svgDefs = this._svg.createElement("defs");
            this._svg.getDocumentElement().appendChild(this._svgDefs);
        }
        return this._svgDefs;
    }

    private CDATASection getStyle() {
        if (this._svgStyle == null) {
            Element style = this._svg.createElement("style");
            this._svgStyle = this._svg.createCDATASection("");
            style.appendChild(this._svgStyle);
            this.getDefs().appendChild(style);
        }
        return this._svgStyle;
    }

    public final boolean hasSmallStrokes() {
        Element e;
        int i;
        NodeList nodes = this._svgGs.peek().getElementsByTagName("path");
        for (i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            if (!"true".equals(e.getAttribute("ffdec:has-small-stroke"))) continue;
            return true;
        }
        nodes = this._svgGs.peek().getElementsByTagName("use");
        for (i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            if (!"true".equals(e.getAttribute("ffdec:has-small-stroke"))) continue;
            return true;
        }
        return false;
    }

    public final void createDefGroup(ExportRectangle bounds, String id) {
        this.createDefGroup(bounds, id, 1.0);
    }

    public final void createDefGroup(ExportRectangle bounds, String id, double zoom) {
        Element g = this._svg.createElement("g");
        if (bounds != null) {
            Matrix mat = Configuration.svgRetainBounds.get() != false ? new Matrix() : Matrix.getTranslateInstance(-bounds.xMin, -bounds.yMin);
            mat.scale(zoom);
            g.setAttribute("transform", mat.getSvgTransformationString(20.0, 1.0));
        }
        if (id != null) {
            g.setAttribute("id", id);
        }
        if (this._svgGs.size() == 0) {
            this._svg.getDocumentElement().appendChild(g);
        } else {
            this.getDefs().appendChild(g);
        }
        this._svgGs.add(g);
    }

    public boolean endGroup() {
        Element g = this._svgGs.pop();
        if (g.getChildNodes().getLength() == 0) {
            g.getParentNode().removeChild(g);
            return false;
        }
        return true;
    }

    public final Element createClipPath(Matrix transform, String id) {
        Element group = this.createSubGroup(id, "clipPath");
        if (transform != null) {
            group.setAttribute("transform", transform.getSvgTransformationString(20.0, 1.0));
        }
        return group;
    }

    public final Element createSubGroup(Matrix transform, String id) {
        Element group = this.createSubGroup(id, "g");
        if (transform != null) {
            group.setAttribute("transform", transform.getSvgTransformationString(20.0, 1.0));
        }
        return group;
    }

    private Element createSubGroup(String id, String tagName) {
        Element group = this._svg.createElement(tagName);
        if (id != null) {
            group.setAttribute("id", id);
        }
        this._svgGs.peek().appendChild(group);
        this._svgGs.add(group);
        return group;
    }

    public void addToGroup(Node newChild) {
        this._svgGs.peek().appendChild(newChild);
    }

    public void addToDefs(Node newChild) {
        this.getDefs().appendChild(newChild);
    }

    public Element createElement(String tagName) {
        return this._svg.createElement(tagName);
    }

    public String getSVG() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(this._svg);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            Logger.getLogger(SVGExporter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return writer.toString();
    }

    private String addClip(String path) {
        ++this.lastClipId;
        Element clipPathElement = this._svg.createElement("clipPath");
        clipPathElement.setAttribute("id", "clip" + this.lastClipId);
        Element pathElement = this._svg.createElement("path");
        pathElement.setAttribute("d", path);
        clipPathElement.appendChild(pathElement);
        this._svgGs.peek().appendChild(clipPathElement);
        return "url(#clip" + this.lastClipId + ")";
    }

    private void addScalingGridUse(Matrix transform, RECT boundRect, String href, String instanceName, RECT scalingRect, String characterId, String characterName, int blendMode, List<FILTER> filters) {
        ExportRectangle exRect;
        Element image = this._svg.createElement("g");
        ExportRectangle newRect = exRect = new ExportRectangle(boundRect);
        if (transform == null) {
            transform = new Matrix();
        }
        newRect = transform.transform(exRect);
        transform = transform.clone();
        transform = Matrix.getTranslateInstance(newRect.xMin, newRect.yMin);
        double scaleWidth = newRect.getWidth() - (double)scalingRect.Xmin - (double)(boundRect.Xmax - scalingRect.Xmax);
        double originalWidth = boundRect.getWidth() - scalingRect.Xmin - (boundRect.Xmax - scalingRect.Xmax);
        double scaleX = scaleWidth / originalWidth;
        double scaleHeight = newRect.getHeight() - (double)scalingRect.Ymin - (double)(boundRect.Ymax - scalingRect.Ymax);
        double originalHeight = boundRect.getHeight() - scalingRect.Ymin - (boundRect.Ymax - scalingRect.Ymax);
        double scaleY = scaleHeight / originalHeight;
        Element leftTopCorner = this._svg.createElement("use");
        leftTopCorner.setAttribute("transform", transform.getSvgTransformationString(20.0, 1.0));
        leftTopCorner.setAttribute("clip-path", this.addClip("M 0,0 L " + Math.rint((double)scalingRect.Xmin / 20.0) + ",0 L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L 0," + Math.rint((double)scalingRect.Ymin / 20.0) + " Z"));
        leftTopCorner.setAttribute("xlink:href", "#" + href);
        image.appendChild(leftTopCorner);
        Element bottomLeftCorner = this._svg.createElement("use");
        Matrix transform2 = transform.clone();
        transform2.translateY += newRect.getHeight() - (double)boundRect.getHeight();
        bottomLeftCorner.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        bottomLeftCorner.setAttribute("clip-path", this.addClip("M 0," + Math.rint((double)(boundRect.getHeight() - (boundRect.Ymax - scalingRect.Ymax)) / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)(boundRect.getHeight() - (boundRect.Ymax - scalingRect.Ymax)) / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)boundRect.getHeight() / 20.0) + " L 0," + Math.rint((double)boundRect.getHeight() / 20.0) + " Z"));
        bottomLeftCorner.setAttribute("xlink:href", "#" + href);
        image.appendChild(bottomLeftCorner);
        Element topRightCorner = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translateX += newRect.getWidth() - (double)boundRect.getWidth();
        topRightCorner.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        topRightCorner.setAttribute("clip-path", this.addClip("M " + Math.rint(((double)boundRect.getWidth() - (exRect.xMax - (double)scalingRect.Xmax)) / 20.0) + ",0 L " + Math.rint((double)boundRect.getWidth() / 20.0) + ",0 L " + Math.rint((double)boundRect.getWidth() / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint(((double)boundRect.getWidth() - (exRect.xMax - (double)scalingRect.Xmax)) / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " Z"));
        topRightCorner.setAttribute("xlink:href", "#" + href);
        image.appendChild(topRightCorner);
        Element bottomRightCorner = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translateX += newRect.getWidth() - (double)boundRect.getWidth();
        transform2.translateY += newRect.getHeight() - (double)boundRect.getHeight();
        bottomRightCorner.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        bottomRightCorner.setAttribute("clip-path", this.addClip("M " + Math.rint(((double)boundRect.getWidth() - (exRect.xMax - (double)scalingRect.Xmax)) / 20.0) + "," + Math.rint((double)(boundRect.getHeight() - (boundRect.Ymax - scalingRect.Ymax)) / 20.0) + " L " + Math.rint((double)boundRect.getWidth() / 20.0) + "," + Math.rint((double)(boundRect.getHeight() - (boundRect.Ymax - scalingRect.Ymax)) / 20.0) + " L " + Math.rint((double)boundRect.getWidth() / 20.0) + "," + Math.rint((double)boundRect.getHeight() / 20.0) + " L " + Math.rint(((double)boundRect.getWidth() - (exRect.xMax - (double)scalingRect.Xmax)) / 20.0) + "," + Math.rint((double)boundRect.getHeight() / 20.0) + " Z"));
        bottomRightCorner.setAttribute("xlink:href", "#" + href);
        image.appendChild(bottomRightCorner);
        Element top = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translate(scalingRect.Xmin, 0.0);
        transform2.scale(scaleX, 1.0);
        transform2.translate(-scalingRect.Xmin, 0.0);
        top.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        top.setAttribute("clip-path", this.addClip("M " + Math.rint((double)scalingRect.Xmin / 20.0) + ",0 L " + Math.rint((double)scalingRect.Xmax / 20.0) + ",0 L " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " Z"));
        top.setAttribute("xlink:href", "#" + href);
        image.appendChild(top);
        Element left = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translate(0.0, scalingRect.Ymin);
        transform2.scale(1.0, scaleY);
        transform2.translate(0.0, -scalingRect.Ymin);
        left.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        left.setAttribute("clip-path", this.addClip("M 0," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " L 0," + Math.rint((double)scalingRect.Ymax / 20.0) + " Z"));
        left.setAttribute("xlink:href", "#" + href);
        image.appendChild(left);
        Element bottom = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translate(scalingRect.Xmin, 0.0);
        transform2.scale(scaleX, 1.0);
        transform2.translate(-scalingRect.Xmin, 0.0);
        transform2.translateY += newRect.getHeight() - (double)boundRect.getHeight();
        bottom.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        bottom.setAttribute("clip-path", this.addClip("M " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " L " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " L " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)boundRect.Ymax / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)boundRect.Ymax / 20.0) + " Z"));
        bottom.setAttribute("xlink:href", "#" + href);
        image.appendChild(bottom);
        Element right = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translate(0.0, scalingRect.Ymin);
        transform2.scale(1.0, scaleY);
        transform2.translate(0.0, -scalingRect.Ymin);
        transform2.translateX += newRect.getWidth() - (double)boundRect.getWidth();
        right.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        right.setAttribute("clip-path", this.addClip("M " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)boundRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)boundRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " L " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " Z"));
        right.setAttribute("xlink:href", "#" + href);
        image.appendChild(right);
        Element center = this._svg.createElement("use");
        transform2 = transform.clone();
        transform2.translate(scalingRect.Xmin, scalingRect.Ymin);
        transform2.scale(scaleX, scaleY);
        transform2.translate(-scalingRect.Xmin, -scalingRect.Ymin);
        center.setAttribute("transform", transform2.getSvgTransformationString(20.0, 1.0));
        center.setAttribute("clip-path", this.addClip("M " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymin / 20.0) + " L " + Math.rint((double)scalingRect.Xmax / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " L " + Math.rint((double)scalingRect.Xmin / 20.0) + "," + Math.rint((double)scalingRect.Ymax / 20.0) + " Z"));
        center.setAttribute("xlink:href", "#" + href);
        image.appendChild(center);
        if (instanceName != null) {
            image.setAttribute("id", instanceName);
        }
        if (characterId != null) {
            image.setAttribute("ffdec:characterId", characterId);
        }
        if (characterName != null && !characterName.isEmpty()) {
            image.setAttribute("ffdec:characterName", characterName);
        }
        this.setBlendMode(image, blendMode);
        this.handleFilters(image, filters);
        this._svgGs.peek().appendChild(image);
    }

    private void handleFilters(Element image, List<FILTER> filters) {
        if (filters == null) {
            return;
        }
        Element filtersElement = this._svg.createElement("filter");
        String filterId = this.getUniqueId("filter");
        String in = "SourceGraphic";
        boolean empty = true;
        for (FILTER filter : filters) {
            String result = filter.toSvg(this._svg, filtersElement, this, in);
            if (result == null) continue;
            empty = false;
            in = result;
        }
        if (empty) {
            return;
        }
        filtersElement.setAttribute("id", filterId);
        image.setAttribute("filter", "url(#" + filterId + ")");
        this._svgGs.peek().appendChild(filtersElement);
    }

    public Element addUse(Matrix transform, RECT boundRect, String href, String instanceName, RECT scalingRect) {
        return this.addUse(transform, boundRect, href, instanceName, scalingRect, null, null, 1, new ArrayList<FILTER>());
    }

    public Element addUse(Matrix transform, RECT boundRect, String href, String instanceName, RECT scalingRect, String characterId, String characterName, int blendMode, List<FILTER> filters) {
        if (scalingRect != null && (transform == null || Double.compare(transform.rotateSkew0, 0.0) == 0 && Double.compare(transform.rotateSkew1, 0.0) == 0)) {
            this.addScalingGridUse(transform, boundRect, href, instanceName, scalingRect, characterId, characterName, blendMode, filters);
            return null;
        }
        Element image = this._svg.createElement("use");
        if (transform != null) {
            image.setAttribute("transform", transform.getSvgTransformationString(20.0, 1.0));
            image.setAttribute("width", Double.toString((double)boundRect.getWidth() / 20.0));
            image.setAttribute("height", Double.toString((double)boundRect.getHeight() / 20.0));
        }
        if (instanceName != null) {
            image.setAttribute("id", instanceName);
        }
        if (characterId != null) {
            image.setAttribute("ffdec:characterId", characterId);
        }
        if (characterName != null && !characterName.isEmpty()) {
            image.setAttribute("ffdec:characterName", characterName);
        }
        this.setBlendMode(image, blendMode);
        this.handleFilters(image, filters);
        image.setAttribute("xlink:href", "#" + href);
        this._svgGs.peek().appendChild(image);
        return image;
    }

    private void setBlendMode(Element element, int blendMode) {
        switch (blendMode) {
            case 3: {
                element.setAttribute("style", "mix-blend-mode: multiply");
                break;
            }
            case 4: {
                element.setAttribute("style", "mix-blend-mode: screen");
                break;
            }
            case 13: {
                element.setAttribute("style", "mix-blend-mode: overlay");
                break;
            }
            case 6: {
                element.setAttribute("style", "mix-blend-mode: darken");
                break;
            }
            case 5: {
                element.setAttribute("style", "mix-blend-mode: lighten");
                break;
            }
            case 14: {
                element.setAttribute("style", "mix-blend-mode: hard-light");
                break;
            }
            case 7: {
                element.setAttribute("style", "mix-blend-mode: difference");
                break;
            }
        }
    }

    public void addStyle(String fontFace, byte[] data, FontExportMode mode) {
        if (!this.fontFaces.contains(fontFace)) {
            this.fontFaces.add(fontFace);
            String base64Data = Helper.byteArrayToBase64String(data);
            String value = this.getStyle().getTextContent();
            value = value + Helper.newLine;
            value = value + "      @font-face {" + Helper.newLine;
            value = value + "        font-family: \"" + fontFace + "\";" + Helper.newLine;
            switch (mode) {
                case TTF: {
                    value = value + "        src: url('data:font/truetype;base64," + base64Data + "') format(\"truetype\");" + Helper.newLine;
                    break;
                }
                case WOFF: {
                    value = value + "        src: url('data:font/woff;base64," + base64Data + "') format(\"woff\");" + Helper.newLine;
                }
            }
            value = value + "      }" + Helper.newLine;
            this.getStyle().setTextContent(value);
        }
    }

    public String getUniqueId(String prefix) {
        Integer lastId = this.lastIds.get(prefix);
        if (lastId == null) {
            lastId = 0;
        } else {
            Integer n = lastId;
            lastId = lastId + 1;
        }
        this.lastIds.put(prefix, lastId);
        return prefix + lastId;
    }

    protected static double roundPixels20(double pixels) {
        return (double)Math.round(pixels * 100.0) / 100.0;
    }

    public static class ExportKey {
        private final Tag tag;
        public final ColorTransform colorTransform;
        public final int ratio;
        public final boolean clipped;

        public ExportKey(Tag tag, ColorTransform colorTransform, int ratio, boolean clipped) {
            this.tag = tag;
            this.colorTransform = colorTransform;
            this.ratio = ratio;
            this.clipped = clipped;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.tag);
            hash = 79 * hash + Objects.hashCode(this.colorTransform);
            hash = 79 * hash + this.ratio;
            hash = 79 * hash + (this.clipped ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExportKey other = (ExportKey)obj;
            if (this.ratio != other.ratio) {
                return false;
            }
            if (this.clipped != other.clipped) {
                return false;
            }
            if (!Objects.equals(this.tag, other.tag)) {
                return false;
            }
            return Objects.equals(this.colorTransform, other.colorTransform);
        }
    }
}

