/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.RunnableIOExResult;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.PcodeGraphVizExporter;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.helpers.FileTextWriter;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.stat.Statistics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class ExportScriptTask
implements Callable<File> {
    private static final Logger logger = Logger.getLogger(ExportScriptTask.class.getName());
    ASMSource asm;
    String directory;
    ScriptExportSettings exportSettings;
    String name;
    int index;
    int count;
    AbortRetryIgnoreHandler handler;
    long startTime;
    long stopTime;
    EventListener eventListener;
    Thread thread;

    public ExportScriptTask(AbortRetryIgnoreHandler handler, int index, int count, String name, ASMSource asm, String directory, ScriptExportSettings exportSettings, EventListener evl) {
        this.asm = asm;
        this.directory = directory;
        this.exportSettings = exportSettings;
        this.name = name;
        this.index = index;
        this.count = count;
        this.handler = handler;
        this.eventListener = evl;
    }

    @Override
    public File call() throws IOException, InterruptedException {
        this.thread = Thread.currentThread();
        final String f = Path.combine(this.directory, this.name) + this.exportSettings.getFileExtension();
        RunnableIOExResult<File> rio = new RunnableIOExResult<File>(this){
            final /* synthetic */ ExportScriptTask this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() throws IOException, InterruptedException {
                File file;
                block21: {
                    this.this$0.startTime = System.currentTimeMillis();
                    file = new File(f);
                    if (!this.this$0.exportSettings.singleFile) {
                        Path.createDirectorySafe(new File(this.this$0.directory));
                        if (file.exists() && !Configuration.overwriteExistingFiles.get().booleanValue()) {
                            this.result = file;
                            return;
                        }
                    }
                    try (FileTextWriter writer = this.this$0.exportSettings.singleFile ? null : new FileTextWriter(Configuration.getCodeFormatting(), new FileOutputStream(f));){
                        ActionList as;
                        FileTextWriter writer2 = this.this$0.exportSettings.singleFile ? this.this$0.exportSettings.singleFileWriter : writer;
                        ScriptExportMode exportMode = this.this$0.exportSettings.mode;
                        if (exportMode == ScriptExportMode.HEX) {
                            this.this$0.asm.getActionSourcePrefix(writer2);
                            this.this$0.asm.getActionBytesAsHex(writer2);
                            this.this$0.asm.getActionSourceSuffix(writer2);
                            break block21;
                        }
                        if (exportMode == ScriptExportMode.PCODE_GRAPHVIZ) {
                            new PcodeGraphVizExporter().exportAs12(this.this$0.asm, writer2);
                            break block21;
                        }
                        if (exportMode != ScriptExportMode.AS) {
                            this.this$0.asm.getASMSource(exportMode, writer2, null);
                            break block21;
                        }
                        try (Statistics s = new Statistics("ASMSource.getActions");){
                            as = this.this$0.asm.getActions();
                        }
                        Action.setActionsAddresses(as, 0L);
                        s = new Statistics("Action.actionsToSource");
                        try {
                            this.this$0.asm.getActionScriptSource(writer2, as);
                        }
                        finally {
                            s.close();
                        }
                    }
                }
                this.result = file;
                this.this$0.stopTime = System.currentTimeMillis();
            }
        };
        if (this.eventListener != null) {
            this.eventListener.handleExportingEvent("script", this.index, this.count, f);
        }
        new RetryTask(rio, this.handler).run();
        if (this.eventListener != null) {
            long time = this.stopTime - this.startTime;
            this.eventListener.handleExportedEvent("script", this.index, this.count, f + ", " + Helper.formatTimeSec(time));
        }
        return (File)rio.result;
    }
}

