/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.FillStyle;
import com.jpexs.decompiler.flash.exporters.commonshape.LineStyle;
import com.jpexs.decompiler.flash.exporters.shape.CurvedEdge;
import com.jpexs.decompiler.flash.exporters.shape.IEdge;
import com.jpexs.decompiler.flash.exporters.shape.IShapeExporter;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExportData;
import com.jpexs.decompiler.flash.exporters.shape.StraightEdge;
import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.Cache;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ShapeExporterBase
implements IShapeExporter {
    private static final boolean USE_REVERSE_LOOKUP = true;
    protected final SHAPE shape;
    private final List<FillStyle> _fillStyles;
    private final List<LineStyle> _lineStyles;
    private final List<List<IEdge>> _fillPaths;
    private final List<List<IEdge>> _linePaths;
    private final ColorTransform colorTransform;
    private boolean canUseSmoothing = true;
    protected int windingRule;

    public ShapeExporterBase(int windingRule, int shapeNum, SWF swf, SHAPE shape, ColorTransform colorTransform) {
        this.shape = shape;
        this.colorTransform = colorTransform;
        this.windingRule = windingRule;
        Cache<SHAPE, ShapeExportData> cache = swf.getShapeExportDataCache();
        ShapeExportData cachedData = cache.get(shape);
        if (cachedData == null) {
            ArrayList<FillStyle> fillStyles = new ArrayList<FillStyle>();
            ArrayList<LineStyle> lineStyles = new ArrayList<LineStyle>();
            if (shape instanceof SHAPEWITHSTYLE) {
                SHAPEWITHSTYLE shapeWithStyle = (SHAPEWITHSTYLE)shape;
                for (FILLSTYLE fILLSTYLE : shapeWithStyle.fillStyles.fillStyles) {
                    fillStyles.add(new FillStyle(fILLSTYLE));
                }
                if (shapeNum <= 3) {
                    for (NeedsCharacters needsCharacters : shapeWithStyle.lineStyles.lineStyles) {
                        lineStyles.add(new LineStyle((ILINESTYLE)needsCharacters));
                    }
                } else {
                    for (NeedsCharacters needsCharacters : shapeWithStyle.lineStyles.lineStyles2) {
                        lineStyles.add(new LineStyle((ILINESTYLE)needsCharacters));
                    }
                }
            }
            ArrayList<Map<Integer, List<IEdge>>> fillEdgeMaps = new ArrayList<Map<Integer, List<IEdge>>>();
            ArrayList<Map<Integer, List<IEdge>>> lineEdgeMaps = new ArrayList<Map<Integer, List<IEdge>>>();
            try {
                this.createEdgeMaps(shapeNum, shape, fillStyles, lineStyles, fillEdgeMaps, lineEdgeMaps);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            int count = lineEdgeMaps.size();
            ArrayList<List<IEdge>> fillPaths = new ArrayList<List<IEdge>>(count);
            ArrayList<List<IEdge>> arrayList = new ArrayList<List<IEdge>>(count);
            for (int i = 0; i < count; ++i) {
                fillPaths.add(this.createPathFromEdgeMap((Map)fillEdgeMaps.get(i)));
                arrayList.add(this.createPathFromEdgeMap((Map)lineEdgeMaps.get(i)));
            }
            cachedData = new ShapeExportData();
            cachedData.fillPaths = fillPaths;
            cachedData.linePaths = arrayList;
            cachedData.fillStyles = fillStyles;
            cachedData.lineStyles = lineStyles;
            cache.put(shape, cachedData);
        }
        this._fillStyles = cachedData.fillStyles;
        this._lineStyles = cachedData.lineStyles;
        this._fillPaths = cachedData.fillPaths;
        this._linePaths = cachedData.linePaths;
        this.handleFillPaths(this._fillPaths);
    }

    protected void handleFillPaths(List<List<IEdge>> fillPaths) {
    }

    public void setCanUseSmoothing(boolean canUseSmoothing) {
        this.canUseSmoothing = canUseSmoothing;
    }

    public void export() {
        this.beginShape();
        for (int i = 0; i < this._linePaths.size(); ++i) {
            this.exportFillPath(this._fillPaths.get(i));
            this.exportLinePath(this._linePaths.get(i));
        }
        this.endShape();
    }

    private void createEdgeMaps(int shapeNum, SHAPE shape, List<FillStyle> fillStyles, List<LineStyle> lineStyles, List<Map<Integer, List<IEdge>>> fillEdgeMaps, List<Map<Integer, List<IEdge>>> lineEdgeMaps) {
        int xPos = 0;
        int yPos = 0;
        int fillStyleIdxOffset = 0;
        int lineStyleIdxOffset = 0;
        int currentFillStyleIdx0 = 0;
        int currentFillStyleIdx1 = 0;
        int currentLineStyleIdx = 0;
        ArrayList<IEdge> subPath = new ArrayList<IEdge>();
        HashMap<Integer, List<IEdge>> currentFillEdgeMap = new HashMap<Integer, List<IEdge>>();
        HashMap<Integer, List<IEdge>> currentLineEdgeMap = new HashMap<Integer, List<IEdge>>();
        List<SHAPERECORD> records = shape.shapeRecords;
        for (int i = 0; i < records.size(); ++i) {
            int yPosFrom;
            int xPosFrom;
            SHAPERECORD shapeRecord = records.get(i);
            if (shapeRecord instanceof StyleChangeRecord) {
                StyleChangeRecord styleChangeRecord = (StyleChangeRecord)shapeRecord;
                if (styleChangeRecord.stateLineStyle || styleChangeRecord.stateFillStyle0 || styleChangeRecord.stateFillStyle1) {
                    this.processSubPath(subPath, currentLineStyleIdx, currentFillStyleIdx0, currentFillStyleIdx1, currentFillEdgeMap, currentLineEdgeMap);
                    subPath = new ArrayList();
                }
                if (styleChangeRecord.stateNewStyles) {
                    fillStyleIdxOffset = fillStyles.size();
                    lineStyleIdxOffset = lineStyles.size();
                    this.appendFillStyles(fillStyles, styleChangeRecord.fillStyles.fillStyles);
                    if (shapeNum <= 3) {
                        this.appendLineStyles(lineStyles, styleChangeRecord.lineStyles.lineStyles);
                    } else {
                        this.appendLineStyles(lineStyles, styleChangeRecord.lineStyles.lineStyles2);
                    }
                }
                if (styleChangeRecord.stateLineStyle && styleChangeRecord.lineStyle == 0 && styleChangeRecord.stateFillStyle0 && styleChangeRecord.fillStyle0 == 0 && styleChangeRecord.stateFillStyle1 && styleChangeRecord.fillStyle1 == 0) {
                    this.cleanEdgeMap(currentFillEdgeMap);
                    this.cleanEdgeMap(currentLineEdgeMap);
                    fillEdgeMaps.add(currentFillEdgeMap);
                    lineEdgeMaps.add(currentLineEdgeMap);
                    currentFillEdgeMap = new HashMap();
                    currentLineEdgeMap = new HashMap();
                    currentLineStyleIdx = 0;
                    currentFillStyleIdx0 = 0;
                    currentFillStyleIdx1 = 0;
                } else {
                    if (styleChangeRecord.stateLineStyle && (currentLineStyleIdx = styleChangeRecord.lineStyle) > 0) {
                        currentLineStyleIdx += lineStyleIdxOffset;
                    }
                    if (styleChangeRecord.stateFillStyle0 && (currentFillStyleIdx0 = styleChangeRecord.fillStyle0) > 0) {
                        currentFillStyleIdx0 += fillStyleIdxOffset;
                    }
                    if (styleChangeRecord.stateFillStyle1 && (currentFillStyleIdx1 = styleChangeRecord.fillStyle1) > 0) {
                        currentFillStyleIdx1 += fillStyleIdxOffset;
                    }
                }
                if (!styleChangeRecord.stateMoveTo) continue;
                xPos = styleChangeRecord.moveDeltaX;
                yPos = styleChangeRecord.moveDeltaY;
                continue;
            }
            if (shapeRecord instanceof StraightEdgeRecord) {
                StraightEdgeRecord straightEdgeRecord = (StraightEdgeRecord)shapeRecord;
                xPosFrom = xPos;
                yPosFrom = yPos;
                if (straightEdgeRecord.generalLineFlag) {
                    xPos += straightEdgeRecord.deltaX;
                    yPos += straightEdgeRecord.deltaY;
                } else if (straightEdgeRecord.vertLineFlag) {
                    yPos += straightEdgeRecord.deltaY;
                } else {
                    xPos += straightEdgeRecord.deltaX;
                }
                subPath.add(new StraightEdge(xPosFrom, yPosFrom, xPos, yPos, currentLineStyleIdx, currentFillStyleIdx1));
                continue;
            }
            if (shapeRecord instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord curvedEdgeRecord = (CurvedEdgeRecord)shapeRecord;
                xPosFrom = xPos;
                yPosFrom = yPos;
                int xPosControl = xPos + curvedEdgeRecord.controlDeltaX;
                int yPosControl = yPos + curvedEdgeRecord.controlDeltaY;
                xPos = xPosControl + curvedEdgeRecord.anchorDeltaX;
                yPos = yPosControl + curvedEdgeRecord.anchorDeltaY;
                subPath.add(new CurvedEdge(xPosFrom, yPosFrom, xPosControl, yPosControl, xPos, yPos, currentLineStyleIdx, currentFillStyleIdx1));
                continue;
            }
            if (!(shapeRecord instanceof EndShapeRecord)) continue;
            this.processSubPath(subPath, currentLineStyleIdx, currentFillStyleIdx0, currentFillStyleIdx1, currentFillEdgeMap, currentLineEdgeMap);
            this.cleanEdgeMap(currentFillEdgeMap);
            this.cleanEdgeMap(currentLineEdgeMap);
            fillEdgeMaps.add(currentFillEdgeMap);
            lineEdgeMaps.add(currentLineEdgeMap);
        }
    }

    private void processSubPath(List<IEdge> subPath, int lineStyleIdx, int fillStyleIdx0, int fillStyleIdx1, Map<Integer, List<IEdge>> currentFillEdgeMap, Map<Integer, List<IEdge>> currentLineEdgeMap) {
        List<IEdge> path;
        if (fillStyleIdx0 != 0) {
            path = currentFillEdgeMap.get(fillStyleIdx0);
            if (path == null) {
                path = new ArrayList<IEdge>();
                currentFillEdgeMap.put(fillStyleIdx0, path);
            }
            for (int j = subPath.size() - 1; j >= 0; --j) {
                IEdge rev = subPath.get(j).reverseWithNewFillStyle(fillStyleIdx0);
                path.add(rev);
            }
        }
        if (fillStyleIdx1 != 0) {
            path = currentFillEdgeMap.get(fillStyleIdx1);
            if (path == null) {
                path = new ArrayList<IEdge>();
                currentFillEdgeMap.put(fillStyleIdx1, path);
            }
            this.appendEdges(path, subPath);
        }
        if (lineStyleIdx != 0) {
            path = currentLineEdgeMap.get(lineStyleIdx);
            if (path == null) {
                path = new ArrayList<IEdge>();
                currentLineEdgeMap.put(lineStyleIdx, path);
            }
            this.appendEdges(path, subPath);
        }
    }

    private void exportFillPath(List<IEdge> path) {
        int posX = Integer.MAX_VALUE;
        int posY = Integer.MAX_VALUE;
        int fillStyleIdx = Integer.MAX_VALUE;
        if (!path.isEmpty()) {
            this.beginFills();
            for (int i = 0; i < path.size(); ++i) {
                IEdge e = path.get(i);
                if (fillStyleIdx != e.getFillStyleIdx()) {
                    if (fillStyleIdx != Integer.MAX_VALUE) {
                        this.endFill();
                    }
                    fillStyleIdx = e.getFillStyleIdx();
                    posX = Integer.MAX_VALUE;
                    posY = Integer.MAX_VALUE;
                    if (fillStyleIdx - 1 < this._fillStyles.size()) {
                        FillStyle fillStyle = this._fillStyles.get(fillStyleIdx - 1);
                        switch (fillStyle.fillStyleType) {
                            case 0: {
                                this.beginFill(this.colorTransform == null ? fillStyle.color : this.colorTransform.apply(fillStyle.color));
                                break;
                            }
                            case 16: 
                            case 18: 
                            case 19: {
                                this.beginGradientFill(fillStyle.fillStyleType, this.colorTransform == null ? fillStyle.gradient.gradientRecords : this.colorTransform.apply(fillStyle.gradient.gradientRecords), fillStyle.gradientMatrix, fillStyle.gradient.spreadMode, fillStyle.gradient.interpolationMode, fillStyle.gradient instanceof FOCALGRADIENT ? ((FOCALGRADIENT)fillStyle.gradient).focalPoint : 0.0f);
                                break;
                            }
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: {
                                this.beginBitmapFill(fillStyle.bitmapId, fillStyle.bitmapMatrix, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 66, this.canUseSmoothing && (fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 65), this.colorTransform);
                            }
                        }
                    } else {
                        this.beginFill(null);
                    }
                }
                if (posX != e.getFromX() || posY != e.getFromY()) {
                    this.moveTo(e.getFromX(), e.getFromY());
                }
                if (e instanceof CurvedEdge) {
                    CurvedEdge c = (CurvedEdge)e;
                    this.curveTo(c.getControlX(), c.getControlY(), c.toX, c.toY);
                } else {
                    this.lineTo(e.getToX(), e.getToY());
                }
                posX = e.getToX();
                posY = e.getToY();
            }
            if (fillStyleIdx != Integer.MAX_VALUE) {
                this.endFill();
            }
            this.endFills();
        }
    }

    private void exportLinePath(List<IEdge> path) {
        int posX = Integer.MAX_VALUE;
        int posY = Integer.MAX_VALUE;
        int lastMoveToX = posX;
        int lastMoveToY = posY;
        int lineStyleIdx = Integer.MAX_VALUE;
        if (!path.isEmpty()) {
            boolean autoClose = true;
            this.beginLines();
            for (int i = 0; i < path.size(); ++i) {
                IEdge e = path.get(i);
                if (lineStyleIdx != e.getLineStyleIdx()) {
                    lineStyleIdx = e.getLineStyleIdx();
                    posX = Integer.MAX_VALUE;
                    posY = Integer.MAX_VALUE;
                    LineStyle lineStyle = null;
                    try {
                        lineStyle = this._lineStyles.get(lineStyleIdx - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (lineStyle != null) {
                        String scaleMode = "NORMAL";
                        boolean pixelHintingFlag = false;
                        int startCapStyle = 0;
                        int endCapStyle = 0;
                        int joinStyle = 0;
                        float miterLimitFactor = 3.0f;
                        boolean hasFillFlag = false;
                        autoClose = true;
                        if (lineStyle.isLineStyle2) {
                            if (lineStyle.noClose) {
                                autoClose = false;
                            }
                            if (lineStyle.noHScaleFlag && lineStyle.noVScaleFlag) {
                                scaleMode = "NONE";
                            } else if (lineStyle.noHScaleFlag) {
                                scaleMode = "VERTICAL";
                            } else if (lineStyle.noVScaleFlag) {
                                scaleMode = "HORIZONTAL";
                            }
                            pixelHintingFlag = lineStyle.pixelHintingFlag;
                            startCapStyle = lineStyle.startCapStyle;
                            endCapStyle = lineStyle.endCapStyle;
                            joinStyle = lineStyle.joinStyle;
                            miterLimitFactor = lineStyle.miterLimitFactor;
                            hasFillFlag = lineStyle.hasFillFlag;
                        }
                        RGB lineColor = lineStyle.color;
                        if (hasFillFlag && lineStyle.fillType.fillStyleType == 0) {
                            lineColor = lineStyle.fillType.color;
                        }
                        this.lineStyle(lineStyle.width, this.colorTransform == null ? lineColor : this.colorTransform.apply(lineColor), pixelHintingFlag, scaleMode, startCapStyle, endCapStyle, joinStyle, miterLimitFactor, !autoClose);
                        if (hasFillFlag) {
                            FillStyle fillStyle = lineStyle.fillType;
                            switch (fillStyle.fillStyleType) {
                                case 16: 
                                case 18: 
                                case 19: {
                                    this.lineGradientStyle(fillStyle.fillStyleType, fillStyle.gradient.gradientRecords, fillStyle.gradientMatrix, fillStyle.gradient.spreadMode, fillStyle.gradient.interpolationMode, fillStyle.gradient instanceof FOCALGRADIENT ? ((FOCALGRADIENT)fillStyle.gradient).focalPoint : 0.0f);
                                    break;
                                }
                                case 64: 
                                case 65: 
                                case 66: 
                                case 67: {
                                    this.lineBitmapStyle(fillStyle.bitmapId, fillStyle.bitmapMatrix, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 66, fillStyle.fillStyleType == 64 || fillStyle.fillStyleType == 65, this.colorTransform);
                                }
                            }
                        }
                    } else {
                        this.lineStyle(1.0, new RGB(Color.black), false, "NORMAL", 0, 0, 0, 3.0f, false);
                    }
                }
                if (posX != e.getFromX() || posY != e.getFromY()) {
                    this.moveTo(e.getFromX(), e.getFromY());
                    lastMoveToX = e.getFromX();
                    lastMoveToY = e.getFromY();
                }
                if (e instanceof CurvedEdge) {
                    CurvedEdge c = (CurvedEdge)e;
                    this.curveTo(c.getControlX(), c.getControlY(), c.toX, c.toY);
                } else {
                    this.lineTo(e.getToX(), e.getToY());
                }
                posX = e.getToX();
                posY = e.getToY();
            }
            this.endLines(autoClose && lastMoveToX == posX && lastMoveToY == posY);
        }
    }

    private List<IEdge> createPathFromEdgeMap(Map<Integer, List<IEdge>> edgeMap) {
        ArrayList<IEdge> newPath = new ArrayList<IEdge>();
        ArrayList<Integer> styleIdxArray = new ArrayList<Integer>();
        for (Integer styleIdx : edgeMap.keySet()) {
            styleIdxArray.add(styleIdx);
        }
        Collections.sort(styleIdxArray);
        for (int i = 0; i < styleIdxArray.size(); ++i) {
            this.appendEdges(newPath, edgeMap.get(styleIdxArray.get(i)));
        }
        return newPath;
    }

    private void cleanEdgeMap(Map<Integer, List<IEdge>> edgeMap) {
        for (Integer styleIdx : edgeMap.keySet()) {
            List<IEdge> subPath = edgeMap.get(styleIdx);
            if (subPath == null || subPath.isEmpty()) continue;
            IEdge prevEdge = null;
            ArrayList<IEdge> tmpPath = new ArrayList<IEdge>();
            Map<Long, List<IEdge>> coordMap = this.createCoordMap(subPath);
            Map<Long, List<IEdge>> reverseCoordMap = this.createReverseCoordMap(subPath);
            while (!subPath.isEmpty()) {
                int idx = 0;
                while (idx < subPath.size()) {
                    if (prevEdge != null) {
                        IEdge subPathEdge = subPath.get(idx);
                        if (prevEdge.getToX() != subPathEdge.getFromX() || prevEdge.getToY() != subPathEdge.getFromY()) {
                            IEdge edge = this.findNextEdgeInCoordMap(coordMap, prevEdge);
                            if (edge != null) {
                                idx = subPath.indexOf(edge);
                                continue;
                            }
                            IEdge revEdge = this.findNextEdgeInCoordMap(reverseCoordMap, prevEdge);
                            if (revEdge != null) {
                                idx = subPath.indexOf(revEdge);
                                IEdge r = revEdge.reverseWithNewFillStyle(revEdge.getFillStyleIdx());
                                this.updateEdgeInCoordMap(coordMap, revEdge, r);
                                this.updateEdgeInReverseCoordMap(reverseCoordMap, revEdge, r);
                                subPath.set(idx, r);
                                continue;
                            }
                            idx = 0;
                            prevEdge = null;
                            continue;
                        }
                    }
                    IEdge edge = subPath.remove(idx);
                    tmpPath.add(edge);
                    this.removeEdgeFromCoordMap(coordMap, edge);
                    this.removeEdgeFromReverseCoordMap(reverseCoordMap, edge);
                    prevEdge = edge;
                }
            }
            edgeMap.put(styleIdx, tmpPath);
        }
    }

    private Map<Long, List<IEdge>> createCoordMap(List<IEdge> path) {
        HashMap<Long, List<IEdge>> coordMap = new HashMap<Long, List<IEdge>>();
        for (int i = 0; i < path.size(); ++i) {
            IEdge edge = path.get(i);
            long fromLong = (long)edge.getFromX() << 32 | (long)edge.getFromY() & 0xFFFFFFFFL;
            List coordMapArray = (List)coordMap.get(fromLong);
            if (coordMapArray == null) {
                ArrayList<IEdge> list = new ArrayList<IEdge>();
                list.add(path.get(i));
                coordMap.put(fromLong, list);
                continue;
            }
            coordMapArray.add(path.get(i));
        }
        return coordMap;
    }

    private Map<Long, List<IEdge>> createReverseCoordMap(List<IEdge> path) {
        HashMap<Long, List<IEdge>> coordMap = new HashMap<Long, List<IEdge>>();
        for (int i = 0; i < path.size(); ++i) {
            IEdge edge = path.get(i);
            long toLong = (long)edge.getToX() << 32 | (long)edge.getToY() & 0xFFFFFFFFL;
            List coordMapArray = (List)coordMap.get(toLong);
            if (coordMapArray == null) {
                ArrayList<IEdge> list = new ArrayList<IEdge>();
                list.add(path.get(i));
                coordMap.put(toLong, list);
                continue;
            }
            coordMapArray.add(path.get(i));
        }
        return coordMap;
    }

    private void removeEdgeFromCoordMap(Map<Long, List<IEdge>> coordMap, IEdge edge) {
        long fromLong = (long)edge.getFromX() << 32 | (long)edge.getFromY() & 0xFFFFFFFFL;
        List<IEdge> coordMapArray = coordMap.get(fromLong);
        if (coordMapArray != null) {
            if (coordMapArray.size() == 1) {
                coordMap.remove(fromLong);
            } else {
                int i = coordMapArray.indexOf(edge);
                if (i > -1) {
                    coordMapArray.remove(i);
                }
            }
        }
    }

    private void removeEdgeFromReverseCoordMap(Map<Long, List<IEdge>> coordMap, IEdge edge) {
        long toLong = (long)edge.getToX() << 32 | (long)edge.getToY() & 0xFFFFFFFFL;
        List<IEdge> coordMapArray = coordMap.get(toLong);
        if (coordMapArray != null) {
            if (coordMapArray.size() == 1) {
                coordMap.remove(toLong);
            } else {
                int i = coordMapArray.indexOf(edge);
                if (i > -1) {
                    coordMapArray.remove(i);
                }
            }
        }
    }

    private IEdge findNextEdgeInCoordMap(Map<Long, List<IEdge>> coordMap, IEdge edge) {
        long toLong = (long)edge.getToX() << 32 | (long)edge.getToY() & 0xFFFFFFFFL;
        List<IEdge> coordMapArray = coordMap.get(toLong);
        if (coordMapArray != null && !coordMapArray.isEmpty()) {
            return coordMapArray.get(0);
        }
        return null;
    }

    private IEdge updateEdgeInCoordMap(Map<Long, List<IEdge>> coordMap, IEdge edge, IEdge newEdge) {
        long fromLong = (long)edge.getFromX() << 32 | (long)edge.getFromY() & 0xFFFFFFFFL;
        coordMap.get(fromLong).remove(edge);
        long fromLong2 = (long)newEdge.getFromX() << 32 | (long)newEdge.getFromY() & 0xFFFFFFFFL;
        if (!coordMap.containsKey(fromLong2)) {
            coordMap.put(fromLong2, new ArrayList());
        }
        coordMap.get(fromLong2).add(newEdge);
        return null;
    }

    private IEdge updateEdgeInReverseCoordMap(Map<Long, List<IEdge>> coordMap, IEdge edge, IEdge newEdge) {
        long toLong = (long)edge.getToX() << 32 | (long)edge.getToY() & 0xFFFFFFFFL;
        coordMap.get(toLong).remove(edge);
        long toLong2 = (long)newEdge.getToX() << 32 | (long)newEdge.getToY() & 0xFFFFFFFFL;
        if (!coordMap.containsKey(toLong2)) {
            coordMap.put(toLong2, new ArrayList());
        }
        coordMap.get(toLong2).add(newEdge);
        return null;
    }

    private void appendFillStyles(List<FillStyle> v1, FILLSTYLE[] v2) {
        for (FILLSTYLE s : v2) {
            v1.add(new FillStyle(s));
        }
    }

    private void appendLineStyles(List<LineStyle> v1, LINESTYLE[] v2) {
        for (LINESTYLE s : v2) {
            v1.add(new LineStyle(s));
        }
    }

    private void appendLineStyles(List<LineStyle> v1, LINESTYLE2[] v2) {
        for (LINESTYLE2 s : v2) {
            v1.add(new LineStyle(s));
        }
    }

    private void appendEdges(List<IEdge> v1, List<IEdge> v2) {
        for (int i = 0; i < v2.size(); ++i) {
            v1.add(v2.get(i));
        }
    }
}

