/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.flexsdk;

import com.jpexs.decompiler.flash.flexsdk.MxmlcException;
import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class MxmlcRunner {
    private String flexSdkPath;

    public MxmlcRunner(String flexSdkPath) {
        this.flexSdkPath = flexSdkPath;
    }

    public static String getMxmlcPath(String flexSdkPath) {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        String path = flexSdkPath + File.separator + "bin" + File.separator + "mxmlc";
        String exePath = path + ".exe";
        String batPath = path + ".bat";
        if (isWin) {
            if (new File(exePath).exists()) {
                return exePath;
            }
            if (new File(batPath).exists()) {
                return batPath;
            }
        } else if (new File(path).exists()) {
            return exePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mxmlc(List<String> arguments) throws MxmlcException, InterruptedException, IOException {
        String[] runArgs = new String[arguments.size() + 1];
        runArgs[0] = MxmlcRunner.getMxmlcPath(this.flexSdkPath);
        for (int i = 0; i < arguments.size(); ++i) {
            runArgs[i + 1] = arguments.get(i);
        }
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(runArgs);
            Helper.readStream(proc.getInputStream());
            String errstring = "";
            try {
                errstring = new String(Helper.readStream(proc.getErrorStream()), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            proc.waitFor();
            int exitValue = proc.exitValue();
            if (exitValue > 0) {
                throw new MxmlcException(errstring);
            }
        }
        finally {
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }
}

