/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.flv;

import com.jpexs.decompiler.flash.EndOfStreamException;
import com.jpexs.decompiler.flash.flv.AUDIODATA;
import com.jpexs.decompiler.flash.flv.FLVTAG;
import com.jpexs.decompiler.flash.flv.SCRIPTDATA;
import com.jpexs.decompiler.flash.flv.SCRIPTDATADATE;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAOBJECT;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAVALUE;
import com.jpexs.decompiler.flash.flv.SCRIPTDATAVARIABLE;
import com.jpexs.decompiler.flash.flv.UnparsedDATA;
import com.jpexs.decompiler.flash.flv.VIDEODATA;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class FLVInputStream {
    private final DataInputStream is;
    private int bitPos = 0;
    private int tempByte = 0;
    private long pos = 0L;

    public FLVInputStream(InputStream is) {
        this.is = new DataInputStream(is);
    }

    public void readHeader(Reference<Boolean> audioPresent, Reference<Boolean> videoPresent) throws IOException {
        byte[] signature = new byte[3];
        this.is.readFully(signature);
        if (signature[0] != 70 || signature[1] != 76 || signature[2] != 86) {
            throw new IOException("Invalid FLV file - invalid signature");
        }
        this.pos += 3L;
        int version = this.read();
        if (version != 1) {
            throw new IOException("Unsupported FLV version: " + version + ", only 1 is supported");
        }
        int reserved = (int)this.readUB(5);
        audioPresent.setVal(this.readUB(1) == 1L);
        this.readUB(1);
        videoPresent.setVal(this.readUB(1) == 1L);
        long headerSize = this.readUI32();
        if (headerSize != 9L) {
            throw new IOException("Invalid header size: " + headerSize);
        }
        this.readUI32();
    }

    public List<FLVTAG> readTags() throws IOException {
        ArrayList<FLVTAG> ret = new ArrayList<FLVTAG>();
        while (this.available() > 0) {
            ret.add(this.readTag());
        }
        return ret;
    }

    private long readUI32() throws IOException {
        return (long)((this.readEx() << 24) + (this.readEx() << 16) + (this.readEx() << 8) + this.readEx()) & 0xFFFFFFFFL;
    }

    private int readEx() throws IOException {
        this.bitPos = 0;
        return this.readNoBitReset();
    }

    public long readUB(int nBits) throws IOException {
        if (nBits == 0) {
            return 0L;
        }
        long ret = this.readUBInternal(nBits);
        return ret;
    }

    private int readNoBitReset() throws IOException, EndOfStreamException {
        int r = this.is.read();
        if (r == -1) {
            throw new EndOfStreamException();
        }
        ++this.pos;
        return r;
    }

    private long readUBInternal(int nBits) throws IOException {
        if (nBits == 0) {
            return 0L;
        }
        long ret = 0L;
        if (this.bitPos == 0) {
            this.tempByte = this.readNoBitReset();
        }
        for (int bit = 0; bit < nBits; ++bit) {
            int nb = this.tempByte >> 7 - this.bitPos & 1;
            ret += (long)(nb << nBits - 1 - bit);
            ++this.bitPos;
            if (this.bitPos != 8) continue;
            this.bitPos = 0;
            if (bit == nBits - 1) continue;
            this.tempByte = this.readNoBitReset();
        }
        return ret;
    }

    private void alignByte() {
        this.bitPos = 0;
    }

    public int read() throws IOException {
        this.alignByte();
        ++this.pos;
        return this.is.read();
    }

    public int readUI8() throws IOException {
        return this.read();
    }

    public int readUI24() throws IOException {
        int ret = (this.readEx() << 16) + (this.readEx() << 8) + this.readEx();
        return ret;
    }

    public byte[] readBytes(int len) throws IOException {
        byte[] data = new byte[len];
        this.is.readFully(data);
        this.pos += (long)len;
        return data;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public FLVTAG readTag() throws IOException {
        int tagType = this.readUI8();
        int dataLen = this.readUI24();
        int timeStamp = this.readUI24();
        int timeStampExtended = this.readUI8();
        int timeStampFull = (timeStampExtended << 24) + timeStamp;
        this.readUI24();
        byte[] data = this.readBytes(dataLen);
        this.readUI32();
        FLVInputStream subStream = new FLVInputStream(new ByteArrayInputStream(data));
        switch (tagType) {
            case 9: {
                return new FLVTAG((long)timeStampFull, subStream.readVIDEODATA());
            }
            case 18: {
                return new FLVTAG((long)timeStampFull, subStream.readSCRIPTDATA());
            }
            case 8: {
                return new FLVTAG((long)timeStampFull, subStream.readAUDIODATA());
            }
        }
        return new FLVTAG((long)timeStampFull, new UnparsedDATA(tagType, data));
    }

    public int readUI16() throws IOException {
        return (this.readEx() << 8) + this.readEx();
    }

    public SCRIPTDATA readSCRIPTDATA() throws IOException {
        SCRIPTDATAVALUE name = this.readSCRIPTDATAVALUE();
        SCRIPTDATAVALUE value = this.readSCRIPTDATAVALUE();
        return new SCRIPTDATA(name, value);
    }

    public double readDOUBLE() throws IOException {
        long el = this.readLong();
        double ret = Double.longBitsToDouble(el);
        return ret;
    }

    private long readLong() throws IOException {
        byte[] readBuffer = this.readBytes(8);
        return ((long)readBuffer[0] << 56) + ((long)(readBuffer[1] & 0xFF) << 48) + ((long)(readBuffer[2] & 0xFF) << 40) + ((long)(readBuffer[3] & 0xFF) << 32) + ((long)(readBuffer[4] & 0xFF) << 24) + (long)((readBuffer[5] & 0xFF) << 16) + (long)((readBuffer[6] & 0xFF) << 8) + (long)(readBuffer[7] & 0xFF);
    }

    public AUDIODATA readAUDIODATA() throws IOException {
        int soundFormat = (int)this.readUB(4);
        int soundRate = (int)this.readUB(2);
        boolean soundSize = (int)this.readUB(1) == 1;
        boolean soundType = (int)this.readUB(1) == 1;
        byte[] soundData = this.readBytes(this.available());
        return new AUDIODATA(soundFormat, soundRate, soundSize, soundType, soundData);
    }

    public SCRIPTDATAOBJECT readSCRIPTDATAOBJECT() throws IOException {
        System.out.println("reading obj");
        String objectName = this.readSCRIPTDATASTRING();
        System.out.println("objectName " + objectName);
        if (objectName.length() == 0) {
            int endMarker = this.readUI8();
            if (endMarker != 9) {
                throw new IOException("Invalid SCRIPTOBJECT end marker - 9 expected but " + endMarker + " found");
            }
            return null;
        }
        SCRIPTDATAVALUE objectData = this.readSCRIPTDATAVALUE();
        return new SCRIPTDATAOBJECT(objectName, objectData);
    }

    public VIDEODATA readVIDEODATA() throws IOException {
        int frameType = (int)this.readUB(4);
        int codecId = (int)this.readUB(4);
        byte[] videoData = this.readBytes(this.available());
        return new VIDEODATA(frameType, codecId, videoData);
    }

    public SCRIPTDATAVALUE readSCRIPTDATAVALUE() throws IOException {
        int type = this.readUI8();
        switch (type) {
            case 0: {
                return new SCRIPTDATAVALUE(this.readDOUBLE());
            }
            case 1: {
                return new SCRIPTDATAVALUE(type, this.readUI8() == 1 ? Boolean.TRUE : Boolean.FALSE);
            }
            case 2: {
                return new SCRIPTDATAVALUE(type, this.readSCRIPTDATASTRING());
            }
            case 3: {
                SCRIPTDATAOBJECT object;
                ArrayList<SCRIPTDATAOBJECT> objects = new ArrayList<SCRIPTDATAOBJECT>();
                while ((object = this.readSCRIPTDATAOBJECT()) != null) {
                    objects.add(object);
                }
                return new SCRIPTDATAVALUE(type, objects);
            }
            case 4: {
                return new SCRIPTDATAVALUE(type, this.readSCRIPTDATASTRING());
            }
            case 5: 
            case 6: {
                return new SCRIPTDATAVALUE(type, null);
            }
            case 7: {
                return new SCRIPTDATAVALUE(type, this.readUI16());
            }
            case 8: {
                SCRIPTDATAVARIABLE variable2;
                int ecmaArrayLength = (int)this.readUI32();
                ArrayList<SCRIPTDATAVARIABLE> variables2 = new ArrayList<SCRIPTDATAVARIABLE>();
                while ((variable2 = this.readSCRIPTDATAVARIABLE()) != null) {
                    variables2.add(variable2);
                }
                return new SCRIPTDATAVALUE(type, variables2);
            }
            case 10: {
                int arrayLength = (int)this.readUI32();
                ArrayList<SCRIPTDATAVARIABLE> variables = new ArrayList<SCRIPTDATAVARIABLE>();
                for (int i = 0; i < arrayLength; ++i) {
                    variables.add(this.readSCRIPTDATAVARIABLE());
                }
                return new SCRIPTDATAVALUE(type, variables);
            }
            case 11: {
                return new SCRIPTDATAVALUE(type, this.readSCRIPTDATADATE());
            }
            case 12: {
                return new SCRIPTDATAVALUE(type, this.readSCRIPTDATALONGSTRING());
            }
        }
        return null;
    }

    public String readSCRIPTDATALONGSTRING() throws IOException {
        int len = (int)this.readUI32();
        return new String(this.readBytes(len), Utf8Helper.charset);
    }

    public SCRIPTDATADATE readSCRIPTDATADATE() throws IOException {
        double time = this.readDOUBLE();
        int localDateTimeOffset = this.readSI16();
        return new SCRIPTDATADATE(time, localDateTimeOffset);
    }

    public int readSI16() throws IOException {
        int uval = (this.readEx() << 8) + this.readEx();
        if (uval >= 32768) {
            uval = -((~uval & 0xFFFF) + 1);
        }
        return uval;
    }

    public SCRIPTDATAVARIABLE readSCRIPTDATAVARIABLE() throws IOException {
        String variableName = this.readSCRIPTDATASTRING();
        if (variableName.length() == 0) {
            int endMarker = this.readUI8();
            if (endMarker != 9) {
                throw new IOException("Invalid SCRIPTDATAVARIABLE end marker - 9 expected but " + endMarker + " found");
            }
            return null;
        }
        SCRIPTDATAVALUE variableValue = this.readSCRIPTDATAVALUE();
        return new SCRIPTDATAVARIABLE(variableName, variableValue);
    }

    public String readSCRIPTDATASTRING() throws IOException {
        int len = this.readUI16();
        return new String(this.readBytes(len), Utf8Helper.charset);
    }
}

