/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.helpers;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.CodeFormatting;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.graph.GraphSourceItem;

public abstract class GraphTextWriter {
    protected long startTime = System.currentTimeMillis();
    protected long suspendTime;
    protected CodeFormatting formatting;
    protected int lineLength = 0;
    public static final int TRAIT_INSTANCE_INITIALIZER = -1;
    public static final int TRAIT_CLASS_INITIALIZER = -2;
    public static final int TRAIT_SCRIPT_INITIALIZER = -3;
    public static final int TRAIT_UNKNOWN = -4;

    public CodeFormatting getFormatting() {
        return this.formatting;
    }

    public GraphTextWriter(CodeFormatting formatting) {
        this.formatting = formatting;
    }

    public boolean getIsHighlighted() {
        return false;
    }

    public GraphTextWriter startOffset(GraphSourceItem src, GraphSourceItem startLineItem, int pos, HighlightData data) {
        return this;
    }

    public GraphTextWriter endOffset() {
        return this;
    }

    public GraphTextWriter startMethod(long index, String name) {
        return this;
    }

    public GraphTextWriter startFunction(String name) {
        return this;
    }

    public GraphTextWriter endMethod() {
        return this;
    }

    public GraphTextWriter endFunction() {
        return this;
    }

    public GraphTextWriter startClass(long index) {
        return this;
    }

    public GraphTextWriter startClass(String className) {
        return this;
    }

    public GraphTextWriter endClass() {
        return this;
    }

    public GraphTextWriter startTrait(long index) {
        return this;
    }

    public GraphTextWriter endTrait() {
        return this;
    }

    public final GraphTextWriter hilightSpecial(String text, HighlightSpecialType type) {
        return this.hilightSpecial(text, type, "");
    }

    public final GraphTextWriter hilightSpecial(String text, HighlightSpecialType type, int specialValue) {
        return this.hilightSpecial(text, type, Integer.toString(specialValue), null);
    }

    public final GraphTextWriter hilightSpecial(String text, HighlightSpecialType type, int specialValue, HighlightData data) {
        return this.hilightSpecial(text, type, Integer.toString(specialValue), data);
    }

    public final GraphTextWriter hilightSpecial(String text, HighlightSpecialType type, String specialValue) {
        return this.hilightSpecial(text, type, specialValue, null);
    }

    protected GraphTextWriter hilightSpecial(String text, HighlightSpecialType type, String specialValue, HighlightData data) {
        return this;
    }

    public static String hilightOffset(String text, long offset) {
        return "";
    }

    public abstract GraphTextWriter appendWithData(String var1, HighlightData var2);

    public GraphTextWriter append(char value) {
        return this.append(Character.toString(value));
    }

    public GraphTextWriter append(int value) {
        return this.append(Integer.toString(value));
    }

    public GraphTextWriter append(long value) {
        return this.append(Long.toString(value));
    }

    public GraphTextWriter append(double value) {
        return this.append(Double.toString(value));
    }

    public abstract GraphTextWriter append(String var1);

    public abstract GraphTextWriter append(String var1, long var2, long var4);

    protected final void addLineLength(int len) {
        this.lineLength += len;
    }

    public abstract GraphTextWriter appendNoHilight(int var1);

    public abstract GraphTextWriter appendNoHilight(String var1);

    public GraphTextWriter indent() {
        return this;
    }

    public GraphTextWriter unindent() {
        return this;
    }

    public GraphTextWriter newLine() {
        this.lineLength = 0;
        return this;
    }

    public int getLength() {
        return 0;
    }

    public int getIndent() {
        return 0;
    }

    public void suspendMeasure() {
        this.suspendTime = System.currentTimeMillis();
    }

    public void continueMeasure() {
        long time = System.currentTimeMillis();
        this.startTime += time - this.suspendTime;
    }

    public String toString() {
        return "";
    }

    private GraphTextWriter startBlock(String opening) {
        if (this.formatting.beginBlockOnNewLine) {
            this.newLine();
        } else {
            this.append(" ");
        }
        return this.append(opening).newLine().indent();
    }

    public GraphTextWriter startBlock() {
        return this.startBlock("{");
    }

    public GraphTextWriter startBlockNoNewLine() {
        if (this.formatting.beginBlockOnNewLine) {
            this.newLine();
        } else {
            this.append(" ");
        }
        return this.append("{");
    }

    private GraphTextWriter endBlock(String closing) {
        return this.unindent().append(closing);
    }

    public GraphTextWriter endBlock() {
        return this.endBlock("}");
    }

    public GraphTextWriter space() {
        return this.append(" ");
    }

    public GraphTextWriter allowWrapHere() {
        if (Configuration.maxScriptLineLength.get() > 0 && this.lineLength > Configuration.maxScriptLineLength.get()) {
            this.newLine();
        }
        return this;
    }

    public GraphTextWriter spaceBeforeCallParenthesis(int argCount) {
        if (argCount > 0) {
            if (this.formatting.spaceBeforeParenthesesMethodCallParentheses) {
                this.space();
            }
        } else if (this.formatting.spaceBeforeParenthesesMethodCallEmptyParentheses) {
            this.space();
        }
        return this;
    }

    public GraphTextWriter addCurrentMethodData(HighlightData data) {
        return this;
    }
}

