/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.StructureInterface;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IggyCharKerning
implements StructureInterface {
    public static final int STRUCT_SIZE = 6;
    private long kernCount;
    List<Character> charsA;
    List<Character> charsB;
    List<Short> kerningOffsets;

    public long getKernCount() {
        return this.kernCount;
    }

    public List<Character> getCharsA() {
        return this.charsA;
    }

    public List<Character> getCharsB() {
        return this.charsB;
    }

    public List<Short> getKerningOffsets() {
        return this.kerningOffsets;
    }

    public IggyCharKerning(List<Character> charsA, List<Character> charsB, List<Short> kerningOffsets) {
        if (charsA.size() != charsB.size() || charsB.size() != kerningOffsets.size()) {
            throw new RuntimeException("sizes of charsA, charsB and offsets must match");
        }
        this.kernCount = charsA.size();
        this.charsA = charsA;
        this.charsB = charsB;
        this.kerningOffsets = kerningOffsets;
    }

    public IggyCharKerning(ReadDataStreamInterface stream, long kernCount) throws IOException {
        this.kernCount = kernCount;
        this.readFromDataStream(stream);
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface stream) throws IOException {
        this.charsA = new ArrayList<Character>();
        this.charsB = new ArrayList<Character>();
        this.kerningOffsets = new ArrayList<Short>();
        int i = 0;
        while ((long)i < this.kernCount) {
            this.charsA.add(Character.valueOf((char)stream.readUI16()));
            this.charsB.add(Character.valueOf((char)stream.readUI16()));
            this.kerningOffsets.add((short)stream.readUI16());
            ++i;
        }
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface stream) throws IOException {
        int i = 0;
        while ((long)i < this.kernCount) {
            stream.writeUI16(this.charsA.get(i).charValue());
            stream.writeUI16(this.charsB.get(i).charValue());
            stream.writeUI16(this.kerningOffsets.get(i).shortValue());
            ++i;
        }
    }
}

