/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.importers.TagImporter;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG4Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLosslessTag;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import dev.matrixlab.webp4j.WebPCodec;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImageImporter
extends TagImporter {
    public Tag importImage(ImageTag it, byte[] newData) throws IOException {
        return this.importImage(it, newData, 0);
    }

    public Tag importImage(ImageTag it, byte[] newData, int tagType) throws IOException {
        ByteArrayOutputStream baos;
        BufferedImage b;
        if (newData.length >= 2 && newData[0] == 66 && newData[1] == 77) {
            b = ImageHelper.read(newData);
            baos = new ByteArrayOutputStream();
            ImageHelper.write(b, ImageFormat.PNG, baos);
            newData = baos.toByteArray();
        }
        if (newData.length >= 4 && newData[0] == 82 && newData[1] == 73 && newData[2] == 70 && newData[3] == 70) {
            if (!ImageFormat.WEBP.available()) {
                throw new RuntimeException("WEBP format is not supported on your platform");
            }
            b = WebPCodec.decodeImage((byte[])newData);
            baos = new ByteArrayOutputStream();
            ImageHelper.write(b, ImageFormat.PNG, baos);
            newData = baos.toByteArray();
        }
        if (tagType == 0) {
            tagType = it instanceof DefineBitsTag ? 21 : it.getId();
        }
        if (tagType == -1) {
            tagType = newData.length >= 4 && newData[0] == -1 && newData[1] == -40 && newData[2] == -1 && newData[3] == -32 ? 21 : 36;
        }
        if (it.getId() != tagType) {
            ImageTag imageTag;
            SWF swf = it.getSwf();
            ByteArrayRange range = it.getOriginalRange();
            int characterId = it.getCharacterId();
            switch (tagType) {
                case 21: {
                    imageTag = new DefineBitsJPEG2Tag(swf, range, characterId, newData);
                    break;
                }
                case 35: {
                    imageTag = new DefineBitsJPEG3Tag(swf, range, characterId, newData);
                    break;
                }
                case 90: {
                    imageTag = new DefineBitsJPEG4Tag(swf, range, characterId, newData);
                    break;
                }
                case 20: {
                    DefineBitsLosslessTag losslessTag = new DefineBitsLosslessTag(swf, range, characterId);
                    losslessTag.setImage(newData);
                    imageTag = losslessTag;
                    break;
                }
                case 36: {
                    DefineBitsLossless2Tag lossless2Tag = new DefineBitsLossless2Tag(swf, range, characterId);
                    lossless2Tag.setImage(newData);
                    imageTag = lossless2Tag;
                    break;
                }
                default: {
                    throw new Error("Unsupported image type tag.");
                }
            }
            imageTag.setModified(true);
            it.getTimelined().replaceTag(it, (Tag)imageTag);
            imageTag.setTimelined(it.getTimelined());
            swf.updateCharacters();
            swf.resetTimelines(swf);
            return imageTag;
        }
        it.setImage(newData);
        return null;
    }

    public Tag importImageAlpha(ImageTag it, byte[] newData) throws IOException {
        try {
            BufferedImage img = ImageHelper.read(newData);
            int width = img.getWidth();
            int height = img.getHeight();
            byte[] data = new byte[width * height];
            int[] imgData = img.getRGB(0, 0, width, height, null, 0, width);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int alpha = imgData[y * width + x] >> 24 & 0xFF;
                    data[y * width + x] = (byte)alpha;
                }
            }
            newData = data;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (it instanceof DefineBitsJPEG3Tag) {
            ((DefineBitsJPEG3Tag)it).setImageAlpha(newData);
        } else if (it instanceof DefineBitsJPEG4Tag) {
            ((DefineBitsJPEG4Tag)it).setImageAlpha(newData);
        }
        return null;
    }

    public void convertImage(ImageTag it, int tagType) throws IOException {
        this.importImage(it, Helper.readStream(it.getConvertedImageData()), tagType);
    }

    public static int getImageTagType(String format) {
        int res = 0;
        switch (format) {
            case "lossless": {
                res = 20;
                break;
            }
            case "lossless2": {
                res = 36;
                break;
            }
            case "jpeg2": {
                res = 21;
                break;
            }
            case "jpeg3": {
                res = 35;
                break;
            }
            case "jpeg4": {
                res = 90;
            }
        }
        return res;
    }

    public int bulkImport(File imagesDir, SWF swf, boolean printOut) {
        int count = 0;
        Map<Integer, CharacterTag> characters = swf.getCharacters(false);
        final List<String> extensions = Arrays.asList("png", "jpg", "jpeg", "gif", "bmp");
        final List<String> alphaExtensions = Arrays.asList("png");
        File[] allFiles = imagesDir.listFiles(new FilenameFilter(){
            final /* synthetic */ ImageImporter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                if (nameLower.endsWith(".alpha.png")) {
                    return false;
                }
                for (String ext : extensions) {
                    if (!nameLower.endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        File[] alphaFiles = imagesDir.listFiles(new FilenameFilter(){
            final /* synthetic */ ImageImporter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                for (String ext : alphaExtensions) {
                    if (!nameLower.endsWith(".alpha." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        for (int characterId : characters.keySet()) {
            File sourceFile;
            String nameNoExt;
            ImageTag imageTag;
            CharacterTag tag = characters.get(characterId);
            if (!(tag instanceof ImageTag) || !(imageTag = (ImageTag)tag).importSupported()) continue;
            ArrayList<File> existingFilesForImageTag = new ArrayList<File>();
            ArrayList<File> existingAlphaFilesForImageTag = new ArrayList<File>();
            ArrayList<String> classNameExpectedFileNames = new ArrayList<String>();
            for (String className : imageTag.getClassNames()) {
                classNameExpectedFileNames.add(Helper.makeFileName(className));
            }
            for (File f : allFiles) {
                if (f.getName().startsWith("" + characterId + ".") || f.getName().startsWith("" + characterId + "_")) {
                    existingFilesForImageTag.add(f);
                    continue;
                }
                nameNoExt = f.getName();
                if (nameNoExt.contains(".")) {
                    nameNoExt = nameNoExt.substring(0, nameNoExt.lastIndexOf("."));
                }
                if (!classNameExpectedFileNames.contains(nameNoExt)) continue;
                existingFilesForImageTag.add(f);
            }
            for (File f : alphaFiles) {
                if (f.getName().startsWith("" + characterId + ".") || f.getName().startsWith("" + characterId + "_")) {
                    existingAlphaFilesForImageTag.add(f);
                    continue;
                }
                nameNoExt = f.getName().substring(0, f.getName().length() - ".alpha.png".length());
                if (!classNameExpectedFileNames.contains(nameNoExt)) continue;
                existingAlphaFilesForImageTag.add(f);
            }
            existingFilesForImageTag.sort(new Comparator<File>(){
                final /* synthetic */ ImageImporter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(File o1, File o2) {
                    String ext1 = o1.getName().substring(o1.getName().lastIndexOf(".") + 1);
                    String ext2 = o2.getName().substring(o2.getName().lastIndexOf(".") + 1);
                    int ret = extensions.indexOf(ext1) - extensions.indexOf(ext2);
                    if (ret == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return ret;
                }
            });
            existingAlphaFilesForImageTag.sort(new Comparator<File>(){
                final /* synthetic */ ImageImporter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(File o1, File o2) {
                    String ext1 = o1.getName().substring(o1.getName().lastIndexOf(".") + 1);
                    String ext2 = o2.getName().substring(o2.getName().lastIndexOf(".") + 1);
                    int ret = alphaExtensions.indexOf(ext1) - alphaExtensions.indexOf(ext2);
                    if (ret == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return ret;
                }
            });
            if (!existingFilesForImageTag.isEmpty()) {
                if (existingFilesForImageTag.size() > 1) {
                    Logger.getLogger(ImageImporter.class.getName()).log(Level.WARNING, "Multiple matching files for image tag {0} exists, {1} selected", new Object[]{characterId, ((File)existingFilesForImageTag.get(0)).getName()});
                }
                sourceFile = (File)existingFilesForImageTag.get(0);
                if (printOut) {
                    System.out.println("Importing character " + characterId + " from file " + sourceFile.getName());
                }
                try {
                    this.importImage(imageTag, Helper.readFile(sourceFile.getPath()));
                    ++count;
                }
                catch (IOException ex) {
                    Logger.getLogger(ImageImporter.class.getName()).log(Level.WARNING, "Cannot import image " + characterId + " from file " + sourceFile.getName(), ex);
                }
            }
            if (!existingAlphaFilesForImageTag.isEmpty()) {
                if (existingAlphaFilesForImageTag.size() > 1) {
                    Logger.getLogger(ImageImporter.class.getName()).log(Level.WARNING, "Multiple matching files for image alpha tag {0} exists, {1} selected", new Object[]{characterId, ((File)existingAlphaFilesForImageTag.get(0)).getName()});
                }
                sourceFile = (File)existingAlphaFilesForImageTag.get(0);
                if (printOut) {
                    System.out.println("Importing character " + characterId + " alpha from file " + sourceFile.getName());
                }
                try {
                    this.importImageAlpha(imageTag, Helper.readFile(sourceFile.getPath()));
                }
                catch (IOException ex) {
                    Logger.getLogger(ImageImporter.class.getName()).log(Level.WARNING, "Cannot import image " + characterId + " alpha from file " + sourceFile.getName(), ex);
                }
            }
            if (!CancellableWorker.isInterrupted()) continue;
            break;
        }
        return count;
    }
}

