/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.importers.ShapeImporter;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.SoundImportException;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.UnsupportedSamplingRateException;
import com.jpexs.decompiler.flash.timeline.SoundStreamFrameRange;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.sound.MP3FRAME;
import com.jpexs.decompiler.flash.types.sound.MP3SOUNDDATA;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundImporter {
    /*
     * Unable to fully structure code
     */
    public boolean importDefineSound(DefineSoundTag soundTag, InputStream is, int newSoundFormat) throws SoundImportException {
        newSoundRate = -1;
        newSoundSize = false;
        newSoundType = false;
        newSoundSampleCount = -1L;
        block4 : switch (newSoundFormat) {
            case 3: {
                try {
                    audioIs = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
                    try {
                        fmt = audioIs.getFormat();
                        newSoundType = fmt.getChannels() == 2;
                        newSoundSize = fmt.getSampleSizeInBits() == 16;
                        newSoundSampleCount = audioIs.getFrameLength();
                        newSoundData = Helper.readStream(audioIs);
                        newSoundRate = Math.round(fmt.getSampleRate());
                        switch (newSoundRate) {
                            case 5512: {
                                newSoundRate = 0;
                                ** break;
lbl20:
                                // 1 sources

                                break block4;
                            }
                            case 11025: {
                                newSoundRate = 1;
                                ** break;
lbl24:
                                // 1 sources

                                break block4;
                            }
                            case 22050: {
                                newSoundRate = 2;
                                ** break;
lbl28:
                                // 1 sources

                                break block4;
                            }
                            case 44100: {
                                newSoundRate = 3;
                                ** break;
lbl32:
                                // 1 sources

                                break block4;
                            }
                            default: {
                                throw new UnsupportedSamplingRateException(newSoundRate, new int[]{5512, 11025, 22050, 44100});
                            }
                        }
                    }
                    finally {
                        if (audioIs != null) {
                            audioIs.close();
                        }
                    }
                }
                catch (IOException | UnsupportedAudioFileException ex) {
                    return false;
                }
            }
            case 2: {
                bis = new BufferedInputStream(is);
                this.loadID3v2(bis);
                mp3data = Helper.readStream(bis);
                ID3_V1_LENTGH = 128;
                ID3_V1_EXT_LENGTH = 227;
                if (mp3data.length > 128 && mp3data[mp3data.length - 128] == 84 && mp3data[mp3data.length - 128 + 1] == 65 && mp3data[mp3data.length - 128 + 2] == 71 && (mp3data = Arrays.copyOf(mp3data, mp3data.length - 128)).length > 227 && mp3data[mp3data.length - 227] == 84 && mp3data[mp3data.length - 227 + 1] == 65 && mp3data[mp3data.length - 227 + 2] == 71 && mp3data[mp3data.length - 227 + 3] == 43) {
                    mp3data = Arrays.copyOf(mp3data, mp3data.length - 227);
                }
                try {
                    snd = new MP3SOUNDDATA(new SWFInputStream(soundTag.getSwf(), mp3data), true);
                    if (!snd.frames.isEmpty()) {
                        fr = snd.frames.get(0);
                        newSoundRate = fr.getSamplingRate();
                        switch (newSoundRate) {
                            case 11025: {
                                newSoundRate = 1;
                                break;
                            }
                            case 22050: {
                                newSoundRate = 2;
                                break;
                            }
                            case 44100: {
                                newSoundRate = 3;
                                break;
                            }
                            default: {
                                throw new UnsupportedSamplingRateException(newSoundRate, new int[]{11025, 22050, 44100});
                            }
                        }
                        newSoundSize = true;
                        newSoundType = fr.isStereo();
                        len = snd.sampleCount();
                        if (fr.isStereo()) {
                            len /= 2;
                        }
                        newSoundSampleCount = len;
                    }
                    baos = new ByteArrayOutputStream();
                    sos = new SWFOutputStream(baos, 10, null);
                    sos.writeSI16(0);
                    sos.write(mp3data);
                    newSoundData = baos.toByteArray();
                    break;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        if (newSoundData != null) {
            soundTag.setSoundSize(newSoundSize);
            soundTag.setSoundRate(newSoundRate);
            soundTag.setSoundSampleCount(newSoundSampleCount);
            soundTag.soundData = new ByteArrayRange(newSoundData);
            soundTag.setSoundType(newSoundType);
            soundTag.setSoundCompression(newSoundFormat);
            soundTag.setModified(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadID3v2(InputStream in) {
        int size = -1;
        try {
            in.mark(10);
            size = this.readID3v2Header(in);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
        try {
            if (size > 0) {
                byte[] rawid3v2 = new byte[size];
                in.read(rawid3v2, 0, rawid3v2.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readID3v2Header(InputStream in) throws IOException {
        byte[] id3header = new byte[4];
        int size = -10;
        in.read(id3header, 0, 3);
        if (id3header[0] == 73 && id3header[1] == 68 && id3header[2] == 51) {
            in.read(id3header, 0, 3);
            byte majorVersion = id3header[0];
            byte revision = id3header[1];
            in.read(id3header, 0, 4);
            size = (id3header[0] << 21) + (id3header[1] << 14) + (id3header[2] << 7) + id3header[3];
        }
        return size + 10;
    }

    public boolean importSoundStream(SoundStreamHeadTypeTag streamHead, InputStream is, int newSoundFormat) throws UnsupportedSamplingRateException {
        return this.importSoundStreamAtFrame(streamHead, is, newSoundFormat, null);
    }

    /*
     * Unable to fully structure code
     */
    public boolean importSoundStreamAtFrame(SoundStreamHeadTypeTag streamHead, InputStream is, int newSoundFormat, Integer startFrame) throws UnsupportedSamplingRateException {
        mp3Frames = null;
        newSoundRate = -1;
        newSoundSize = false;
        newSoundType = false;
        newSoundSampleCount = -1L;
        uncompressedSoundData = null;
        mp3data = null;
        swf = streamHead.getSwf();
        sampleLen = 0;
        soundRateHz = 0;
        bitRateOriginal = -1;
        newBitRate = -1;
        if (streamHead.getSoundFormatId() == 2 && !(ranges = streamHead.getRanges()).isEmpty()) {
            try {
                sis = new SWFInputStream(swf, ranges.get((int)0).blocks.get((int)0).streamSoundData.getRangeData());
                s = new MP3SOUNDDATA(sis, false);
                if (!s.frames.isEmpty()) {
                    bitRateOriginal = s.frames.get(0).getBitRate();
                }
            }
            catch (IOException s) {
                // empty catch block
            }
        }
        block7 : switch (newSoundFormat) {
            case 3: {
                try {
                    audioIs = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
                    try {
                        fmt = audioIs.getFormat();
                        newSoundType = fmt.getChannels() == 2;
                        newSoundSize = fmt.getSampleSizeInBits() == 16;
                        bitRateOriginal = -1;
                        uncompressedSoundData = Helper.readStream(audioIs);
                        sampleLen = (newSoundType != false ? 2 : 1) * (newSoundSize != false ? 2 : 1);
                        soundRateHz = Math.round(fmt.getSampleRate());
                        newSoundSampleCount = (int)Math.ceil((float)soundRateHz / swf.frameRate);
                        switch (soundRateHz) {
                            case 5512: {
                                newSoundRate = 0;
                                ** break;
lbl39:
                                // 1 sources

                                break block7;
                            }
                            case 11025: {
                                newSoundRate = 1;
                                ** break;
lbl43:
                                // 1 sources

                                break block7;
                            }
                            case 22050: {
                                newSoundRate = 2;
                                ** break;
lbl47:
                                // 1 sources

                                break block7;
                            }
                            case 44100: {
                                newSoundRate = 3;
                                ** break;
lbl51:
                                // 1 sources

                                break block7;
                            }
                            default: {
                                throw new UnsupportedSamplingRateException(newSoundRate, new int[]{5512, 11025, 22050, 44100});
                            }
                        }
                    }
                    finally {
                        if (audioIs != null) {
                            audioIs.close();
                        }
                    }
                }
                catch (IOException | UnsupportedAudioFileException ex) {
                    return false;
                }
            }
            case 2: {
                bis = new BufferedInputStream(is);
                this.loadID3v2(bis);
                mp3data = Helper.readStream(bis);
                ID3_V1_LENTGH = 128;
                ID3_V1_EXT_LENGTH = 227;
                if (mp3data.length > 128 && mp3data[mp3data.length - 128] == 84 && mp3data[mp3data.length - 128 + 1] == 65 && mp3data[mp3data.length - 128 + 2] == 71 && (mp3data = Arrays.copyOf(mp3data, mp3data.length - 128)).length > 227 && mp3data[mp3data.length - 227] == 84 && mp3data[mp3data.length - 227 + 1] == 65 && mp3data[mp3data.length - 227 + 2] == 71 && mp3data[mp3data.length - 227 + 3] == 43) {
                    mp3data = Arrays.copyOf(mp3data, mp3data.length - 227);
                }
                try {
                    snd = new MP3SOUNDDATA(new SWFInputStream(swf, mp3data), true);
                    if (!snd.frames.isEmpty()) {
                        fr = snd.frames.get(0);
                        soundRateHz = fr.getSamplingRate();
                        newBitRate = fr.getBitRate();
                        switch (soundRateHz) {
                            case 11025: {
                                newSoundRate = 1;
                                break;
                            }
                            case 22050: {
                                newSoundRate = 2;
                                break;
                            }
                            case 44100: {
                                newSoundRate = 3;
                                break;
                            }
                            default: {
                                throw new UnsupportedSamplingRateException(newSoundRate, new int[]{11025, 22050, 44100});
                            }
                        }
                        newSoundSize = true;
                        newSoundType = fr.isStereo();
                        newSoundSampleCount = (int)Math.ceil((float)soundRateHz / swf.frameRate);
                    }
                    mp3Frames = snd.frames;
                    break;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        if (startFrame != null && (newSoundFormat != streamHead.getSoundFormatId() || newSoundSize != streamHead.getSoundSize() || newSoundType != streamHead.getSoundType() || newSoundRate != streamHead.getSoundRate() || newBitRate != bitRateOriginal)) {
            data = streamHead.getRawSoundData();
            try {
                wholeStreamUncompressedData = streamHead.getSoundFormat().decode(null, data, 0);
            }
            catch (IOException ex) {
                return false;
            }
            if (mp3data != null) {
                rateMap = new int[]{5512, 11025, 22050, 44100};
                mp3SoundFormat = new SoundFormat(2, rateMap[newSoundRate], newSoundType);
                try {
                    uncompressedSoundData = mp3SoundFormat.decode(null, Arrays.asList(new ByteArrayRange[]{new ByteArrayRange(mp3data)}), 0);
                }
                catch (IOException ex) {
                    return false;
                }
                mp3Frames = null;
            }
            newSoundFormat = 3;
            if (newSoundSize && !streamHead.getSoundSize()) {
                wholeStreamUncompressedData = this.to16bit(wholeStreamUncompressedData);
            } else if (streamHead.getSoundSize() && !newSoundSize) {
                uncompressedSoundData = this.to16bit(uncompressedSoundData);
                newSoundSize = true;
            }
            if (newSoundType && !streamHead.getSoundType()) {
                wholeStreamUncompressedData = this.toStereo(wholeStreamUncompressedData, newSoundSize);
            } else if (streamHead.getSoundType() && !newSoundType) {
                uncompressedSoundData = this.toStereo(uncompressedSoundData, newSoundSize);
                newSoundType = true;
            }
            if (newSoundRate > streamHead.getSoundRate()) {
                for (i = streamHead.getSoundRate(); i < newSoundRate; ++i) {
                    wholeStreamUncompressedData = this.toHigherRate(wholeStreamUncompressedData, newSoundSize, newSoundType);
                }
            } else if (streamHead.getSoundRate() > newSoundRate) {
                for (i = newSoundRate; i < streamHead.getSoundRate(); ++i) {
                    uncompressedSoundData = this.toHigherRate(uncompressedSoundData, newSoundSize, newSoundType);
                }
                newSoundRate = streamHead.getSoundRate();
            }
            sampleLen = (newSoundType != false ? 2 : 1) * (newSoundSize != false ? 2 : 1);
            rateMap = new int[]{5512, 11025, 22050, 44100};
            this.addStream(streamHead, wholeStreamUncompressedData, swf, rateMap[newSoundRate], sampleLen, null, null, true);
        }
        this.addStream(streamHead, uncompressedSoundData, swf, soundRateHz, sampleLen, mp3Frames, startFrame, false);
        streamHead.setSoundCompression(newSoundFormat);
        streamHead.setSoundSampleCount((int)newSoundSampleCount);
        streamHead.setSoundSize(newSoundSize);
        streamHead.setSoundType(newSoundType);
        streamHead.setSoundRate(newSoundRate);
        streamHead.setModified(true);
        streamHead.getTimelined().resetTimeline();
        swf.resetTimeline();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void addStream(SoundStreamHeadTypeTag streamHead, byte[] uncompressedSoundData, SWF swf, int soundRateHz, int sampleLen, List<MP3FRAME> mp3Frames, Integer startFrame, boolean matchRanges) {
        void var15_26;
        long lastNumSamplesLong;
        ByteArrayInputStream bais = uncompressedSoundData == null ? null : new ByteArrayInputStream(uncompressedSoundData);
        List<SoundStreamFrameRange> ranges = streamHead.getRanges();
        ArrayList<SoundStreamBlockTag> existingBlocks = new ArrayList<SoundStreamBlockTag>();
        Timelined timelined = streamHead.getTimelined();
        int firstSeekSamples = 0;
        if (startFrame == null) {
            for (SoundStreamFrameRange soundStreamFrameRange : ranges) {
                existingBlocks.addAll(soundStreamFrameRange.blocks);
            }
            startFrame = 0;
            if (!existingBlocks.isEmpty()) {
                ReadOnlyTagList tags = timelined.getTags();
                Iterator<Tag> iterator = tags.iterator();
                while (iterator.hasNext()) {
                    Tag t = iterator.next();
                    if (t instanceof ShowFrameTag) {
                        Integer n = startFrame;
                        startFrame = startFrame + 1;
                    }
                    if (!(t instanceof SoundStreamBlockTag)) continue;
                    break;
                }
            }
        } else {
            for (SoundStreamFrameRange soundStreamFrameRange : ranges) {
                if (soundStreamFrameRange.startFrame != startFrame) continue;
                firstSeekSamples = soundStreamFrameRange.getSeekSamples();
                existingBlocks.addAll(soundStreamFrameRange.blocks);
                break;
            }
        }
        for (SoundStreamBlockTag soundStreamBlockTag : existingBlocks) {
            timelined.removeTag(soundStreamBlockTag);
        }
        ArrayList<SoundStreamBlockTag> blocks = new ArrayList<SoundStreamBlockTag>();
        if (bais != null) {
            DataInputStream dataInputStream = new DataInputStream(bais);
            long pos = 0L;
            int frame = 0;
            lastNumSamplesLong = 0L;
            try {
                while (dataInputStream.available() > 0) {
                    float timeAfterFrame = (float)(frame + 1) / swf.frameRate;
                    float numSamplesAfterFrame = (float)((frame + 1) * soundRateHz) / swf.frameRate;
                    long numSamplesAfterFrameLong = (long)Math.ceil(numSamplesAfterFrame);
                    long deltaNumSamples = numSamplesAfterFrameLong - lastNumSamplesLong;
                    lastNumSamplesLong = numSamplesAfterFrameLong;
                    if (deltaNumSamples > 0L) {
                        byte[] buf = new byte[(int)deltaNumSamples * sampleLen];
                        dataInputStream.readFully(buf);
                        SoundStreamBlockTag block = new SoundStreamBlockTag(swf);
                        block.streamSoundData = new ByteArrayRange(buf);
                        blocks.add(block);
                    } else {
                        SoundStreamBlockTag block = new SoundStreamBlockTag(swf);
                        block.streamSoundData = new ByteArrayRange(new byte[0]);
                        blocks.add(block);
                    }
                    ++frame;
                }
            }
            catch (IOException timeAfterFrame) {
                // empty catch block
            }
        }
        if (mp3Frames != null && !mp3Frames.isEmpty()) {
            MP3FRAME mP3FRAME = mp3Frames.get(0);
            int sampleCountPerMp3Frame = mP3FRAME.getSampleCount();
            int frame = startFrame;
            int mp3FrameNum = 0;
            lastNumSamplesLong = Math.round((float)(startFrame * soundRateHz) / swf.frameRate) - firstSeekSamples;
            while (mp3FrameNum < mp3Frames.size()) {
                float idealNumberOfSamplesAfterFrame = (float)((frame + 1) * soundRateHz) / swf.frameRate;
                long numSamplesBeforeFrameLong = Math.round((float)(frame * soundRateHz) / swf.frameRate);
                int seekSamples = (int)(numSamplesBeforeFrameLong - lastNumSamplesLong);
                SoundStreamBlockTag block = new SoundStreamBlockTag(swf);
                block.forceWriteAsLong = true;
                ArrayList<MP3FRAME> blockMp3Frames = new ArrayList<MP3FRAME>();
                int blockSamples = 0;
                while (mp3FrameNum < mp3Frames.size() && (float)(lastNumSamplesLong + (long)sampleCountPerMp3Frame) < idealNumberOfSamplesAfterFrame) {
                    MP3FRAME mp3Frame = mp3Frames.get(mp3FrameNum);
                    lastNumSamplesLong += (long)sampleCountPerMp3Frame;
                    blockSamples += sampleCountPerMp3Frame;
                    blockMp3Frames.add(mp3Frame);
                    ++mp3FrameNum;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SWFOutputStream sos = new SWFOutputStream(baos, 10, null);
                try {
                    sos.writeUI16(blockSamples);
                    sos.writeSI16(seekSamples);
                    for (MP3FRAME mp3Frame : blockMp3Frames) {
                        sos.write(mp3Frame.getBytes());
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(SoundImporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                block.streamSoundData = new ByteArrayRange(baos.toByteArray());
                blocks.add(block);
                ++frame;
            }
        }
        ReadOnlyTagList readOnlyTagList = timelined.getTags();
        int frame = -1;
        for (int i = 0; i < var15_26.size() && !blocks.isEmpty(); ++i) {
            Tag t = var15_26.get(i);
            if (t instanceof SoundStreamBlockTag && frame + 1 >= startFrame) {
                timelined.removeTag(i);
                ReadOnlyTagList readOnlyTagList2 = timelined.getTags();
                --i;
                continue;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
            boolean match = false;
            if (matchRanges) {
                for (SoundStreamFrameRange range : ranges) {
                    if (frame < range.startFrame || frame > range.endFrame) continue;
                    match = true;
                    break;
                }
            } else if (frame >= startFrame) {
                match = true;
            }
            if (!match || blocks.isEmpty()) continue;
            SoundStreamBlockTag block = (SoundStreamBlockTag)blocks.remove(0);
            block.setTimelined(timelined);
            timelined.addTag(i, block);
            ReadOnlyTagList readOnlyTagList3 = timelined.getTags();
            ++i;
        }
        int framesBefore = timelined.getFrameCount();
        while (!blocks.isEmpty()) {
            SoundStreamBlockTag block = (SoundStreamBlockTag)blocks.remove(0);
            block.setTimelined(timelined);
            timelined.addTag(block);
            ShowFrameTag sft = new ShowFrameTag(swf);
            sft.setTimelined(timelined);
            timelined.addTag(sft);
            ++framesBefore;
        }
        timelined.setFrameCount(framesBefore);
        timelined.resetTimeline();
    }

    private byte[] toStereo(byte[] data, boolean soundSize) {
        byte[] ret = new byte[data.length * 2];
        for (int i = 0; i < data.length; i += soundSize ? 2 : 1) {
            if (soundSize) {
                ret[i * 2] = data[i];
                ret[i * 2 + 1] = data[i + 1];
                ret[i * 2 + 2] = data[i];
                ret[i * 2 + 3] = data[i + 1];
                continue;
            }
            ret[i * 2] = data[i];
            ret[i * 2 + 1] = data[i];
        }
        return ret;
    }

    private byte[] to16bit(byte[] data) {
        byte[] ret = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int val = data[i] & 0xFF;
            val = val * 65535 / 255;
            ret[i * 2] = (byte)(val & 0xFF);
            ret[i * 2 + 1] = (byte)(val >> 8 & 0xFF);
        }
        return ret;
    }

    private byte[] toHigherRate(byte[] data, boolean soundSize, boolean soundType) {
        int sampleLen = (soundType ? 2 : 1) * (soundSize ? 2 : 1);
        byte[] ret = new byte[data.length * 2 - sampleLen];
        short prevLeft = 0;
        short prevRight = 0;
        int retPos = 0;
        for (int i = 0; i < data.length; i += sampleLen) {
            short right;
            short left;
            if (soundSize) {
                left = (short)((data[i] & 0xFF) + ((data[i + 1] & 0xFF) << 8));
                right = soundType ? (short)((data[i + 2] & 0xFF) + ((data[i + 3] & 0xFF) << 8)) : left;
            } else {
                left = data[i];
                right = soundType ? data[i + 1] : left;
            }
            if (i > 0) {
                int midLeft = (prevLeft + left) / 2;
                int midRight = (prevRight + right) / 2;
                if (soundSize) {
                    ret[retPos] = (byte)(midLeft & 0xFF);
                    ret[retPos + 1] = (byte)(midLeft >> 8 & 0xFF);
                    if (soundType) {
                        ret[retPos + 2] = (byte)(midRight & 0xFF);
                        ret[retPos + 3] = (byte)(midRight >> 8 & 0xFF);
                    }
                } else {
                    ret[retPos] = (byte)(midLeft & 0xFF);
                    if (soundType) {
                        ret[retPos + 1] = (byte)(midRight & 0xFF);
                    }
                }
                retPos += sampleLen;
            }
            if (soundSize) {
                ret[retPos] = (byte)(left & 0xFF);
                ret[retPos + 1] = (byte)(left >> 8 & 0xFF);
                if (soundType) {
                    ret[retPos + 2] = (byte)(right & 0xFF);
                    ret[retPos + 3] = (byte)(right >> 8 & 0xFF);
                }
            } else {
                ret[retPos] = (byte)(left & 0xFF);
                if (soundType) {
                    ret[retPos + 1] = (byte)(right & 0xFF);
                }
            }
            prevLeft = left;
            prevRight = right;
            retPos += sampleLen;
        }
        return ret;
    }

    public boolean importSound(SoundTag soundTag, InputStream is, int newSoundFormat, Integer startFrame) throws SoundImportException {
        if (soundTag instanceof DefineSoundTag) {
            return this.importDefineSound((DefineSoundTag)soundTag, is, newSoundFormat);
        }
        if (soundTag instanceof SoundStreamHeadTypeTag) {
            return this.importSoundStreamAtFrame((SoundStreamHeadTypeTag)soundTag, is, newSoundFormat, startFrame);
        }
        if (soundTag instanceof SoundStreamFrameRange) {
            return this.importSoundStreamAtFrame(((SoundStreamFrameRange)soundTag).getHead(), is, newSoundFormat, ((SoundStreamFrameRange)soundTag).startFrame);
        }
        return false;
    }

    public int bulkImport(File soundDir, SWF swf, boolean printOut) {
        Map<Integer, CharacterTag> characters = swf.getCharacters(false);
        int soundCount = 0;
        final List<String> extensions = Arrays.asList("mp3", "wav");
        File[] allFiles = soundDir.listFiles(new FilenameFilter(){
            final /* synthetic */ SoundImporter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                for (String ext : extensions) {
                    if (!nameLower.endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        ArrayList<Tag> soundTags = new ArrayList<Tag>();
        ArrayList<List<Object>> ranges = new ArrayList<List<Object>>();
        Iterator<Serializable> iterator = characters.keySet().iterator();
        block14: while (iterator.hasNext()) {
            int characterId = iterator.next();
            CharacterTag characterTag = characters.get(characterId);
            if (characterTag instanceof DefineSoundTag) {
                soundTags.add((DefineSoundTag)characterTag);
                ranges.add(new ArrayList());
            }
            if (!(characterTag instanceof DefineSpriteTag)) continue;
            DefineSpriteTag sprite = (DefineSpriteTag)characterTag;
            for (Tag subTag : sprite.getTags()) {
                if (!(subTag instanceof SoundStreamHeadTypeTag)) continue;
                soundTags.add((SoundStreamHeadTypeTag)subTag);
                ranges.add(sprite.getTimeline().getSoundStreamBlocks((SoundStreamHeadTypeTag)subTag));
                continue block14;
            }
        }
        for (Tag tag : swf.getTags()) {
            if (!(tag instanceof SoundStreamHeadTypeTag)) continue;
            soundTags.add((SoundStreamHeadTypeTag)tag);
            ranges.add(swf.getTimeline().getSoundStreamBlocks((SoundStreamHeadTypeTag)tag));
            break;
        }
        int pos = -1;
        block17: for (SoundTag soundTag : soundTags) {
            ++pos;
            int characterId = soundTag.getCharacterId();
            ArrayList<Object> existingFilesForSoundTag = new ArrayList<Object>();
            ArrayList<String> classNameExpectedFileNames = new ArrayList<String>();
            if (soundTag instanceof CharacterTag) {
                for (String className : ((CharacterTag)((Object)soundTag)).getClassNames()) {
                    classNameExpectedFileNames.add(Helper.makeFileName(className));
                }
            }
            for (File file : allFiles) {
                if (file.getName().startsWith("" + characterId + ".") || file.getName().startsWith("" + characterId + "_")) {
                    existingFilesForSoundTag.add(file);
                    continue;
                }
                String nameNoExt = file.getName();
                if (nameNoExt.contains(".")) {
                    nameNoExt = nameNoExt.substring(0, nameNoExt.lastIndexOf("."));
                }
                if (!classNameExpectedFileNames.contains(nameNoExt)) continue;
                existingFilesForSoundTag.add(file);
            }
            existingFilesForSoundTag.sort(new Comparator<File>(){
                final /* synthetic */ SoundImporter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(File o1, File o2) {
                    String ext1 = o1.getName().substring(o1.getName().lastIndexOf(".") + 1);
                    String ext2 = o2.getName().substring(o2.getName().lastIndexOf(".") + 1);
                    int ret = extensions.indexOf(ext1) - extensions.indexOf(ext2);
                    if (ret == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return ret;
                }
            });
            if (existingFilesForSoundTag.isEmpty()) continue;
            if (!((List)ranges.get(pos)).isEmpty()) {
                block20: for (SoundStreamFrameRange r : (List)ranges.get(pos)) {
                    for (File file : existingFilesForSoundTag) {
                        if (!file.getName().startsWith("" + characterId + "_" + (r.startFrame + 1) + "-")) continue;
                        try {
                            if (printOut) {
                                System.out.println("Importing character " + characterId + ", start frame " + r.startFrame + " from file " + file.getName());
                            }
                            int soundFormat = 3;
                            if (file.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
                                soundFormat = 2;
                            }
                            try (FileInputStream fis = new FileInputStream(file);){
                                this.importSound(soundTag, fis, soundFormat, r.startFrame);
                                ++soundCount;
                            }
                        }
                        catch (SoundImportException | IOException ex) {
                            Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Cannot import sound " + characterId + " from file " + file.getName(), ex);
                        }
                        if (!CancellableWorker.isInterrupted()) continue block20;
                        break block17;
                    }
                }
                continue;
            }
            if (existingFilesForSoundTag.size() > 1) {
                Logger.getLogger(SoundImporter.class.getName()).log(Level.WARNING, "Multiple matching files for sound tag {0} exists, {1} selected", new Object[]{characterId, ((File)existingFilesForSoundTag.get(0)).getName()});
            }
            File sourceFile = (File)existingFilesForSoundTag.get(0);
            try {
                if (printOut) {
                    System.out.println("Importing character " + characterId + " from file " + sourceFile.getName());
                }
                int soundFormat = 3;
                if (sourceFile.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
                    soundFormat = 2;
                }
                try (FileInputStream fis = new FileInputStream(sourceFile);){
                    this.importSound(soundTag, fis, soundFormat, null);
                    ++soundCount;
                }
            }
            catch (SoundImportException | IOException ex) {
                Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Cannot import sound " + characterId + " from file " + sourceFile.getName(), ex);
            }
            if (!CancellableWorker.isInterrupted()) continue;
            break;
        }
        return soundCount;
    }
}

