/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import at.dhyan.open_imaging.GifDecoder;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.importers.ShapeImporter;
import com.jpexs.decompiler.flash.tags.DefineShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class SpriteImporter {
    private void removeCharacters(Set<Integer> usedCharacters, SWF swf) {
        for (int ch : usedCharacters) {
            Set<Integer> dependentCharacters;
            CharacterTag ct = swf.getCharacter(ch);
            if (ct == null || !ct.getClassNames().isEmpty() || ct.getExportName() != null || !(dependentCharacters = swf.getDependentCharacters(ch)).isEmpty()) continue;
            LinkedHashSet<Integer> needed = new LinkedHashSet<Integer>();
            ct.getNeededCharacters(needed, swf);
            List<CharacterIdTag> attachedTags = swf.getCharacterIdTags(ch);
            for (CharacterIdTag cit : attachedTags) {
                if (!(cit instanceof Tag)) continue;
                Tag citt = (Tag)((Object)cit);
                citt.getTimelined().removeTag(citt);
            }
            ct.getTimelined().removeTag(ct);
            swf.computeDependentCharacters();
            this.removeCharacters(needed, swf);
        }
    }

    public boolean importSprite(DefineSpriteTag spriteTag, InputStream is) throws IOException {
        GifDecoder.GifImage gif = GifDecoder.read((InputStream)is);
        int frameCount = gif.getFrameCount();
        LinkedHashSet<Integer> usedCharacters = new LinkedHashSet<Integer>();
        for (int i = spriteTag.getTags().size() - 1; i >= 0; --i) {
            PlaceObjectTypeTag pt;
            int characterId;
            Tag t = spriteTag.getTags().get(i);
            if (t instanceof PlaceObjectTypeTag && (characterId = (pt = (PlaceObjectTypeTag)t).getCharacterId()) != -1) {
                usedCharacters.add(characterId);
            }
            spriteTag.removeTag(i);
        }
        spriteTag.getSwf().computeDependentCharacters();
        this.removeCharacters(usedCharacters, spriteTag.getSwf());
        ShapeImporter shapeImporter = new ShapeImporter();
        SWF swf = spriteTag.getSwf();
        float swfFrameRate = swf.frameRate;
        int gifFrameTimeMs = 0;
        int gifFrame = 0;
        int swfFrame = 0;
        int lastGifFrame = -1;
        int gifFrameCount = gif.getFrameCount();
        while (gifFrame < gifFrameCount) {
            if (lastGifFrame != gifFrame) {
                BufferedImage img = gif.getFrame(gifFrame);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)img, "png", baos);
                byte[] frameImageData = baos.toByteArray();
                DefineShape2Tag shapeTag = new DefineShape2Tag(spriteTag.getSwf());
                SWF.addTagBefore(shapeTag, spriteTag);
                shapeImporter.importImage(shapeTag, frameImageData, 0, false);
                PlaceObject2Tag placeObject = new PlaceObject2Tag(swf);
                placeObject.placeFlagHasCharacter = true;
                placeObject.characterId = shapeTag.shapeId;
                placeObject.depth = 1;
                if (swfFrame > 0) {
                    placeObject.placeFlagMove = true;
                }
                spriteTag.addTag(placeObject);
                placeObject.setTimelined(spriteTag);
            }
            ShowFrameTag showFrame = new ShowFrameTag(swf);
            spriteTag.addTag(showFrame);
            showFrame.setTimelined(spriteTag);
            lastGifFrame = gifFrame;
            float swfFrameTimeMs = (float)(++swfFrame * 100) / swfFrameRate;
            while (gifFrame < gifFrameCount && (float)(gifFrameTimeMs + gif.getDelay(gifFrame)) < swfFrameTimeMs) {
                gifFrameTimeMs += gif.getDelay(gifFrame);
                ++gifFrame;
            }
        }
        spriteTag.frameCount = frameCount;
        spriteTag.hasEndTag = true;
        spriteTag.resetTimeline();
        swf.resetTimeline();
        return true;
    }

    public int bulkImport(File spritesDir, SWF swf, boolean printOut) {
        Map<Integer, CharacterTag> characters = swf.getCharacters(false);
        int spriteCount = 0;
        final List<String> extensions = Arrays.asList("gif");
        File[] allFiles = spritesDir.listFiles(new FilenameFilter(){
            final /* synthetic */ SpriteImporter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(File dir, String name) {
                String nameLower = name.toLowerCase();
                for (String ext : extensions) {
                    if (!nameLower.endsWith("." + ext)) continue;
                    return true;
                }
                return false;
            }
        });
        for (int characterId : characters.keySet()) {
            CharacterTag tag = characters.get(characterId);
            if (!(tag instanceof DefineSpriteTag)) continue;
            DefineSpriteTag spriteTag = (DefineSpriteTag)tag;
            ArrayList<File> existingFilesForSpriteTag = new ArrayList<File>();
            ArrayList<String> classNameExpectedFileNames = new ArrayList<String>();
            for (String className : spriteTag.getClassNames()) {
                classNameExpectedFileNames.add(Helper.makeFileName(className));
            }
            for (File f : allFiles) {
                if (f.getName().startsWith("" + characterId + ".") || f.getName().startsWith("" + characterId + "_")) {
                    existingFilesForSpriteTag.add(f);
                    continue;
                }
                String nameNoExt = f.getName();
                if (nameNoExt.contains(".")) {
                    nameNoExt = nameNoExt.substring(0, nameNoExt.lastIndexOf("."));
                }
                if (!classNameExpectedFileNames.contains(nameNoExt)) continue;
                existingFilesForSpriteTag.add(f);
            }
            existingFilesForSpriteTag.sort(new Comparator<File>(){
                final /* synthetic */ SpriteImporter this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(File o1, File o2) {
                    String ext1 = o1.getName().substring(o1.getName().lastIndexOf(".") + 1);
                    String ext2 = o2.getName().substring(o2.getName().lastIndexOf(".") + 1);
                    int ret = extensions.indexOf(ext1) - extensions.indexOf(ext2);
                    if (ret == 0) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return ret;
                }
            });
            if (existingFilesForSpriteTag.isEmpty()) continue;
            if (existingFilesForSpriteTag.size() > 1) {
                Logger.getLogger(SpriteImporter.class.getName()).log(Level.WARNING, "Multiple matching files for sprite tag {0} exists, {1} selected", new Object[]{characterId, ((File)existingFilesForSpriteTag.get(0)).getName()});
            }
            File sourceFile = (File)existingFilesForSpriteTag.get(0);
            if (printOut) {
                System.out.println("Importing character " + characterId + " from file " + sourceFile.getName());
            }
            try (FileInputStream fis = new FileInputStream(sourceFile.getAbsolutePath());){
                this.importSprite(spriteTag, fis);
                ++spriteCount;
            }
            catch (IOException ex) {
                Logger.getLogger(ShapeImporter.class.getName()).log(Level.WARNING, "Cannot import sprite " + characterId + " from file " + sourceFile.getName(), ex);
            }
            if (!CancellableWorker.isInterrupted()) continue;
            break;
        }
        return spriteCount;
    }
}

