/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.amf.amf3;

import com.jpexs.decompiler.flash.amf.amf3.ListMap;
import com.jpexs.decompiler.flash.amf.amf3.Traits;
import com.jpexs.decompiler.flash.amf.amf3.types.ArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.BasicType;
import com.jpexs.decompiler.flash.amf.amf3.types.ByteArrayType;
import com.jpexs.decompiler.flash.amf.amf3.types.DateType;
import com.jpexs.decompiler.flash.amf.amf3.types.DictionaryType;
import com.jpexs.decompiler.flash.amf.amf3.types.ObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorDoubleType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorIntType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorObjectType;
import com.jpexs.decompiler.flash.amf.amf3.types.VectorUIntType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlDocType;
import com.jpexs.decompiler.flash.amf.amf3.types.XmlType;
import com.jpexs.decompiler.flash.importers.amf.AmfLexer;
import com.jpexs.decompiler.flash.importers.amf.AmfParseException;
import com.jpexs.decompiler.flash.importers.amf.ParsedSymbol;
import com.jpexs.decompiler.flash.importers.amf.SymbolType;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Amf3Importer {
    private AmfLexer lexer;

    private ParsedSymbol lex() throws IOException, AmfParseException {
        ParsedSymbol ret = this.lexer.lex();
        return ret;
    }

    private void pushback(ParsedSymbol s) {
        this.lexer.pushback(s);
    }

    private void expected(ParsedSymbol symb, int line, Object ... expected) throws IOException, AmfParseException {
        boolean found = false;
        for (Object t : expected) {
            if (symb.type == t) {
                found = true;
            }
            if (symb.group != t) continue;
            found = true;
        }
        if (!found) {
            String expStr = "";
            boolean first = true;
            for (Object e : expected) {
                if (!first) {
                    expStr = expStr + " or ";
                }
                expStr = expStr + e;
                first = false;
            }
            throw new AmfParseException("" + expStr + " expected but " + (Object)((Object)symb.type) + " found", line);
        }
    }

    private ParsedSymbol expectedType(Object ... type) throws IOException, AmfParseException {
        ParsedSymbol symb = this.lex();
        this.expected(symb, this.lexer.yyline(), type);
        return symb;
    }

    private JsArray parseArray(Map<String, Object> objectTable) throws IOException, AmfParseException {
        this.expectedType(new Object[]{SymbolType.BRACKET_OPEN});
        ArrayList<Object> arrayVals = new ArrayList<Object>();
        ParsedSymbol s = this.lex();
        if (!s.isType(new Object[]{SymbolType.BRACKET_CLOSE})) {
            this.pushback(s);
            arrayVals.add(this.value(objectTable));
            s = this.lex();
            while (s.isType(new Object[]{SymbolType.COMMA})) {
                arrayVals.add(this.value(objectTable));
                s = this.lex();
            }
        }
        this.expected(s, this.lexer.yyline(), new Object[]{SymbolType.BRACKET_CLOSE});
        return new JsArray(arrayVals);
    }

    private JsObject parseObject(Map<String, Object> objectTable) throws IOException, AmfParseException {
        JsObject ret = new JsObject();
        this.expectedType(new Object[]{SymbolType.CURLY_OPEN});
        ParsedSymbol s = this.lex();
        if (!s.isType(new Object[]{SymbolType.CURLY_CLOSE})) {
            this.pushback(s);
            do {
                Object key = this.value(objectTable);
                this.expectedType(new Object[]{SymbolType.COLON});
                Object value = this.value(objectTable);
                ret.put(key, value);
                s = this.lex();
            } while (s.isType(new Object[]{SymbolType.COMMA}));
        }
        this.pushback(s);
        this.expectedType(new Object[]{SymbolType.CURLY_CLOSE});
        return ret;
    }

    private Object resolveObjects(Object object, Map<String, Object> objectTable, boolean allowTypedObject) throws AmfParseException {
        Object resultObject = object;
        if (object instanceof JsArray) {
            JsArray jsa = (JsArray)object;
            JsArray ret = new JsArray();
            for (int i = 0; i < jsa.values.size(); ++i) {
                ret.values.add(this.resolveObjects(jsa.values.get(i), objectTable, true));
            }
            resultObject = ret;
        } else if (object instanceof JsObject) {
            if (allowTypedObject) {
                JsObject typedObject = (JsObject)object;
                if (typedObject.containsKey("type")) {
                    String typeStr = typedObject.getString("type");
                    String id = typedObject.containsKey("id") ? typedObject.getString("id") : null;
                    block14 : switch (typeStr) {
                        case "Date": {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                            String dateStr = typedObject.getString("value");
                            try {
                                resultObject = new DateType(sdf.parse(dateStr).getTime());
                                break;
                            }
                            catch (ParseException ex) {
                                throw new AmfParseException("Invalid date format: " + dateStr, this.lexer.yyline());
                            }
                        }
                        case "XML": {
                            resultObject = new XmlType(typedObject.getString("value"));
                            break;
                        }
                        case "XMLDocument": {
                            resultObject = new XmlDocType(typedObject.getString("value"));
                            break;
                        }
                        case "Object": {
                            String className = typedObject.getString("className");
                            if (typedObject.containsKey("serialized")) break;
                            boolean dynamic = typedObject.getBoolean("dynamic");
                            typedObject.resolve("sealedMembers", objectTable, false);
                            JsObject jsoSealed = typedObject.getJsObject("sealedMembers");
                            Map<String, Object> sealedMembers = jsoSealed.getStringMapped();
                            typedObject.resolve("dynamicMembers", objectTable, false);
                            Map<String, Object> dynamicMembers = typedObject.getJsObject("dynamicMembers").getStringMapped();
                            ArrayList<String> sealedMemberNames = new ArrayList<String>(jsoSealed.stringKeys());
                            resultObject = new ObjectType(new Traits(className, dynamic, sealedMemberNames), sealedMembers, dynamicMembers);
                            break;
                        }
                        case "Array": {
                            typedObject.resolve("denseValues", objectTable, false);
                            List<Object> denseValues = typedObject.getJsArray("denseValues").getValues();
                            typedObject.resolve("associativeValues", objectTable, false);
                            JsObject resolvedArr = typedObject.getJsObject("associativeValues");
                            Map<String, Object> associativeValues = resolvedArr.getStringMapped();
                            resultObject = new ArrayType(denseValues, associativeValues);
                            break;
                        }
                        case "Vector": {
                            boolean fixed = typedObject.getBoolean("fixed");
                            String subtype = typedObject.getString("subtype");
                            typedObject.resolve("values", objectTable, false);
                            switch (subtype) {
                                case "int": {
                                    resultObject = new VectorIntType(fixed, typedObject.getJsArrayOfInt("values"));
                                    break block14;
                                }
                                case "uint": {
                                    resultObject = new VectorUIntType(fixed, typedObject.getJsArrayOfUint("values"));
                                    break block14;
                                }
                                case "Number": {
                                    resultObject = new VectorDoubleType(fixed, typedObject.getJsArrayOfNumber("values"));
                                    break block14;
                                }
                            }
                            resultObject = new VectorObjectType(fixed, subtype, typedObject.getJsArrayOfObject("values"));
                            break;
                        }
                        case "ByteArray": {
                            try {
                                resultObject = new ByteArrayType(Helper.hexToByteArray(typedObject.getString("value")));
                                break;
                            }
                            catch (IllegalArgumentException iex) {
                                throw new AmfParseException("Invalid hex byte sequence", this.lexer.yyline());
                            }
                        }
                        case "Dictionary": {
                            boolean weakKeys = typedObject.getBoolean("weakKeys");
                            LinkedHashMap<Object, Object> entries = new LinkedHashMap<Object, Object>();
                            List entryArray = typedObject.getJsArray("entries").values;
                            for (Object entry : entryArray) {
                                if (!(entry instanceof JsObject)) {
                                    throw new AmfParseException("Invalid dictionary entry", this.lexer.yyline());
                                }
                                JsObject entryJso = (JsObject)entry;
                                entryJso.resolve("key", objectTable, true);
                                entryJso.resolve("value", objectTable, true);
                                Object key = entryJso.get("key");
                                Object value = entryJso.get("value");
                                entries.put(key, value);
                            }
                            resultObject = new DictionaryType(weakKeys, (Map<Object, Object>)entries);
                            break;
                        }
                        case "Reference": {
                            resultObject = new ReferencedObjectType(typedObject.getString("referencedId"));
                            break;
                        }
                        case "Undefined": {
                            resultObject = BasicType.UNDEFINED;
                            break;
                        }
                        default: {
                            throw new AmfParseException("Unknown object type: " + typeStr, this.lexer.yyline());
                        }
                    }
                    if (id != null) {
                        objectTable.put(id, resultObject);
                    }
                }
            } else {
                JsObject jsObject = (JsObject)object;
                for (Object key : jsObject.keySet()) {
                    Object val = jsObject.get(key);
                    Object resKey = this.resolveObjects(key, objectTable, true);
                    Object resVal = this.resolveObjects(val, objectTable, true);
                    jsObject.remove(key);
                    jsObject.put(resKey, resVal);
                }
                resultObject = jsObject;
            }
        }
        return resultObject;
    }

    private Map<String, Object> map(Map<String, Object> objectTable) throws IOException, AmfParseException {
        ParsedSymbol s;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.expectedType(new Object[]{SymbolType.CURLY_OPEN});
        do {
            s = this.lex();
            if (!s.isType(new Object[]{SymbolType.STRING})) break;
            String key = (String)s.value;
            this.expectedType(new Object[]{SymbolType.COLON});
            result.put(key, this.value(objectTable));
            s = this.lex();
        } while (s.type == SymbolType.COMMA);
        this.expected(s, this.lexer.yyline(), new Object[]{SymbolType.CURLY_CLOSE});
        return result;
    }

    private Object value(Map<String, Object> objectTable) throws IOException, AmfParseException {
        ParsedSymbol s = this.lex();
        switch (s.type) {
            case CURLY_OPEN: {
                this.pushback(s);
                return this.parseObject(objectTable);
            }
            case BRACKET_OPEN: {
                this.pushback(s);
                return this.parseArray(objectTable);
            }
            case STRING: 
            case DOUBLE: 
            case INTEGER: {
                return s.value;
            }
            case UNDEFINED: {
                return BasicType.UNDEFINED;
            }
            case NULL: {
                return BasicType.NULL;
            }
            case UNKNOWN: {
                return BasicType.UNKNOWN;
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case REFERENCE: {
                String referencedId = (String)s.value;
                return new ReferencedObjectType(referencedId);
            }
        }
        throw new AmfParseException("Unexpected symbol: " + s, this.lexer.yyline());
    }

    private Object replaceReferences(Object object, Map<String, Object> objectsTable) throws AmfParseException {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (object instanceof ReferencedObjectType) {
                            String key = ((ReferencedObjectType)object).key;
                            if (!objectsTable.containsKey(key)) {
                                throw new AmfParseException("Reference to undefined object: #" + key, 0L);
                            }
                            return objectsTable.get(key);
                        }
                        if (!(object instanceof ObjectType)) break block9;
                        ObjectType ot = (ObjectType)object;
                        for (String key : ot.sealedMembersKeySet()) {
                            ot.putSealedMember(key, this.replaceReferences(ot.getSealedMember(key), objectsTable));
                        }
                        for (String key : ot.dynamicMembersKeySet()) {
                            ot.putDynamicMember(key, this.replaceReferences(ot.getDynamicMember(key), objectsTable));
                        }
                        for (String key : ot.serializedMembersKeySet()) {
                            ot.putSerializedMember(key, this.replaceReferences(ot.getSerializedMember(key), objectsTable));
                        }
                        break block10;
                    }
                    if (!(object instanceof ArrayType)) break block11;
                    ArrayType at = (ArrayType)object;
                    for (String key : at.associativeKeySet()) {
                        at.putAssociative(key, this.replaceReferences(at.getAssociative(key), objectsTable));
                    }
                    for (int i = 0; i < at.getDenseValues().size(); ++i) {
                        at.setDense(i, this.replaceReferences(at.getDense(i), objectsTable));
                    }
                    break block10;
                }
                if (!(object instanceof VectorObjectType)) break block12;
                VectorObjectType vot = (VectorObjectType)object;
                for (int i = 0; i < vot.getValues().size(); ++i) {
                    vot.getValues().set(i, this.replaceReferences(vot.getValues().get(i), objectsTable));
                }
                break block10;
            }
            if (!(object instanceof DictionaryType)) break block10;
            DictionaryType dt = (DictionaryType)object;
            for (Object key : dt.keySet()) {
                Object val = dt.get(key);
                Object newKey = this.replaceReferences(key, objectsTable);
                Object newVal = this.replaceReferences(val, objectsTable);
                dt.remove(key);
                dt.put(newKey, newVal);
            }
        }
        return object;
    }

    public Object stringToAmf(String val) throws IOException, AmfParseException {
        this.lexer = new AmfLexer(new StringReader(val));
        LinkedHashMap<String, Object> objectsTable = new LinkedHashMap<String, Object>();
        ArrayList references = new ArrayList();
        Object result = this.value(objectsTable);
        Object resultResolved = this.resolveObjects(result, objectsTable, true);
        Object resultNoRef = this.replaceReferences(resultResolved, objectsTable);
        return resultNoRef;
    }

    public Map<String, Object> stringToAmfMap(String val) throws IOException, AmfParseException {
        this.lexer = new AmfLexer(new StringReader(val));
        LinkedHashMap<String, Object> objectsTable = new LinkedHashMap<String, Object>();
        ArrayList references = new ArrayList();
        Map<String, Object> result = this.map(objectsTable);
        for (String key : result.keySet()) {
            Object resultResolved = this.resolveObjects(result.get(key), objectsTable, true);
            result.put(key, resultResolved);
        }
        for (String key : result.keySet()) {
            Object resultNoRef = this.replaceReferences(result.get(key), objectsTable);
            result.put(key, resultNoRef);
        }
        return result;
    }

    private class JsArray {
        private List<Object> values = new ArrayList<Object>();

        public JsArray() {
        }

        public JsArray(List<Object> values) {
            this.values = values;
        }

        public void add(Object value) {
            this.values.add(value);
        }

        public List<Object> getValues() {
            return this.values;
        }
    }

    private class JsObject {
        private final Map<Object, Object> values = new ListMap<Object, Object>();

        private JsObject() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Object key : this.values.keySet()) {
                sb.append(key).append(":").append("?").append(",\r\n");
            }
            sb.append("}");
            return sb.toString();
        }

        public Object remove(Object key) {
            return this.values.remove(key);
        }

        public Set<Object> keySet() {
            return this.values.keySet();
        }

        public Object get(Object key) {
            return this.values.get(key);
        }

        public void put(Object key, Object value) {
            this.values.put(key, value);
        }

        public String getString(Object key) throws AmfParseException {
            return (String)this.getRequired(key, "String");
        }

        public Boolean getBoolean(Object key) throws AmfParseException {
            return (Boolean)this.getRequired(key, "Boolean");
        }

        public JsObject getJsObject(Object key) throws AmfParseException {
            return (JsObject)this.getRequired(key, "JsObject");
        }

        public List<Object> getJsArrayOfObject(Object key) throws AmfParseException {
            return this.getJsArray(key).getValues();
        }

        public List<String> getJsArrayOfString(Object key) throws AmfParseException {
            return this.getJsArray(key, "String");
        }

        public List<Long> getJsArrayOfInt(Object key) throws AmfParseException {
            return this.getJsArray(key, "int");
        }

        public List<Long> getJsArrayOfUint(Object key) throws AmfParseException {
            return this.getJsArray(key, "uint");
        }

        public List<Double> getJsArrayOfNumber(Object key) throws AmfParseException {
            return this.getJsArray(key, "Number");
        }

        public JsArray getJsArray(Object key) throws AmfParseException {
            return (JsArray)this.getRequired(key, "JsArray");
        }

        public List getJsArray(Object key, String valueType) throws AmfParseException {
            JsArray jsArr = (JsArray)this.getRequired(key, "JsArray");
            switch (valueType) {
                case "String": {
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Object v : jsArr.getValues()) {
                        String sv = null;
                        if (!(v instanceof String)) {
                            throw new AmfParseException("Not String: " + v, 0L);
                        }
                        sv = (String)v;
                        stringList.add(sv);
                    }
                    return stringList;
                }
                case "int": 
                case "uint": {
                    ArrayList<Long> longList = new ArrayList<Long>();
                    for (Object v : jsArr.getValues()) {
                        Long lv = null;
                        if (!(v instanceof Long)) {
                            throw new AmfParseException("Not an Integer value: " + v, 0L);
                        }
                        lv = (Long)v;
                        if (valueType.equals("uint") && lv < 0L) {
                            throw new AmfParseException("Not an Unsigned Integer value: " + v, 0L);
                        }
                        longList.add(lv);
                    }
                    return longList;
                }
                case "Number": {
                    ArrayList<Double> doubleList = new ArrayList<Double>();
                    for (Object v : jsArr.getValues()) {
                        Double cv = null;
                        if (v instanceof Long) {
                            cv = (double)((Long)v);
                        } else if (v instanceof Double) {
                            cv = (Double)v;
                        } else {
                            throw new AmfParseException("Not a Number: " + v, 0L);
                        }
                        doubleList.add(cv);
                    }
                    return doubleList;
                }
            }
            throw new AmfParseException("Unsupported array value type: " + valueType, 0L);
        }

        public Long getLong(Object key) throws AmfParseException {
            return (Long)this.getRequired(key, "Long");
        }

        public Object getRequired(Object key, String requiredType) throws AmfParseException {
            if (!this.containsKey(key)) {
                throw new AmfParseException("\"" + key + "\" is missing", 0L);
            }
            Object val = this.get(key);
            boolean typeMatches = true;
            if (requiredType != null) {
                switch (requiredType) {
                    case "String": {
                        typeMatches = val instanceof String;
                        break;
                    }
                    case "Long": {
                        typeMatches = val instanceof Long;
                        break;
                    }
                    case "JsObject": {
                        typeMatches = val instanceof JsObject;
                        break;
                    }
                    case "JsArray": {
                        typeMatches = val instanceof JsArray;
                        break;
                    }
                    case "Boolean": {
                        typeMatches = val instanceof Boolean;
                    }
                }
            }
            if (!typeMatches) {
                throw new AmfParseException("\"" + key + "\" value must be of type " + requiredType, 0L);
            }
            return val;
        }

        public boolean containsKey(Object key) {
            return this.values.containsKey(key);
        }

        public void resolve(Object key, Map<String, Object> objectTable, boolean allowTypedObject) throws AmfParseException {
            Object val = this.values.get(key);
            Object resolved = Amf3Importer.this.resolveObjects(val, objectTable, allowTypedObject);
            this.values.put(key, resolved);
        }

        public List<String> stringKeys() {
            ArrayList<String> ret = new ArrayList<String>();
            for (Object key : this.values.keySet()) {
                if (!(key instanceof String)) continue;
                ret.add((String)key);
            }
            return ret;
        }

        public Map<Object, Object> getAll() {
            return this.values;
        }

        public Map<String, Object> getStringMapped() {
            ListMap<String, Object> ret = new ListMap<String, Object>();
            for (Object key : this.values.keySet()) {
                if (!(key instanceof String)) continue;
                String keyStr = (String)key;
                ret.put(keyStr, this.values.get(key));
            }
            return ret;
        }
    }

    private class ReferencedObjectType {
        private final String key;

        public ReferencedObjectType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return "#" + this.key;
        }
    }
}

