/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg.css;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssSelectorToXPath {
    private final String xpath_url_attrs = "@href|@src";
    private final String xpath_lower_case = this.xpath_to_lower(null);
    private final String xpath_ns_uri = "ancestor-or-self::*[last()]/@url";
    private final String xpath_ns_path = this.xpath_url_path(this.xpath_url("ancestor-or-self::*[last()]/@url"));
    private final String xpath_has_protocol = "(starts-with(@href|@src,\"http://\") or starts-with(@href|@src,\"https://\"))";
    private final String xpath_is_internal = "starts-with(" + this.xpath_url(null) + "," + this.xpath_url_domain("ancestor-or-self::*[last()]/@url") + ") or " + this.xpath_ends_with(this.xpath_url_domain(null), this.xpath_url_domain("ancestor-or-self::*[last()]/@url"));
    private final String xpath_is_local = "((starts-with(@href|@src,\"http://\") or starts-with(@href|@src,\"https://\")) and starts-with(" + this.xpath_url(null) + "," + this.xpath_url("ancestor-or-self::*[last()]/@url") + "))";
    private final String xpath_is_path = "starts-with(@href|@src,\"/\")";
    private final String xpath_is_local_path = "starts-with(" + this.xpath_url_path(null) + "," + this.xpath_ns_path + ")";
    private final String xpath_normalize_space = "normalize-space()";
    private final String xpath_internal = "[not((starts-with(@href|@src,\"http://\") or starts-with(@href|@src,\"https://\"))) or " + this.xpath_is_internal + "]";
    private final String xpath_external = "[(starts-with(@href|@src,\"http://\") or starts-with(@href|@src,\"https://\")) and not(" + this.xpath_is_internal + ")]";
    private final char escape_literal = (char)30;
    private final char escape_parens = (char)31;
    private final String regex_string_literal = "(\"[^\"\\x1E]*\"|'[^'\\x1E]*'|=\\s*[^\\s\\]\\'\\\"]+)";
    private final String regex_escaped_literal = "['\"]?(\\x1E+)['\"]?";
    private final String regex_css_wrap_pseudo = "(\\x1F\\)|[^\\)])\\:(first|limit|last|gt|lt|eq|nth)([^\\-]|$)";
    private final String regex_special_chars = "[\\x1C-\\x1F]+";
    private final String regex_first_axis = "^([\\s\\(\\x1F]*)(\\.?[^\\.\\/\\(]{1,2}[a-z]*:*)";
    private final String regex_filter_prefix = "(^|\\/|\\:)\\[";
    private final String regex_attr_prefix = "([^\\(\\[\\/\\|\\s\\x1F])\\@";
    private final String regex_nth_equation = "^([-0-9]*)n.*?([0-9]*)$";
    private final String css_combinators_regex = "\\s*(!?[+>~,^ ])\\s*(\\.?\\/+|[a-z\\-]+::)?([a-z\\-]+\\()?((and\\s*|or\\s*|mod\\s*)?[^+>~,\\s'\"\\]\\|\\^\\$\\!\\<\\=\\x1C-\\x1F]+)?";
    private final String css_attributes_regex = "\\[([^\\@\\|\\*\\=\\^\\~\\$\\!\\(\\/\\s\\x1C-\\x1F]+)\\s*(([\\|\\*\\~\\^\\$\\!]?)=?\\s*(\\x1E+))?\\]";
    private final String css_pseudo_classes_regex = ":([a-z\\-]+)(\\((\\x1F+)(([^\\x1F]+(\\3\\x1F+)?)*)(\\3\\)))?";
    private String css_ids_classes_regex = "(#|\\.)([^\\#\\@\\.\\/\\(\\[\\)\\]\\|\\:\\s\\+\\>\\<\\'\\\"\\x1D-\\x1F]+)";

    private String xpath_to_lower(String s) {
        return "translate(" + (s == null ? "normalize-space()" : s) + ", 'ABCDEFGHJIKLMNOPQRSTUVWXYZ', 'abcdefghjiklmnopqrstuvwxyz')";
    }

    private String xpath_ends_with(String s1, String s2) {
        return "substring(" + s1 + ",string-length(" + s1 + ")-string-length(" + s2 + ")+1)=" + s2;
    }

    private String xpath_url(String s) {
        return "substring-before(concat(substring-after(" + (s == null ? "@href|@src" : s) + ",\"://\"),\"?\"),\"?\")";
    }

    private String xpath_url_path(String s) {
        return "substring-after(" + (s == null || s.isEmpty() ? "@href|@src" : s) + ",\"/\")";
    }

    private String xpath_url_domain(String s) {
        return "substring-before(concat(substring-after(" + (s == null || s.isEmpty() ? "@href|@src" : s) + ",\"://\"),\"/\"),\"/\")";
    }

    private boolean isNumeric(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private String css_combinators_callback(String match, String operator, String axis, String func, String literal, String exclude, int offset, String orig) {
        String prefix = "";
        if (operator.equals(" ") && exclude != null) {
            return match;
        }
        if (axis == null) {
            if (!(func == null || func.equals("node(") || func.equals("text(") || func.equals("comment("))) {
                return null;
            }
            if (literal == null) {
                literal = func;
            }
            if (this.isNumeric(literal)) {
                return match;
            }
            if (orig.length() <= offset - 1) {
                prefix = ".";
            } else {
                char prevChar = orig.charAt(offset - 1);
                if (prevChar == '(' || prevChar == '|' || prevChar == ':') {
                    prefix = ".";
                }
            }
        }
        if (literal == null) {
            if (offset + match.length() == orig.length()) {
                literal = "*";
            } else {
                return match;
            }
        }
        switch (operator) {
            case " ": {
                return "//" + literal;
            }
            case ">": {
                return "/" + literal;
            }
            case "+": {
                return prefix + "/following-sibling::*[1]/self::" + literal;
            }
            case "~": {
                return prefix + "/following-sibling::" + literal;
            }
            case ",": {
                axis = ".//";
                return "|" + axis + literal;
            }
            case "^": {
                return "/child::*[1]/self::" + literal;
            }
            case "!^": {
                return "/child::*[last()]/self::" + literal;
            }
            case "! ": {
                return "/ancestor-or-self::" + literal;
            }
            case "!>": {
                return "/parent::" + literal;
            }
            case "!+": {
                return "/preceding-sibling::*[1]/self::" + literal;
            }
            case "!~": {
                return "/preceding-sibling::" + literal;
            }
        }
        return null;
    }

    private String css_attributes_callback(String str, String attr, String comp, String op, String val, int offset, String orig) {
        String axis = "";
        if (op == null) {
            op = "";
        }
        switch (op) {
            case "!": {
                return axis + "[not(@" + attr + ") or @" + attr + "!=\"" + val + "\"]";
            }
            case "$": {
                return axis + "[substring(@" + attr + ",string-length(@" + attr + ")-(string-length(\"" + val + "'\")-1))=\"" + val + "\"]";
            }
            case "^": {
                return axis + "[starts-with(@" + attr + ",\"" + val + "\")]";
            }
            case "~": {
                return axis + "[contains(concat(\" \",normalize-space(@" + attr + "),\" \"),concat(\" \",\"" + val + "\",\" \"))]";
            }
            case "*": {
                return axis + "[contains(@" + attr + ",\"" + val + "\")]";
            }
            case "|": {
                return axis + "[@" + attr + "=\"" + val + "\" or starts-with(@" + attr + ",concat(\"" + val + "\",\"-\"))]";
            }
        }
        if (comp == null) {
            if (attr.charAt(attr.length() - 1) == '(' || attr.matches("^[0-9]+$") || attr.indexOf(58) != -1) {
                return str;
            }
            return axis + "[@" + attr + "]";
        }
        return axis + "[@" + attr + "=\"" + val + "\"]";
    }

    private String css_pseudo_classes_callback(String match, String name, String g1, String g2, String arg, String g3, String g4, String g5, int offset, String orig) {
        if (offset - 2 >= 0 && orig.charAt(offset - 1) == ':' && orig.charAt(offset - 2) != ':') {
            return match;
        }
        if ("odd".equals(name) || "even".equals(name)) {
            arg = name;
            name = "nth-of-type";
        }
        switch (name) {
            case "after": {
                return "[count(" + this.css2xpath("preceding::" + arg, true) + ") > 0]";
            }
            case "after-sibling": {
                return "[count(" + this.css2xpath("preceding-sibling::" + arg, true) + ") > 0]";
            }
            case "before": {
                return "[count(" + this.css2xpath("following::" + arg, true) + ") > 0]";
            }
            case "before-sibling": {
                return "[count(" + this.css2xpath("following-sibling::" + arg, true) + ") > 0]";
            }
            case "checked": {
                return "[@selected or @checked]";
            }
            case "contains": {
                return "[contains(normalize-space()," + arg + ")]";
            }
            case "icontains": {
                return "[contains(" + this.xpath_lower_case + "," + this.xpath_to_lower(arg) + ")]";
            }
            case "empty": {
                return "[not(*) and not(normalize-space())]";
            }
            case "enabled": 
            case "disabled": {
                return "[@" + name + "]";
            }
            case "first-child": {
                return "[not(preceding-sibling::*)]";
            }
            case "first": 
            case "limit": 
            case "first-of-type": {
                if (arg != null) {
                    return "[position()<=" + arg + "]";
                }
                return "[1]";
            }
            case "gt": {
                return "[position()>" + (Integer.parseInt(arg, 10) + 1) + "]";
            }
            case "lt": {
                return "[position()<" + (Integer.parseInt(arg, 10) + 1) + "]";
            }
            case "last-child": {
                return "[not(following-sibling::*)]";
            }
            case "only-child": {
                return "[not(preceding-sibling::*) and not(following-sibling::*)]";
            }
            case "only-of-type": {
                return "[not(preceding-sibling::*[name()=name(self::node())]) and not(following-sibling::*[name()=name(self::node())])]";
            }
            case "nth-child": {
                if (this.isNumeric(arg)) {
                    return "[(count(preceding-sibling::*)+1) = " + arg + "]";
                }
                switch (arg) {
                    case "even": {
                        return "[(count(preceding-sibling::*)+1) mod 2=0]";
                    }
                    case "odd": {
                        return "[(count(preceding-sibling::*)+1) mod 2=1]";
                    }
                }
                String[] a = (arg == null || arg.isEmpty() ? "0" : arg).replaceAll("^([-0-9]*)n.*?([0-9]*)$", "$1+$2").split("\\+");
                String a0 = a.length < 1 || a[0].isEmpty() ? "1" : a[0];
                String a1 = a.length < 2 || a[1].isEmpty() ? "0" : a[1];
                return "[(count(preceding-sibling::*)+1)>=" + a1 + " and ((count(preceding-sibling::*)+1)-" + a1 + ") mod " + a0 + "=0]";
            }
            case "nth-of-type": {
                if (this.isNumeric(arg)) {
                    return "[" + arg + "]";
                }
                switch (arg) {
                    case "odd": {
                        return "[position() mod 2=1]";
                    }
                    case "even": {
                        return "[position() mod 2=0 and position()>=0]";
                    }
                }
                String[] a = (arg == null || arg.isEmpty() ? "0" : arg).replaceAll("^([-0-9]*)n.*?([0-9]*)$", "$1+$2").split("\\+");
                String a0 = a.length < 1 || a[0].isEmpty() ? "1" : a[0];
                String a1 = a.length < 2 || a[1].isEmpty() ? "0" : a[1];
                return "[position()>=" + a1 + " and (position()-" + a1 + ") mod " + a0 + "=0]";
            }
            case "eq": 
            case "nth": {
                if (this.isNumeric(arg)) {
                    return "[" + (Integer.parseInt(arg, 10) + 1) + "]";
                }
                return "[1]";
            }
            case "text": {
                return "[@type=\"text\"]";
            }
            case "istarts-with": {
                return "[starts-with(" + this.xpath_lower_case + "," + this.xpath_to_lower(arg) + ")]";
            }
            case "starts-with": {
                return "[starts-with(normalize-space()," + arg + ")]";
            }
            case "iends-with": {
                return "[" + this.xpath_ends_with(this.xpath_lower_case, this.xpath_to_lower(arg)) + "]";
            }
            case "ends-with": {
                return "[" + this.xpath_ends_with("normalize-space()", arg) + "]";
            }
            case "has": {
                String xpath1 = this.prependAxis(this.css2xpath(arg, true), ".//");
                return "[count(" + xpath1 + ") > 0]";
            }
            case "has-sibling": {
                String xpath2 = this.css2xpath("preceding-sibling::" + arg, true);
                return "[count(" + xpath2 + ") > 0 or count(following-sibling::" + xpath2.substring(19) + ") > 0]";
            }
            case "has-parent": {
                return "[count(" + this.css2xpath("parent::" + arg, true) + ") > 0]";
            }
            case "has-ancestor": {
                return "[count(" + this.css2xpath("ancestor::" + arg, true) + ") > 0]";
            }
            case "last": 
            case "last-of-type": {
                if (arg != null) {
                    return "[position()>last()-" + arg + "]";
                }
                return "[last()]";
            }
            case "selected": {
                return "[local-name()=\"option\" and @selected]";
            }
            case "skip": 
            case "skip-first": {
                return "[position()>" + arg + "]";
            }
            case "skip-last": {
                if (arg != null) {
                    return "[last()-position()>=" + arg + "]";
                }
                return "[position()<last()]";
            }
            case "root": {
                return "/ancestor::[last()]";
            }
            case "range": {
                String[] arr = arg.split(",");
                return "[" + arr[0] + "<=position() and position()<=" + arr[1] + "]";
            }
            case "input": {
                return "[local-name()=\"input\" or local-name()=\"button\" or local-name()=\"select\" or local-name()=\"textarea\"]";
            }
            case "internal": {
                return this.xpath_internal;
            }
            case "external": {
                return this.xpath_external;
            }
            case "http": 
            case "https": 
            case "mailto": 
            case "javascript": {
                return "[starts-with(@href,concat(\"" + name + "\",\":\"))]";
            }
            case "domain": {
                return "[(string-length(" + this.xpath_url_domain(null) + ")=0 and contains(" + this.xpath_url_domain("ancestor-or-self::*[last()]/@url") + "," + arg + ")) or contains(" + this.xpath_url_domain(null) + "," + arg + ")]";
            }
            case "path": {
                return "[starts-with(" + this.xpath_url_path(null) + ",substring-after(\"" + arg + "\",\"/\"))]";
            }
            case "not": {
                String xpath3 = this.css2xpath(arg, true);
                if (xpath3.charAt(0) == '[') {
                    xpath3 = "self::node()" + xpath3;
                }
                return "[not(" + xpath3 + ")]";
            }
            case "target": {
                return "[starts-with(@href, \"#\")]";
            }
            case "lang": {
                return "[@lang=\"" + arg + "\"]";
            }
            case "read-only": 
            case "read-write": {
                return "[@" + name.replace("-", "") + "]";
            }
            case "valid": 
            case "required": 
            case "in-range": 
            case "out-of-range": {
                return "[@" + name + "]";
            }
        }
        return "[@_pseudo_" + name + "]";
    }

    private String css_ids_classes_callback(String str, String op, String val, int offset, String orig) {
        String axis = "";
        if ("#".equals(op)) {
            return axis + "[@id=\"" + val + "\"]";
        }
        return axis + "[contains(concat(\" \",normalize-space(@class),\" \"),\" " + val + " \")]";
    }

    private String prependAxis(String s, String axis) {
        Pattern pat = Pattern.compile("^([\\s\\(\\x1F]*)(\\.?[^\\.\\/\\(]{1,2}[a-z]*:*)");
        StringBuffer buf = new StringBuffer();
        Matcher mat = pat.matcher(s);
        while (mat.find()) {
            String start = mat.group(1);
            String literal = mat.group(2);
            if (literal.length() >= 2 && "::".equals(literal.substring(literal.length() - 2))) {
                mat.appendReplacement(buf, mat.group());
                continue;
            }
            if (literal.charAt(0) == '[') {
                axis = axis + "*";
            }
            mat.appendReplacement(buf, start + axis + literal);
        }
        mat.appendTail(buf);
        return buf.toString();
    }

    private int selectorStart(String s, int i) {
        int depth = 0;
        int offset = 0;
        block6: while (i-- > 0) {
            switch (s.charAt(i)) {
                case '\u001f': 
                case ' ': {
                    ++offset;
                    continue block6;
                }
                case '(': 
                case '[': {
                    if (--depth >= 0) continue block6;
                    return ++i + offset;
                }
                case ')': 
                case ']': {
                    ++depth;
                    continue block6;
                }
                case ',': 
                case '|': {
                    if (depth != 0) break;
                    return ++i + offset;
                }
            }
            offset = 0;
        }
        return 0;
    }

    private String escapeChar(String s, String open, String close, char chr) {
        Pattern pat = Pattern.compile("[\\" + open + "\\" + close + "]");
        StringBuffer buf = new StringBuffer();
        Matcher mat = pat.matcher(s);
        int depth = 0;
        while (mat.find()) {
            if (open.equals(mat.group())) {
                ++depth;
            }
            if (open.equals(mat.group())) {
                mat.appendReplacement(buf, mat.group() + this.repeat("" + chr, depth));
                continue;
            }
            mat.appendReplacement(buf, this.repeat("" + chr, depth--) + mat.group());
        }
        mat.appendTail(buf);
        return buf.toString();
    }

    private String repeat(String str, int num) {
        String result = "";
        while (true) {
            if ((num & 1) == 1) {
                result = result + str;
            }
            if ((num >>>= 1) <= 0) break;
            str = str + str;
        }
        return result;
    }

    private String replace(String s, String regexp, ReplaceCallBack callback) {
        Pattern pat = Pattern.compile(regexp);
        StringBuffer sb = new StringBuffer();
        Matcher m = pat.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, callback.run(m, s));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private int search(String s, String regexp) {
        Pattern pat = Pattern.compile(regexp);
        Matcher m = pat.matcher(s);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }

    public String css2xpath(String s) {
        return this.css2xpath(s, false);
    }

    public String css2xpath(String s, boolean nested) {
        int index;
        if (nested) {
            String s1 = s;
            s = this.replace(s, ":([a-z\\-]+)(\\((\\x1F+)(([^\\x1F]+(\\3\\x1F+)?)*)(\\3\\)))?", new ReplaceCallBack(){

                @Override
                public String run(Matcher mat, String s) {
                    return CssSelectorToXPath.this.css_pseudo_classes_callback(mat.group(), mat.group(1), mat.group(1), mat.group(2), mat.group(3), mat.group(4), mat.group(5), mat.group(6), mat.start(), s);
                }
            });
            s = this.replace(s, ":([a-z\\-]+)(\\((\\x1F+)(([^\\x1F]+(\\3\\x1F+)?)*)(\\3\\)))?", new ReplaceCallBack(){

                @Override
                public String run(Matcher mat, String s) {
                    return CssSelectorToXPath.this.css_pseudo_classes_callback(mat.group(), mat.group(1), mat.group(2), mat.group(3), mat.group(4), mat.group(5), mat.group(6), mat.group(7), mat.start(), s);
                }
            });
            s = this.replace(s, this.css_ids_classes_regex, new ReplaceCallBack(){

                @Override
                public String run(Matcher mat, String s) {
                    return CssSelectorToXPath.this.css_ids_classes_callback(mat.group(), mat.group(1), mat.group(2), mat.start(), s);
                }
            });
            return s;
        }
        s = this.escapeChar(s, "(", ")", '\u001f');
        final ArrayList literals = new ArrayList();
        s = this.replace(s, "(\"[^\"\\x1E]*\"|'[^'\\x1E]*'|=\\s*[^\\s\\]\\'\\\"]+)", new ReplaceCallBack(){
            final /* synthetic */ CssSelectorToXPath this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String run(Matcher mat, String fullS) {
                String s = mat.group();
                String a = mat.group(1);
                if (a.charAt(0) == '=') {
                    if (this.this$0.isNumeric(a = a.substring(1).trim())) {
                        return s;
                    }
                } else {
                    a = a.substring(1, a.length() - 1);
                }
                literals.add(a);
                return this.this$0.repeat("\u001e", literals.size());
            }
        });
        s = this.replace(s, "\\s*(!?[+>~,^ ])\\s*(\\.?\\/+|[a-z\\-]+::)?([a-z\\-]+\\()?((and\\s*|or\\s*|mod\\s*)?[^+>~,\\s'\"\\]\\|\\^\\$\\!\\<\\=\\x1C-\\x1F]+)?", new ReplaceCallBack(){

            @Override
            public String run(Matcher mat, String s) {
                return CssSelectorToXPath.this.css_combinators_callback(mat.group(), mat.group(1), mat.group(2), mat.group(3), mat.group(4), mat.group(5), mat.start(), s);
            }
        });
        s = this.replace(s, "\\[([^\\@\\|\\*\\=\\^\\~\\$\\!\\(\\/\\s\\x1C-\\x1F]+)\\s*(([\\|\\*\\~\\^\\$\\!]?)=?\\s*(\\x1E+))?\\]", new ReplaceCallBack(){

            @Override
            public String run(Matcher mat, String s) {
                return CssSelectorToXPath.this.css_attributes_callback(mat.group(), mat.group(1), mat.group(2), mat.group(3), mat.group(4), mat.start(), s);
            }
        });
        while ((index = this.search(s, "(\\x1F\\)|[^\\)])\\:(first|limit|last|gt|lt|eq|nth)([^\\-]|$)")) != -1) {
            index = s.indexOf(58, index);
            int start = this.selectorStart(s, index);
            s = s.substring(0, start) + '(' + s.substring(start, index) + ')' + s.substring(index);
        }
        s = this.replace(s, ":([a-z\\-]+)(\\((\\x1F+)(([^\\x1F]+(\\3\\x1F+)?)*)(\\3\\)))?", new ReplaceCallBack(){

            @Override
            public String run(Matcher mat, String s) {
                return CssSelectorToXPath.this.css_pseudo_classes_callback(mat.group(), mat.group(1), mat.group(2), mat.group(3), mat.group(4), mat.group(5), mat.group(6), mat.group(7), mat.start(), s);
            }
        });
        s = this.replace(s, this.css_ids_classes_regex, new ReplaceCallBack(){

            @Override
            public String run(Matcher mat, String s) {
                return CssSelectorToXPath.this.css_ids_classes_callback(mat.group(), mat.group(1), mat.group(2), mat.start(), s);
            }
        });
        s = this.replace(s, "['\"]?(\\x1E+)['\"]?", new ReplaceCallBack(){
            final /* synthetic */ CssSelectorToXPath this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String run(Matcher mat, String a) {
                String str = (String)literals.get(mat.group(1).length() - 1);
                return "\"" + str + "\"";
            }
        });
        s = s.replaceAll("[\\x1C-\\x1F]+", "");
        s = s.replaceAll("(^|\\/|\\:)\\[", "$1*[");
        s = s.replaceAll("([^\\(\\[\\/\\|\\s\\x1F])\\@", "$1/@");
        s = this.prependAxis(s, ".//");
        return s;
    }

    private static interface ReplaceCallBack {
        public String run(Matcher var1, String var2);
    }
}

