/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.math;

import com.jpexs.decompiler.flash.math.BezierUtils;
import com.jpexs.decompiler.flash.math.Intersections;
import com.jpexs.helpers.Reference;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Stack;

public class BezierEdge
implements Serializable {
    public List<Point2D> points = new ArrayList<Point2D>(3);
    private List<Point2D> revPoints = new ArrayList<Point2D>();
    private int hash;
    private int revHash;
    private Rectangle2D bbox;
    private boolean empty;
    private final double MIN_SIZE = 0.5;
    public static final double ROUND_VALUE = 2.0;

    public BezierEdge(List<Point2D> points) {
        this.points = points;
        this.calcParams();
    }

    public BezierEdge clone() {
        return new BezierEdge(new ArrayList<Point2D>(this.points));
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public BezierEdge(double x0, double y0, double x1, double y1) {
        this.points.add(new Point2D.Double(x0, y0));
        this.points.add(new Point2D.Double(x1, y1));
        this.calcParams();
    }

    public BezierEdge(double x0, double y0, double cx, double cy, double x1, double y1) {
        this.points.add(new Point2D.Double(x0, y0));
        this.points.add(new Point2D.Double(cx, cy));
        this.points.add(new Point2D.Double(x1, y1));
        this.calcParams();
    }

    public Point2D getBeginPoint() {
        return this.points.get(0);
    }

    public Point2D getEndPoint() {
        return this.points.get(this.points.size() - 1);
    }

    public void setBeginPoint(Point2D p) {
        this.points.set(0, p);
        this.calcParams();
    }

    public void setEndPoint(Point2D p) {
        this.points.set(this.points.size() - 1, p);
        this.calcParams();
    }

    public Point2D pointAt(double t) {
        if (this.points.size() == 2) {
            double x = (1.0 - t) * this.points.get(0).getX() + t * this.points.get(1).getX();
            double y = (1.0 - t) * this.points.get(0).getY() + t * this.points.get(1).getY();
            return new Point2D.Double(x, y);
        }
        double x = (1.0 - t) * (1.0 - t) * this.points.get(0).getX() + 2.0 * t * (1.0 - t) * this.points.get(1).getX() + t * t * this.points.get(2).getX();
        double y = (1.0 - t) * (1.0 - t) * this.points.get(0).getY() + 2.0 * t * (1.0 - t) * this.points.get(1).getY() + t * t * this.points.get(2).getY();
        return new Point2D.Double(x, y);
    }

    private void calcParams() {
        if (this.points.size() == 2) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            for (Point2D p : this.points) {
                if (p.getX() < minX) {
                    minX = p.getX();
                }
                if (p.getX() > maxX) {
                    maxX = p.getX();
                }
                if (p.getY() < minY) {
                    minY = p.getY();
                }
                if (!(p.getY() > maxY)) continue;
                maxY = p.getY();
            }
            this.bbox = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
        } else {
            this.bbox = BezierEdge.quadraticBBox(this.points.get(0), this.points.get(1), this.points.get(2));
        }
        this.hash = this.points.hashCode();
        this.revPoints = new ArrayList<Point2D>();
        for (int i = this.points.size() - 1; i >= 0; --i) {
            this.revPoints.add(this.points.get(i));
        }
        this.revHash = this.revPoints.hashCode();
        this.empty = true;
        Point2D p1 = this.getBeginPoint();
        for (int i = 1; i < this.points.size(); ++i) {
            if (this.points.get(i).equals(p1)) continue;
            this.empty = false;
            break;
        }
    }

    public Rectangle2D bbox() {
        return this.bbox;
    }

    public double area() {
        Rectangle2D rect = this.bbox();
        double w = rect.getWidth();
        double h = rect.getHeight();
        if (w < 0.5) {
            w = 0.5;
        }
        if (h < 0.5) {
            h = 0.5;
        }
        return w * h;
    }

    private static boolean rectIntersection(Rectangle2D r1, Rectangle2D r2) {
        double xmax2;
        double xmin = Math.max(r1.getX(), r2.getX());
        double xmax1 = r1.getX() + r1.getWidth();
        double xmax = Math.min(xmax1, xmax2 = r2.getX() + r2.getWidth());
        if (Double.compare(xmax, xmin) >= 0) {
            double ymax2;
            double ymin = Math.max(r1.getY(), r2.getY());
            double ymax1 = r1.getY() + r1.getHeight();
            double ymax = Math.min(ymax1, ymax2 = r2.getY() + r2.getHeight());
            if (Double.compare(ymax, ymin) >= 0) {
                return true;
            }
        }
        return false;
    }

    public List<Point2D> getIntersections(BezierEdge b2) {
        if (!Intersections.rectIntersection(this.bbox, b2.bbox)) {
            return new ArrayList<Point2D>();
        }
        if (this.points.size() == 2) {
            if (b2.points.size() == 2) {
                return Intersections.intersectLineLine(this.points.get(0), this.points.get(1), b2.points.get(0), b2.points.get(1), true);
            }
            return Intersections.intersectBezier2Line(b2.points.get(0), b2.points.get(1), b2.points.get(2), this.points.get(0), this.points.get(1));
        }
        if (b2.points.size() == 2) {
            return Intersections.intersectBezier2Line(this.points.get(0), this.points.get(1), this.points.get(2), b2.points.get(0), b2.points.get(1));
        }
        return Intersections.intersectBezier2Bezier2(this.points.get(0), this.points.get(1), this.points.get(2), b2.points.get(0), b2.points.get(1), b2.points.get(2));
    }

    public boolean intersectsOld(BezierEdge b2, List<Double> t1Ref, List<Double> t2Ref) {
        ArrayList<Point2D> interPoints = new ArrayList<Point2D>();
        ArrayList<Double> t1RefA = new ArrayList<Double>();
        ArrayList<Double> t2RefA = new ArrayList<Double>();
        boolean ret = this.intersects(b2, 0.0, 1.0, 0.0, 1.0, t1RefA, t2RefA, interPoints);
        Point2D last = new Point2D.Double(Double.MAX_VALUE, Double.MAX_VALUE);
        int numSame = 0;
        double sumT1 = 0.0;
        double sumT2 = 0.0;
        for (int i = 0; i < interPoints.size(); ++i) {
            double dist = ((Point2D)interPoints.get(i)).distance(last);
            System.err.println("dist=" + dist);
            if (dist <= 5.0) {
                ++numSame;
                sumT1 += ((Double)t1RefA.get(i)).doubleValue();
                sumT2 += ((Double)t2RefA.get(i)).doubleValue();
                last = (Point2D)interPoints.get(i);
                continue;
            }
            if (numSame > 0) {
                t1Ref.add(sumT1 / (double)numSame);
                t2Ref.add(sumT2 / (double)numSame);
            }
            numSame = 1;
            last = (Point2D)interPoints.get(i);
            sumT1 = (Double)t1RefA.get(i);
            sumT2 = (Double)t2RefA.get(i);
        }
        if (numSame > 0) {
            t1Ref.add(sumT1 / (double)numSame);
            t2Ref.add(sumT2 / (double)numSame);
        }
        return ret;
    }

    public boolean intersects(BezierEdge b2, List<Double> t1Ref, List<Double> t2Ref, List<Point2D> intPoints) {
        List<Point2D> inter = this.getIntersections(b2);
        BezierUtils utils = new BezierUtils();
        for (Point2D p : inter) {
            Point2D p1 = this.points.get(0);
            Point2D p3 = this.points.get(this.points.size() - 1);
            Point2D p2 = this.points.size() == 3 ? this.points.get(1) : new Point2D.Double((p1.getX() + p3.getX()) / 2.0, (p1.getY() + p3.getY()) / 2.0);
            t1Ref.add(utils.closestPointToBezier(p, p1, p2, p3));
            p1 = b2.points.get(0);
            p3 = b2.points.get(b2.points.size() - 1);
            p2 = b2.points.size() == 3 ? b2.points.get(1) : new Point2D.Double((p1.getX() + p3.getX()) / 2.0, (p1.getY() + p3.getY()) / 2.0);
            t2Ref.add(utils.closestPointToBezier(p, p1, p2, p3));
        }
        intPoints.addAll(inter);
        return !inter.isEmpty();
    }

    private boolean intersects(BezierEdge b2, double start1, double end1, double start2, double end2, List<Double> t1Ref, List<Double> t2Ref, List<Point2D> interPoints) {
        Rectangle2D bb2;
        double threshold = 1.0;
        Rectangle2D bb1 = this.bbox();
        if (!BezierEdge.rectIntersection(bb1, bb2 = b2.bbox())) {
            return false;
        }
        double sumAreas = this.area() + b2.area();
        if (Double.compare(sumAreas, 1.0) <= 0) {
            double t1 = (start1 + end1) / 2.0;
            double t2 = (start2 + end2) / 2.0;
            Point2D selPoint = this.getBeginPoint();
            interPoints.add(selPoint);
            t1Ref.add(t1);
            t2Ref.add(t2);
            return true;
        }
        BezierUtils bu = new BezierUtils();
        ArrayList<Point2D> b1aPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> b1bPoints = new ArrayList<Point2D>();
        bu.subdivide(this.points, 0.5, b1aPoints, b1bPoints);
        ArrayList<Point2D> b2aPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> b2bPoints = new ArrayList<Point2D>();
        bu.subdivide(b2.points, 0.5, b2aPoints, b2bPoints);
        BezierEdge b1a = new BezierEdge(b1aPoints);
        BezierEdge b1b = new BezierEdge(b1bPoints);
        BezierEdge b2a = new BezierEdge(b2aPoints);
        BezierEdge b2b = new BezierEdge(b2bPoints);
        double half1 = start1 + (end1 - start1) / 2.0;
        double half2 = start2 + (end2 - start2) / 2.0;
        boolean ok = false;
        if (b1a.intersects(b2a, start1, half1, start2, half2, t1Ref, t2Ref, interPoints)) {
            ok = true;
        }
        if (b1a.intersects(b2b, start1, half1, half2, end2, t1Ref, t2Ref, interPoints)) {
            ok = true;
        }
        if (b1b.intersects(b2a, half1, end1, start2, half2, t1Ref, t2Ref, interPoints)) {
            ok = true;
        }
        if (b1b.intersects(b2b, half1, end1, half2, end2, t1Ref, t2Ref, interPoints)) {
            ok = true;
        }
        return ok;
    }

    public double length() {
        double distance = 0.0;
        double epsilon = 1.0;
        Stack<BezierEdge> parts = new Stack<BezierEdge>();
        parts.push(this);
        while (!parts.isEmpty()) {
            BezierEdge curve = (BezierEdge)parts.pop();
            double d = curve.points.get(0).distance(curve.points.get(curve.points.size() - 1));
            if (d < epsilon) {
                distance += d;
                continue;
            }
            Reference<Object> leftRef = new Reference<Object>(null);
            Reference<Object> rightRef = new Reference<Object>(null);
            curve.split(0.5, leftRef, rightRef);
            parts.add(leftRef.getVal());
            parts.add(rightRef.getVal());
        }
        return distance;
    }

    public String toString() {
        ArrayList<String> list = new ArrayList<String>();
        for (Point2D p : this.points) {
            list.add("[" + p.getX() + "," + p.getY() + "]");
        }
        return "{" + String.join((CharSequence)"-", list) + "}";
    }

    public String toSvg() {
        DecimalFormat df = new DecimalFormat("0.###", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setGroupingUsed(false);
        String ret = "";
        ret = ret + "M ";
        ret = ret + df.format(this.points.get(0).getX());
        ret = ret + " ";
        ret = ret + df.format(this.points.get(0).getY());
        ret = ret + " ";
        ret = this.points.size() == 3 ? ret + "Q " : ret + "L ";
        ret = ret + df.format(this.points.get(1).getX());
        ret = ret + " ";
        ret = ret + df.format(this.points.get(1).getY());
        if (this.points.size() == 3) {
            ret = ret + " ";
            ret = ret + df.format(this.points.get(2).getX());
            ret = ret + " ";
            ret = ret + df.format(this.points.get(2).getY());
        }
        return ret;
    }

    public void split(double t, Reference<BezierEdge> left, Reference<BezierEdge> right) {
        ArrayList<Point2D> leftPoints = new ArrayList<Point2D>();
        ArrayList<Point2D> rightPoints = new ArrayList<Point2D>();
        BezierUtils bu = new BezierUtils();
        bu.subdivide(this.points, t, leftPoints, rightPoints);
        left.setVal(new BezierEdge(leftPoints));
        rightPoints.set(0, (Point2D)leftPoints.get(leftPoints.size() - 1));
        right.setVal(new BezierEdge(rightPoints));
    }

    public List<BezierEdge> split(List<Double> tList) {
        ArrayList<BezierEdge> result = new ArrayList<BezierEdge>();
        double prevT = 0.0;
        BezierEdge remaining = this;
        for (double t : tList) {
            double localT = (t - prevT) / (1.0 - prevT);
            Reference<Object> leftRef = new Reference<Object>(null);
            Reference<Object> rightRef = new Reference<Object>(null);
            remaining.split(localT, leftRef, rightRef);
            result.add(leftRef.getVal());
            remaining = rightRef.getVal();
            prevT = t;
        }
        result.add(remaining);
        return result;
    }

    public BezierEdge reverse() {
        return new BezierEdge(this.revPoints);
    }

    public void round() {
        for (int i = 0; i < this.points.size(); ++i) {
            this.points.set(i, new Point2D.Double(Math.round(this.points.get(i).getX()), Math.round(this.points.get(i).getY())));
        }
        this.calcParams();
    }

    public void roundHalf() {
        for (int i = 0; i < this.points.size(); ++i) {
            this.points.set(i, new Point2D.Double((double)Math.round(this.points.get(i).getX() * 2.0) / 2.0, (double)Math.round(this.points.get(i).getY() * 2.0) / 2.0));
        }
        this.calcParams();
    }

    public void roundX() {
        for (int i = 0; i < this.points.size(); ++i) {
            this.points.set(i, new Point2D.Double((double)Math.round(this.points.get(i).getX() * 2.0) / 2.0, (double)Math.round(this.points.get(i).getY() * 2.0) / 2.0));
        }
        this.calcParams();
    }

    public void roundN(double n) {
        for (int i = 0; i < this.points.size(); ++i) {
            this.points.set(i, new Point2D.Double((double)Math.round(this.points.get(i).getX() * n) / n, (double)Math.round(this.points.get(i).getY() * n) / n));
        }
        this.calcParams();
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BezierEdge other = (BezierEdge)obj;
        if (other.hash != this.hash) {
            return false;
        }
        return Objects.equals(this.points, other.points);
    }

    public boolean equalsReverse(BezierEdge other) {
        if (this.hash != other.revHash) {
            return false;
        }
        if (other.points.size() != this.points.size()) {
            return false;
        }
        for (int i = 0; i < this.points.size(); ++i) {
            if (this.points.get(i).equals(other.points.get(this.points.size() - 1 - i))) continue;
            return false;
        }
        return true;
    }

    public void shrinkToLine() {
        double det;
        if (this.points.size() == 3 && (det = (this.points.get(1).getX() - this.points.get(0).getX()) * (this.points.get(2).getY() - this.points.get(0).getY()) - (this.points.get(1).getY() - this.points.get(0).getY()) * (this.points.get(2).getX() - this.points.get(0).getX())) == 0.0) {
            this.points.remove(1);
            this.revPoints.remove(1);
            this.calcParams();
        }
    }

    public Double findXCriticalT() {
        double EPS = 1.0E-12;
        if (this.points.size() < 3) {
            return null;
        }
        double a = this.points.get(2).getX() - 2.0 * this.points.get(1).getX() + this.points.get(0).getX();
        double b = this.points.get(1).getX() - this.points.get(0).getX();
        if (Math.abs(a) < EPS) {
            return null;
        }
        double t = -b / a;
        if (t > EPS && t < 1.0 - EPS) {
            return t;
        }
        return null;
    }

    private static double quad(double p0, double p1, double p2, double t) {
        double u = 1.0 - t;
        return u * u * p0 + 2.0 * u * t * p1 + t * t * p2;
    }

    public double yAt(double x) {
        double t;
        double EPS = 1.0E-12;
        if (this.points.size() == 2) {
            double x0 = this.points.get(0).getX();
            double y0 = this.points.get(0).getY();
            double x1 = this.points.get(1).getX();
            double y1 = this.points.get(1).getY();
            double dx = x1 - x0;
            if (Math.abs(dx) < EPS) {
                return (y0 + y1) * 0.5;
            }
            double t2 = (x - x0) / dx;
            if (t2 < 0.0) {
                t2 = 0.0;
            } else if (t2 > 1.0) {
                t2 = 1.0;
            }
            return y0 + t2 * (y1 - y0);
        }
        double A = this.points.get(0).getX() - 2.0 * this.points.get(1).getX() + this.points.get(2).getX();
        double B = 2.0 * (this.points.get(1).getX() - this.points.get(0).getX());
        double C = this.points.get(0).getX() - x;
        if (Math.abs(A) < EPS) {
            t = Math.abs(B) < EPS ? 0.5 : -C / B;
        } else {
            double disc = B * B - 4.0 * A * C;
            if (disc < 0.0 && disc > -1.0E-14) {
                disc = 0.0;
            }
            if (disc < 0.0) {
                t = 0.5;
            } else {
                boolean t2In;
                double sqrtD = Math.sqrt(disc);
                double q = -0.5 * (B + Math.copySign(sqrtD, B));
                double t1 = q / A;
                double t2 = Math.abs(q) < EPS ? t1 : C / q;
                boolean t1In = t1 > -1.0E-9 && t1 < 1.000000001;
                boolean bl = t2In = t2 > -1.0E-9 && t2 < 1.000000001;
                if (t1In && !t2In) {
                    t = t1;
                } else if (!t1In && t2In) {
                    t = t2;
                } else if (t1In && t2In) {
                    t = Math.abs(t1 - 0.5) < Math.abs(t2 - 0.5) ? t1 : t2;
                } else {
                    double c1 = Math.min(Math.max(t1, 0.0), 1.0);
                    double c2 = Math.min(Math.max(t2, 0.0), 1.0);
                    double x1 = BezierEdge.quad(this.points.get(0).getX(), this.points.get(1).getX(), this.points.get(2).getX(), c1);
                    double x2 = BezierEdge.quad(this.points.get(0).getX(), this.points.get(1).getX(), this.points.get(2).getX(), c2);
                    double d = t = Math.abs(x1 - x) <= Math.abs(x2 - x) ? c1 : c2;
                }
            }
        }
        if (t < 0.0) {
            t = 0.0;
        } else if (t > 1.0) {
            t = 1.0;
        }
        return BezierEdge.quad(this.points.get(0).getY(), this.points.get(1).getY(), this.points.get(2).getY(), t);
    }

    private static Point2D.Double evalQuad(Point2D p0, Point2D p1, Point2D p2, double t) {
        double u = 1.0 - t;
        double x = u * u * p0.getX() + 2.0 * u * t * p1.getX() + t * t * p2.getX();
        double y = u * u * p0.getY() + 2.0 * u * t * p1.getY() + t * t * p2.getY();
        return new Point2D.Double(x, y);
    }

    public static Rectangle2D quadraticBBox(Point2D p0, Point2D p1, Point2D p2) {
        double ty;
        double tx;
        ArrayList<Double> candidates = new ArrayList<Double>();
        candidates.add(0.0);
        candidates.add(1.0);
        double denomX = p0.getX() - 2.0 * p1.getX() + p2.getX();
        double denomY = p0.getY() - 2.0 * p1.getY() + p2.getY();
        double EPS = 1.0E-12;
        if (Math.abs(denomX) > 1.0E-12 && (tx = (p0.getX() - p1.getX()) / denomX) > 0.0 && tx < 1.0) {
            candidates.add(tx);
        }
        if (Math.abs(denomY) > 1.0E-12 && (ty = (p0.getY() - p1.getY()) / denomY) > 0.0 && ty < 1.0) {
            candidates.add(ty);
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        Iterator iterator = candidates.iterator();
        while (iterator.hasNext()) {
            double t = (Double)iterator.next();
            double tt = Math.max(0.0, Math.min(1.0, t));
            Point2D.Double pt = BezierEdge.evalQuad(p0, p1, p2, tt);
            double x = pt.x;
            double y = pt.y;
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }
}

