/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.simpleparser;

import com.jpexs.decompiler.flash.simpleparser.ClassTrait;
import com.jpexs.decompiler.flash.simpleparser.FunctionScope;
import com.jpexs.decompiler.flash.simpleparser.LinkHandler;
import com.jpexs.decompiler.flash.simpleparser.MethodScope;
import com.jpexs.decompiler.flash.simpleparser.Path;
import com.jpexs.decompiler.flash.simpleparser.Scope;
import com.jpexs.decompiler.flash.simpleparser.Separator;
import com.jpexs.decompiler.flash.simpleparser.SimpleParseException;
import com.jpexs.decompiler.flash.simpleparser.TraitVarConstValueScope;
import com.jpexs.decompiler.flash.simpleparser.Type;
import com.jpexs.decompiler.flash.simpleparser.Variable;
import com.jpexs.decompiler.flash.simpleparser.VariableOrScope;
import com.jpexs.decompiler.flash.simpleparser.VariableOrScopeWithAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SimpleParser {
    public void parse(String var1, Map<Integer, List<Integer>> var2, Map<Integer, Integer> var3, List<SimpleParseException> var4, List<Path> var5, Map<Integer, Integer> var6, Map<Integer, List<Integer>> var7, LinkHandler var8, Map<Integer, Path> var9, Map<Path, List<Integer>> var10, Map<Integer, Path> var11, Map<Integer, Boolean> var12, Map<Path, List<Variable>> var13, Map<Integer, Path> var14, Map<Integer, Path> var15, Integer var16, List<Variable> var17) throws SimpleParseException, IOException, InterruptedException;

    public static void fillSuggestionsOne(List<Variable> variableSuggestions, Map<Path, Integer> varNameToDefinition, Map<Integer, Boolean> positionToStatic, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Map<Integer, Variable> definitionToSubType, Map<Integer, Variable> definitionToCallSubType, Set<String> used) {
        for (Path p : varNameToDefinition.keySet()) {
            int definition = varNameToDefinition.get(p);
            if (definition < 0 || used.contains(p.getLast().toString())) continue;
            used.add(p.getLast().toString());
            Path type = definitionToType.get(definition);
            Path callType = definitionToCallType.get(definition);
            Variable subType = definitionToSubType.get(definition);
            Variable callSubType = definitionToCallSubType.get(definition);
            Boolean isStatic = positionToStatic.get(definition);
            variableSuggestions.add(new Variable(true, p, definition, isStatic, type, callType, subType, callSubType));
        }
    }

    public static void fillSuggestions(List<Variable> variableSuggestions, Map<Path, Integer> varNameToDefinition1, Map<Path, Integer> varNameToDefinition2, Map<Integer, Boolean> positionToStatic, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Map<Integer, Variable> definitionToSubType, Map<Integer, Variable> definitionToCallSubType) {
        HashSet<String> used = new HashSet<String>();
        if (varNameToDefinition1 != null) {
            SimpleParser.fillSuggestionsOne(variableSuggestions, varNameToDefinition1, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, used);
        }
        if (varNameToDefinition2 != null) {
            SimpleParser.fillSuggestionsOne(variableSuggestions, varNameToDefinition2, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, used);
        }
        variableSuggestions.add(new Variable(true, new Path("--finish--"), 0));
    }

    public static void parseVariablesList(List<VariableOrScope> sharedVariables, Map<Integer, List<Integer>> definitionPosToReferences, Map<Integer, Integer> referenceToDefinition, List<SimpleParseException> errors, boolean innerFunctionCanUseTraits, List<Path> externalTypes, Map<Integer, Integer> referenceToExternalTypeIndex, Map<Integer, List<Integer>> externalTypeIndexToReference, LinkHandler linkHandler, Map<Integer, Path> referenceToExternalTraitKey, Map<Path, List<Integer>> externalTraitKeyToReference, Map<Integer, Path> separatorPosToType, Map<Integer, Boolean> separatorIsStatic, Map<Path, List<Variable>> localTypeTraits, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Integer caretPosition, List<Variable> variableSuggestions) {
        ArrayList<Path> externalSimpleTypes = new ArrayList<Path>();
        LinkedHashMap<Path, Path> simpleExternalClassNameToFullClassName = new LinkedHashMap<Path, Path>();
        for (Path type : externalTypes) {
            externalSimpleTypes.add(type.getLast());
            simpleExternalClassNameToFullClassName.put(type.getLast(), type);
        }
        LinkedHashMap<Integer, Variable> definitionToSubType = new LinkedHashMap<Integer, Variable>();
        LinkedHashMap<Integer, Variable> definitionToCallSubType = new LinkedHashMap<Integer, Variable>();
        LinkedHashMap<Path, Integer> traitFullNameToDefinition = new LinkedHashMap<Path, Integer>();
        ArrayList<VariableOrScopeWithAccess> variables = new ArrayList<VariableOrScopeWithAccess>();
        for (VariableOrScope vs : sharedVariables) {
            variables.add(new VariableOrScopeWithAccess(vs, true));
        }
        LinkedHashMap<Integer, Boolean> positionToStatic = new LinkedHashMap<Integer, Boolean>();
        LinkedHashMap<Path, Integer> parentVarFullNameToDefinitionPosition = new LinkedHashMap<Path, Integer>();
        LinkedHashMap<Path, Integer> parentVarNameToDefinitionPosition = new LinkedHashMap<Path, Integer>();
        SimpleParser.findClassTraits(variables, traitFullNameToDefinition, definitionPosToReferences, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, parentVarFullNameToDefinitionPosition, parentVarNameToDefinitionPosition);
        for (Path path : traitFullNameToDefinition.keySet()) {
            int definition = (Integer)traitFullNameToDefinition.get(path);
            boolean isStatic = false;
            if (positionToStatic.containsKey(definition) && ((Boolean)positionToStatic.get(definition)).booleanValue()) {
                isStatic = true;
            }
            Path traitType = definitionToType.get(definition);
            Path traitCallType = definitionToCallType.get(definition);
            Variable traitSubType = (Variable)definitionToSubType.get(definition);
            Variable traitCallSubType = (Variable)definitionToCallSubType.get(definition);
            Path cls = path.getParent();
            String traitName = path.getLast().toString();
            if (!localTypeTraits.containsKey(cls)) {
                localTypeTraits.put(cls, new ArrayList());
            }
            localTypeTraits.get(cls).add(new Variable(true, path.getLast(), definition, isStatic, traitType, traitCallType, traitSubType, traitCallSubType));
        }
        SimpleParser.parseVariablesList(variables, definitionPosToReferences, referenceToDefinition, parentVarFullNameToDefinitionPosition, parentVarNameToDefinitionPosition, positionToStatic, true, errors, null, innerFunctionCanUseTraits, externalSimpleTypes, externalTypes, referenceToExternalTypeIndex, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, traitFullNameToDefinition, linkHandler, simpleExternalClassNameToFullClassName, referenceToExternalTraitKey, externalTraitKeyToReference, separatorPosToType, separatorIsStatic, caretPosition, variableSuggestions, null, null);
        for (Map.Entry entry : referenceToExternalTypeIndex.entrySet()) {
            if (!externalTypeIndexToReference.containsKey(entry.getValue())) {
                externalTypeIndexToReference.put((Integer)entry.getValue(), new ArrayList());
            }
            externalTypeIndexToReference.get(entry.getValue()).add((Integer)entry.getKey());
        }
        if (caretPosition != null && variableSuggestions.isEmpty() && (variables.isEmpty() || ((VariableOrScopeWithAccess)variables.get((int)(variables.size() - 1))).var.getPosition() <= caretPosition)) {
            SimpleParser.fillSuggestions(variableSuggestions, parentVarNameToDefinitionPosition, null, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType);
        }
        if (!variableSuggestions.isEmpty()) {
            variableSuggestions.remove(variableSuggestions.size() - 1);
        }
    }

    public static void parseVariablesList(List<VariableOrScopeWithAccess> variables, Map<Integer, List<Integer>> definitionPosToReferences, Map<Integer, Integer> referenceToDefinition, Map<Path, Integer> parentVarFullNameToDefinitionPosition, Map<Path, Integer> parentVarNameToDefinitionPosition, Map<Integer, Boolean> positionToStatic, boolean isStatic, List<SimpleParseException> errors, Scope scope, boolean innerFunctionCanUseTraits, List<Path> externalSimpleTypes, List<Path> externalFullTypes, Map<Integer, Integer> referenceToExternalTypeIndex, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Map<Integer, Variable> definitionToSubType, Map<Integer, Variable> definitionToCallSubType, Map<Path, Integer> traitFullNameToDefinition, LinkHandler linkHandler, Map<Path, Path> simpleExternalClassNameToFullClassName, Map<Integer, Path> referenceToExternalTraitKey, Map<Path, List<Integer>> externalTraitKeyToReference, Map<Integer, Path> separatorPosToType, Map<Integer, Boolean> separatorIsStatic, Integer caretPosition, List<Variable> variableSuggestions, Integer scopeStartPos, Integer scopeEndPos) {
        LinkedHashMap<Path, Integer> privateVarNameToDefinitionPosition = new LinkedHashMap<Path, Integer>();
        privateVarNameToDefinitionPosition.putAll(parentVarNameToDefinitionPosition);
        LinkedHashMap<Path, Integer> privateVarFullNameToDefinitionPosition = new LinkedHashMap<Path, Integer>();
        privateVarFullNameToDefinitionPosition.putAll(parentVarFullNameToDefinitionPosition);
        for (int i = 0; i < variables.size(); ++i) {
            VariableOrScope vt2;
            VariableOrScopeWithAccess vsa = variables.get(i);
            VariableOrScope vt = variables.get((int)i).var;
            VariableOrScope variableOrScope = vt2 = i + 1 < variables.size() ? variables.get((int)(i + 1)).var : null;
            if (i == 0 && scopeStartPos != null && caretPosition != null && caretPosition >= scopeStartPos && vt.getPosition() > caretPosition && variableSuggestions.isEmpty()) {
                SimpleParser.fillSuggestions(variableSuggestions, parentVarNameToDefinitionPosition, privateVarNameToDefinitionPosition, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType);
            }
            if (vt instanceof Separator) {
                Separator s = (Separator)vt;
                SimpleParser.searchTrait(s.parentName, s.position, true, separatorPosToType, separatorIsStatic, privateVarFullNameToDefinitionPosition, privateVarNameToDefinitionPosition, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, traitFullNameToDefinition, definitionPosToReferences, referenceToDefinition, linkHandler, simpleExternalClassNameToFullClassName, referenceToExternalTraitKey, externalTraitKeyToReference);
            }
            if (vt instanceof Variable) {
                Variable v = (Variable)vt;
                if (v.definition) {
                    if (vsa.shared) {
                        parentVarFullNameToDefinitionPosition.put(v.name, v.position);
                        parentVarNameToDefinitionPosition.put(v.getLastName(), v.position);
                    }
                    privateVarFullNameToDefinitionPosition.put(v.name, v.position);
                    privateVarNameToDefinitionPosition.put(v.getLastName(), v.position);
                    if (!definitionPosToReferences.containsKey(v.position)) {
                        definitionPosToReferences.put(v.position, new ArrayList());
                    }
                    positionToStatic.put(v.position, v.isStatic != null ? v.isStatic : isStatic);
                    if (v.type != null) {
                        definitionToType.put(v.position, v.type);
                    }
                    if (v.subType != null) {
                        definitionToSubType.put(v.position, v.subType);
                    }
                } else if (!privateVarFullNameToDefinitionPosition.containsKey(v.name) && !privateVarNameToDefinitionPosition.containsKey(v.name)) {
                    if (externalFullTypes.contains(v.name)) {
                        referenceToExternalTypeIndex.put(v.position, externalFullTypes.indexOf(v.name));
                    } else if (externalSimpleTypes.contains(v.name)) {
                        referenceToExternalTypeIndex.put(v.position, externalSimpleTypes.indexOf(v.name));
                    } else {
                        boolean traitFound = SimpleParser.searchTrait(v.name, v.position, false, separatorPosToType, separatorIsStatic, privateVarFullNameToDefinitionPosition, privateVarNameToDefinitionPosition, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, traitFullNameToDefinition, definitionPosToReferences, referenceToDefinition, linkHandler, simpleExternalClassNameToFullClassName, referenceToExternalTraitKey, externalTraitKeyToReference);
                        if (!traitFound) {
                            if (vsa.shared) {
                                parentVarFullNameToDefinitionPosition.put(v.name, -v.position - 1);
                                parentVarNameToDefinitionPosition.put(v.getLastName(), -v.position - 1);
                            }
                            privateVarFullNameToDefinitionPosition.put(v.name, -v.position - 1);
                            privateVarNameToDefinitionPosition.put(v.getLastName(), -v.position - 1);
                            definitionPosToReferences.put(-v.position - 1, new ArrayList());
                            definitionPosToReferences.get(-v.position - 1).add(v.position);
                            referenceToDefinition.put(v.position, -v.position - 1);
                        }
                    }
                } else if ("this".equals(v.name) && isStatic) {
                    errors.add(new SimpleParseException("Cannot use this in static context", -1L, v.position));
                } else {
                    boolean staticDefinition;
                    int definitionPos = privateVarFullNameToDefinitionPosition.containsKey(v.name) ? ((Integer)privateVarFullNameToDefinitionPosition.get(v.name)).intValue() : ((Integer)privateVarNameToDefinitionPosition.get(v.name)).intValue();
                    boolean bl = staticDefinition = definitionPos >= 0 ? positionToStatic.get(definitionPos) : true;
                    if (staticDefinition || !isStatic) {
                        definitionPosToReferences.get(definitionPos).add(v.position);
                        referenceToDefinition.put(v.position, definitionPos);
                    }
                }
            }
            if (vt instanceof Scope) {
                Scope vs = (Scope)vt;
                boolean subStatic = isStatic;
                if (vs instanceof FunctionScope) {
                    subStatic = ((FunctionScope)vs).isStatic();
                }
                if (vs instanceof TraitVarConstValueScope) {
                    subStatic = ((TraitVarConstValueScope)vs).isStatic();
                }
                LinkedHashMap<Path, Integer> subPrivateVarFullNameToDefinitionPosition = privateVarFullNameToDefinitionPosition;
                LinkedHashMap<Path, Integer> subPrivateVarNameToDefinitionPosition = privateVarNameToDefinitionPosition;
                if (vs instanceof FunctionScope && !(vs instanceof MethodScope)) {
                    subPrivateVarFullNameToDefinitionPosition = new LinkedHashMap<Path, Integer>(subPrivateVarFullNameToDefinitionPosition);
                    subPrivateVarNameToDefinitionPosition = new LinkedHashMap<Path, Integer>(subPrivateVarNameToDefinitionPosition);
                    HashSet keys = new HashSet(subPrivateVarFullNameToDefinitionPosition.keySet());
                    for (Path vName : keys) {
                        if (!vName.toString().equals("this") && !vName.getFirst().toString().equals("this")) continue;
                        subPrivateVarFullNameToDefinitionPosition.remove(vName);
                        if (vName.toString().equals("this")) {
                            subPrivateVarNameToDefinitionPosition.remove(new Path("this"));
                        }
                        if (innerFunctionCanUseTraits) continue;
                        subPrivateVarNameToDefinitionPosition.remove(vName.getLast());
                    }
                }
                SimpleParser.parseVariablesList(vs.getScopeItems(), definitionPosToReferences, referenceToDefinition, privateVarFullNameToDefinitionPosition, privateVarNameToDefinitionPosition, positionToStatic, subStatic, errors, vs, innerFunctionCanUseTraits, externalSimpleTypes, externalFullTypes, referenceToExternalTypeIndex, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, traitFullNameToDefinition, linkHandler, simpleExternalClassNameToFullClassName, referenceToExternalTraitKey, externalTraitKeyToReference, separatorPosToType, separatorIsStatic, caretPosition, variableSuggestions, vs.getPosition(), vs.getEndPosition());
            }
            if (vt2 == null || caretPosition == null || !variableSuggestions.isEmpty() || vt.getPosition() > caretPosition || vt2.getPosition() <= caretPosition || !(vt instanceof Variable)) continue;
            SimpleParser.fillSuggestions(variableSuggestions, parentVarNameToDefinitionPosition, privateVarNameToDefinitionPosition, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType);
        }
        if (caretPosition != null && variableSuggestions.isEmpty() && scopeEndPos != null && scopeEndPos > caretPosition) {
            SimpleParser.fillSuggestions(variableSuggestions, parentVarNameToDefinitionPosition, privateVarNameToDefinitionPosition, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType);
        }
    }

    public static void findClassTraits(List<VariableOrScopeWithAccess> variables, Map<Path, Integer> traitFullNameToDefinition, Map<Integer, List<Integer>> definitionPosToReferences, Map<Integer, Boolean> positionToStatic, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Map<Integer, Variable> definitionToSubType, Map<Integer, Variable> definitionToCallSubType, Map<Path, Integer> parentVarFullNameToDefinitionPosition, Map<Path, Integer> parentVarNameToDefinitionPosition) {
        for (VariableOrScopeWithAccess vsa : variables) {
            VariableOrScope v = vsa.var;
            if (v instanceof Type) {
                Type t = (Type)v;
                if (t.definition) {
                    definitionToType.put(t.position, t.name);
                }
            }
            if (v instanceof ClassTrait) {
                ClassTrait ct = (ClassTrait)v;
                definitionPosToReferences.put(ct.position, new ArrayList());
                positionToStatic.put(ct.position, ct.isStatic);
                if (ct.type != null) {
                    definitionToType.put(ct.position, ct.type);
                }
                if (ct.callType != null) {
                    definitionToCallType.put(ct.position, ct.callType);
                }
                if (ct.subType != null) {
                    definitionToSubType.put(ct.position, ct.subType);
                }
                if (ct.callSubType != null) {
                    definitionToCallSubType.put(ct.position, ct.callSubType);
                }
                traitFullNameToDefinition.put(ct.getFullIdentifier(), ((ClassTrait)v).position);
                parentVarFullNameToDefinitionPosition.put(ct.name, ct.position);
                parentVarNameToDefinitionPosition.put(ct.getLastName(), ct.position);
            }
            if (!(v instanceof Scope)) continue;
            Scope s = (Scope)v;
            SimpleParser.findClassTraits(s.getScopeItems(), traitFullNameToDefinition, definitionPosToReferences, positionToStatic, definitionToType, definitionToCallType, definitionToSubType, definitionToCallSubType, parentVarFullNameToDefinitionPosition, parentVarNameToDefinitionPosition);
        }
    }

    public static boolean searchTrait(Path vName, int vPosition, boolean separator, Map<Integer, Path> separatorPosToType, Map<Integer, Boolean> separatorIsStatic, Map<Path, Integer> privateVarFullNameToDefinitionPosition, Map<Path, Integer> privateVarNameToDefinitionPosition, Map<Integer, Path> definitionToType, Map<Integer, Path> definitionToCallType, Map<Integer, Variable> definitionToSubType, Map<Integer, Variable> definitionToCallSubType, Map<Path, Integer> traitFullNameToDefinition, Map<Integer, List<Integer>> definitionPosToReferences, Map<Integer, Integer> referenceToDefinition, LinkHandler linkHandler, Map<Path, Path> simpleExternalClassNameToFullClassName, Map<Integer, Path> referenceToExternalTraitKey, Map<Path, List<Integer>> externalTraitKeyToReference) {
        boolean traitFound = false;
        if (vName.hasParent()) {
            Path parts = vName;
            Integer definitionPos = null;
            Path firstName = vName.getFirst();
            if (privateVarFullNameToDefinitionPosition.containsKey(firstName)) {
                definitionPos = privateVarFullNameToDefinitionPosition.get(firstName);
            } else if (privateVarNameToDefinitionPosition.containsKey(firstName)) {
                definitionPos = privateVarNameToDefinitionPosition.get(firstName);
            }
            Path type = null;
            boolean isStatic = false;
            if (definitionPos != null) {
                if (definitionToType.containsKey(definitionPos) && (type = definitionToType.get(definitionPos)).getLast().equals(firstName)) {
                    isStatic = true;
                }
            } else if (simpleExternalClassNameToFullClassName.containsKey(firstName)) {
                type = simpleExternalClassNameToFullClassName.get(firstName);
                isStatic = true;
            }
            if (type != null) {
                traitFound = true;
                Variable lastSubType = null;
                Path traitKey = null;
                Path externalCallType = null;
                ArrayList externalSubTypes = new ArrayList();
                ArrayList<Path> externalCallSubTypes = new ArrayList<Path>();
                Path part = null;
                for (int p = 1; p < parts.size(); ++p) {
                    part = parts.get(p);
                    if (part.equals(Path.PATH_PARENTHESIS)) {
                        if (parts.get(p - 1).equals(Path.PATH_BRACKETS)) {
                            traitFound = false;
                            break;
                        }
                        if (definitionPos == null) {
                            type = externalCallType;
                            externalSubTypes.clear();
                            externalSubTypes.addAll(externalCallSubTypes);
                        } else {
                            type = definitionToCallType.get(definitionPos);
                        }
                        lastSubType = null;
                        continue;
                    }
                    if (part.equals(Path.PATH_BRACKETS)) {
                        if (definitionPos != null) {
                            if ((lastSubType = lastSubType != null ? lastSubType.subType : (parts.get(p - 1).toString().equals("()") ? definitionToCallSubType.get(definitionPos) : definitionToSubType.get(definitionPos))) == null) {
                                traitFound = false;
                                break;
                            }
                            type = lastSubType.name;
                            continue;
                        }
                        if (externalSubTypes.isEmpty()) {
                            traitFound = false;
                            break;
                        }
                        type = (Path)externalSubTypes.remove(0);
                        continue;
                    }
                    if (type == null) break;
                    traitKey = type.add(part);
                    if (!traitFullNameToDefinition.containsKey(traitKey)) {
                        Path st;
                        if (simpleExternalClassNameToFullClassName.containsKey(type)) {
                            type = simpleExternalClassNameToFullClassName.get(type);
                        }
                        traitKey = type.add(part);
                        Path newType = linkHandler.getTraitType(type, part.toString());
                        if (newType == null) {
                            traitFound = false;
                            break;
                        }
                        externalSubTypes.clear();
                        int i = 1;
                        while ((st = linkHandler.getTraitSubType(type, part.toString(), i)) != null) {
                            externalSubTypes.add(st);
                            ++i;
                        }
                        externalCallType = linkHandler.getTraitCallType(type, part.toString());
                        externalCallSubTypes.clear();
                        i = 1;
                        while ((st = linkHandler.getTraitCallSubType(type, part.toString(), i)) != null) {
                            externalCallSubTypes.add(st);
                            ++i;
                        }
                        type = newType;
                        definitionPos = null;
                        lastSubType = null;
                        continue;
                    }
                    externalCallSubTypes.clear();
                    externalSubTypes.clear();
                    externalCallType = null;
                    definitionPos = traitFullNameToDefinition.get(traitKey);
                    type = definitionToType.get(definitionPos);
                    lastSubType = null;
                }
                if (traitFound) {
                    if (definitionPos != null) {
                        definitionPosToReferences.get(definitionPos).add(vPosition);
                        referenceToDefinition.put(vPosition, definitionPos);
                    } else if (part != null) {
                        if (!externalTraitKeyToReference.containsKey(traitKey)) {
                            externalTraitKeyToReference.put(traitKey, new ArrayList());
                        }
                        externalTraitKeyToReference.get(traitKey).add(vPosition);
                        referenceToExternalTraitKey.put(vPosition, traitKey);
                    }
                    if (separator) {
                        separatorPosToType.put(vPosition, type);
                        separatorIsStatic.put(vPosition, isStatic);
                    }
                }
            }
        } else if (separator) {
            Integer definitionPos = null;
            Path firstName = vName.getFirst();
            if (privateVarFullNameToDefinitionPosition.containsKey(firstName)) {
                definitionPos = privateVarFullNameToDefinitionPosition.get(firstName);
            } else if (privateVarNameToDefinitionPosition.containsKey(firstName)) {
                definitionPos = privateVarNameToDefinitionPosition.get(firstName);
            }
            Path type = null;
            boolean isStatic = false;
            if (definitionPos != null) {
                if (definitionToType.containsKey(definitionPos) && (type = definitionToType.get(definitionPos)).getLast().equals(firstName)) {
                    isStatic = true;
                }
            } else if (simpleExternalClassNameToFullClassName.containsKey(firstName)) {
                type = simpleExternalClassNameToFullClassName.get(firstName);
                isStatic = true;
            }
            if (type != null) {
                if (definitionPos != null) {
                    definitionPosToReferences.get(definitionPos).add(vPosition);
                    referenceToDefinition.put(vPosition, definitionPos);
                }
                separatorPosToType.put(vPosition, type);
                separatorIsStatic.put(vPosition, isStatic);
            }
        }
        return traitFound;
    }
}

