/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.BITMAPDATA;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.COLORMAPDATA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=2)
public class DefineBitsLosslessTag
extends ImageTag
implements AloneTag {
    public static final int ID = 20;
    public static final String NAME = "DefineBitsLossless";
    @SWFType(value=BasicType.UI8)
    @EnumValues(value={@EnumValue(value=3, text="8-bit colormapped"), @EnumValue(value=4, text="15-bit RGB"), @EnumValue(value=5, text="24-bit RGB")})
    public int bitmapFormat;
    @SWFType(value=BasicType.UI16)
    public int bitmapWidth;
    @SWFType(value=BasicType.UI16)
    public int bitmapHeight;
    @SWFType(value=BasicType.UI8)
    @Conditional(value={"bitmapFormat"}, options={3})
    public int bitmapColorTableSize;
    public ByteArrayRange zlibBitmapData;
    public static final int FORMAT_8BIT_COLORMAPPED = 3;
    public static final int FORMAT_15BIT_RGB = 4;
    public static final int FORMAT_24BIT_RGB = 5;
    @HideInRawEdit
    private COLORMAPDATA colorMapData;
    @HideInRawEdit
    private BITMAPDATA bitmapData;
    @Internal
    private boolean decompressed = false;

    public DefineBitsLosslessTag(SWF swf) {
        this(swf, null, swf.getNextCharacterId());
    }

    public DefineBitsLosslessTag(SWF swf, ByteArrayRange data, int characterID) {
        super(swf, 20, NAME, data);
        this.characterID = characterID;
        this.bitmapFormat = 5;
        this.bitmapWidth = 1;
        this.bitmapHeight = 1;
        this.zlibBitmapData = new ByteArrayRange(this.createEmptyImage());
        this.forceWriteAsLong = true;
    }

    public DefineBitsLosslessTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 20, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.bitmapFormat = sis.readUI8("bitmapFormat");
        this.bitmapWidth = sis.readUI16("bitmapWidth");
        this.bitmapHeight = sis.readUI16("bitmapHeight");
        if (this.bitmapFormat == 3) {
            this.bitmapColorTableSize = sis.readUI8("bitmapColorTableSize");
        }
        this.zlibBitmapData = sis.readByteRangeEx(sis.available(), "zlibBitmapData", DumpInfoSpecialType.ZLIB_DATA, null);
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI8(this.bitmapFormat);
        sos.writeUI16(this.bitmapWidth);
        sos.writeUI16(this.bitmapHeight);
        if (this.bitmapFormat == 3) {
            sos.writeUI8(this.bitmapColorTableSize);
        }
        sos.write(this.zlibBitmapData);
    }

    private byte[] createEmptyImage() {
        try {
            BITMAPDATA bitmapData = new BITMAPDATA();
            bitmapData.bitmapPixelDataPix24 = new int[]{-16777216};
            ByteArrayOutputStream bitmapDataOS = new ByteArrayOutputStream();
            SWFOutputStream sos = new SWFOutputStream(bitmapDataOS, this.getVersion(), this.getCharset());
            sos.writeBITMAPDATA(bitmapData, 5, 1, 1);
            ByteArrayOutputStream zlibOS = new ByteArrayOutputStream();
            SWFOutputStream sos2 = new SWFOutputStream(zlibOS, this.getVersion(), this.getCharset());
            sos2.writeBytesZlib(bitmapDataOS.toByteArray());
            return zlibOS.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsLosslessTag.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        SerializableImage image = new SerializableImage(ImageHelper.read(data));
        int width = image.getWidth();
        int height = image.getHeight();
        this.bitmapData = new BITMAPDATA();
        this.bitmapData.bitmapPixelDataPix24 = new int[width * height];
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < pixels.length; ++pos) {
            int argb;
            this.bitmapData.bitmapPixelDataPix24[pos] = argb = pixels[pos] | 0xFF000000;
        }
        int format = 5;
        ByteArrayOutputStream bitmapDataOS = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(bitmapDataOS, this.getVersion(), this.getCharset());
        sos.writeBITMAPDATA(this.bitmapData, format, width, height);
        ByteArrayOutputStream zlibOS = new ByteArrayOutputStream();
        SWFOutputStream sos2 = new SWFOutputStream(zlibOS, this.getVersion(), this.getCharset());
        sos2.writeBytesZlib(bitmapDataOS.toByteArray());
        this.zlibBitmapData = new ByteArrayRange(zlibOS.toByteArray());
        this.bitmapFormat = format;
        this.bitmapWidth = width;
        this.bitmapHeight = height;
        this.decompressed = false;
        this.clearCache();
        this.setModified(true);
    }

    public COLORMAPDATA getColorMapData() {
        if (!this.decompressed) {
            this.uncompressData();
        }
        return this.colorMapData;
    }

    public BITMAPDATA getBitmapData() {
        if (!this.decompressed) {
            this.uncompressData();
        }
        return this.bitmapData;
    }

    private void uncompressData() {
        try {
            byte[] uncompressedData = SWFInputStream.uncompressByteArray(this.zlibBitmapData.getArray(), this.zlibBitmapData.getPos(), this.zlibBitmapData.getLength());
            SWFInputStream sis = new SWFInputStream(this.swf, uncompressedData);
            if (this.bitmapFormat == 3) {
                this.colorMapData = sis.readCOLORMAPDATA(this.bitmapColorTableSize, this.bitmapWidth, this.bitmapHeight, "colorMapData");
            } else if (this.bitmapFormat == 4 || this.bitmapFormat == 5) {
                this.bitmapData = sis.readBITMAPDATA(this.bitmapFormat, this.bitmapWidth, this.bitmapHeight, "bitmapData");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decompressed = true;
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    protected SerializableImage getImage() {
        int[] pixels = new int[this.bitmapWidth * this.bitmapHeight];
        if (this.bitmapFormat == 3) {
            COLORMAPDATA colorMapData = this.getColorMapData();
            int pos32aligned = 0;
            int pos = 0;
            for (int y = 0; y < this.bitmapHeight; ++y) {
                for (int x = 0; x < this.bitmapWidth; ++x) {
                    int c = 0;
                    int colorTableIndex = colorMapData.colorMapPixelData[pos32aligned] & 0xFF;
                    if (colorTableIndex < colorMapData.colorTableRGB.length) {
                        c = colorMapData.colorTableRGB[colorTableIndex];
                    }
                    pixels[pos++] = c;
                    ++pos32aligned;
                }
                while (pos32aligned % 4 != 0) {
                    ++pos32aligned;
                }
            }
        } else if (this.bitmapFormat == 4 || this.bitmapFormat == 5) {
            BITMAPDATA bitmapData = this.getBitmapData();
            int pos = 0;
            int[] bitmapPixelData = null;
            if (this.bitmapFormat == 4) {
                bitmapPixelData = bitmapData.bitmapPixelDataPix15;
            } else if (this.bitmapFormat == 5) {
                bitmapPixelData = bitmapData.bitmapPixelDataPix24;
            }
            for (int y = 0; y < this.bitmapHeight; ++y) {
                for (int x = 0; x < this.bitmapWidth; ++x) {
                    int c = bitmapPixelData[pos] | 0xFF000000;
                    pixels[pos++] = c;
                }
            }
        }
        SerializableImage bi = new SerializableImage(this.bitmapWidth, this.bitmapHeight, SerializableImage.TYPE_INT_RGB, pixels);
        return bi;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.bitmapWidth, this.bitmapHeight);
    }
}

