/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@SWFVersion(from=3)
public class DefineButton2Tag
extends ButtonTag
implements ASMSourceContainer {
    public static final int ID = 34;
    public static final String NAME = "DefineButton2";
    @SWFType(value=BasicType.UI16)
    public int buttonId;
    @Reserved
    @SWFType(value=BasicType.UB, count=7)
    public int reserved;
    public boolean trackAsMenu;
    public List<BUTTONRECORD> characters;
    public List<BUTTONCONDACTION> actions = new ArrayList<BUTTONCONDACTION>();

    public DefineButton2Tag(SWF swf) {
        super(swf, 34, NAME, null);
        this.buttonId = swf.getNextCharacterId();
        this.characters = new ArrayList<BUTTONRECORD>();
    }

    public DefineButton2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 34, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.buttonId = sis.readUI16("buttonId");
        this.reserved = (int)sis.readUB(7, "reserved");
        this.trackAsMenu = sis.readUB(1, "trackAsMenu") == 1L;
        int actionOffset = sis.readUI16("actionOffset");
        this.characters = sis.readBUTTONRECORDList(this.swf, this, "characters");
        if (actionOffset > 0) {
            this.actions = sis.readBUTTONCONDACTIONList(this.swf, this, "actions");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.buttonId);
        sos.writeUB(7, this.reserved);
        sos.writeUB(1, this.trackAsMenu ? 1L : 0L);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try (SWFOutputStream sos2 = new SWFOutputStream(baos2, this.getVersion(), this.getCharset());){
            sos2.writeBUTTONRECORDList(this.characters, true);
        }
        byte[] brdata = baos2.toByteArray();
        if (this.actions == null || this.actions.isEmpty()) {
            sos.writeUI16(0);
        } else {
            sos.writeUI16(2 + brdata.length);
        }
        sos.write(brdata);
        sos.writeBUTTONCONDACTIONList(this.actions);
    }

    @Override
    public void getDataNoScript(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.buttonId);
        sos.writeUB(7, this.reserved);
        sos.writeUB(1, this.trackAsMenu ? 1L : 0L);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try (SWFOutputStream sos2 = new SWFOutputStream(baos2, this.getVersion(), this.getCharset());){
            sos2.writeBUTTONRECORDList(this.characters, true);
        }
        byte[] brdata = baos2.toByteArray();
        sos.writeUI16(0);
        sos.write(brdata);
    }

    @Override
    public int getCharacterId() {
        return this.buttonId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.buttonId = characterId;
    }

    @Override
    public List<BUTTONRECORD> getRecords() {
        return this.characters;
    }

    public List<BUTTONCONDACTION> getSubItems() {
        return this.actions;
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (int i = 0; i < this.characters.size(); ++i) {
            BUTTONRECORD character = this.characters.get(i);
            if (character.characterId != oldCharacterId) continue;
            character.characterId = newCharacterId;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (int i = 0; i < this.characters.size(); ++i) {
            if (this.characters.get((int)i).characterId != characterId) continue;
            this.characters.remove(i);
            modified = true;
            --i;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        RECT ret;
        if (this.swf == null) {
            return null;
        }
        Cache<CharacterTag, RECT> cache = this.swf == null ? null : this.swf.getRectCache();
        RECT rECT = ret = cache == null ? null : cache.get(this);
        if (ret != null) {
            return ret;
        }
        RECT rect = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        boolean foundSomething = false;
        for (BUTTONRECORD r : this.characters) {
            BoundedTag bt;
            CharacterTag ch = this.swf.getCharacter(r.characterId);
            if (!(ch instanceof BoundedTag) || added.contains(bt = (BoundedTag)((Object)ch))) continue;
            added.add(bt);
            RECT r2 = bt.getRect(added);
            added.remove(bt);
            MATRIX mat = r.placeMatrix;
            if (mat != null) {
                r2 = mat.apply(r2);
            }
            rect.Xmin = Math.min(r2.Xmin, rect.Xmin);
            rect.Ymin = Math.min(r2.Ymin, rect.Ymin);
            rect.Xmax = Math.max(r2.Xmax, rect.Xmax);
            rect.Ymax = Math.max(r2.Ymax, rect.Ymax);
            foundSomething = true;
        }
        if (!foundSomething) {
            rect = new RECT();
        }
        if (cache != null) {
            cache.put(this, rect);
        }
        return rect;
    }

    @Override
    public boolean trackAsMenu() {
        return this.trackAsMenu;
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    protected void initTimeline(Timeline timeline) {
        int maxDepth = 0;
        Frame frameUp = new Frame(timeline, 0);
        Frame frameDown = new Frame(timeline, 0);
        Frame frameOver = new Frame(timeline, 0);
        Frame frameHit = new Frame(timeline, 0);
        for (BUTTONRECORD r : this.characters) {
            if (this.swf.getCyclicCharacters().contains(r.characterId)) continue;
            DepthState layer = new DepthState(this.swf, null, null);
            layer.colorTransForm = r.colorTransform;
            layer.blendMode = r.blendMode;
            layer.filters = r.filterList;
            layer.matrix = r.placeMatrix;
            layer.characterId = r.characterId;
            layer.depth = r.placeDepth;
            if (r.placeDepth > maxDepth) {
                maxDepth = r.placeDepth;
            }
            if (r.buttonStateUp) {
                frameUp.layers.put(r.placeDepth, new DepthState(layer, frameUp, frameUp, false));
                frameUp.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
            }
            if (r.buttonStateOver) {
                frameOver.layers.put(r.placeDepth, new DepthState(layer, frameOver, frameOver, false));
                if (!r.buttonStateUp) {
                    frameOver.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
                }
            }
            if (r.buttonStateDown) {
                frameDown.layers.put(r.placeDepth, new DepthState(layer, frameDown, frameDown, false));
                if (!r.buttonStateOver) {
                    frameDown.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
                }
            }
            if (!r.buttonStateHitTest) continue;
            frameHit.layers.put(r.placeDepth, new DepthState(layer, frameHit, frameHit, false));
            if (r.buttonStateDown) continue;
            frameHit.layers.get((Object)Integer.valueOf((int)r.placeDepth)).key = true;
        }
        timeline.addFrame(frameUp);
        if (frameOver.layers.isEmpty()) {
            frameOver = frameUp;
        }
        timeline.addFrame(frameOver);
        if (frameDown.layers.isEmpty()) {
            frameDown = frameOver;
        }
        timeline.addFrame(frameDown);
        if (frameHit.layers.isEmpty()) {
            frameHit = frameUp;
        }
        timeline.addFrame(frameHit);
    }

    @Override
    public int getFrameCount() {
        return 4;
    }

    @Override
    public void setFrameCount(int frameCount) {
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
        for (BUTTONRECORD rec : this.characters) {
            needed.add(rec.characterId);
        }
    }
}

