/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

@SWFVersion(from=8)
public class ImportAssets2Tag
extends Tag
implements ImportTag {
    public static final int ID = 71;
    public static final String NAME = "ImportAssets2";
    public String url;
    @SWFType(value=BasicType.UI8)
    public int downloadNow = 1;
    @SWFType(value=BasicType.UI8)
    public int hasDigest = 0;
    @Conditional(value={"hasDigest"}, options={1})
    String sha1 = "";
    @SWFType(value=BasicType.UI16)
    @SWFArray(value="tag", countField="count")
    @Table(value="assets", itemName="asset")
    public List<Integer> tags;
    @SWFArray(value="name", countField="count")
    @Table(value="assets", itemName="asset")
    public List<String> names;

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.setModified(true);
    }

    public ImportAssets2Tag(SWF swf) {
        super(swf, 71, NAME, null);
        this.url = "";
        this.tags = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
    }

    public ImportAssets2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 71, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.tags = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
        this.url = sis.readString("url");
        this.downloadNow = sis.readUI8("downloadNow");
        this.hasDigest = sis.readUI8("hasDigest");
        if (this.hasDigest == 1) {
            this.sha1 = Helper.bytesToHexString(sis.readBytes(20, "SHA1"));
        }
        int count = sis.readUI16("count");
        for (int i = 0; i < count; ++i) {
            int charId = sis.readUI16("charId");
            String tagName = sis.readString("tagName");
            this.tags.add(charId);
            this.names.add(tagName);
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeString(this.url);
        sos.writeUI8(this.downloadNow);
        if (this.hasDigest == 1 && this.sha1 != null && this.sha1.matches("[0-9a-fA-F]{40}")) {
            sos.writeUI8(1);
            sos.write(Helper.hexToByteArray(this.sha1));
        } else {
            sos.writeUI8(0);
        }
        sos.writeUI16(this.tags.size());
        for (int i = 0; i < this.tags.size(); ++i) {
            sos.writeUI16(this.tags.get(i));
            sos.writeString(this.names.get(i));
        }
    }

    @Override
    public Map<Integer, String> getAssets() {
        HashMap<Integer, String> assets = new HashMap<Integer, String>();
        for (int i = 0; i < this.tags.size(); ++i) {
            assets.put(this.tags.get(i), this.names.get(i));
        }
        return assets;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Map<String, String> getNameProperties() {
        Map<String, String> ret = super.getNameProperties();
        if (this.names.size() == 1) {
            ret.put("chid", "" + this.tags.get(0));
            String importName = this.names.get(0);
            if (importName.startsWith("__Packages.")) {
                ret.put("imp", DottedChain.parseNoSuffix(importName).toPrintableString(new LinkedHashSet<String>(), this.getSwf(), false));
            } else {
                ret.put("imp", "\"" + Helper.escapePCodeString(importName) + "\"");
            }
        }
        return ret;
    }
}

