/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.abc.CopyOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.tags.CSMSettingsTag;
import com.jpexs.decompiler.flash.tags.CharacterSetTag;
import com.jpexs.decompiler.flash.tags.DebugIDTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG4Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLossless2Tag;
import com.jpexs.decompiler.flash.tags.DefineBitsLosslessTag;
import com.jpexs.decompiler.flash.tags.DefineBitsTag;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonCxformTag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineFont2Tag;
import com.jpexs.decompiler.flash.tags.DefineFont3Tag;
import com.jpexs.decompiler.flash.tags.DefineFont4Tag;
import com.jpexs.decompiler.flash.tags.DefineFontAlignZonesTag;
import com.jpexs.decompiler.flash.tags.DefineFontInfo2Tag;
import com.jpexs.decompiler.flash.tags.DefineFontInfoTag;
import com.jpexs.decompiler.flash.tags.DefineFontNameTag;
import com.jpexs.decompiler.flash.tags.DefineFontTag;
import com.jpexs.decompiler.flash.tags.DefineMorphShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineMorphShapeTag;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSceneAndFrameLabelDataTag;
import com.jpexs.decompiler.flash.tags.DefineShape2Tag;
import com.jpexs.decompiler.flash.tags.DefineShape3Tag;
import com.jpexs.decompiler.flash.tags.DefineShape4Tag;
import com.jpexs.decompiler.flash.tags.DefineShapeTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineText2Tag;
import com.jpexs.decompiler.flash.tags.DefineTextFormatTag;
import com.jpexs.decompiler.flash.tags.DefineTextTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DefineVideoTag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.DoABCTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.EnableDebugger2Tag;
import com.jpexs.decompiler.flash.tags.EnableDebuggerTag;
import com.jpexs.decompiler.flash.tags.EnableTelemetryTag;
import com.jpexs.decompiler.flash.tags.EndTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.FontRefTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.FreeCharacterTag;
import com.jpexs.decompiler.flash.tags.GenCommandTag;
import com.jpexs.decompiler.flash.tags.ImportAssets2Tag;
import com.jpexs.decompiler.flash.tags.ImportAssetsTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.NameCharacterTag;
import com.jpexs.decompiler.flash.tags.PlaceImagePrivateTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject3Tag;
import com.jpexs.decompiler.flash.tags.PlaceObject4Tag;
import com.jpexs.decompiler.flash.tags.PlaceObjectTag;
import com.jpexs.decompiler.flash.tags.ProductInfoTag;
import com.jpexs.decompiler.flash.tags.ProtectTag;
import com.jpexs.decompiler.flash.tags.RemoveObject2Tag;
import com.jpexs.decompiler.flash.tags.RemoveObjectTag;
import com.jpexs.decompiler.flash.tags.ScriptLimitsTag;
import com.jpexs.decompiler.flash.tags.SerialNumberTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.SetTabIndexTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.SoundStreamHead2Tag;
import com.jpexs.decompiler.flash.tags.SoundStreamHeadTag;
import com.jpexs.decompiler.flash.tags.StartSound2Tag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.SyncFrameTag;
import com.jpexs.decompiler.flash.tags.TagChangedListener;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.TagStub;
import com.jpexs.decompiler.flash.tags.TagTypeInfo;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.Exportable;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalGradient;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalImage2;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalStreamSound;
import com.jpexs.decompiler.flash.tags.gfx.DefineGradientMap;
import com.jpexs.decompiler.flash.tags.gfx.DefineSubImage;
import com.jpexs.decompiler.flash.tags.gfx.ExporterInfo;
import com.jpexs.decompiler.flash.tags.gfx.FontTextureInfo;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Tag
implements NeedsCharacters,
Exportable,
Serializable {
    private static final Logger logger = Logger.getLogger(Tag.class.getName());
    protected int id;
    public boolean forceWriteAsLong = false;
    protected String tagName;
    @Internal
    protected transient SWF swf;
    @Internal
    protected transient Timelined timelined;
    @Internal
    private boolean modified;
    @Internal
    protected boolean imported = false;
    @Internal
    protected boolean importedDeep = false;
    @Internal
    private ByteArrayRange originalRange;
    private final HashSet<TagChangedListener> listeners = new HashSet();
    @Internal
    public ByteArrayRange remainingData;
    private static final Object lockObject = new Object();
    private static volatile Integer[] knownTagIds;
    private static volatile Map<Integer, List<TagTypeInfo>> knownTagInfosById;
    private static volatile Map<String, TagTypeInfo> knownTagInfosByName;
    private static volatile List<Integer> requiredTagIds;

    public void setImported(boolean imported, boolean deep) {
        this.imported = imported;
        this.importedDeep = deep;
    }

    public boolean isImported() {
        return this.imported;
    }

    public boolean isImportedDeep() {
        return this.importedDeep;
    }

    public Tag(SWF swf, int id, String name, ByteArrayRange data) {
        this.id = id;
        this.tagName = name;
        this.originalRange = data;
        this.swf = swf;
        if (swf == null) {
            throw new Error("swf parameter cannot be null.");
        }
        if (data == null) {
            this.modified = true;
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public Map<String, String> getNameProperties() {
        return new LinkedHashMap<String, String>();
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tagName);
        Map<String, String> props = this.getNameProperties();
        if (!props.isEmpty()) {
            sb.append(" (");
            ArrayList<String> parts = new ArrayList<String>();
            for (String key : props.keySet()) {
                parts.add(key + ": " + props.get(key));
            }
            sb.append(String.join((CharSequence)", ", parts));
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public String getExportFileName() {
        return this.tagName;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public Openable getOpenable() {
        return this.swf;
    }

    public SWF getSwf() {
        return this.swf;
    }

    public void setSwf(SWF swf) {
        this.setSwf(swf, false);
    }

    public void setSwf(SWF swf, boolean deep) {
        this.swf = swf;
        if (deep && this instanceof DefineSpriteTag) {
            DefineSpriteTag sprite = (DefineSpriteTag)this;
            for (Tag subTag : sprite.getTags()) {
                subTag.setSwf(swf);
            }
        }
    }

    public Timelined getTimelined() {
        return this.timelined;
    }

    public void setTimelined(Timelined timelined) {
        this.timelined = timelined;
    }

    public abstract void readData(SWFInputStream var1, ByteArrayRange var2, int var3, boolean var4, boolean var5, boolean var6) throws IOException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer[] getKnownTags() {
        if (knownTagIds == null) {
            Object object = lockObject;
            synchronized (object) {
                if (knownTagIds == null) {
                    Set<Integer> keySet = Tag.getKnownClasses().keySet();
                    Integer[] tagIds = keySet.toArray(new Integer[keySet.size()]);
                    knownTagIds = tagIds;
                }
            }
        }
        return knownTagIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, List<TagTypeInfo>> getKnownClasses() {
        if (knownTagInfosById == null) {
            Object object = lockObject;
            synchronized (object) {
                if (knownTagInfosById == null) {
                    HashMap<Integer, List<TagTypeInfo>> map = new HashMap<Integer, List<TagTypeInfo>>();
                    HashMap<String, TagTypeInfo> map2 = new HashMap<String, TagTypeInfo>();
                    Tag.addTagInfo(map, map2, 74, CSMSettingsTag.class, "CSMSettings");
                    Tag.addTagInfo(map, map2, 63, DebugIDTag.class, "DebugID");
                    Tag.addTagInfo(map, map2, 87, DefineBinaryDataTag.class, "DefineBinaryData");
                    Tag.addTagInfo(map, map2, 21, DefineBitsJPEG2Tag.class, "DefineBitsJPEG2");
                    Tag.addTagInfo(map, map2, 35, DefineBitsJPEG3Tag.class, "DefineBitsJPEG3");
                    Tag.addTagInfo(map, map2, 90, DefineBitsJPEG4Tag.class, "DefineBitsJPEG4");
                    Tag.addTagInfo(map, map2, 36, DefineBitsLossless2Tag.class, "DefineBitsLossless2");
                    Tag.addTagInfo(map, map2, 20, DefineBitsLosslessTag.class, "DefineBitsLossless");
                    Tag.addTagInfo(map, map2, 6, DefineBitsTag.class, "DefineBits");
                    Tag.addTagInfo(map, map2, 34, DefineButton2Tag.class, "DefineButton2");
                    Tag.addTagInfo(map, map2, 23, DefineButtonCxformTag.class, "DefineButtonCxform");
                    Tag.addTagInfo(map, map2, 17, DefineButtonSoundTag.class, "DefineButtonSound");
                    Tag.addTagInfo(map, map2, 7, DefineButtonTag.class, "DefineButton");
                    Tag.addTagInfo(map, map2, 37, DefineEditTextTag.class, "DefineEditText");
                    Tag.addTagInfo(map, map2, 48, DefineFont2Tag.class, "DefineFont2");
                    Tag.addTagInfo(map, map2, 75, DefineFont3Tag.class, "DefineFont3");
                    Tag.addTagInfo(map, map2, 91, DefineFont4Tag.class, "DefineFont4");
                    Tag.addTagInfo(map, map2, 73, DefineFontAlignZonesTag.class, "DefineFontAlignZones");
                    Tag.addTagInfo(map, map2, 62, DefineFontInfo2Tag.class, "DefineFontInfo2");
                    Tag.addTagInfo(map, map2, 13, DefineFontInfoTag.class, "DefineFontInfo");
                    Tag.addTagInfo(map, map2, 88, DefineFontNameTag.class, "DefineFontName");
                    Tag.addTagInfo(map, map2, 10, DefineFontTag.class, "DefineFont");
                    Tag.addTagInfo(map, map2, 84, DefineMorphShape2Tag.class, "DefineMorphShape2");
                    Tag.addTagInfo(map, map2, 46, DefineMorphShapeTag.class, "DefineMorphShape");
                    Tag.addTagInfo(map, map2, 78, DefineScalingGridTag.class, "DefineScalingGrid");
                    Tag.addTagInfo(map, map2, 86, DefineSceneAndFrameLabelDataTag.class, "DefineSceneAndFrameLabelData");
                    Tag.addTagInfo(map, map2, 22, DefineShape2Tag.class, "DefineShape2");
                    Tag.addTagInfo(map, map2, 32, DefineShape3Tag.class, "DefineShape3");
                    Tag.addTagInfo(map, map2, 83, DefineShape4Tag.class, "DefineShape4");
                    Tag.addTagInfo(map, map2, 2, DefineShapeTag.class, "DefineShape");
                    Tag.addTagInfo(map, map2, 14, DefineSoundTag.class, "DefineSound");
                    Tag.addTagInfo(map, map2, 39, DefineSpriteTag.class, "DefineSprite");
                    Tag.addTagInfo(map, map2, 33, DefineText2Tag.class, "DefineText2");
                    Tag.addTagInfo(map, map2, 11, DefineTextTag.class, "DefineText");
                    Tag.addTagInfo(map, map2, 60, DefineVideoStreamTag.class, "DefineVideoStream");
                    Tag.addTagInfo(map, map2, 82, DoABC2Tag.class, "DoABC2");
                    Tag.addTagInfo(map, map2, 72, DoABCTag.class, "DoABC");
                    Tag.addTagInfo(map, map2, 12, DoActionTag.class, "DoAction");
                    Tag.addTagInfo(map, map2, 59, DoInitActionTag.class, "DoInitAction");
                    Tag.addTagInfo(map, map2, 64, EnableDebugger2Tag.class, "EnableDebugger2");
                    Tag.addTagInfo(map, map2, 58, EnableDebuggerTag.class, "EnableDebugger");
                    Tag.addTagInfo(map, map2, 93, EnableTelemetryTag.class, "EnableTelemetry");
                    Tag.addTagInfo(map, map2, 0, EndTag.class, "End");
                    Tag.addTagInfo(map, map2, 56, ExportAssetsTag.class, "ExportAssets");
                    Tag.addTagInfo(map, map2, 69, FileAttributesTag.class, "FileAttributes");
                    Tag.addTagInfo(map, map2, 43, FrameLabelTag.class, "FrameLabel");
                    Tag.addTagInfo(map, map2, 71, ImportAssets2Tag.class, "ImportAssets2");
                    Tag.addTagInfo(map, map2, 57, ImportAssetsTag.class, "ImportAssets");
                    Tag.addTagInfo(map, map2, 8, JPEGTablesTag.class, "JPEGTables");
                    Tag.addTagInfo(map, map2, 77, MetadataTag.class, "Metadata");
                    Tag.addTagInfo(map, map2, 26, PlaceObject2Tag.class, "PlaceObject2");
                    Tag.addTagInfo(map, map2, 70, PlaceObject3Tag.class, "PlaceObject3");
                    Tag.addTagInfo(map, map2, 94, PlaceObject4Tag.class, "PlaceObject4");
                    Tag.addTagInfo(map, map2, 4, PlaceObjectTag.class, "PlaceObject");
                    Tag.addTagInfo(map, map2, 85, PlaceImagePrivateTag.class, "PlaceImagePrivate");
                    Tag.addTagInfo(map, map2, 41, ProductInfoTag.class, "ProductInfo");
                    Tag.addTagInfo(map, map2, 24, ProtectTag.class, "Protect");
                    Tag.addTagInfo(map, map2, 28, RemoveObject2Tag.class, "RemoveObject2");
                    Tag.addTagInfo(map, map2, 5, RemoveObjectTag.class, "RemoveObject");
                    Tag.addTagInfo(map, map2, 65, ScriptLimitsTag.class, "ScriptLimits");
                    Tag.addTagInfo(map, map2, 9, SetBackgroundColorTag.class, "SetBackgroundColor");
                    Tag.addTagInfo(map, map2, 66, SetTabIndexTag.class, "SetTabIndex");
                    Tag.addTagInfo(map, map2, 1, ShowFrameTag.class, "ShowFrame");
                    Tag.addTagInfo(map, map2, 19, SoundStreamBlockTag.class, "SoundStreamBlock");
                    Tag.addTagInfo(map, map2, 45, SoundStreamHead2Tag.class, "SoundStreamHead2");
                    Tag.addTagInfo(map, map2, 18, SoundStreamHeadTag.class, "SoundStreamHead");
                    Tag.addTagInfo(map, map2, 89, StartSound2Tag.class, "StartSound2");
                    Tag.addTagInfo(map, map2, 15, StartSoundTag.class, "StartSound");
                    Tag.addTagInfo(map, map2, 76, SymbolClassTag.class, "SymbolClass");
                    Tag.addTagInfo(map, map2, 61, VideoFrameTag.class, "VideoFrame");
                    Tag.addTagInfo(map, map2, 1005, DefineCompactedFont.class, "DefineCompactedFont");
                    Tag.addTagInfo(map, map2, 1003, DefineExternalGradient.class, "DefineExternalGradient");
                    Tag.addTagInfo(map, map2, 1001, DefineExternalImage.class, "DefineExternalImage");
                    Tag.addTagInfo(map, map2, 1009, DefineExternalImage2.class, "DefineExternalImage2");
                    Tag.addTagInfo(map, map2, 1006, DefineExternalSound.class, "DefineExternalSound");
                    Tag.addTagInfo(map, map2, 1007, DefineExternalStreamSound.class, "DefineExternalStreamSound");
                    Tag.addTagInfo(map, map2, 1004, DefineGradientMap.class, "DefineGradientMap");
                    Tag.addTagInfo(map, map2, 1008, DefineSubImage.class, "DefineSubImage");
                    Tag.addTagInfo(map, map2, 1000, ExporterInfo.class, "ExporterInfo");
                    Tag.addTagInfo(map, map2, 1002, FontTextureInfo.class, "FontTextureInfo");
                    Tag.addTagInfo(map, map2, 38, DefineVideoTag.class, "DefineVideo");
                    Tag.addTagInfo(map, map2, 49, GenCommandTag.class, "GenCommand");
                    Tag.addTagInfo(map, map2, 52, FontRefTag.class, "FontRef");
                    Tag.addTagInfo(map, map2, 42, DefineTextFormatTag.class, "DefineTextFormat");
                    Tag.addTagInfo(map, map2, 40, NameCharacterTag.class, "NameCharacter");
                    Tag.addTagInfo(map, map2, 51, CharacterSetTag.class, "CharacterSet");
                    Tag.addTagInfo(map, map2, 41, SerialNumberTag.class, "SerialNumber");
                    Tag.addTagInfo(map, map2, 3, FreeCharacterTag.class, "FreeCharacter");
                    Tag.addTagInfo(map, map2, 29, SyncFrameTag.class, "SyncFrame");
                    knownTagInfosById = map;
                    knownTagInfosByName = map2;
                }
            }
        }
        return knownTagInfosById;
    }

    public static Map<String, TagTypeInfo> getKnownClassesByName() {
        if (knownTagInfosByName == null) {
            Tag.getKnownClasses();
        }
        return knownTagInfosByName;
    }

    private static void addTagInfo(Map<Integer, List<TagTypeInfo>> map, Map<String, TagTypeInfo> map2, int id, Class cls, String name) {
        if (!map.containsKey(id)) {
            map.put(id, new ArrayList());
        }
        map.get(id).add(new TagTypeInfo(id, cls, name));
        map2.put(name, new TagTypeInfo(id, cls, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> getRequiredTags() {
        if (requiredTagIds == null) {
            Object object = lockObject;
            synchronized (object) {
                if (requiredTagIds == null) {
                    List<Integer> tagIds = Arrays.asList(87, 21, 35, 90, 36, 20, 6, 34, 23, 17, 7, 37, 48, 75, 91, 73, 62, 13, 88, 10, 84, 46, 78, 86, 22, 32, 83, 2, 14, 39, 33, 11, 60, 82, 72, 12, 59, 1);
                    requiredTagIds = tagIds;
                }
            }
        }
        return requiredTagIds;
    }

    public int getVersion() {
        if (this.swf == null) {
            return 10;
        }
        return this.swf.version;
    }

    protected byte[] getHeader(int dataLength) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SWFOutputStream sos = new SWFOutputStream(baos, this.swf.version, this.swf.getCharset());
            int tagLength = dataLength;
            int tagID = this.getId();
            int tagIDLength = tagID << 6;
            if (tagLength <= 62 && !this.forceWriteAsLong) {
                sos.writeUI16(tagIDLength += tagLength);
            } else {
                sos.writeUI16(tagIDLength += 63);
                sos.writeSI32(tagLength);
            }
        }
        catch (IOException iex) {
            throw new Error("This should never happen.", iex);
        }
        return baos.toByteArray();
    }

    public static byte[] getTagHeader(int tagIDTagLength, long tagLength, boolean writeLong, int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SWFOutputStream sos = new SWFOutputStream(baos, version, Utf8Helper.charsetName);
            sos.writeUI16(tagIDTagLength);
            if (writeLong) {
                sos.writeSI32(tagLength);
            }
        }
        catch (IOException iex) {
            throw new Error("This should never happen.", iex);
        }
        return baos.toByteArray();
    }

    public void writeTag(SWFOutputStream sos) throws IOException {
        if (Configuration._debugCopy.get().booleanValue() || this.isModified() || this.isImported()) {
            byte[] newData = this.getData();
            byte[] newHeaderData = this.getHeader(newData.length);
            sos.write(newHeaderData);
            sos.write(newData);
        } else {
            sos.write(this.originalRange.getArray(), this.originalRange.getPos(), this.originalRange.getLength());
        }
    }

    public void writeTagNoScripts(SWFOutputStream sos) throws IOException {
        byte[] newData = this.getDataNoScript();
        byte[] newHeaderData = this.getHeader(newData.length);
        sos.write(newHeaderData);
        sos.write(newData);
    }

    public Tag cloneTag() throws InterruptedException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = this.getData();
        byte[] headerData = this.getHeader(data.length);
        baos.write(headerData);
        baos.write(data);
        byte[] dataWithHeader = baos.toByteArray();
        SWFInputStream tagDataStream = new SWFInputStream(this.swf, data, 0L, data.length);
        TagStub copy = new TagStub(this.swf, this.getId(), "Unresolved", new ByteArrayRange(dataWithHeader), tagDataStream);
        copy.forceWriteAsLong = this.forceWriteAsLong;
        return SWFInputStream.resolveTag(copy, 0, false, true, false, false);
    }

    public Tag getOriginalTag() throws InterruptedException, IOException {
        byte[] data = this.getOriginalData();
        SWFInputStream tagDataStream = new SWFInputStream(this.swf, data, this.getDataPos(), data.length);
        TagStub copy = new TagStub(this.swf, this.getId(), "Unresolved", this.getOriginalRange(), tagDataStream);
        copy.forceWriteAsLong = this.forceWriteAsLong;
        return SWFInputStream.resolveTag(copy, 0, false, true, false, false);
    }

    public boolean canUndo() {
        return this.originalRange != null && this.isModified();
    }

    public void undo() throws InterruptedException, IOException {
        if (this.originalRange == null) {
            return;
        }
        SWFInputStream tagDataStream = new SWFInputStream(this.swf, this.originalRange.getArray(), 0L, this.originalRange.getPos() + this.originalRange.getLength());
        tagDataStream.seek(this.getDataPos());
        this.readData(tagDataStream, this.getOriginalRange(), 0, false, true, false);
        this.setModified(false);
    }

    public String toString() {
        return this.getName();
    }

    public abstract void getData(SWFOutputStream var1) throws IOException;

    public byte[] getData() {
        byte[] originalData;
        ByteArrayOutputStream baos;
        OutputStream os = baos = new ByteArrayOutputStream();
        if (Configuration._debugCopy.get().booleanValue() && (originalData = this.getOriginalData()) != null) {
            os = new CopyOutputStream(os, new ByteArrayInputStream(this.getOriginalData()));
        }
        try (SWFOutputStream sos = new SWFOutputStream(os, this.getVersion(), this.getCharset());){
            this.getData(sos);
            if (this.remainingData != null) {
                sos.write(this.remainingData);
            }
        }
        catch (IOException e) {
            throw new Error("This should never happen.", e);
        }
        return baos.toByteArray();
    }

    public void getDataNoScript(SWFOutputStream sos) throws IOException {
        this.getData(sos);
    }

    public byte[] getDataNoScript() {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        try (SWFOutputStream sos = new SWFOutputStream(os, this.getVersion(), this.getCharset());){
            this.getDataNoScript(sos);
            if (this.remainingData != null) {
                sos.write(this.remainingData);
            }
        }
        catch (IOException e) {
            throw new Error("This should never happen.", e);
        }
        return baos.toByteArray();
    }

    public final ByteArrayRange getOriginalRange() {
        return this.originalRange;
    }

    public final byte[] getOriginalData() {
        if (this.originalRange == null) {
            return null;
        }
        int dataLength = this.getOriginalDataLength();
        int pos = this.originalRange.getPos() + this.originalRange.getLength() - dataLength;
        byte[] data = new byte[dataLength];
        System.arraycopy(this.originalRange.getArray(), pos, data, 0, dataLength);
        return data;
    }

    public final int getOriginalDataLength() {
        if (this.originalRange == null) {
            return 0;
        }
        return this.originalRange.getLength() - (this.isLongOriginal() ? 6 : 2);
    }

    private boolean isLongOriginal() {
        int shortLength = this.originalRange.getArray()[this.originalRange.getPos()] & 0x3F;
        return shortLength == 63;
    }

    public long getPos() {
        if (this.originalRange == null) {
            return -1L;
        }
        return this.originalRange.getPos();
    }

    public long getDataPos() {
        if (this.originalRange == null) {
            return -1L;
        }
        return this.originalRange.getPos() + (this.isLongOriginal() ? 6 : 2);
    }

    public void setModified(boolean value) {
        boolean oldValue = this.modified;
        this.modified = value;
        if (value && oldValue != value) {
            this.informListeners();
        }
    }

    public final void addEventListener(TagChangedListener listener) {
        this.listeners.add(listener);
    }

    public final void removeEventListener(TagChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void informListeners() {
        for (TagChangedListener listener : this.listeners) {
            listener.handleEvent(this);
        }
    }

    public void createOriginalData() {
        byte[] data = this.getData();
        byte[] headerData = this.getHeader(data.length);
        byte[] tagData = new byte[data.length + headerData.length];
        System.arraycopy(headerData, 0, tagData, 0, headerData.length);
        System.arraycopy(data, 0, tagData, headerData.length, data.length);
        this.originalRange = new ByteArrayRange(tagData);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public boolean isReadOnly() {
        return this.isImported();
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
    }

    public Set<Integer> getMissingNeededCharacters(Set<Integer> needed) {
        LinkedHashSet<Integer> needed2 = new LinkedHashSet<Integer>(needed);
        if (needed2.isEmpty()) {
            return new LinkedHashSet<Integer>();
        }
        Timelined tim = this.getTimelined();
        if (tim == null) {
            return needed2;
        }
        ReadOnlyTagList tags = tim.getTags();
        for (int i = tags.indexOf(this) - 1; i >= 0; --i) {
            if (tags.get(i) instanceof ImportTag) {
                ImportTag it = (ImportTag)((Object)tags.get(i));
                needed2.removeAll(it.getAssets().keySet());
                if (needed2.isEmpty()) {
                    return needed2;
                }
            }
            if (!(tags.get(i) instanceof CharacterTag)) continue;
            int charId = ((CharacterTag)tags.get(i)).getCharacterId();
            needed2.remove(charId);
            if (!needed2.isEmpty()) continue;
            return needed2;
        }
        return needed2;
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        return false;
    }

    public void getNeededCharactersDeep(Set<Integer> needed) {
        LinkedHashSet<Integer> needed2 = new LinkedHashSet<Integer>();
        this.getNeededCharacters(needed2, this.swf);
        ArrayList<Integer> needed3 = new ArrayList<Integer>(needed2);
        for (int i = 0; i < needed3.size(); ++i) {
            int characterId = (Integer)needed3.get(i);
            if (this.swf == null) {
                return;
            }
            if (!this.swf.getCharacters(true).containsKey(characterId) || this.swf.getCyclicCharacters().contains(characterId)) continue;
            LinkedHashSet<Integer> needed4 = new LinkedHashSet<Integer>();
            CharacterTag character = this.swf.getCharacter(characterId);
            if (character.isImported()) continue;
            character.getNeededCharacters(needed4, this.swf);
            ArrayList<Integer> newItems = new ArrayList<Integer>();
            Iterator iterator = needed4.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                int index = needed3.indexOf(n);
                if (index > i) {
                    needed3.remove(index);
                }
                if (needed3.contains(n) || newItems.contains(n)) continue;
                newItems.add(n);
            }
            if (newItems.isEmpty()) continue;
            needed3.addAll(i, newItems);
            --i;
        }
        for (Integer characterId : needed3) {
            if (this.swf == null) {
                return;
            }
            if (!this.swf.getCharacters(true).containsKey(characterId)) continue;
            needed.add(characterId);
        }
    }

    private void getDependentCharactersOnTimelined(Timelined timelined, Set<Integer> dependent) {
        for (Tag tag : timelined.getTags()) {
            if (tag instanceof CharacterTag && ((CharacterTag)tag).getCharacterId() != -1) {
                HashSet<Integer> needed = new HashSet<Integer>();
                tag.getNeededCharactersDeep(needed);
                for (int dep : dependent) {
                    if (!needed.contains(dep)) continue;
                    dependent.add(((CharacterTag)tag).getCharacterId());
                    break;
                }
            }
            if (!(tag instanceof DefineSpriteTag)) continue;
            this.getDependentCharactersOnTimelined((DefineSpriteTag)tag, dependent);
        }
    }

    public void getDependentCharacters(Set<Integer> dependent) {
        this.getDependentCharactersOnTimelined(this.swf, dependent);
    }

    public void getTagInfo(TagInfo tagInfo) {
        tagInfo.addInfo("general", "tagType", String.format("%s (%d)", this.tagName, this.id));
        if (this instanceof CharacterIdTag) {
            CharacterIdTag characterIdTag = (CharacterIdTag)((Object)this);
            tagInfo.addInfo("general", "characterId", characterIdTag.getCharacterId());
        }
        if (this.originalRange != null) {
            int pos = this.originalRange.getPos();
            int length = this.originalRange.getLength();
            tagInfo.addInfo("general", "offset", String.format("%d (0x%x)", pos, pos));
            tagInfo.addInfo("general", "length", String.format("%d (0x%x)", length, length));
        }
        if (this instanceof BoundedTag) {
            BoundedTag boundedIdTag = (BoundedTag)((Object)this);
            RECT bounds = boundedIdTag.getRect();
            tagInfo.addInfo("general", "bounds", String.format("(%.2f, %.2f)[%.2f x %.2f]", (double)bounds.Xmin / 20.0, (double)bounds.Ymin / 20.0, (double)bounds.getWidth() / 20.0, (double)bounds.getHeight() / 20.0));
        }
    }

    public String getCharset() {
        if (this.swf == null) {
            return Utf8Helper.charsetName;
        }
        return this.swf.getCharset();
    }

    public String getUniqueId() {
        return null;
    }
}

