/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.shape.BitmapExporter;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.exporters.shape.SVGShapeExporter;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Shape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;

public abstract class ImageTag
extends DrawableTag {
    @SWFType(value=BasicType.UI16)
    public int characterID;
    protected SerializableImage cachedImage;

    public ImageTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public abstract InputStream getOriginalImageData();

    protected abstract SerializableImage getImage();

    public abstract Dimension getImageDimension();

    public abstract void setImage(byte[] var1) throws IOException;

    public abstract ImageFormat getOriginalImageFormat();

    public boolean importSupported() {
        return true;
    }

    public abstract ImageFormat getImageFormat();

    public static ImageFormat getImageFormat(byte[] data) {
        return ImageTag.getImageFormat(new ByteArrayRange(data));
    }

    public static ImageFormat getImageFormat(ByteArrayRange data) {
        if (ImageTag.hasErrorHeader(data)) {
            return ImageFormat.JPEG;
        }
        if (data.getLength() > 2 && (data.get(0) & 0xFF) == 255 && (data.get(1) & 0xFF) == 216) {
            return ImageFormat.JPEG;
        }
        if (data.getLength() > 6 && (data.get(0) & 0xFF) == 71 && (data.get(1) & 0xFF) == 73 && (data.get(2) & 0xFF) == 70 && (data.get(3) & 0xFF) == 56 && (data.get(4) & 0xFF) == 57 && (data.get(5) & 0xFF) == 97) {
            return ImageFormat.GIF;
        }
        if (data.getLength() > 8 && (data.get(0) & 0xFF) == 137 && (data.get(1) & 0xFF) == 80 && (data.get(2) & 0xFF) == 78 && (data.get(3) & 0xFF) == 71 && (data.get(4) & 0xFF) == 13 && (data.get(5) & 0xFF) == 10 && (data.get(6) & 0xFF) == 26 && (data.get(7) & 0xFF) == 10) {
            return ImageFormat.PNG;
        }
        return ImageFormat.UNKNOWN;
    }

    public SerializableImage getImageCached() {
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        SerializableImage image = this.getImage();
        if (Configuration.cacheImages.get().booleanValue()) {
            this.cachedImage = image;
        }
        return image;
    }

    public InputStream getConvertedImageData() {
        InputStream is;
        if (this.getImageFormat() == this.getOriginalImageFormat() && (is = this.getOriginalImageData()) != null) {
            return is;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageHelper.write(this.getImage().getBufferedImage(), this.getImageFormat(), baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public InputStream getImageData() {
        InputStream is = this.getOriginalImageData();
        if (is != null) {
            return is;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageHelper.write(this.getImage().getBufferedImage(), this.getImageFormat(), baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static boolean hasErrorHeader(byte[] data) {
        return ImageTag.hasErrorHeader(new ByteArrayRange(data));
    }

    public static boolean hasErrorHeader(ByteArrayRange data) {
        return data.getLength() > 4 && (data.get(0) & 0xFF) == 255 && (data.get(1) & 0xFF) == 217 && (data.get(2) & 0xFF) == 255 && (data.get(3) & 0xFF) == 216;
    }

    private SHAPEWITHSTYLE getShape(int shapeNum) {
        RECT rect = this.getRect();
        return this.getShape(rect, false, shapeNum);
    }

    public SHAPEWITHSTYLE getShape(RECT rect, boolean fill, int shapeNum) {
        boolean translated = rect.Xmin != 0 || rect.Ymin != 0;
        SHAPEWITHSTYLE shape = new SHAPEWITHSTYLE();
        shape.fillStyles = new FILLSTYLEARRAY();
        shape.fillStyles.fillStyles = new FILLSTYLE[1];
        FILLSTYLE fillStyle = new FILLSTYLE();
        fillStyle.inShape3 = shapeNum >= 3;
        fillStyle.fillStyleType = Configuration.shapeImportUseNonSmoothedFill.get() != false ? 66 : 64;
        fillStyle.bitmapId = this.getCharacterId();
        MATRIX matrix = new MATRIX();
        matrix.hasScale = true;
        if (fill) {
            RECT imageRect = this.getRect();
            matrix.scaleX = (float)(20.0 * (double)rect.getWidth() / (double)imageRect.getWidth());
            matrix.scaleY = (float)(20.0 * (double)rect.getHeight() / (double)imageRect.getHeight());
        } else {
            matrix.scaleY = matrix.scaleX = 20.0f;
        }
        if (translated) {
            matrix.translateX = rect.Xmin;
            matrix.translateY = rect.Ymin;
        }
        fillStyle.bitmapMatrix = matrix;
        shape.fillStyles.fillStyles[0] = fillStyle;
        shape.lineStyles = new LINESTYLEARRAY();
        shape.lineStyles.lineStyles = new LINESTYLE[0];
        shape.lineStyles.lineStyles2 = new LINESTYLE2[0];
        shape.shapeRecords = new ArrayList();
        StyleChangeRecord style = new StyleChangeRecord();
        style.stateFillStyle0 = true;
        style.fillStyle0 = 1;
        style.stateMoveTo = true;
        if (translated) {
            style.moveDeltaX = rect.Xmin;
            style.moveDeltaY = rect.Ymin;
        }
        shape.shapeRecords.add(style);
        StraightEdgeRecord top = new StraightEdgeRecord();
        top.generalLineFlag = true;
        top.deltaX = rect.getWidth();
        top.calculateBits();
        StraightEdgeRecord right = new StraightEdgeRecord();
        right.generalLineFlag = true;
        right.deltaY = rect.getHeight();
        right.calculateBits();
        StraightEdgeRecord bottom = new StraightEdgeRecord();
        bottom.generalLineFlag = true;
        bottom.deltaX = -rect.getWidth();
        bottom.calculateBits();
        StraightEdgeRecord left = new StraightEdgeRecord();
        left.generalLineFlag = true;
        left.deltaY = -rect.getHeight();
        left.calculateBits();
        shape.shapeRecords.add(top);
        shape.shapeRecords.add(right);
        shape.shapeRecords.add(bottom);
        shape.shapeRecords.add(left);
        shape.shapeRecords.add(new EndShapeRecord());
        return shape;
    }

    @Override
    public RECT getRect() {
        return this.getRect(null);
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        Dimension dimension = this.getImageDimension();
        int widthInTwips = (int)(dimension.getWidth() * 20.0);
        int heightInTwips = (int)(dimension.getHeight() * 20.0);
        return new RECT(0, widthInTwips, 0, heightInTwips);
    }

    @Override
    public int getUsedParameters() {
        return 0;
    }

    @Override
    public Shape getOutline(boolean fast, int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        return transformation.toTransform().createTransformedShape(this.getShape(1).getOutline(fast, 1, this.swf, stroked));
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing) {
        BitmapExporter.export(0, 1, this.swf, this.getShape(1), null, image, unzoom, transformation, strokeTransformation, colorTransform, true, canUseSmoothing);
    }

    @Override
    public void toSVG(SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) throws IOException {
        SVGShapeExporter shapeExporter = new SVGShapeExporter(0, 1, this.swf, this.getShape(1), this.getCharacterId(), exporter, null, colorTransform, 1.0, exporter.getZoom(), strokeTransformation);
        shapeExporter.export();
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        CanvasShapeExporter cse = new CanvasShapeExporter(0, 1, null, unitDivisor, this.swf, this.getShape(1), null, 0, 0);
        cse.export();
        result.append(cse.getShapeData());
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    public void clearCache() {
        this.cachedImage = null;
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        Dimension dimension = this.getImageDimension();
        tagInfo.addInfo("general", "width", dimension.getWidth());
        tagInfo.addInfo("general", "height", dimension.getHeight());
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }

    public boolean isSameImage(ImageTag otherImage) {
        SerializableImage imgA = this.getImageCached();
        SerializableImage imgB = otherImage.getImageCached();
        if (imgA.getWidth() != imgB.getWidth() || imgA.getHeight() != imgB.getHeight()) {
            return false;
        }
        int width = imgA.getWidth();
        int height = imgA.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (imgA.getRGB(x, y) == imgB.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }
}

