/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.packers.Packer;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.base.BinaryDataInterface;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class PackedBinaryData
implements TreeItem,
BinaryDataInterface {
    private boolean modified = false;
    private final SWF swf;
    private final BinaryDataInterface parent;
    private ByteArrayRange data;
    private PackedBinaryData sub;
    private Packer usedPacker;
    private SWF innerSwf;
    private String packerKey;

    public PackedBinaryData(SWF swf, BinaryDataInterface parent, ByteArrayRange data) {
        this.swf = swf;
        this.parent = parent;
        this.data = data;
    }

    @Override
    public boolean unpack(Packer packer, String key) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (!packer.decrypt(new ByteArrayInputStream(this.data.getRangeData()), baos, key)) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        this.sub = new PackedBinaryData(this.swf, this, new ByteArrayRange(baos.toByteArray()));
        this.usedPacker = packer;
        this.packerKey = key;
        return true;
    }

    @Override
    public PackedBinaryData getSub() {
        return this.sub;
    }

    public BinaryDataInterface getParent() {
        return this.parent;
    }

    @Override
    public Openable getOpenable() {
        return this.swf;
    }

    @Override
    public SWF getSwf() {
        return this.swf;
    }

    @Override
    public void setModified(boolean value) {
        this.modified = value;
        if (value) {
            this.parent.setModified(value);
        } else if (this.sub != null) {
            this.sub.setModified(false);
        }
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public boolean isSwfData() {
        try {
            String signature;
            if (this.data.getLength() > 8 && SWF.swfSignatures.contains(signature = new String(this.data.getRangeData(0, 3), Utf8Helper.charset))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Packer getUsedPacker() {
        return this.usedPacker;
    }

    @Override
    public void detectPacker() {
        for (Packer packer : DefineBinaryDataTag.getAvailablePackers()) {
            if (packer.suitableForData(this.data.getRangeData()) != Boolean.TRUE) continue;
            this.usedPacker = packer;
            break;
        }
    }

    @Override
    public ByteArrayRange getDataBytes() {
        return this.data;
    }

    @Override
    public void setDataBytes(ByteArrayRange data) {
        this.data = data;
        this.setModified(true);
    }

    @Override
    public boolean pack() {
        if (this.sub == null) {
            return false;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (!this.usedPacker.encrypt(new ByteArrayInputStream(this.sub.getDataBytes().getRangeData()), baos, this.packerKey)) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        this.setDataBytes(new ByteArrayRange(baos.toByteArray()));
        return true;
    }

    public String toString() {
        return "(Data - " + this.parent.getUsedPacker().getName() + ")";
    }

    @Override
    public void setInnerSwf(SWF swf) {
        this.innerSwf = swf;
    }

    @Override
    public SWF getInnerSwf() {
        return this.innerSwf;
    }

    @Override
    public String getPathIdentifier() {
        return "(Data - " + this.parent.getUsedPacker().getName() + ")";
    }

    @Override
    public String getStoragesPathIdentifier() {
        return "data-" + this.parent.getUsedPacker().getIdentifier();
    }

    @Override
    public BinaryDataInterface getTopLevelBinaryData() {
        PackedBinaryData packed = this;
        while (packed.parent instanceof PackedBinaryData) {
            packed = (PackedBinaryData)packed.parent;
        }
        return packed.parent;
    }

    @Override
    public String getExportFileName() {
        ArrayList<String> parts = new ArrayList<String>();
        BinaryDataInterface binaryData = this;
        while (binaryData instanceof PackedBinaryData) {
            parts.add(0, binaryData.parent.getUsedPacker().getIdentifier());
            binaryData = binaryData.parent;
        }
        parts.add(0, binaryData.getExportFileName());
        return String.join((CharSequence)"_", parts);
    }

    @Override
    public String getCharacterExportFileName() {
        ArrayList<String> parts = new ArrayList<String>();
        BinaryDataInterface binaryData = this;
        while (binaryData instanceof PackedBinaryData) {
            parts.add(0, binaryData.parent.getUsedPacker().getIdentifier());
            binaryData = binaryData.parent;
        }
        parts.add(0, binaryData.getCharacterExportFileName());
        return String.join((CharSequence)"_", parts);
    }

    @Override
    public String getName() {
        ArrayList<String> parts = new ArrayList<String>();
        BinaryDataInterface binaryData = this;
        while (binaryData instanceof PackedBinaryData) {
            parts.add(0, binaryData.parent.getUsedPacker().getName());
            binaryData = binaryData.parent;
        }
        parts.add(0, binaryData.getName());
        return String.join((CharSequence)" / ", parts);
    }

    @Override
    public String getClassExportFileName(String className) {
        ArrayList<String> parts = new ArrayList<String>();
        BinaryDataInterface binaryData = this;
        while (binaryData instanceof PackedBinaryData) {
            parts.add(0, binaryData.getStoragesPathIdentifier());
            binaryData = binaryData.parent;
        }
        parts.add(0, binaryData.getClassExportFileName(className));
        return String.join((CharSequence)"_", parts);
    }

    @Override
    public String getPackerKey() {
        return this.packerKey;
    }
}

