/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.RequiresNormalizedFonts;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.text.ParsedSymbol;
import com.jpexs.decompiler.flash.tags.text.TextAlign;
import com.jpexs.decompiler.flash.tags.text.TextLexer;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StaticTextTag
extends TextTag {
    @SWFType(value=BasicType.UI16)
    public int characterID;
    protected int glyphBits;
    protected int advanceBits;
    public RECT textBounds;
    public MATRIX textMatrix;
    public List<TEXTRECORD> textRecords;

    public abstract int getTextNum();

    public StaticTextTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        TEXTRECORD tr;
        this.characterID = sis.readUI16("characterID");
        this.textBounds = sis.readRECT("textBounds");
        this.textMatrix = sis.readMatrix("textMatrix");
        this.glyphBits = sis.readUI8("glyphBits");
        this.advanceBits = sis.readUI8("advanceBits");
        this.textRecords = new ArrayList<TEXTRECORD>();
        while ((tr = sis.readTEXTRECORD(this.getTextNum(), this.glyphBits, this.advanceBits, "record")) != null) {
            this.textRecords.add(tr);
        }
    }

    @Override
    public void insertCharacterGlyph(int glyphPos, char character) {
    }

    @Override
    public void removeCharacterGlyph(int glyphPos) {
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeRECT(this.textBounds);
        sos.writeMatrix(this.textMatrix);
        int glyphBits = 0;
        int advanceBits = 0;
        for (TEXTRECORD tr : this.textRecords) {
            for (GLYPHENTRY ge : tr.glyphEntries) {
                glyphBits = SWFOutputStream.enlargeBitCountU(glyphBits, ge.glyphIndex);
                advanceBits = SWFOutputStream.enlargeBitCountS(advanceBits, ge.glyphAdvance);
            }
        }
        if (Configuration._debugCopy.get().booleanValue()) {
            glyphBits = Math.max(glyphBits, this.glyphBits);
            advanceBits = Math.max(advanceBits, this.advanceBits);
        }
        sos.writeUI8(glyphBits);
        sos.writeUI8(advanceBits);
        for (TEXTRECORD tr : this.textRecords) {
            sos.writeTEXTRECORD(tr, this.getTextNum(), glyphBits, advanceBits);
        }
        sos.writeUI8(0);
    }

    @Override
    public RECT getBounds() {
        return this.textBounds;
    }

    @Override
    public MATRIX getTextMatrix() {
        return this.textMatrix;
    }

    @Override
    public void setBounds(RECT r) {
        this.textBounds = r;
    }

    @Override
    public List<String> getTexts() {
        FontTag fnt = null;
        ArrayList<String> ret = new ArrayList<String>();
        for (TEXTRECORD rec : this.textRecords) {
            FontTag fnt2;
            if (rec.styleFlagsHasFont && (fnt2 = this.swf.getFont(rec.fontId)) != null) {
                fnt = fnt2;
            }
            if (rec.styleFlagsHasXOffset || rec.styleFlagsHasYOffset) {
                // empty if block
            }
            if (fnt == null) {
                ret.add(AppResources.translate("fontNotFound").replace("%fontId%", Integer.toString(rec.fontId)));
                continue;
            }
            ret.add(rec.getText(fnt));
        }
        return ret;
    }

    @Override
    public List<Integer> getFontIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (TEXTRECORD rec : this.textRecords) {
            if (!rec.styleFlagsHasFont) continue;
            ret.add(rec.fontId);
        }
        return ret;
    }

    @Override
    public void updateTextBounds() {
        this.updateTextBounds(this.textBounds);
    }

    @Override
    public boolean alignText(TextAlign textAlign) {
        StaticTextTag.alignText(this.swf, this.textRecords, textAlign);
        this.setModified(true);
        return true;
    }

    @Override
    public boolean translateText(int diff) {
        this.textMatrix.translateX += diff;
        this.updateTextBounds();
        this.setModified(true);
        return true;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return this.textBounds;
    }

    @Override
    public ExportRectangle calculateTextBounds() {
        return StaticTextTag.calculateTextBounds(this.swf, this.textRecords, this.getTextMatrix());
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public HighlightedText getFormattedText(boolean ignoreLetterSpacing) {
        FontTag fnt = null;
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        writer.append("[").newLine();
        writer.append("xmin ").append(this.textBounds.Xmin).newLine();
        writer.append("ymin ").append(this.textBounds.Ymin).newLine();
        writer.append("xmax ").append(this.textBounds.Xmax).newLine();
        writer.append("ymax ").append(this.textBounds.Ymax).newLine();
        if (this.textMatrix.translateX != 0) {
            writer.append("translatex ").append(this.textMatrix.translateX).newLine();
        }
        if (this.textMatrix.translateY != 0) {
            writer.append("translatey ").append(this.textMatrix.translateY).newLine();
        }
        if (this.textMatrix.hasScale) {
            writer.append("scalexf ").append(this.textMatrix.scaleX).newLine();
            writer.append("scaleyf ").append(this.textMatrix.scaleY).newLine();
        }
        if (this.textMatrix.hasRotate) {
            writer.append("rotateskew0f ").append(this.textMatrix.rotateSkew0).newLine();
            writer.append("rotateskew1f ").append(this.textMatrix.rotateSkew1).newLine();
        }
        writer.append("]");
        int textHeight = 12;
        int prevLetterSpacing = 0;
        for (TEXTRECORD rec : this.textRecords) {
            int letterSpacing = 0;
            if (rec.styleFlagsHasFont || rec.styleFlagsHasColor || rec.styleFlagsHasXOffset || rec.styleFlagsHasYOffset) {
                writer.append("[").newLine();
                if (rec.styleFlagsHasFont) {
                    FontTag fnt2 = this.swf.getFont(rec.fontId);
                    if (fnt2 != null) {
                        fnt = fnt2;
                    }
                    writer.append("font ").append(rec.fontId).newLine();
                    writer.append("height ").append(rec.textHeight).newLine();
                    textHeight = rec.textHeight;
                }
                if (fnt != null && !ignoreLetterSpacing) {
                    letterSpacing = StaticTextTag.detectLetterSpacing(rec, fnt, textHeight);
                    if (letterSpacing != prevLetterSpacing) {
                        writer.append("letterspacing ").append(letterSpacing).newLine();
                    }
                    prevLetterSpacing = letterSpacing;
                }
                if (rec.styleFlagsHasColor) {
                    if (this.getTextNum() == 1) {
                        writer.append("color ").append(rec.textColor.toHexRGB()).newLine();
                    } else {
                        writer.append("color ").append(rec.textColorA.toHexARGB()).newLine();
                    }
                }
                if (rec.styleFlagsHasXOffset) {
                    writer.append("x ").append(rec.xOffset).newLine();
                }
                if (rec.styleFlagsHasYOffset) {
                    writer.append("y ").append(rec.yOffset).newLine();
                }
            }
            if (fnt == null) {
                writer.append(AppResources.translate("fontNotFound").replace("%fontId%", Integer.toString(rec.fontId)));
                continue;
            }
            boolean first = true;
            LinkedHashMap<String, Integer> spacing = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> spacingCount = new LinkedHashMap<String, Integer>();
            LinkedHashSet<String> ignoredSpacings = new LinkedHashSet<String>();
            LinkedHashMap charToSpacing = new LinkedHashMap();
            LinkedHashSet<Character> noSpacing = new LinkedHashSet<Character>();
            LinkedHashMap<Character, Integer> charCount = new LinkedHashMap<Character, Integer>();
            if (rec.glyphEntries.size() > 1) {
                for (int i = 0; i < rec.glyphEntries.size(); ++i) {
                    GLYPHENTRY ge = rec.glyphEntries.get(i);
                    char c = fnt.glyphToChar(ge.glyphIndex);
                    Character nextChar = null;
                    if (i + 1 < rec.glyphEntries.size()) {
                        GLYPHENTRY nge = rec.glyphEntries.get(i + 1);
                        nextChar = Character.valueOf(fnt.glyphToChar(nge.glyphIndex));
                    }
                    int advance = StaticTextTag.getAdvance(fnt, ge.glyphIndex, textHeight, c, nextChar);
                    int delta = ge.glyphAdvance - advance;
                    String spacingKey = "" + c + (nextChar == null ? "" : nextChar);
                    int spacingVal = delta - letterSpacing;
                    if (!charToSpacing.containsKey(Character.valueOf(c))) {
                        charToSpacing.put(Character.valueOf(c), new LinkedHashSet());
                    }
                    ((Set)charToSpacing.get(Character.valueOf(c))).add(spacingVal);
                    if (!charCount.containsKey(Character.valueOf(c))) {
                        charCount.put(Character.valueOf(c), 0);
                    }
                    charCount.put(Character.valueOf(c), (Integer)charCount.get(Character.valueOf(c)) + 1);
                    if (delta != letterSpacing && !ignoreLetterSpacing) {
                        if (ignoredSpacings.contains(spacingKey)) continue;
                        if (spacing.containsKey(spacingKey) && (Integer)spacing.get(spacingKey) != spacingVal) {
                            spacing.remove(spacingKey);
                            spacingCount.remove(spacingKey);
                            ignoredSpacings.add(spacingKey);
                            continue;
                        }
                        spacing.put(spacingKey, spacingVal);
                        if (!spacingCount.containsKey(spacingKey)) {
                            spacingCount.put(spacingKey, 0);
                        }
                        spacingCount.put(spacingKey, (Integer)spacingCount.get(spacingKey) + 1);
                        continue;
                    }
                    noSpacing.add(Character.valueOf(c));
                }
            }
            ArrayList spacingKeys = new ArrayList(spacing.keySet());
            LinkedHashMap<Character, Integer> simpleSpacing = new LinkedHashMap<Character, Integer>();
            for (String spacingKey : spacingKeys) {
                Character c = Character.valueOf(spacingKey.charAt(0));
                if (((Set)charToSpacing.get(c)).size() != 1 || (Integer)charCount.get(c) <= 1) continue;
                spacing.remove(spacingKey);
                simpleSpacing.put(c, (Integer)((Set)charToSpacing.get(c)).iterator().next());
            }
            if (!(rec.styleFlagsHasFont || rec.styleFlagsHasColor || rec.styleFlagsHasXOffset || rec.styleFlagsHasYOffset || simpleSpacing.isEmpty() && spacing.isEmpty())) {
                writer.append("[").newLine().append("resetspacing").newLine();
            }
            if (!simpleSpacing.isEmpty()) {
                for (Character c : simpleSpacing.keySet()) {
                    writer.append("spacing \"").append(Helper.escapeString("" + c)).append("\"");
                    writer.append(" ");
                    writer.append((Integer)simpleSpacing.get(c));
                    writer.newLine();
                }
            }
            if (!spacing.isEmpty()) {
                for (String spacingKey : spacing.keySet()) {
                    writer.append("spacingpair \"").append(Helper.escapeString("" + spacingKey.charAt(0))).append("\"");
                    writer.append(" ");
                    if (spacingKey.length() > 1) {
                        writer.append("\"").append(spacingKey.charAt(1)).append("\"");
                    } else {
                        writer.append("\"\"");
                    }
                    writer.append(" ");
                    writer.append((Integer)spacing.get(spacingKey));
                    writer.newLine();
                }
            }
            if (rec.styleFlagsHasFont || rec.styleFlagsHasColor || rec.styleFlagsHasXOffset || rec.styleFlagsHasYOffset || !simpleSpacing.isEmpty() || !spacing.isEmpty()) {
                writer.append("]");
            }
            for (int i = 0; i < rec.glyphEntries.size(); ++i) {
                int advance;
                int delta;
                String spacingKey;
                GLYPHENTRY ge = rec.glyphEntries.get(i);
                char c = fnt.glyphToChar(ge.glyphIndex);
                String sc = ("" + c).replace("[", "\\[").replace("]", "\\]");
                writer.hilightSpecial(sc, HighlightSpecialType.TEXT);
                if (ignoreLetterSpacing) continue;
                Character nextChar = null;
                if (i + 1 < rec.glyphEntries.size()) {
                    GLYPHENTRY nge = rec.glyphEntries.get(i + 1);
                    nextChar = Character.valueOf(fnt.glyphToChar(nge.glyphIndex));
                }
                if (spacing.containsKey(spacingKey = "" + c + (nextChar == null ? "" : nextChar)) || simpleSpacing.containsKey(Character.valueOf(c)) || (delta = ge.glyphAdvance - (advance = StaticTextTag.getAdvance(fnt, ge.glyphIndex, textHeight, c, nextChar))) == letterSpacing || ignoreLetterSpacing) continue;
                writer.append("[space " + (delta - letterSpacing) + "]");
            }
        }
        writer.finishHilights();
        return new HighlightedText(writer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setFormattedText(MissingCharacterHandler missingCharHandler, String formattedText, String[] texts) throws TextParseException {
        try {
            TextLexer lexer = new TextLexer(new StringReader(formattedText));
            ParsedSymbol s = null;
            ArrayList<TEXTRECORD> textRecords = new ArrayList<TEXTRECORD>();
            RGB color = null;
            RGBA colorA = null;
            int fontId = -1;
            int textHeight = -1;
            int letterSpacing = 0;
            FontTag font = null;
            Integer x = null;
            Integer y = null;
            int currentX = 0;
            int currentY = 0;
            int maxX = Integer.MIN_VALUE;
            int minX = Integer.MAX_VALUE;
            MATRIX textMatrix = new MATRIX();
            textMatrix.hasRotate = false;
            textMatrix.hasScale = false;
            RECT textBounds = new RECT();
            int textIdx = 0;
            LinkedHashMap<Character, Integer> simpleSpacing = new LinkedHashMap<Character, Integer>();
            LinkedHashMap<String, Integer> pairSpacing = new LinkedHashMap<String, Integer>();
            boolean append = false;
            while ((s = lexer.yylex()) != null) {
                block23 : switch (s.type) {
                    case PARAMETER_IDENTIFIER: {
                        String paramName;
                        switch (paramName = (String)s.value) {
                            case "font": 
                            case "height": 
                            case "letterspacing": 
                            case "color": 
                            case "x": 
                            case "y": 
                            case "resetspacing": {
                                simpleSpacing.clear();
                                pairSpacing.clear();
                                break;
                            }
                        }
                        if (!paramName.equals("space")) {
                            append = false;
                        }
                        switch (paramName) {
                            case "resetspacing": {
                                break block23;
                            }
                            case "color": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                if (this.getTextNum() == 1) {
                                    Matcher m = Pattern.compile("#([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])").matcher(paramValue);
                                    if (!m.matches()) {
                                        throw new TextParseException("Invalid color. Valid format is #rrggbb. Found: " + paramValue, lexer.yyline());
                                    }
                                    color = new RGB(Integer.parseInt(m.group(1), 16), Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16));
                                    break block23;
                                }
                                Matcher m = Pattern.compile("#([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])").matcher(paramValue);
                                if (!m.matches()) {
                                    throw new TextParseException("Invalid color. Valid format is #aarrggbb. Found: " + paramValue, lexer.yyline());
                                }
                                colorA = new RGBA(Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16), Integer.parseInt(m.group(4), 16), Integer.parseInt(m.group(1), 16));
                                break block23;
                            }
                            case "font": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    fontId = Integer.parseInt(paramValue);
                                    FontTag ft = this.swf.getFont(fontId);
                                    if (ft == null) {
                                        throw new TextParseException("Font not found.", lexer.yyline());
                                    }
                                    font = ft;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid font id - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "height": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textHeight = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid font height - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "letterspacing": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    letterSpacing = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid font letter spacing - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "x": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    x = Integer.parseInt(paramValue);
                                    currentX = x;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid x position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "y": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    y = Integer.parseInt(paramValue);
                                    currentY = y;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid y position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "xmin": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textBounds.Xmin = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmin position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "xmax": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textBounds.Xmax = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmax position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymin": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textBounds.Ymin = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymin position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymax": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textBounds.Ymax = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymax position - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "scalex": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.scaleX = MATRIX.toFloat(Integer.parseInt(paramValue));
                                    textMatrix.hasScale = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid scalex value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "scaley": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.scaleY = MATRIX.toFloat(Integer.parseInt(paramValue));
                                    textMatrix.hasScale = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid scaley value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "scalexf": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.scaleX = Float.parseFloat(paramValue);
                                    textMatrix.hasScale = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid scalexf value - float number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "scaleyf": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.scaleY = Float.parseFloat(paramValue);
                                    textMatrix.hasScale = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid scaleyf value - float number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rotateskew0": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.rotateSkew0 = MATRIX.toFloat(Integer.parseInt(paramValue));
                                    textMatrix.hasRotate = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid rotateskew0 value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rotateskew1": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.rotateSkew1 = MATRIX.toFloat(Integer.parseInt(paramValue));
                                    textMatrix.hasRotate = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid rotateskew1 value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rotateskew0f": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.rotateSkew0 = Float.parseFloat(paramValue);
                                    textMatrix.hasRotate = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid rotateskew0 value - float number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rotateskew1f": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.rotateSkew1 = Float.parseFloat(paramValue);
                                    textMatrix.hasRotate = true;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid rotateskew1 value - float number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "translatex": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.translateX = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid translatex value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "translatey": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    textMatrix.translateY = Integer.parseInt(paramValue);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid translatey value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "space": {
                                s = lexer.yylex();
                                String paramValue = (String)s.value;
                                try {
                                    int space = Integer.parseInt(paramValue);
                                    if (textRecords.isEmpty()) {
                                        throw new TextParseException("space parameter must be placed after some text", lexer.yyline());
                                    }
                                    TEXTRECORD lastRecord = (TEXTRECORD)textRecords.get(textRecords.size() - 1);
                                    if (lastRecord.glyphEntries.isEmpty()) break block23;
                                    lastRecord.glyphEntries.get((int)(lastRecord.glyphEntries.size() - 1)).glyphAdvance += space;
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid space value - number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "spacing": {
                                s = lexer.yylex();
                                String spacingChar = (String)s.value;
                                if (spacingChar.length() != 1) {
                                    throw new TextParseException("Invalid spacing character - single character expected. Found: " + (String)s.value, lexer.yyline());
                                }
                                s = lexer.yylex();
                                try {
                                    int space = Integer.parseInt((String)s.value);
                                    simpleSpacing.put(Character.valueOf(spacingChar.charAt(0)), space);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid spacing value - number expected. Found: " + (String)s.value, lexer.yyline());
                                }
                            }
                            case "spacingpair": {
                                s = lexer.yylex();
                                String spacingChar1 = (String)s.value;
                                if (spacingChar1.length() != 1) {
                                    throw new TextParseException("Invalid spacing character1 - single character expected. Found: " + (String)s.value, lexer.yyline());
                                }
                                s = lexer.yylex();
                                String spacingChar2 = (String)s.value;
                                if (spacingChar2.length() > 1) {
                                    throw new TextParseException("Invalid spacing character2 - single character expected. Found: " + (String)s.value, lexer.yyline());
                                }
                                s = lexer.yylex();
                                try {
                                    int space = Integer.parseInt((String)s.value);
                                    pairSpacing.put(spacingChar1 + spacingChar2, space);
                                    break block23;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid spacing value - number expected. Found: " + (String)s.value, lexer.yyline());
                                }
                            }
                            default: {
                                throw new TextParseException("Unrecognized parameter name: " + paramName, lexer.yyline());
                            }
                        }
                    }
                    case TEXT: {
                        int advance;
                        TEXTRECORD tr;
                        String txt;
                        String string = txt = texts == null || textIdx >= texts.length ? (String)s.value : texts[textIdx++];
                        if (txt == null || font == null && txt.isEmpty()) break;
                        if (font == null) {
                            throw new TextParseException("Font not defined", lexer.yyline());
                        }
                        while (!(txt.isEmpty() || txt.charAt(0) != '\r' && txt.charAt(0) != '\n')) {
                            txt = txt.substring(1);
                        }
                        while (!(txt.isEmpty() || txt.charAt(txt.length() - 1) != '\r' && txt.charAt(txt.length() - 1) != '\n')) {
                            txt = txt.substring(0, txt.length() - 1);
                        }
                        StringBuilder txtSb = new StringBuilder();
                        for (int i = 0; i < txt.length(); ++i) {
                            char c = txt.charAt(i);
                            if (!font.containsChar(c)) {
                                if (missingCharHandler.handle(this, font, c)) {
                                    return this.setFormattedText(missingCharHandler, formattedText, texts);
                                }
                                if (missingCharHandler.getIgnoreMissingCharacters()) continue;
                                return false;
                            }
                            txtSb.append(c);
                        }
                        txt = txtSb.toString();
                        if (append) {
                            tr = (TEXTRECORD)textRecords.get(textRecords.size() - 1);
                        } else {
                            tr = new TEXTRECORD();
                            textRecords.add(tr);
                            if (fontId > -1) {
                                tr.fontId = fontId;
                                tr.textHeight = textHeight;
                                fontId = -1;
                                tr.styleFlagsHasFont = true;
                            }
                            if (this.getTextNum() == 1) {
                                if (color != null) {
                                    tr.textColor = color;
                                    tr.styleFlagsHasColor = true;
                                    color = null;
                                }
                            } else if (colorA != null) {
                                tr.textColorA = colorA;
                                tr.styleFlagsHasColor = true;
                                colorA = null;
                            }
                            if (x != null) {
                                tr.xOffset = x;
                                tr.styleFlagsHasXOffset = true;
                                x = null;
                            }
                            if (y != null) {
                                tr.yOffset = y;
                                tr.styleFlagsHasYOffset = true;
                                y = null;
                            }
                            tr.glyphEntries = new ArrayList<GLYPHENTRY>(txt.length());
                        }
                        for (int i = 0; i < txt.length(); currentX += advance, ++i) {
                            String pairKey;
                            char c = txt.charAt(i);
                            Character nextChar = null;
                            if (i + 1 < txt.length()) {
                                nextChar = Character.valueOf(txt.charAt(i + 1));
                            }
                            GLYPHENTRY ge = new GLYPHENTRY();
                            ge.glyphIndex = font.charToGlyph(c);
                            advance = StaticTextTag.getAdvance(font, ge.glyphIndex, textHeight, c, nextChar);
                            advance += letterSpacing;
                            if (simpleSpacing.containsKey(Character.valueOf(c))) {
                                advance += (Integer)simpleSpacing.get(Character.valueOf(c)) - letterSpacing;
                            }
                            if (pairSpacing.containsKey(pairKey = "" + c + (nextChar == null ? "" : nextChar))) {
                                advance += (Integer)pairSpacing.get(pairKey) - letterSpacing;
                            }
                            ge.glyphAdvance = advance;
                            tr.glyphEntries.add(ge);
                        }
                        if (currentX > maxX) {
                            maxX = currentX;
                        }
                        if (currentX < minX) {
                            minX = currentX;
                        }
                        append = true;
                        break;
                    }
                }
            }
            this.setModified(true);
            this.textRecords = textRecords;
            this.textMatrix = textMatrix;
            this.textBounds = textBounds;
        }
        catch (IOException ex) {
            return false;
        }
        catch (TextParseException ex) {
            throw ex;
        }
        this.updateTextBounds();
        return true;
    }

    public static int getAdvance(FontTag font, int glyphIndex, int textHeight, char c, Character nextChar) {
        int advance;
        if (font.hasLayout()) {
            int kerningAdjustment = 0;
            if (nextChar != null) {
                kerningAdjustment = font.getCharKerningAdjustment(c, nextChar.charValue());
            }
            advance = (int)Math.round((double)textHeight * (font.getGlyphAdvance(glyphIndex) + (double)kerningAdjustment) / (font.getDivider() * 1024.0));
        } else {
            String fontName = font.getSystemFontName();
            advance = (int)Math.round(20.0 * (double)FontTag.getSystemFontAdvance(fontName, font.getFontStyle(), (int)((double)textHeight / 20.0), Character.valueOf(c), nextChar));
        }
        return advance;
    }

    public static int detectLetterSpacing(TEXTRECORD textRecord, FontTag font, int textHeight) {
        int minLetterSpacing = Integer.MAX_VALUE;
        int numNegatives = 0;
        List<GLYPHENTRY> glyphEntries = textRecord.glyphEntries;
        if (glyphEntries.size() < 2) {
            return 0;
        }
        int numMin = 0;
        for (int i = 0; i < glyphEntries.size() - 1; ++i) {
            Character nextChar;
            GLYPHENTRY glyph = glyphEntries.get(i);
            GLYPHENTRY nextGlyph = glyphEntries.get(i + 1);
            char c = font.glyphToChar(glyph.glyphIndex);
            int advance = StaticTextTag.getAdvance(font, glyph.glyphIndex, textHeight, c, nextChar = Character.valueOf(font.glyphToChar(nextGlyph.glyphIndex)));
            int letterSpacing = glyph.glyphAdvance - advance;
            if (letterSpacing < 0) {
                ++numNegatives;
            }
            if (letterSpacing == minLetterSpacing) {
                ++numMin;
            }
            if (letterSpacing >= minLetterSpacing) continue;
            minLetterSpacing = letterSpacing;
            numMin = 1;
        }
        if (minLetterSpacing < 0 && numNegatives < glyphEntries.size() / 2) {
            minLetterSpacing = 0;
        }
        if (numMin == 1) {
            return 0;
        }
        return minLetterSpacing;
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed, SWF swf) {
        for (TEXTRECORD tr : this.textRecords) {
            if (!tr.styleFlagsHasFont) continue;
            needed.add(tr.fontId);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (TEXTRECORD tr : this.textRecords) {
            if (tr.fontId != oldCharacterId) continue;
            tr.fontId = newCharacterId;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (TEXTRECORD tr : this.textRecords) {
            if (tr.fontId != characterId) continue;
            tr.styleFlagsHasFont = false;
            tr.fontId = 0;
            modified = true;
        }
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public int getUsedParameters() {
        return 0;
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing) {
        int realTextId;
        RequiresNormalizedFonts g;
        Map<Integer, TextTag> normalizedTexts;
        if (image.getGraphics() instanceof RequiresNormalizedFonts && (normalizedTexts = (g = (RequiresNormalizedFonts)((Object)image.getGraphics())).getNormalizedTexts()).containsKey(realTextId = this.getSwf().getCharacterId(this)) && normalizedTexts.get(realTextId) instanceof StaticTextTag) {
            StaticTextTag normalizedText = (StaticTextTag)normalizedTexts.get(realTextId);
            StaticTextTag.staticTextToImage(this.swf, normalizedText.textRecords, this.getTextNum(), image, normalizedText.textMatrix, transformation, colorTransform, renderContext.selectionText == this ? renderContext.selectionStart : 0, renderContext.selectionText == this ? renderContext.selectionEnd : 0);
            return;
        }
        StaticTextTag.staticTextToImage(this.swf, this.textRecords, this.getTextNum(), image, this.textMatrix, transformation, colorTransform, renderContext.selectionText == this ? renderContext.selectionStart : 0, renderContext.selectionText == this ? renderContext.selectionEnd : 0);
    }

    @Override
    public void toSVG(SVGExporter exporter, int ratio, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) {
        int realTextId = this.getSwf().getCharacterId(this);
        if (exporter.getNormalizedTexts().containsKey(realTextId) && exporter.getNormalizedTexts().get(realTextId) instanceof StaticTextTag) {
            StaticTextTag normalizedText = (StaticTextTag)exporter.getNormalizedTexts().get(realTextId);
            StaticTextTag.staticTextToSVG(this.swf, normalizedText.textRecords, this.getTextNum(), exporter, this.getRect(), normalizedText.textMatrix, colorTransform, exporter.getZoom(), transformation);
            return;
        }
        StaticTextTag.staticTextToSVG(this.swf, this.textRecords, this.getTextNum(), exporter, this.getRect(), this.textMatrix, colorTransform, exporter.getZoom(), transformation);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        StaticTextTag.staticTextToHtmlCanvas(unitDivisor, this.swf, this.textRecords, this.getTextNum(), result, this.textBounds, this.textMatrix, null);
    }
}

