/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.Openable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import natorder.NaturalOrderComparator;

public class AS3Package
extends AS3ClassTreeItem {
    private final Openable openable;
    public String packageName;
    private final String DEFAULT_PACKAGE_NAME = AppResources.translate("package.default");
    private final Map<String, AS3Package> subPackages = new TreeMap<String, AS3Package>(new Comparator<String>(){
        NaturalOrderComparator naturalOrderComparator = new NaturalOrderComparator();

        @Override
        public int compare(String o1, String o2) {
            if (Objects.equals(o1, o2)) {
                return 0;
            }
            if (AS3Package.this.DEFAULT_PACKAGE_NAME.equals(o1)) {
                return -1;
            }
            if (AS3Package.this.DEFAULT_PACKAGE_NAME.equals(o2)) {
                return 1;
            }
            return this.naturalOrderComparator.compare(o1, o2);
        }
    });
    private final Map<String, ScriptPack> scripts = new TreeMap<String, ScriptPack>(new NaturalOrderComparator());
    private List<AS3Package> sortedPackages;
    private List<ScriptPack> sortedScripts;
    private final boolean flat;
    private final boolean defaultPackage;
    private final Integer compoundScriptIndex;
    private final ABC abc;
    private ScriptPack compoundInitializerPack = null;
    private final boolean partOfCompoundScript;

    public AS3Package(String packageName, Openable openable, boolean flat, boolean defaultPackage, ABC abc, boolean partOfCompoundScript, Integer compoundScriptIndex) {
        super(packageName, "", null);
        this.flat = flat;
        this.openable = openable;
        this.packageName = packageName;
        this.defaultPackage = defaultPackage;
        this.compoundScriptIndex = compoundScriptIndex;
        this.abc = abc;
        this.partOfCompoundScript = partOfCompoundScript;
    }

    public boolean isPartOfCompoundScript() {
        return this.partOfCompoundScript;
    }

    public void setCompoundInitializerPack(ScriptPack compoundInitializerPack) {
        this.compoundInitializerPack = compoundInitializerPack;
    }

    public ScriptPack getCompoundInitializerPack() {
        return this.compoundInitializerPack;
    }

    public boolean isDefaultPackage() {
        return this.defaultPackage;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public boolean isCompoundScript() {
        return this.compoundScriptIndex != null;
    }

    public Integer getCompoundScriptIndex() {
        return this.compoundScriptIndex;
    }

    public ABC getAbc() {
        return this.abc;
    }

    @Override
    public Openable getOpenable() {
        return this.openable;
    }

    public List<AS3Package> getSubPackages() {
        if (this.sortedPackages == null) {
            ArrayList<AS3Package> list = new ArrayList<AS3Package>();
            for (AS3Package subPackage : this.subPackages.values()) {
                list.add(subPackage);
            }
            this.sortedPackages = list;
        }
        return this.sortedPackages;
    }

    public List<ScriptPack> getScriptPacks() {
        if (this.sortedScripts == null) {
            ArrayList<ScriptPack> list = new ArrayList<ScriptPack>();
            for (ScriptPack script : this.scripts.values()) {
                list.add(script);
            }
            this.sortedScripts = list;
        }
        return this.sortedScripts;
    }

    public void addScriptPack(ScriptPack script) {
        this.scripts.put(script.getPrintableNameWithNamespaceSuffix(), script);
        this.sortedScripts = null;
    }

    public void addSubPackage(AS3Package subPackage) {
        this.subPackages.put(subPackage.getNameWithNamespaceSuffix(), subPackage);
        this.sortedPackages = null;
    }

    public AS3Package getSubPackage(String packageName) {
        return this.subPackages.get(packageName);
    }

    public List<AS3ClassTreeItem> getAllChildren() {
        ArrayList<AS3ClassTreeItem> result = new ArrayList<AS3ClassTreeItem>(this.getChildCount());
        result.addAll(this.subPackages.values());
        result.addAll(this.getScriptPacks());
        return result;
    }

    public AS3ClassTreeItem getChild(int index) {
        if (index < this.subPackages.size()) {
            return this.getSubPackages().get(index);
        }
        if ((index -= this.subPackages.size()) < this.getScriptPacks().size()) {
            return this.getScriptPacks().get(index);
        }
        return null;
    }

    public int getChildCount() {
        return this.subPackages.size() + this.getScriptPacks().size();
    }

    public int getIndexOfChild(AS3ClassTreeItem child) {
        int res = 0;
        if (child instanceof AS3Package) {
            for (AS3Package pkg : this.subPackages.values()) {
                if (pkg.packageName.equals(((AS3Package)child).packageName)) break;
                ++res;
            }
            return res;
        }
        res = this.subPackages.size();
        for (ScriptPack pack : this.scripts.values()) {
            if (pack.equals(child)) break;
            ++res;
        }
        return res;
    }

    public void clear() {
        this.subPackages.clear();
        this.scripts.clear();
        this.sortedPackages = null;
        this.sortedScripts = null;
    }

    @Override
    public String toString() {
        if (this.flat) {
            return this.packageName;
        }
        return this.packageName;
    }

    @Override
    public boolean isModified() {
        List<ScriptPack> sps = this.getScriptPacks();
        for (ScriptPack sp : sps) {
            if (!sp.isModified()) continue;
            return true;
        }
        List<AS3Package> ps = this.getSubPackages();
        for (AS3Package p : ps) {
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected SWF getSwf() {
        Openable op = this.getOpenable();
        if (op instanceof SWF) {
            return (SWF)op;
        }
        if (op instanceof ABC) {
            return ((ABC)op).getSwf();
        }
        return null;
    }
}

