/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.Exportable;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public class Frame
implements TreeItem,
Exportable {
    public final int frame;
    public TreeMap<Integer, DepthState> layers = new TreeMap();
    public RGB backgroundColor = new RGBA(0, 0, 0, 0);
    public final Timeline timeline;
    public List<Integer> sounds = new ArrayList<Integer>();
    public List<String> soundClasses = new ArrayList<String>();
    public List<SOUNDINFO> soundInfos = new ArrayList<SOUNDINFO>();
    public List<DoActionTag> actions = new ArrayList<DoActionTag>();
    public List<ASMSourceContainer> actionContainers = new ArrayList<ASMSourceContainer>();
    public List<Tag> innerTags = new ArrayList<Tag>();
    public List<Tag> allInnerTags = new ArrayList<Tag>();
    public ShowFrameTag showFrameTag = null;
    public boolean layersChanged;
    public List<String> labels = new ArrayList<String>();
    public List<Boolean> namedAnchors = new ArrayList<Boolean>();

    public Frame(Timeline timeline, int frame) {
        this.timeline = timeline;
        this.frame = frame;
    }

    public Frame(Frame obj, int frame) {
        this.frame = frame;
        this.layers = new TreeMap();
        this.backgroundColor = obj.backgroundColor;
        this.timeline = obj.timeline;
        for (int depth : obj.layers.keySet()) {
            this.layers.put(depth, new DepthState(obj.layers.get(depth), this, obj.layers.get((Object)Integer.valueOf((int)depth)).placeFrame, true));
        }
    }

    @Override
    public Openable getOpenable() {
        return this.timeline.swf;
    }

    public String toString() {
        String name = "frame " + (this.frame + 1);
        ArrayList<String> labels = new ArrayList<String>();
        for (Tag t : this.innerTags) {
            if (!(t instanceof FrameLabelTag)) continue;
            labels.add("\"" + Helper.escapePCodeString(((FrameLabelTag)t).name) + "\"");
        }
        if (!labels.isEmpty()) {
            name = name + " (name: " + String.join((CharSequence)", ", labels) + ")";
        }
        if (this.allInnerTags.isEmpty() || !(this.allInnerTags.get(this.allInnerTags.size() - 1) instanceof ShowFrameTag)) {
            name = name + " - " + AppResources.translate("frame.withoutShowFrame");
        }
        return name;
    }

    @Override
    public String getExportFileName() {
        return "frame_" + (this.frame + 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Frame) {
            Frame frameObj = (Frame)obj;
            return Objects.equals(this.timeline, frameObj.timeline) && this.frame == frameObj.frame;
        }
        return false;
    }

    public int hashCode() {
        return this.timeline.hashCode() ^ Integer.hashCode(this.frame);
    }

    public boolean isAllInnerTagsModified() {
        for (Tag t : this.allInnerTags) {
            if (!t.isModified() || t.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isModified() {
        for (Tag tag : this.innerTags) {
            if (!tag.isModified() || tag.isReadOnly()) continue;
            return true;
        }
        for (Tag tag : this.actions) {
            if (!tag.isModified() || tag.isReadOnly()) continue;
            return true;
        }
        for (ASMSourceContainer aSMSourceContainer : this.actionContainers) {
            if (!aSMSourceContainer.isModified()) continue;
            return true;
        }
        return this.showFrameTag != null && this.showFrameTag.isModified() && !this.showFrameTag.isReadOnly();
    }

    public void getNeededCharacters(Set<Integer> needed) {
        for (Tag t : this.innerTags) {
            PlaceObjectTypeTag place;
            int characterId;
            if (!(t instanceof PlaceObjectTypeTag) || (characterId = (place = (PlaceObjectTypeTag)t).getCharacterId()) == -1) continue;
            needed.add(characterId);
        }
    }

    public void getNeededCharactersDeep(Set<Integer> needed) {
        for (Tag t : this.innerTags) {
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            PlaceObjectTypeTag place = (PlaceObjectTypeTag)t;
            int characterId = ((PlaceObjectTypeTag)t).getCharacterId();
            if (characterId == -1) continue;
            CharacterTag character = place.getSwf().getCharacter(characterId);
            if (character != null) {
                character.getNeededCharactersDeep(needed);
            }
            needed.add(characterId);
        }
    }
}

