/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Scene;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.Objects;

public class SceneFrame
implements TreeItem {
    private final SWF swf;
    private final Scene scene;
    private final int realFrameIndex;

    public SceneFrame(SWF swf, Scene scene, int realFrameIndex) {
        this.swf = swf;
        this.scene = scene;
        this.realFrameIndex = realFrameIndex;
    }

    public int getSceneFrameIndex() {
        return this.realFrameIndex - this.scene.startFrame;
    }

    public Frame getFrame() {
        return this.swf.getTimeline().getFrame(this.realFrameIndex);
    }

    public String toString() {
        return "scene frame " + (this.getSceneFrameIndex() + 1);
    }

    @Override
    public Openable getOpenable() {
        return this.swf;
    }

    @Override
    public boolean isModified() {
        return this.getFrame().isModified();
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + Objects.hashCode(this.scene);
        hash = 47 * hash + this.realFrameIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SceneFrame other = (SceneFrame)obj;
        if (this.realFrameIndex != other.realFrameIndex) {
            return false;
        }
        return Objects.equals(this.scene, other.scene);
    }
}

