/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.TagRemoveListener;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.BlendModeSettable;
import com.jpexs.decompiler.flash.exporters.FrameExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSceneAndFrameLabelDataTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.StartSound2Tag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DisplayObjectCacheKey;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.StaticTextTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.gfx.DefineExternalStreamSound;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.Clip;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Scene;
import com.jpexs.decompiler.flash.timeline.SoundStreamFrameRange;
import com.jpexs.decompiler.flash.timeline.SvgClip;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.ILINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.filters.BlendComposite;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import org.w3c.dom.Element;

public class Timeline {
    public int id;
    public SWF swf;
    public RECT displayRect;
    public float frameRate;
    public Timelined timelined;
    public int maxDepth;
    public int fontFrameNum = -1;
    private final List<Frame> frames = new ArrayList<Frame>();
    private final Map<Integer, Integer> depthMaxFrame = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> depthMaxFrameButtons = new HashMap<Integer, Integer>();
    public final List<ASMSource> asmSources = new ArrayList<ASMSource>();
    private final List<ASMSourceContainer> asmSourceContainers = new ArrayList<ASMSourceContainer>();
    private final Map<ASMSource, Integer> actionFrames = new HashMap<ASMSource, Integer>();
    private final Map<Integer, List<SoundStreamFrameRange>> soundStreamRanges = new LinkedHashMap<Integer, List<SoundStreamFrameRange>>();
    private AS2Package as2RootPackage;
    public final List<Tag> otherTags = new ArrayList<Tag>();
    private boolean initialized = false;
    private Map<String, Integer> labelToFrame = new HashMap<String, Integer>();
    private List<Scene> scenes = new ArrayList<Scene>();
    public static final int DRAW_MODE_ALL = 0;
    public static final int DRAW_MODE_SHAPES = 1;
    public static final int DRAW_MODE_SPRITES = 2;
    private static final DecimalFormat svgPathDecimalFormat;

    private static String formatDoubleSvg(double value) {
        return svgPathDecimalFormat.format(value);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public synchronized List<Frame> getFrames() {
        this.ensureInitialized();
        return this.frames;
    }

    public synchronized Frame getFrame(int index) {
        this.ensureInitialized();
        if (index >= this.frames.size()) {
            return null;
        }
        return this.frames.get(index);
    }

    public synchronized DepthState getDepthState(int frame, int depth) {
        Frame fr = this.getFrame(frame);
        if (fr == null) {
            return null;
        }
        return fr.layers.get(depth);
    }

    public synchronized void addFrame(Frame frame) {
        this.ensureInitialized();
        this.frames.add(frame);
        this.maxDepth = this.getMaxDepthInternal();
        this.calculateMaxDepthFrames();
    }

    public AS2Package getAS2RootPackage() {
        this.ensureInitialized();
        return this.as2RootPackage;
    }

    public Map<Integer, Integer> getDepthMaxFrame() {
        this.ensureInitialized();
        return this.depthMaxFrame;
    }

    public Map<Integer, Integer> getDepthMaxFrameButtons() {
        this.ensureInitialized();
        return this.depthMaxFrameButtons;
    }

    public List<SoundStreamFrameRange> getSoundStreamBlocks(SoundStreamHeadTypeTag head) {
        this.ensureInitialized();
        return this.soundStreamRanges.get(head.getCharacterId());
    }

    public Tag getParentTag() {
        return this.timelined instanceof Tag ? (Tag)((Object)this.timelined) : null;
    }

    public void reset(SWF swf) {
        this.reset(swf, swf, 0, swf.displayRect);
    }

    public synchronized void reset(SWF swf, Timelined timelined, int id, RECT displayRect) {
        this.initialized = false;
        this.frames.clear();
        this.depthMaxFrame.clear();
        this.depthMaxFrameButtons.clear();
        this.asmSources.clear();
        this.asmSourceContainers.clear();
        this.actionFrames.clear();
        this.soundStreamRanges.clear();
        this.otherTags.clear();
        this.id = id;
        this.swf = swf;
        this.displayRect = displayRect;
        this.frameRate = swf.frameRate;
        this.timelined = timelined;
        this.as2RootPackage = new AS2Package(null, null, swf, false, false);
    }

    public final int getMaxDepth() {
        this.ensureInitialized();
        return this.maxDepth;
    }

    private synchronized int getMaxDepthInternal() {
        int max_depth = 0;
        for (Frame f : this.frames) {
            for (int depth : f.layers.keySet()) {
                int clipDepth;
                if (depth > max_depth) {
                    max_depth = depth;
                }
                if ((clipDepth = f.layers.get((Object)Integer.valueOf((int)depth)).clipDepth) <= max_depth) continue;
                max_depth = clipDepth;
            }
        }
        return max_depth;
    }

    public synchronized int getFrameCount() {
        this.ensureInitialized();
        return this.frames.size();
    }

    public synchronized int getRealFrameCount() {
        this.ensureInitialized();
        int cnt = 1;
        for (int i = 1; i < this.frames.size(); ++i) {
            if (!this.frames.get((int)i).actions.isEmpty()) {
                ++cnt;
                continue;
            }
            if (!this.frames.get((int)i).layersChanged) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getFrameForAction(ASMSource asm) {
        Integer frame = this.actionFrames.get(asm);
        if (frame == null) {
            return -1;
        }
        return frame;
    }

    public Timeline(SWF swf) {
        this(swf, swf, 0, swf.displayRect);
    }

    public Timeline(SWF swf, Timelined timelined, int id, RECT displayRect) {
        this.id = id;
        this.swf = swf;
        this.displayRect = displayRect;
        this.frameRate = swf.frameRate;
        this.timelined = timelined;
        this.as2RootPackage = new AS2Package(null, null, swf, false, false);
    }

    public int getFrameWithLabel(String label) {
        if (this.labelToFrame.containsKey(label)) {
            return this.labelToFrame.get(label);
        }
        return -1;
    }

    private synchronized void initialize() {
        int frameIdx = 0;
        Frame frame = new Frame(this, frameIdx++);
        frame.layersChanged = true;
        boolean newFrameNeeded = false;
        this.scenes = new ArrayList<Scene>();
        Scene prevScene = null;
        ArrayList<Tag> tagList = this.timelined.getTags().toArrayList();
        for (Tag t : tagList) {
            int depth;
            ASMSourceContainer asmSourceContainer;
            newFrameNeeded = true;
            boolean isNested = ShowFrameTag.isNestedTagType(t.getId());
            if (isNested) {
                frame.innerTags.add(t);
            }
            frame.allInnerTags.add(t);
            if (this.id == 0 && t instanceof DefineSceneAndFrameLabelDataTag) {
                DefineSceneAndFrameLabelDataTag sceneData = (DefineSceneAndFrameLabelDataTag)t;
                this.scenes = new ArrayList<Scene>();
                for (int i = 0; i < sceneData.sceneNames.length; ++i) {
                    int ioffset = (int)sceneData.sceneOffsets[i];
                    Scene currentScene = new Scene(this.swf, ioffset, -1, sceneData.sceneNames[i]);
                    this.scenes.add(currentScene);
                    if (prevScene != null) {
                        prevScene.endFrame = ioffset - 1;
                    }
                    prevScene = currentScene;
                }
            }
            if (t instanceof ASMSourceContainer && !(asmSourceContainer = (ASMSourceContainer)((Object)t)).getSubItems().isEmpty()) {
                if (isNested) {
                    frame.actionContainers.add(asmSourceContainer);
                } else {
                    this.asmSourceContainers.add(asmSourceContainer);
                }
            }
            if (t instanceof FrameLabelTag) {
                String labelName = ((FrameLabelTag)t).getLabelName();
                frame.labels.add(labelName);
                frame.namedAnchors.add(((FrameLabelTag)t).isNamedAnchor());
                this.labelToFrame.put(labelName, this.frames.size());
                continue;
            }
            if (t instanceof StartSoundTag) {
                frame.sounds.add(((StartSoundTag)t).soundId);
                frame.soundClasses.add(null);
                frame.soundInfos.add(((StartSoundTag)t).soundInfo);
                continue;
            }
            if (t instanceof StartSound2Tag) {
                frame.sounds.add(-1);
                frame.soundClasses.add(((StartSound2Tag)t).soundClassName);
                frame.soundInfos.add(((StartSound2Tag)t).soundInfo);
                continue;
            }
            if (t instanceof SetBackgroundColorTag) {
                frame.backgroundColor = ((SetBackgroundColorTag)t).backgroundColor;
                continue;
            }
            if (t instanceof PlaceObjectTypeTag) {
                String className;
                CharacterTag character;
                boolean wasOccupied;
                PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
                depth = po.getDepth();
                DepthState fl = frame.layers.get(depth);
                if (fl == null) {
                    fl = new DepthState(this.swf, frame, frame);
                    frame.layers.put(depth, fl);
                    fl.depth = depth;
                }
                frame.layersChanged = true;
                fl.placeObjectTag = po;
                fl.placeFrame = frame;
                fl.minPlaceObjectNum = Math.max(fl.minPlaceObjectNum, po.getPlaceObjectNum());
                boolean bl = wasOccupied = fl.characterId != -1 || fl.className != null;
                if (po.flagMove() != wasOccupied) continue;
                int characterId = po.getCharacterId();
                if (characterId != -1) {
                    fl.characterId = characterId;
                    fl.hasImage = po.hasImage();
                }
                if ((character = this.swf.getCharacter(characterId)) instanceof DefineSpriteTag && this.swf.getCyclicCharacters().contains(characterId)) {
                    fl.characterId = -1;
                }
                if ((className = po.getClassName()) != null) {
                    fl.className = className;
                    character = this.swf.getCharacterByClass(className);
                    if (character instanceof DefineSpriteTag && this.swf.getCyclicCharacters().contains(characterId)) {
                        fl.className = null;
                    }
                }
                if (character instanceof FontTag) {
                    fl.characterId = -1;
                    fl.className = null;
                    fl.key = true;
                } else {
                    boolean bl2 = fl.key = characterId != -1 || className != null;
                }
                if (po.flagMove()) {
                    RGBA bgColor;
                    int clipDepth2;
                    int ratio2;
                    List<FILTER> filters2;
                    int blendMode2;
                    CLIPACTIONS clipActions2;
                    String className2;
                    ColorTransform colorTransForm2;
                    String instanceName2;
                    MATRIX matrix2 = po.getMatrix();
                    if (matrix2 != null) {
                        fl.matrix = matrix2;
                    }
                    if ((instanceName2 = po.getInstanceName()) != null) {
                        fl.instanceName = instanceName2;
                    }
                    if ((colorTransForm2 = po.getColorTransform()) != null) {
                        fl.colorTransForm = colorTransForm2;
                    }
                    if ((className2 = po.getClassName()) != null) {
                        fl.className = className2;
                    }
                    if ((clipActions2 = po.getClipActions()) != null) {
                        fl.clipActions = clipActions2;
                    }
                    if (po.cacheAsBitmap()) {
                        fl.cacheAsBitmap = true;
                    }
                    if ((blendMode2 = po.getBlendMode()) > 0) {
                        fl.blendMode = blendMode2;
                    }
                    if ((filters2 = po.getFilters()) != null) {
                        fl.filters = filters2;
                    }
                    if ((ratio2 = po.getRatio()) > -1) {
                        fl.ratio = ratio2;
                    }
                    if ((clipDepth2 = po.getClipDepth()) > -1) {
                        fl.clipDepth = clipDepth2;
                    }
                    if ((bgColor = po.getBackgroundColor()) != null) {
                        fl.backGroundColor = bgColor;
                    }
                    fl.isVisible = po.isVisible();
                    continue;
                }
                fl.matrix = po.getMatrix();
                fl.instanceName = po.getInstanceName();
                fl.colorTransForm = po.getColorTransform();
                fl.cacheAsBitmap = po.cacheAsBitmap();
                fl.blendMode = po.getBlendMode();
                fl.filters = po.getFilters();
                fl.ratio = po.getRatio();
                fl.clipActions = po.getClipActions();
                fl.clipDepth = po.getClipDepth();
                fl.isVisible = po.isVisible();
                fl.backGroundColor = po.getBackgroundColor();
                continue;
            }
            if (t instanceof RemoveTag) {
                RemoveTag r = (RemoveTag)t;
                depth = r.getDepth();
                frame.layers.remove(depth);
                frame.layersChanged = true;
                continue;
            }
            if (t instanceof DoActionTag) {
                frame.actions.add((DoActionTag)t);
                this.actionFrames.put((DoActionTag)t, frame.frame);
                continue;
            }
            if (t instanceof ShowFrameTag) {
                frame.showFrameTag = (ShowFrameTag)t;
                this.frames.add(frame);
                frame = new Frame(frame, frameIdx++);
                newFrameNeeded = false;
                continue;
            }
            if (t instanceof ASMSource) {
                this.asmSources.add((ASMSource)((Object)t));
                continue;
            }
            this.otherTags.add(t);
        }
        if (newFrameNeeded) {
            this.frames.add(frame);
        }
        if (prevScene != null) {
            prevScene.endFrame = this.frames.size() - 1;
        }
        this.maxDepth = this.getMaxDepthInternal();
        this.detectTweens();
        this.calculateMaxDepthFrames();
        this.createASPackages();
        if (this.timelined instanceof SWF) {
            this.populateSoundStreamBlocks(-1, this.timelined.getTags());
        }
        this.initialized = true;
    }

    private synchronized void detectTweens() {
        for (int d = 0; d <= this.maxDepth; ++d) {
            int characterId = -1;
            String charClassName = null;
            MATRIX matrix = null;
            int len = 0;
            for (int f = 0; f <= this.frames.size(); ++f) {
                DepthState ds;
                DepthState depthState = ds = f >= this.frames.size() ? null : this.frames.get((int)f).layers.get(d);
                if (ds != null && (characterId != -1 || charClassName != null) && ds.characterId == characterId && Objects.equals(ds.className, charClassName) && (ds.getCharacter() instanceof MorphShapeTag || Objects.equals(ds.matrix, matrix))) {
                    ++len;
                } else {
                    len = 1;
                    if (ds != null) {
                        ds.key = true;
                    }
                }
                characterId = ds == null ? -1 : ds.characterId;
                charClassName = ds == null ? null : ds.className;
                matrix = ds == null ? null : ds.matrix;
            }
        }
    }

    private synchronized void calculateMaxDepthFrames() {
        this.depthMaxFrame.clear();
        this.depthMaxFrameButtons.clear();
        block0: for (int d = 0; d <= this.maxDepth; ++d) {
            for (int f = this.frames.size() - 1; f >= 0; --f) {
                if (this.frames.get((int)f).layers.get(d) == null) continue;
                this.depthMaxFrame.put(d, f);
                continue block0;
            }
        }
        if (this.timelined instanceof ButtonTag) {
            ButtonTag button = (ButtonTag)this.timelined;
            Set<Integer> emptyFrames = button.getEmptyFrames();
            block2: for (int d = 0; d <= this.maxDepth; ++d) {
                for (int f = this.frames.size() - 1; f >= 0; --f) {
                    if (this.frames.get((int)f).layers.get(d) == null || emptyFrames.contains(f)) continue;
                    this.depthMaxFrameButtons.put(d, f);
                    continue block2;
                }
            }
        } else {
            this.depthMaxFrameButtons.putAll(this.depthMaxFrame);
        }
    }

    private void createASPackages() {
        for (ASMSource asm : this.asmSources) {
            String[] stringArray;
            if (!(asm instanceof DoInitActionTag)) continue;
            DoInitActionTag initAction = (DoInitActionTag)asm;
            String path = this.swf.getExportName(initAction.spriteId);
            if (path == null) continue;
            if (path.isEmpty()) {
                path = initAction.getExportFileName();
            }
            if (path.contains(".")) {
                stringArray = path.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = path;
            }
            String[] pathParts = stringArray;
            AS2Package pkg = this.as2RootPackage;
            boolean isNamedPackages = "__Packages".equals(pathParts[0]);
            for (int pos = 0; pos < pathParts.length - 1; ++pos) {
                AS2Package subPkg;
                if (Configuration.flattenASPackages.get().booleanValue() && (!isNamedPackages || pos != 0)) {
                    String fullPath = isNamedPackages ? path.substring(pathParts[0].length() + 1, path.length() - pathParts[pathParts.length - 1].length() - 1) : path.substring(0, path.length() - pathParts[pathParts.length - 1].length() - 1);
                    subPkg = pkg.subPackages.get(fullPath);
                    if (subPkg == null) {
                        subPkg = new AS2Package(fullPath, pkg, this.swf, true, false);
                        pkg.subPackages.put(fullPath, subPkg);
                    }
                    pkg = subPkg;
                    break;
                }
                String pathPart = pathParts[pos];
                subPkg = pkg.subPackages.get(pathPart);
                if (subPkg == null) {
                    subPkg = new AS2Package(pathPart, pkg, this.swf, false, false);
                    pkg.subPackages.put(pathPart, subPkg);
                }
                pkg = subPkg;
            }
            if (Configuration.flattenASPackages.get().booleanValue() && (pathParts.length == 2 && isNamedPackages || pathParts.length == 1)) {
                String fullPath = AppResources.translate("package.default");
                AS2Package subPkg = pkg.subPackages.get(fullPath);
                if (subPkg == null) {
                    subPkg = new AS2Package(fullPath, pkg, this.swf, true, true);
                    pkg.subPackages.put(fullPath, subPkg);
                }
                pkg = subPkg;
            }
            pkg.scripts.put(pathParts[pathParts.length - 1], asm);
        }
    }

    private void populateSoundStreamBlocks(int containerId, Iterable<Tag> tags) {
        ArrayList<SoundStreamFrameRange> ranges = null;
        SoundStreamFrameRange range = null;
        int MIN_NUM_FRAMES_NO_SOUND = 2;
        int numFramesNoSound = 2;
        boolean frameHasSound = false;
        int frame = 0;
        SoundStreamHeadTypeTag head = null;
        ArrayList<Integer> sceneOffsets = new ArrayList<Integer>();
        for (Tag t : tags) {
            if (containerId == -1 && t instanceof DefineSceneAndFrameLabelDataTag) {
                DefineSceneAndFrameLabelDataTag sceneFrameData = (DefineSceneAndFrameLabelDataTag)t;
                long[] lArray = sceneFrameData.sceneOffsets;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long offset = lArray[i];
                    sceneOffsets.add((int)offset.longValue());
                }
            }
            if (t instanceof SoundStreamHeadTypeTag) {
                head = (SoundStreamHeadTypeTag)t;
                head.setCharacterId(containerId);
                ranges = new ArrayList<SoundStreamFrameRange>();
                range = new SoundStreamFrameRange(head);
                range.startFrame = -1;
                range.endFrame = -1;
                numFramesNoSound = 2;
                this.soundStreamRanges.put(containerId, ranges);
                continue;
            }
            if (t instanceof DefineExternalStreamSound) {
                DefineExternalStreamSound externalStream = (DefineExternalStreamSound)t;
                externalStream.setCharacterId(containerId);
                continue;
            }
            if (t instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)t;
                this.populateSoundStreamBlocks(sprite.getCharacterId(), sprite.getTags());
            }
            if (t instanceof ShowFrameTag) {
                ++frame;
                numFramesNoSound = frameHasSound ? 0 : ++numFramesNoSound;
                frameHasSound = false;
                if (sceneOffsets.contains(frame) && range != null) {
                    if (range.endFrame > -1) {
                        ranges.add(range);
                    }
                    range = new SoundStreamFrameRange(head);
                    range.startFrame = -1;
                    range.endFrame = -1;
                }
            }
            if (ranges == null || range == null || !(t instanceof SoundStreamBlockTag)) continue;
            if (numFramesNoSound >= 2 && range.endFrame > -1) {
                ranges.add(range);
                range = new SoundStreamFrameRange(head);
                range.startFrame = -1;
                range.endFrame = -1;
            }
            range.blocks.add((SoundStreamBlockTag)t);
            if (range.startFrame == -1) {
                range.startFrame = frame;
            }
            range.endFrame = frame;
            frameHasSound = true;
        }
        if (range != null && ranges != null && range.endFrame > -1) {
            ranges.add(range);
        }
    }

    public void getNeededCharacters(Set<Integer> usedCharacters) {
        for (int i = 0; i < this.getFrameCount(); ++i) {
            this.getNeededCharacters(i, usedCharacters);
        }
    }

    public void getNeededCharacters(List<Integer> frames, Set<Integer> usedCharacters) {
        for (int frame = 0; frame < this.getFrameCount(); ++frame) {
            this.getNeededCharacters(frame, usedCharacters);
        }
    }

    public void getNeededCharacters(int frame, Set<Integer> usedCharacters) {
        Frame frameObj = this.getFrame(frame);
        for (int depth : frameObj.layers.keySet()) {
            DepthState layer = frameObj.layers.get(depth);
            CharacterTag ch = layer.getCharacter();
            if (ch == null) continue;
            usedCharacters.add(ch.getCharacterId());
            ch.getNeededCharactersDeep(usedCharacters);
        }
    }

    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (int i = 0; i < this.timelined.getTags().size(); ++i) {
            Tag t = this.timelined.getTags().get(i);
            if (!(t instanceof CharacterIdTag) || ((CharacterIdTag)((Object)t)).getCharacterId() != oldCharacterId) continue;
            ((CharacterIdTag)((Object)t)).setCharacterId(newCharacterId);
            t.setModified(true);
            modified = true;
        }
        return modified;
    }

    public boolean removeCharacter(int characterId, TagRemoveListener listener) {
        return this.swf.removeCharacterFromTimeline(characterId, this, listener);
    }

    public double roundToPixel(double val) {
        return Math.rint(val / 20.0) * 20.0;
    }

    private void drawDrawable(SWF swf, Matrix strokeTransform, DepthState layer, Matrix layerMatrix, Graphics2D g, ColorTransform colorTransForm, int blendMode, int parentBlendMode, List<Clip> clips, Matrix transformation, boolean isClip, int clipDepth, Matrix absMat, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, DrawableTag drawable, List<FILTER> filters, double unzoom, ColorTransform mergedColorTransform, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, Matrix fullTransformation, boolean scaleStrokes, int drawMode, boolean canUseSmoothing) {
        Matrix drawMatrix = new Matrix();
        int drawableFrameCount = drawable.getNumFrames();
        if (drawableFrameCount == 0) {
            drawableFrameCount = 1;
        }
        RECT boundRect = drawable.getRectWithStrokes();
        ExportRectangle rect = new ExportRectangle(boundRect);
        Matrix mat = transformation.concatenate(layerMatrix);
        rect = mat.transform(rect);
        ExportRectangle viewRectZoom = new ExportRectangle(viewRect);
        viewRectZoom.xMin *= unzoom;
        viewRectZoom.xMax *= unzoom;
        viewRectZoom.yMin *= unzoom;
        viewRectZoom.yMax *= unzoom;
        ExportRectangle fullRect = fullTransformation.concatenate(layerMatrix).transform(new ExportRectangle(boundRect));
        viewRectZoom.xMax -= viewRectZoom.xMin;
        viewRectZoom.xMin = 0.0;
        viewRectZoom.yMax -= viewRectZoom.yMin;
        viewRectZoom.yMin = 0.0;
        if (!viewRectZoom.intersects(fullRect)) {
            if (clipDepth > -1) {
                Clip clip = new Clip(new Area(), clipDepth);
                clips.add(clip);
            }
            return;
        }
        strokeTransform = strokeTransform.concatenate(layerMatrix);
        boolean cacheAsBitmap = layer.cacheAsBitmap() && layer.placeObjectTag != null && drawable.isSingleFrame();
        SerializableImage img = null;
        if (cacheAsBitmap && renderContext.displayObjectCache != null) {
            DisplayObjectCacheKey key = new DisplayObjectCacheKey(layer.placeObjectTag, unzoom, viewRect);
            try {
                img = renderContext.displayObjectCache.get(key);
            }
            catch (NullPointerException npe) {
                return;
            }
        }
        int stateCount = renderContext.stateUnderCursor == null ? 0 : renderContext.stateUnderCursor.size();
        int dframe = this.fontFrameNum != -1 ? this.fontFrameNum : time % drawableFrameCount;
        int dtime = time - dframe;
        ExportRectangle viewRect2 = new ExportRectangle(viewRect);
        double deltaXMax = 0.0;
        double deltaYMax = 0.0;
        if (filters != null && filters.size() > 0) {
            for (FILTER filter : filters) {
                if (!filter.enabled) continue;
                double x = filter.getDeltaX();
                double y = filter.getDeltaY();
                deltaXMax += x;
                deltaYMax += y;
            }
            rect.xMin -= deltaXMax * unzoom * 20.0;
            rect.xMax += deltaXMax * unzoom * 20.0;
            rect.yMin -= deltaYMax * unzoom * 20.0;
            rect.yMax += deltaYMax * unzoom * 20.0;
            viewRect2.xMin -= deltaXMax * 20.0;
            viewRect2.xMax += deltaXMax * 20.0;
            viewRect2.yMin -= deltaYMax * 20.0;
            viewRect2.yMax += deltaYMax * 20.0;
        }
        drawMatrix.translate(rect.xMin, rect.yMin);
        drawMatrix.translateX /= 20.0;
        drawMatrix.translateY /= 20.0;
        boolean canUseSameImage = true;
        if (img == null) {
            int newWidth = (int)Math.ceil(rect.getWidth() / 20.0);
            int newHeight = (int)Math.ceil(rect.getHeight() / 20.0);
            int deltaX = (int)Math.ceil(rect.xMin / 20.0);
            int deltaY = (int)Math.ceil(rect.yMin / 20.0);
            newWidth = Math.min(image.getWidth() - deltaX, newWidth);
            newHeight = Math.min(image.getHeight() - deltaY, newHeight);
            if (newWidth <= 0 || newHeight <= 0) {
                return;
            }
            Matrix m = mat.preConcatenate(Matrix.getTranslateInstance(-rect.xMin, -rect.yMin));
            if (drawable instanceof ButtonTag) {
                dtime = time;
                dframe = 0;
                if (renderContext.cursorPosition != null && renderContext.enableButtons) {
                    int dx = (int)(viewRect.xMin * unzoom);
                    int dy = (int)(viewRect.yMin * unzoom);
                    java.awt.Point cursorPositionInView = new java.awt.Point((int)Math.round((double)renderContext.cursorPosition.x * unzoom) - dx, (int)Math.round((double)renderContext.cursorPosition.y * unzoom) - dy);
                    Shape buttonShape = ((ButtonTag)drawable).getOutline(true, 3, dtime, ratio, renderContext, absMat, true, viewRect, unzoom);
                    if (buttonShape.contains(cursorPositionInView)) {
                        renderContext.mouseOverButton = (ButtonTag)drawable;
                        dframe = renderContext.mouseButton > 0 ? 2 : 1;
                    }
                }
            }
            if (filters != null && !filters.isEmpty()) {
                canUseSameImage = false;
            }
            if (blendMode > 1) {
                canUseSameImage = false;
            }
            if (clipDepth > -1) {
                canUseSameImage = false;
            }
            if (cacheAsBitmap) {
                canUseSameImage = false;
            }
            Matrix mfull = fullTransformation.concatenate(layerMatrix);
            if (canUseSameImage && sameImage) {
                img = image;
                m = mat.clone();
                g.setTransform(new AffineTransform());
            } else {
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
            }
            if (drawable instanceof TextTag) {
                TextTag textTag = (TextTag)drawable;
                Matrix textMatrix = new Matrix(textTag.getTextMatrix());
                if (drawable == renderContext.selectionText) {
                    renderContext.selectionAbsMatrix = absMat.concatenate(textMatrix);
                }
                if (renderContext.enableTexts) {
                    int dx = (int)(viewRect.xMin * unzoom);
                    int dy = (int)(viewRect.yMin * unzoom);
                    java.awt.Point cursorPositionInView = renderContext.cursorPosition == null ? new java.awt.Point(0, 0) : new java.awt.Point((int)Math.round((double)renderContext.cursorPosition.x * unzoom) - dx, (int)Math.round((double)renderContext.cursorPosition.y * unzoom) - dy);
                    Shape textShape = ((TextTag)drawable).getOutline(true, 0, 0, 0, renderContext, absMat, true, viewRect, unzoom);
                    if (textShape.contains(cursorPositionInView)) {
                        renderContext.mouseOverText = textTag;
                        renderContext.mouseOverTextAbsMatrix = absMat;
                    }
                    if (textShape.contains(cursorPositionInView) || drawable == renderContext.selectionText && renderContext.mouseButton == 1) {
                        Rectangle2D.Double r;
                        RECT gp;
                        Rectangle textBounds = textShape.getBounds();
                        List<Object> textRecords = new ArrayList();
                        if (textTag instanceof StaticTextTag) {
                            textRecords = ((StaticTextTag)textTag).textRecords;
                        }
                        if (textTag instanceof DefineEditTextTag) {
                            textRecords = ((DefineEditTextTag)textTag).getTextRecords(textTag.getSwf());
                        }
                        List<RECT> glyphPositions = TextTag.getGlyphEntriesPositions(textRecords, textTag.getSwf());
                        int pos = 0;
                        renderContext.glyphPosUnderCursor = -1;
                        int closestPos = -1;
                        double closestDistance = Double.MAX_VALUE;
                        java.awt.Point cursorPosNoTrans = absMat.concatenate(textMatrix).inverse().transform(cursorPositionInView);
                        pos = 0;
                        for (RECT gp2 : glyphPositions) {
                            Rectangle2D.Double r2 = new Rectangle2D.Double(gp2.Xmin, gp2.Ymin, gp2.Xmax - gp2.Xmin, gp2.Ymax - gp2.Ymin);
                            if (r2.contains(cursorPosNoTrans)) {
                                closestPos = pos;
                                closestDistance = 0.0;
                                break;
                            }
                            if ((double)cursorPosNoTrans.y >= ((RectangularShape)r2).getY() && (double)cursorPosNoTrans.y <= r2.getMaxY()) {
                                double tx = Math.max(r2.getMinX() - cursorPosNoTrans.getX(), 0.0);
                                if ((tx = Math.max(tx, cursorPosNoTrans.getX() - r2.getMaxX())) < closestDistance) {
                                    closestDistance = tx;
                                    closestPos = pos;
                                }
                            }
                            ++pos;
                        }
                        if (closestPos == -1 && renderContext.mouseButton == 1 && !glyphPositions.isEmpty()) {
                            gp = glyphPositions.get(0);
                            r = new Rectangle2D.Double(gp.Xmin, gp.Ymin, gp.Xmax - gp.Xmin, gp.Ymax - gp.Ymin);
                            if ((double)cursorPosNoTrans.y < ((RectangularShape)r).getY()) {
                                closestPos = 0;
                            }
                            gp = glyphPositions.get(glyphPositions.size() - 1);
                            r = new Rectangle2D.Double(gp.Xmin, gp.Ymin, gp.Xmax - gp.Xmin, gp.Ymax - gp.Ymin);
                            if ((double)cursorPosNoTrans.y > r.getMaxY()) {
                                closestPos = glyphPositions.size() - 1;
                            }
                        }
                        if (closestPos > -1) {
                            gp = glyphPositions.get(closestPos);
                            r = new Rectangle2D.Double(gp.Xmin, gp.Ymin, gp.Xmax - gp.Xmin, gp.Ymax - gp.Ymin);
                            renderContext.glyphUnderCursorRect = r;
                            renderContext.glyphUnderCursorXPosition = cursorPosNoTrans.x;
                            if (renderContext.glyphUnderCursorXPosition < ((RectangularShape)r).getX()) {
                                renderContext.glyphUnderCursorXPosition = ((RectangularShape)r).getX();
                            }
                            if (renderContext.glyphUnderCursorXPosition > r.getMaxX()) {
                                renderContext.glyphUnderCursorXPosition = r.getMaxX();
                            }
                            renderContext.glyphPosUnderCursor = closestPos;
                        }
                    }
                }
            }
            ColorTransform mergedColorTransform2 = mergedColorTransform;
            if (blendMode > 1) {
                mergedColorTransform2 = null;
            }
            if (filters != null && !filters.isEmpty()) {
                mergedColorTransform2 = null;
            }
            if (clipDepth > -1) {
                CXFORMWITHALPHA clrMask = new CXFORMWITHALPHA();
                clrMask.hasAddTerms = true;
                clrMask.hasMultTerms = true;
                clrMask.alphaAddTerm = 255;
                clrMask.redMultTerm = 0;
                clrMask.greenMultTerm = 0;
                clrMask.blueMultTerm = 0;
                mergedColorTransform2 = clrMask;
            }
            if (!(drawable instanceof ImageTag) || swf.isAS3() && layer.hasImage) {
                drawable.toImage(dframe, dtime, ratio, renderContext, img, fullImage, isClip || clipDepth > -1, m, strokeTransform, absMat, mfull, mergedColorTransform2, unzoom, sameImage, viewRect2, viewRectRaw, scaleStrokes, drawMode, layer.blendMode, canUseSmoothing);
            }
            if (cacheAsBitmap && layer.backGroundColor != null && (blendMode <= 1 || filters != null && !filters.isEmpty())) {
                Graphics2D g2 = (Graphics2D)img.getGraphics();
                g2.setComposite(AlphaComposite.DstOver);
                Color bgColor = layer.backGroundColor.toColor();
                g2.setColor(bgColor);
                g2.fillRect((int)Math.round(deltaXMax * unzoom), (int)Math.round(deltaYMax * unzoom), (int)Math.round(rect.getWidth() / 20.0 - 2.0 * deltaXMax * unzoom), (int)Math.round(rect.getHeight() / 20.0 - 2.0 * deltaYMax * unzoom));
            }
            if (filters != null) {
                for (FILTER filter : filters) {
                    if (!filter.enabled) continue;
                    img = filter.apply(img, unzoom, 0, 0, newWidth, newHeight);
                }
            }
            if (blendMode > 1 && colorTransForm != null) {
                img = colorTransForm.apply(img);
            }
            if (!sameImage && cacheAsBitmap && renderContext.displayObjectCache != null) {
                renderContext.clearPlaceObjectCache(layer.placeObjectTag);
                renderContext.displayObjectCache.put(new DisplayObjectCacheKey(layer.placeObjectTag, unzoom, viewRect), img);
            }
        }
        AffineTransform trans = drawMatrix.toTransform();
        if (g instanceof BlendModeSettable) {
            ((BlendModeSettable)((Object)g)).setBlendMode(blendMode);
        } else {
            switch (blendMode) {
                case 0: 
                case 1: {
                    g.setComposite(AlphaComposite.SrcOver);
                    break;
                }
                case 2: {
                    g.setComposite(AlphaComposite.SrcOver);
                    break;
                }
                case 3: {
                    g.setComposite(BlendComposite.Multiply);
                    break;
                }
                case 4: {
                    g.setComposite(BlendComposite.Screen);
                    break;
                }
                case 5: {
                    g.setComposite(BlendComposite.Lighten);
                    break;
                }
                case 6: {
                    g.setComposite(BlendComposite.Darken);
                    break;
                }
                case 7: {
                    g.setComposite(BlendComposite.Difference);
                    break;
                }
                case 8: {
                    g.setComposite(BlendComposite.Add);
                    break;
                }
                case 9: {
                    g.setComposite(BlendComposite.Subtract);
                    break;
                }
                case 10: {
                    g.setComposite(BlendComposite.Invert);
                    break;
                }
                case 11: {
                    g.setComposite(BlendComposite.Alpha);
                    break;
                }
                case 12: {
                    g.setComposite(BlendComposite.Erase);
                    break;
                }
                case 13: {
                    g.setComposite(BlendComposite.Overlay);
                    break;
                }
                case 14: {
                    g.setComposite(BlendComposite.HardLight);
                    break;
                }
                default: {
                    g.setComposite(AlphaComposite.SrcOver);
                }
            }
        }
        if (clipDepth > -1) {
            BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            Graphics2D gm = (Graphics2D)mask.getGraphics();
            gm.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gm.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            gm.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gm.setComposite(AlphaComposite.Src);
            gm.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            gm.fillRect(0, 0, image.getWidth(), image.getHeight());
            gm.setTransform(trans);
            gm.drawImage((Image)img.getBufferedImage(), 0, 0, null);
            Clip clip = new Clip(Helper.imageToShape(mask), clipDepth);
            clips.add(clip);
        } else {
            if (renderContext.cursorPosition != null) {
                int dx = (int)Math.round(viewRectRaw.xMin * unzoom);
                int dy = (int)Math.round(viewRectRaw.yMin * unzoom);
                java.awt.Point cursorPositionInView = new java.awt.Point((int)Math.round((double)renderContext.cursorPosition.x * unzoom) - dx, (int)Math.round((double)renderContext.cursorPosition.y * unzoom) - dy);
                if (drawable instanceof DefineSpriteTag) {
                    if (renderContext.stateUnderCursor.size() > stateCount) {
                        renderContext.stateUnderCursor.add(layer);
                    }
                } else if (absMat.transform(new ExportRectangle(boundRect)).contains(cursorPositionInView)) {
                    Shape shape;
                    if (drawable instanceof ButtonTag && !renderContext.enableButtons) {
                        dframe = 3;
                    }
                    if ((shape = drawable.getOutline(true, dframe, dtime, layer.ratio, renderContext, absMat, true, viewRect, unzoom)).contains(cursorPositionInView)) {
                        renderContext.stateUnderCursor.add(layer);
                    }
                }
            }
            if (renderContext.borderImage != null) {
                Graphics2D g2 = (Graphics2D)renderContext.borderImage.getGraphics();
                g2.setPaint(Color.red);
                g2.setStroke(new BasicStroke(2.0f));
                Shape shape = drawable.getOutline(true, dframe, dtime, layer.ratio, renderContext, absMat.preConcatenate(Matrix.getScaleInstance(0.05)), true, viewRect, unzoom);
                g2.draw(shape);
            }
            if (!sameImage || !canUseSameImage) {
                g.setTransform(drawMatrix.toTransform());
                if ((blendMode > 1 || filters != null && !filters.isEmpty()) && mergedColorTransform != null) {
                    img = mergedColorTransform.apply(img);
                }
                if (blendMode > 1 && (filters == null || filters.isEmpty()) && cacheAsBitmap && layer.backGroundColor != null) {
                    Graphics2D g2 = (Graphics2D)img.getGraphics();
                    g2.setComposite(AlphaComposite.DstOver);
                    Color bgColor = layer.backGroundColor.toColor();
                    g2.setColor(bgColor);
                    g2.fillRect((int)Math.round(deltaXMax * unzoom), (int)Math.round(deltaYMax * unzoom), (int)Math.round(rect.getWidth() / 20.0 - 2.0 * deltaXMax * unzoom), (int)Math.round(rect.getHeight() / 20.0 - 2.0 * deltaYMax * unzoom));
                }
                if (blendMode != 11 && blendMode != 12 || parentBlendMode > 1) {
                    g.drawImage((Image)img.getBufferedImage(), 0, 0, null);
                }
            }
            if (g instanceof BlendModeSettable) {
                ((BlendModeSettable)((Object)g)).setBlendMode(0);
            } else {
                g.setComposite(AlphaComposite.SrcOver);
            }
        }
    }

    public void toImage(int frame, int time, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, ExportRectangle viewRectRaw, Matrix fullTransformation, boolean scaleStrokes, int drawMode, int blendMode, boolean canUseSmoothing, List<Integer> ignoreDepths) {
        if (this.getFrameCount() <= frame) {
            return;
        }
        Frame frameObj = this.getFrame(frame);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Graphics2D fullG = (Graphics2D)fullImage.getGraphics();
        Shape prevClip = g.getClip();
        if (!sameImage) {
            g.setPaint(frameObj.backgroundColor.toColor());
            g.fill(new Rectangle(image.getWidth(), image.getHeight()));
        }
        sameImage = true;
        g.setTransform(transformation.toTransform());
        ArrayList<Clip> clips = new ArrayList<Clip>();
        int maxDepth = this.getMaxDepth();
        int clipCount = 0;
        for (int i = 0; i <= maxDepth; ++i) {
            CharacterTag character;
            boolean clipChanged = clipCount != clips.size();
            for (int c = 0; c < clips.size(); ++c) {
                if (((Clip)clips.get((int)c)).depth >= i) continue;
                clips.remove(c);
                --c;
                clipChanged = true;
            }
            if (clipChanged) {
                if (clips.size() > 0) {
                    Area clip = null;
                    if (prevClip != null) {
                        clip = new Area(prevClip);
                    }
                    for (Clip clip1 : clips) {
                        Shape shape = clip1.shape;
                        if (clip == null) {
                            clip = new Area(shape);
                            continue;
                        }
                        clip.intersect(new Area(shape));
                    }
                    g.setTransform(new AffineTransform());
                    g.setClip(clip);
                } else {
                    g.setClip(prevClip);
                }
                clipCount = clips.size();
            }
            if (!frameObj.layers.containsKey(i)) continue;
            DepthState layer = frameObj.layers.get(i);
            if (!layer.isVisible || (character = layer.getCharacter()) == null) continue;
            Matrix layerMatrix = new Matrix(layer.getDrawingMatrix());
            Matrix mat = transformation.concatenate(layerMatrix);
            Matrix absMat = absoluteTransformation.concatenate(layerMatrix);
            ColorTransform clrTrans = colorTransform;
            if (layer.colorTransForm != null) {
                clrTrans = clrTrans == null ? layer.colorTransForm : colorTransform.merge(layer.colorTransForm);
            }
            boolean showPlaceholder = false;
            if (drawMode != 0 && drawMode != 2 && !(character instanceof ShapeTag) || drawMode != 0 && drawMode != 1 && character instanceof ShapeTag || ignoreDepths.contains(i)) continue;
            if (character instanceof DrawableTag) {
                RECT scalingRect = null;
                DefineScalingGridTag sgt = character.getScalingGridTag();
                if (sgt != null) {
                    scalingRect = sgt.splitter;
                }
                if (scalingRect != null) {
                    ExportRectangle[] sourceRect = new ExportRectangle[9];
                    ExportRectangle[] targetRect = new ExportRectangle[9];
                    Matrix[] transforms = new Matrix[9];
                    DrawableTag dr = (DrawableTag)character;
                    ExportRectangle boundsRect = new ExportRectangle(dr.getRect());
                    ExportRectangle targetBoundsRect = layerMatrix.transform(boundsRect);
                    DefineScalingGridTag.getSlices(targetBoundsRect, boundsRect, new ExportRectangle(scalingRect), sourceRect, targetRect, transforms);
                    Shape c = g.getClip();
                    AffineTransform origTransform = g.getTransform();
                    int s = 0;
                    for (int sy = 0; sy < 3; ++sy) {
                        for (int sx = 0; sx < 3; ++sx) {
                            g.setTransform(new AffineTransform());
                            ExportRectangle p1 = transformation.transform(targetRect[s]);
                            if (sx == 0) {
                                p1.xMin = 0.0;
                            }
                            if (sy == 0) {
                                p1.yMin = 0.0;
                            }
                            if (sx == 2) {
                                p1.xMax = unzoom * viewRect.getWidth();
                            }
                            if (sy == 2) {
                                p1.yMax = unzoom * viewRect.getHeight();
                            }
                            p1.xMin /= 20.0;
                            p1.xMax /= 20.0;
                            p1.yMin /= 20.0;
                            p1.yMax /= 20.0;
                            Rectangle2D.Double r = new Rectangle2D.Double(p1.xMin, p1.yMin, p1.getWidth(), p1.getHeight());
                            g.setClip(r);
                            this.drawDrawable(this.swf, strokeTransformation, layer, transforms[s], g, colorTransform, layer.blendMode, blendMode, clips, transformation, isClip, layer.clipDepth, absMat, layer.time + time, layer.ratio, renderContext, image, fullImage, (DrawableTag)character, layer.filters, unzoom, clrTrans, sameImage, viewRect, viewRectRaw, fullTransformation, false, 1, canUseSmoothing);
                            ++s;
                        }
                    }
                    g.setClip(c);
                    g.setTransform(origTransform);
                    this.drawDrawable(this.swf, strokeTransformation, layer, layerMatrix, g, colorTransform, layer.blendMode, blendMode, clips, transformation, isClip, layer.clipDepth, absMat, layer.time + time, layer.ratio, renderContext, image, fullImage, (DrawableTag)character, layer.filters, unzoom, clrTrans, sameImage, viewRect, viewRectRaw, fullTransformation, scaleStrokes, 2, canUseSmoothing);
                } else {
                    boolean subScaleStrokes = scaleStrokes;
                    if (character instanceof DefineSpriteTag) {
                        subScaleStrokes = true;
                    }
                    this.drawDrawable(this.swf, strokeTransformation, layer, layerMatrix, g, colorTransform, layer.blendMode, blendMode, clips, transformation, isClip, layer.clipDepth, absMat, layer.time + time, layer.ratio, renderContext, image, fullImage, (DrawableTag)character, layer.filters, unzoom, clrTrans, sameImage, viewRect, viewRectRaw, fullTransformation, subScaleStrokes, 0, canUseSmoothing);
                }
            } else if (character instanceof BoundedTag) {
                showPlaceholder = true;
            }
            if (!showPlaceholder) continue;
            AffineTransform trans = mat.preConcatenate(Matrix.getScaleInstance(0.05)).toTransform();
            g.setTransform(trans);
            BoundedTag b = (BoundedTag)((Object)character);
            g.setPaint(new Color(255, 255, 255, 128));
            g.setComposite(BlendComposite.Invert);
            g.setStroke(new BasicStroke(20.0f));
            RECT r = b.getRect();
            g.setFont(g.getFont().deriveFont(240.0f));
            g.drawString(character.toString(), r.Xmin + 60, r.Ymin + 300);
            g.draw(new Rectangle(r.Xmin, r.Ymin, r.getWidth(), r.getHeight()));
            g.drawLine(r.Xmin, r.Ymin, r.Xmax, r.Ymax);
            g.drawLine(r.Xmax, r.Ymin, r.Xmin, r.Ymax);
            g.setComposite(AlphaComposite.Dst);
        }
        g.setTransform(new AffineTransform());
        g.setClip(prevClip);
    }

    private boolean tagHasSmallStrokes(SVGExporter exporter, DrawableTag drawableTag, Matrix matrix) {
        if (drawableTag instanceof Timelined) {
            Timelined tim = (Timelined)((Object)drawableTag);
            for (Frame fr : tim.getTimeline().frames) {
                for (DepthState ds : fr.layers.values()) {
                    Matrix subMat = matrix.concatenate(new Matrix(ds.matrix));
                    CharacterTag cht = ds.getCharacter();
                    if (!(cht instanceof DrawableTag) || !this.tagHasSmallStrokes(exporter, (DrawableTag)cht, subMat)) continue;
                    return true;
                }
            }
        }
        if (drawableTag instanceof ShapeTag) {
            Point p00 = matrix.transform(0.0, 0.0);
            Point p11 = matrix.transform(1.0, 1.0);
            double thicknessScale = p00.distanceTo(p11) / Math.sqrt(2.0);
            ShapeTag st = (ShapeTag)drawableTag;
            ArrayList<LINESTYLEARRAY> lineStyles = new ArrayList<LINESTYLEARRAY>();
            lineStyles.add(st.getShapes().lineStyles);
            for (SHAPERECORD rec : st.getShapes().shapeRecords) {
                if (!(rec instanceof StyleChangeRecord)) continue;
                StyleChangeRecord scr = (StyleChangeRecord)rec;
                if (!scr.stateNewStyles) continue;
                lineStyles.add(scr.lineStyles);
            }
            for (LINESTYLEARRAY lsArr : lineStyles) {
                if (lsArr.lineStyles != null) {
                    for (ILINESTYLE iLINESTYLE : lsArr.lineStyles) {
                        if (!((double)((LINESTYLE)iLINESTYLE).width * exporter.getZoom() * thicknessScale < 20.0)) continue;
                        return true;
                    }
                }
                if (lsArr.lineStyles2 == null) continue;
                for (ILINESTYLE iLINESTYLE : lsArr.lineStyles2) {
                    if (!((double)((LINESTYLE2)iLINESTYLE).width * exporter.getZoom() * thicknessScale < 20.0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void toSVG(int frame, int time, DepthState stateUnderCursor, int mouseButton, SVGExporter exporter, ColorTransform colorTransform, int level, Matrix transformation, Matrix strokeTransformation) throws IOException {
        if (this.getFrameCount() <= frame) {
            return;
        }
        Frame frameObj = this.getFrame(frame);
        ArrayList<SvgClip> clips = new ArrayList<SvgClip>();
        int maxDepth = this.getMaxDepth();
        int clipCount = 0;
        Element clipGroup = null;
        for (int i = 0; i <= maxDepth; ++i) {
            String assetName;
            DrawableTag drawable;
            CharacterTag character;
            boolean clipChanged = clipCount != clips.size();
            for (int c = 0; c < clips.size(); ++c) {
                if (((SvgClip)clips.get((int)c)).depth >= i) continue;
                clips.remove(c);
                --c;
                clipChanged = true;
            }
            if (clipChanged) {
                if (clipGroup != null) {
                    exporter.endGroup();
                    clipGroup = null;
                }
                if (!clips.isEmpty()) {
                    String clipName = exporter.getUniqueId("clipPath");
                    exporter.createClipPath(null, clipName);
                    Area a = null;
                    for (SvgClip c : clips) {
                        if (a == null) {
                            a = new Area(c.shape);
                            continue;
                        }
                        a.intersect(new Area(c.shape));
                    }
                    StringBuilder sb = new StringBuilder();
                    FlatteningPathIterator pathIterator = new FlatteningPathIterator(a.getPathIterator(AffineTransform.getScaleInstance(0.05, 0.05)), 0.01);
                    float[] coords = new float[6];
                    while (!pathIterator.isDone()) {
                        int type = pathIterator.currentSegment(coords);
                        switch (type) {
                            case 0: {
                                sb.append("M ").append(Timeline.formatDoubleSvg(coords[0])).append(" ").append(Timeline.formatDoubleSvg(coords[1])).append(" ");
                                break;
                            }
                            case 1: {
                                sb.append("L ").append(Timeline.formatDoubleSvg(coords[0])).append(" ").append(Timeline.formatDoubleSvg(coords[1])).append(" ");
                                break;
                            }
                            case 2: {
                                sb.append("Q ").append(Timeline.formatDoubleSvg(coords[0])).append(" ").append(Timeline.formatDoubleSvg(coords[1])).append(" ").append(Timeline.formatDoubleSvg(coords[2])).append(" ").append(Timeline.formatDoubleSvg(coords[3])).append(" ");
                                break;
                            }
                            case 3: {
                                sb.append("C ").append(Timeline.formatDoubleSvg(coords[0])).append(" ").append(Timeline.formatDoubleSvg(coords[1])).append(" ").append(Timeline.formatDoubleSvg(coords[2])).append(" ").append(Timeline.formatDoubleSvg(coords[3])).append(" ").append(Timeline.formatDoubleSvg(coords[4])).append(" ").append(Timeline.formatDoubleSvg(coords[5])).append(" ");
                                break;
                            }
                            case 4: {
                                sb.append("Z ");
                            }
                        }
                        pathIterator.next();
                    }
                    Element path = exporter.createElement("path");
                    path.setAttribute("d", sb.toString().trim());
                    exporter.addToGroup(path);
                    exporter.endGroup();
                    clipGroup = exporter.createSubGroup((Matrix)null, (String)null);
                    clipGroup.setAttribute("clip-path", "url(#" + clipName + ")");
                }
                clipCount = clips.size();
            }
            if (!frameObj.layers.containsKey(i)) continue;
            DepthState layer = frameObj.layers.get(i);
            if (!layer.isVisible || (character = layer.getCharacter()) == null) continue;
            ColorTransform clrTrans = colorTransform;
            if (layer.colorTransForm != null && layer.blendMode <= 1) {
                clrTrans = clrTrans == null ? layer.colorTransForm : colorTransform.merge(layer.colorTransForm);
            }
            Matrix layerMatrix = new Matrix(layer.getDrawingMatrix());
            Matrix absMat = strokeTransformation.concatenate(layerMatrix);
            if (!(character instanceof DrawableTag)) continue;
            DrawableTag drawableTag = drawable = (DrawableTag)character;
            RECT boundRect = drawable.getRect();
            ExportRectangle rect = new ExportRectangle(boundRect);
            DefineScalingGridTag scalingGrid = character.getScalingGridTag();
            if (layer.clipDepth > -1) {
                Shape shape = drawable.getOutline(false, 0, 0, layer.ratio, new RenderContext(), layerMatrix, false, null, 1.0);
                SvgClip clip = new SvgClip(layer.clipDepth, shape);
                clips.add(clip);
                continue;
            }
            boolean createNew = false;
            SVGExporter.ExportKey exportKey = new SVGExporter.ExportKey(drawableTag, clrTrans, layer.ratio, layer.clipDepth > -1);
            boolean hasSmallStroke = this.tagHasSmallStrokes(exporter, drawable, absMat);
            if (!hasSmallStroke && exporter.exportedTags.containsKey(exportKey)) {
                assetName = exporter.exportedTags.get(exportKey);
            } else {
                assetName = Timeline.getTagIdPrefix(drawableTag, exporter);
                if (!hasSmallStroke) {
                    exporter.exportedTags.put(exportKey, assetName);
                }
                createNew = true;
            }
            if (createNew) {
                exporter.createDefGroup(new ExportRectangle(boundRect), assetName);
                drawable.toSVG(exporter, layer.ratio, clrTrans, level + 1, transformation, absMat);
                exporter.endGroup();
            }
            Matrix mat = Matrix.getTranslateInstance(rect.xMin, rect.yMin).preConcatenate(new Matrix(layer.matrix));
            exporter.addUse(mat, boundRect, assetName, layer.instanceName, scalingGrid == null ? null : scalingGrid.splitter, String.valueOf(drawable.getCharacterId()), String.join((CharSequence)"___", drawable.getClassNames()), layer.blendMode, layer.filters);
        }
        if (clipGroup != null) {
            exporter.endGroup();
        }
    }

    private static String getTagIdPrefix(Tag tag, SVGExporter exporter) {
        if (tag instanceof ShapeTag) {
            return exporter.getUniqueId("shape");
        }
        if (tag instanceof MorphShapeTag) {
            return exporter.getUniqueId("morphshape");
        }
        if (tag instanceof DefineSpriteTag) {
            return exporter.getUniqueId("sprite");
        }
        if (tag instanceof TextTag) {
            return exporter.getUniqueId("text");
        }
        if (tag instanceof ButtonTag) {
            return exporter.getUniqueId("button");
        }
        return exporter.getUniqueId("tag");
    }

    public void toHtmlCanvas(StringBuilder result, double unitDivisor, List<Integer> frames) {
        FrameExporter.framesToHtmlCanvas(result, unitDivisor, this, frames, 0, null, 0, this.displayRect, null, null);
    }

    public void getSounds(int frame, int time, ButtonTag mouseOverButton, int mouseButton, List<Integer> sounds, List<String> soundClasses, List<SOUNDINFO> soundInfos) {
        Frame fr = this.getFrame(frame);
        if (fr == null) {
            return;
        }
        if (time == 0) {
            sounds.addAll(fr.sounds);
            soundClasses.addAll(fr.soundClasses);
            soundInfos.addAll(fr.soundInfos);
        }
        for (int d = this.maxDepth; d >= 0; --d) {
            int frameCount;
            CharacterTag c;
            DepthState ds = fr.layers.get(d);
            if (ds == null || !((c = ds.getCharacter()) instanceof Timelined) || (frameCount = ((Timelined)((Object)c)).getTimeline().frames.size()) == 0) continue;
            int dframe = time % frameCount;
            if (c instanceof ButtonTag) {
                dframe = 0;
                if (mouseOverButton == c) {
                    dframe = mouseButton > 0 ? 2 : 1;
                }
            }
            ((Timelined)((Object)c)).getTimeline().getSounds(dframe, 0, mouseOverButton, mouseButton, sounds, soundClasses, soundInfos);
        }
    }

    public Shape getOutline(boolean fast, int frame, int time, RenderContext renderContext, Matrix transformation, boolean stroked, ExportRectangle viewRect, double unzoom) {
        Frame fr = this.getFrame(frame);
        if (fr == null) {
            return new Rectangle2D.Double();
        }
        Area area = new Area();
        Stack<Clip> clips = new Stack<Clip>();
        for (int d = this.maxDepth; d >= 0; --d) {
            CharacterTag character;
            DepthState layer;
            Clip currentClip = null;
            for (int i = clips.size() - 1; i >= 0; --i) {
                Clip cl = (Clip)clips.get(i);
                if (cl.depth > d) continue;
                clips.remove(i);
            }
            if (!clips.isEmpty()) {
                currentClip = (Clip)clips.peek();
            }
            if ((layer = fr.layers.get(d)) == null || !layer.isVisible || !((character = layer.getCharacter()) instanceof DrawableTag)) continue;
            DrawableTag drawable = (DrawableTag)character;
            Matrix m = transformation.concatenate(new Matrix(layer.getDrawingMatrix()));
            int drawableFrameCount = drawable.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            int dframe = time % drawableFrameCount;
            if (character instanceof ButtonTag) {
                dframe = 0;
                if (renderContext.cursorPosition != null && renderContext.enableButtons) {
                    ButtonTag buttonTag = (ButtonTag)character;
                    Shape buttonShape = buttonTag.getOutline(fast, 3, time, layer.ratio, renderContext, m, stroked, viewRect, unzoom);
                    int dx = (int)Math.round(viewRect.xMin * unzoom);
                    int dy = (int)Math.round(viewRect.yMin * unzoom);
                    java.awt.Point cursorPositionInView = new java.awt.Point((int)Math.round((double)renderContext.cursorPosition.x * unzoom) - dx, (int)Math.round((double)renderContext.cursorPosition.y * unzoom) - dy);
                    if (buttonShape.contains(cursorPositionInView)) {
                        dframe = renderContext.mouseButton > 0 ? 2 : 1;
                    }
                }
            }
            Shape cshape = ((DrawableTag)character).getOutline(fast, dframe, time, layer.ratio, renderContext, m, stroked, viewRect, unzoom);
            Area addArea = new Area(cshape);
            if (currentClip != null) {
                Area a = new Area(new Rectangle(this.displayRect.Xmin, this.displayRect.Ymin, this.displayRect.getWidth(), this.displayRect.getHeight()));
                a.subtract(new Area(currentClip.shape));
                addArea.subtract(a);
            }
            if (layer.clipDepth > -1) {
                Clip clip = new Clip(addArea, layer.clipDepth);
                clips.push(clip);
                continue;
            }
            area.add(addArea);
        }
        return area;
    }

    public boolean isSingleFrame() {
        for (int i = 0; i < this.getFrameCount(); ++i) {
            if (this.isSingleFrame(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleFrame(int frame) {
        int i;
        Frame frameObj = this.getFrame(frame);
        for (i = 0; i < frameObj.innerTags.size(); ++i) {
            if (!(frameObj.innerTags.get(i) instanceof SoundStreamBlockTag)) continue;
            return false;
        }
        for (i = 0; i <= this.maxDepth; ++i) {
            DrawableTag drawable;
            CharacterTag character;
            if (!frameObj.layers.containsKey(i)) continue;
            DepthState layer = frameObj.layers.get(i);
            if (!layer.isVisible || (character = layer.getCharacter()) == null) continue;
            if (!frameObj.sounds.isEmpty()) {
                return false;
            }
            if (!(character instanceof DrawableTag) || (drawable = (DrawableTag)character).isSingleFrame()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timeline) {
            Timeline timelineObj = (Timeline)obj;
            return this.timelined.equals(timelineObj.timelined);
        }
        return false;
    }

    public List<Scene> getScenes() {
        this.ensureInitialized();
        return new ArrayList<Scene>(this.scenes);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        svgPathDecimalFormat = new DecimalFormat("0.##", symbols);
    }
}

