/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionTreeOperation;
import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.as2.Trait;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.HasSwfAndTag;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class BUTTONCONDACTION
implements ASMSource,
Serializable,
HasSwfAndTag {
    private SWF swf;
    private Tag tag;
    private String scriptName = "-";
    private String exportedScriptName = "-";
    @Internal
    public boolean isLast;
    public boolean condIdleToOverDown;
    public boolean condOutDownToIdle;
    public boolean condOutDownToOverDown;
    public boolean condOverDownToOutDown;
    public boolean condOverDownToOverUp;
    public boolean condOverUpToOverDown;
    public boolean condOverUpToIddle;
    public boolean condIdleToOverUp;
    @SWFType(value=BasicType.UB, count=7)
    @Conditional(minSwfVersion=4)
    public int condKeyPress;
    public boolean condOverDownToIdle;
    @HideInRawEdit
    public ByteArrayRange actionBytes;
    List<DisassemblyListener> listeners = new ArrayList<DisassemblyListener>();

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    public BUTTONCONDACTION() {
        this.swf = null;
        this.tag = null;
        this.actionBytes = new ByteArrayRange(SWFInputStream.BYTE_ARRAY_EMPTY);
    }

    public BUTTONCONDACTION(SWF swf, Tag tag) {
        this.swf = swf;
        this.tag = tag;
        this.actionBytes = new ByteArrayRange(SWFInputStream.BYTE_ARRAY_EMPTY);
    }

    @Override
    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public BUTTONCONDACTION(SWF swf, SWFInputStream sis, Tag tag) throws IOException {
        this.swf = swf;
        this.tag = tag;
        int condActionSize = sis.readUI16("condActionSize");
        this.isLast = condActionSize <= 0;
        this.condIdleToOverDown = sis.readUB(1, "condIdleToOverDown") == 1L;
        this.condOutDownToIdle = sis.readUB(1, "condOutDownToIdle") == 1L;
        this.condOutDownToOverDown = sis.readUB(1, "condOutDownToOverDown") == 1L;
        this.condOverDownToOutDown = sis.readUB(1, "condOverDownToOutDown") == 1L;
        this.condOverDownToOverUp = sis.readUB(1, "condOverDownToOverUp") == 1L;
        this.condOverUpToOverDown = sis.readUB(1, "condOverUpToOverDown") == 1L;
        this.condOverUpToIddle = sis.readUB(1, "condOverUpToIddle") == 1L;
        this.condIdleToOverUp = sis.readUB(1, "condIdleToOverUp") == 1L;
        this.condKeyPress = (int)sis.readUB(7, "condKeyPress");
        this.condOverDownToIdle = sis.readUB(1, "condOverDownToIdle") == 1L;
        this.actionBytes = sis.readByteRangeEx(condActionSize <= 0 ? (long)sis.available() : (long)(condActionSize - 4), "actionBytes", DumpInfoSpecialType.ACTION_BYTES, sis.getPos());
    }

    @Override
    public Openable getOpenable() {
        return this.swf;
    }

    @Override
    public SWF getSwf() {
        return this.swf;
    }

    public String toString() {
        return "BUTTONCONDACTION " + this.getHeader(false);
    }

    @Override
    public GraphTextWriter getASMSource(ScriptExportMode exportMode, GraphTextWriter writer, ActionList actions) throws InterruptedException {
        if (actions == null) {
            actions = this.getActions();
        }
        return Action.actionsToString(this.listeners, 0L, actions, this.swf.version, exportMode, writer);
    }

    @Override
    public GraphTextWriter getActionScriptSource(GraphTextWriter writer, ActionList actions) throws InterruptedException {
        if (actions == null) {
            actions = this.getActions();
        }
        return Action.actionsToSource(new HashMap<String, Map<String, Trait>>(), this, actions, this.getScriptName(), writer, actions.getCharset());
    }

    @Override
    public GraphTextWriter getActionScriptSource(GraphTextWriter writer, ActionList actions, List<ActionTreeOperation> treeOperations) throws InterruptedException {
        if (actions == null) {
            actions = this.getActions();
        }
        return Action.actionsToSource(new HashMap<String, Map<String, Trait>>(), this, actions, this.getScriptName(), writer, actions.getCharset(), treeOperations);
    }

    @Override
    public boolean containsSource() {
        return true;
    }

    @Override
    public ActionList getActions() throws InterruptedException {
        return SWF.getCachedActionList(this, this.listeners);
    }

    @Override
    public void setActions(List<Action> actions) {
        this.actionBytes = Action.actionsToByteArrayRange(actions, true, this.swf.version);
    }

    @Override
    public ByteArrayRange getActionBytes() {
        return this.actionBytes;
    }

    @Override
    public void setActionBytes(byte[] actionBytes) {
        this.actionBytes = new ByteArrayRange(actionBytes);
        SWF.uncache(this);
    }

    @Override
    public void setConstantPools(List<List<String>> constantPools) throws ConstantPoolTooBigException {
        Action.setConstantPools(this, constantPools, false);
    }

    @Override
    public void setModified() {
        if (this.tag != null) {
            this.tag.setModified(true);
        }
    }

    @Override
    public boolean isModified() {
        if (this.tag != null) {
            return this.tag.isModified();
        }
        return false;
    }

    @Override
    public GraphTextWriter getActionBytesAsHex(GraphTextWriter writer) {
        return Helper.byteArrayToHexWithHeader(writer, this.actionBytes.getRangeData());
    }

    @Override
    public void addDisassemblyListener(DisassemblyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDisassemblyListener(DisassemblyListener listener) {
        this.listeners.remove(listener);
    }

    private String getHeader(boolean asFilename) {
        ArrayList<String> events = new ArrayList<String>();
        if (this.condOverUpToOverDown) {
            events.add("press");
        }
        if (this.condOverDownToOverUp) {
            events.add("release");
        }
        if (this.condOutDownToIdle) {
            events.add("releaseOutside");
        }
        if (this.condIdleToOverUp) {
            events.add("rollOver");
        }
        if (this.condOverUpToIddle) {
            events.add("rollOut");
        }
        if (this.condOverDownToOutDown || this.condOverDownToIdle) {
            events.add("dragOut");
        }
        if (this.condOutDownToOverDown || this.condIdleToOverDown) {
            events.add("dragOver");
        }
        if (this.condKeyPress > 0) {
            if (asFilename) {
                events.add("keyPress " + Helper.makeFileName(CLIPACTIONRECORD.keyToString(this.condKeyPress).replace("<", "").replace(">", "")) + "");
            } else {
                events.add("keyPress \"" + Helper.escapeActionScriptString(CLIPACTIONRECORD.keyToString(this.condKeyPress)) + "\"");
            }
        }
        String onStr = "";
        for (int i = 0; i < events.size(); ++i) {
            if (i > 0) {
                onStr = onStr + ", ";
            }
            onStr = onStr + (String)events.get(i);
        }
        return "on(" + onStr + ")";
    }

    @Override
    public GraphTextWriter getActionSourcePrefix(GraphTextWriter writer) {
        writer.appendNoHilight(this.getHeader(false));
        writer.appendNoHilight("{").newLine();
        return writer.indent();
    }

    @Override
    public GraphTextWriter getActionSourceSuffix(GraphTextWriter writer) {
        writer.unindent();
        return writer.appendNoHilight("}").newLine();
    }

    @Override
    public int getPrefixLineCount() {
        return 1;
    }

    @Override
    public String removePrefixAndSuffix(String source) {
        return Helper.unindentRows(1, 1, source);
    }

    @Override
    public String getExportFileName() {
        return "BUTTONCONDACTION " + this.getHeader(true);
    }

    @Override
    public Tag getSourceTag() {
        return this.tag;
    }

    @Override
    public void setSourceTag(Tag t) {
        this.tag = t;
        this.swf = t.getSwf();
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    @Override
    public List<GraphTargetItem> getActionsToTree() {
        try {
            return Action.actionsToTree(new LinkedHashSet<String>(), false, new HashMap<String, Map<String, Trait>>(), false, false, this.getActions(), this.swf.version, 0, this.getScriptName(), this.swf.getCharset());
        }
        catch (InterruptedException ex) {
            return new ArrayList<GraphTargetItem>();
        }
    }

    @Override
    public String getExportedScriptName() {
        return this.exportedScriptName;
    }

    @Override
    public void setExportedScriptName(String scriptName) {
        this.exportedScriptName = scriptName;
    }
}

