/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.annotations.Calculated;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.io.Serializable;

public class CXFORMWITHALPHA
extends ColorTransform
implements Serializable {
    public boolean hasAddTerms;
    public boolean hasMultTerms;
    @Calculated
    @SWFType(value=BasicType.UB, count=4)
    public int nbits;
    @Conditional(value={"hasMultTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int redMultTerm;
    @Conditional(value={"hasMultTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int greenMultTerm;
    @Conditional(value={"hasMultTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int blueMultTerm;
    @Conditional(value={"hasMultTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int alphaMultTerm;
    @Conditional(value={"hasAddTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int redAddTerm;
    @Conditional(value={"hasAddTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int greenAddTerm;
    @Conditional(value={"hasAddTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int blueAddTerm;
    @Conditional(value={"hasAddTerms"})
    @SWFType(value=BasicType.SB, countField="nbits")
    public int alphaAddTerm;

    @Override
    public int getRedAdd() {
        return this.hasAddTerms ? this.redAddTerm : super.getRedAdd();
    }

    @Override
    public int getGreenAdd() {
        return this.hasAddTerms ? this.greenAddTerm : super.getGreenAdd();
    }

    @Override
    public int getBlueAdd() {
        return this.hasAddTerms ? this.blueAddTerm : super.getBlueAdd();
    }

    @Override
    public int getAlphaAdd() {
        return this.hasAddTerms ? this.alphaAddTerm : super.getAlphaAdd();
    }

    @Override
    public int getRedMulti() {
        return this.hasMultTerms ? this.redMultTerm : super.getRedMulti();
    }

    @Override
    public int getGreenMulti() {
        return this.hasMultTerms ? this.greenMultTerm : super.getGreenMulti();
    }

    @Override
    public int getBlueMulti() {
        return this.hasMultTerms ? this.blueMultTerm : super.getBlueMulti();
    }

    @Override
    public int getAlphaMulti() {
        return this.hasMultTerms ? this.alphaMultTerm : super.getAlphaMulti();
    }

    public CXFORMWITHALPHA() {
        this.alphaMultTerm = 256;
        this.redMultTerm = 256;
        this.greenMultTerm = 256;
        this.blueMultTerm = 256;
    }

    public CXFORMWITHALPHA(CXFORM cxform) {
        this.redMultTerm = cxform.redMultTerm;
        this.greenMultTerm = cxform.greenMultTerm;
        this.blueMultTerm = cxform.blueMultTerm;
        this.redAddTerm = cxform.redAddTerm;
        this.greenAddTerm = cxform.greenAddTerm;
        this.blueAddTerm = cxform.blueAddTerm;
        this.alphaAddTerm = 0;
        this.alphaMultTerm = 256;
    }

    public CXFORMWITHALPHA(ColorTransform colorTransform) {
        this.redMultTerm = colorTransform.getRedMulti();
        this.greenMultTerm = colorTransform.getGreenMulti();
        this.blueMultTerm = colorTransform.getBlueMulti();
        this.alphaMultTerm = colorTransform.getAlphaMulti();
        this.redAddTerm = colorTransform.getRedAdd();
        this.greenAddTerm = colorTransform.getGreenAdd();
        this.blueAddTerm = colorTransform.getBlueAdd();
        this.alphaAddTerm = colorTransform.getAlphaAdd();
        this.hasAddTerms = this.redAddTerm != 0 || this.greenAddTerm != 0 || this.blueAddTerm != 0 || this.alphaAddTerm != 0;
        this.hasMultTerms = this.redMultTerm != 255 || this.greenMultTerm != 255 || this.blueMultTerm != 255 || this.alphaMultTerm != 255;
    }

    @Override
    public CXFORMWITHALPHA clone() {
        CXFORMWITHALPHA ret = (CXFORMWITHALPHA)super.clone();
        ret.hasAddTerms = this.hasAddTerms;
        ret.hasMultTerms = this.hasMultTerms;
        ret.nbits = this.nbits;
        ret.redMultTerm = this.redMultTerm;
        ret.greenMultTerm = this.greenMultTerm;
        ret.blueMultTerm = this.blueMultTerm;
        ret.alphaMultTerm = this.alphaMultTerm;
        ret.redAddTerm = this.redAddTerm;
        ret.greenAddTerm = this.greenAddTerm;
        ret.blueAddTerm = this.blueAddTerm;
        ret.alphaAddTerm = this.alphaAddTerm;
        return ret;
    }
}

