/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.io.Serializable;

public class MORPHLINESTYLE2
implements Serializable {
    @SWFType(value=BasicType.UI16)
    public int startWidth;
    @SWFType(value=BasicType.UI16)
    public int endWidth;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Round cap"), @EnumValue(value=1, text="No cap"), @EnumValue(value=2, text="Square cap")})
    public int startCapStyle;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Round join"), @EnumValue(value=1, text="Bevel join"), @EnumValue(value=2, text="Miter join")})
    public int joinStyle;
    public static final int ROUND_JOIN = 0;
    public static final int BEVEL_JOIN = 1;
    public static final int MITER_JOIN = 2;
    public boolean hasFillFlag;
    public boolean noHScaleFlag;
    public boolean noVScaleFlag;
    public boolean pixelHintingFlag;
    @Reserved
    @SWFType(value=BasicType.UB, count=5)
    public int reserved;
    public boolean noClose;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="Round cap"), @EnumValue(value=1, text="No cap"), @EnumValue(value=2, text="Square cap")})
    public int endCapStyle;
    public static final int ROUND_CAP = 0;
    public static final int NO_CAP = 1;
    public static final int SQUARE_CAP = 2;
    @SWFType(value=BasicType.UFIXED8)
    @Conditional(value={"joinStyle"}, options={2})
    public float miterLimitFactor;
    @Conditional(value={"!hasFillFlag"})
    public RGBA startColor;
    @Conditional(value={"!hasFillFlag"})
    public RGBA endColor;
    @Conditional(value={"hasFillFlag"})
    public MORPHFILLSTYLE fillType;

    public LINESTYLE2 getLineStyle2At(int ratio) {
        LINESTYLE2 ret = new LINESTYLE2();
        ret.width = this.startWidth + (this.endWidth - this.startWidth) * ratio / 65535;
        ret.startCapStyle = this.startCapStyle;
        ret.joinStyle = this.joinStyle;
        ret.hasFillFlag = this.hasFillFlag;
        ret.noHScaleFlag = this.noHScaleFlag;
        ret.noVScaleFlag = this.noVScaleFlag;
        ret.pixelHintingFlag = this.pixelHintingFlag;
        ret.noClose = this.noClose;
        ret.endCapStyle = this.endCapStyle;
        ret.miterLimitFactor = this.miterLimitFactor;
        if (this.hasFillFlag) {
            ret.fillType = this.fillType.getFillStyleAt(ratio);
        } else {
            ret.color = MORPHGRADIENT.morphColor(this.startColor, this.endColor, ratio);
        }
        return ret;
    }

    public LINESTYLE2 getStartLineStyle2() {
        LINESTYLE2 ret = new LINESTYLE2();
        ret.width = this.startWidth;
        ret.startCapStyle = this.startCapStyle;
        ret.joinStyle = this.joinStyle;
        ret.hasFillFlag = this.hasFillFlag;
        ret.noHScaleFlag = this.noHScaleFlag;
        ret.noVScaleFlag = this.noVScaleFlag;
        ret.pixelHintingFlag = this.pixelHintingFlag;
        ret.noClose = this.noClose;
        ret.endCapStyle = this.endCapStyle;
        ret.miterLimitFactor = this.miterLimitFactor;
        ret.color = this.startColor;
        if (this.hasFillFlag) {
            ret.fillType = this.fillType.getStartFillStyle();
        }
        return ret;
    }

    public LINESTYLE2 getEndLineStyle2() {
        LINESTYLE2 ret = new LINESTYLE2();
        ret.width = this.endWidth;
        ret.startCapStyle = this.startCapStyle;
        ret.joinStyle = this.joinStyle;
        ret.hasFillFlag = this.hasFillFlag;
        ret.noHScaleFlag = this.noHScaleFlag;
        ret.noVScaleFlag = this.noVScaleFlag;
        ret.pixelHintingFlag = this.pixelHintingFlag;
        ret.noClose = this.noClose;
        ret.endCapStyle = this.endCapStyle;
        ret.miterLimitFactor = this.miterLimitFactor;
        ret.color = this.endColor;
        if (this.hasFillFlag) {
            ret.fillType = this.fillType.getEndFillStyle();
        }
        return ret;
    }
}

