/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.decompiler.flash.math.BezierEdge;
import java.util.List;

public class EasingDetector {
    public static double framePercentToRatio(double framePercent, int ease) {
        BezierEdge be = new BezierEdge(0.0, 0.0, 50.0, Short.MAX_VALUE + ease * 65535 / 100 / 2, 100.0, 65535.0);
        BezierEdge line = new BezierEdge(framePercent, 0.0, framePercent, 65535.0);
        return be.getIntersections(line).get(0).getY();
    }

    public static double ratioToFramePercent(double ratio, int ease) {
        BezierEdge be = new BezierEdge(0.0, 0.0, 50.0, 50.0 + (double)ease / 2.0, 100.0, 65535.0);
        BezierEdge line = new BezierEdge(0.0, ratio, 100.0, ratio);
        return be.getIntersections(line).get(0).getX();
    }

    public static Integer getEaseFromShapeRatios(List<Integer> ratios) {
        if (ratios.isEmpty()) {
            return null;
        }
        if (ratios.get(0) != 0) {
            ratios.add(0, 0);
        }
        if (ratios.get(ratios.size() - 1) != 65535) {
            ratios.add(65535);
        }
        int ease = 100;
        while (true) {
            double minDist = Double.MAX_VALUE;
            double maxDist = Double.MIN_VALUE;
            for (int f = 0; f < ratios.size(); ++f) {
                double framePct = (double)(f * 100) / (double)(ratios.size() - 1);
                double tweenPct = ratios.get(f).intValue();
                double tweenPctShouldBe = Math.round(EasingDetector.framePercentToRatio(framePct, ease));
                double dist = tweenPctShouldBe - tweenPct;
                if (dist > maxDist) {
                    maxDist = dist;
                }
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
            if (minDist > -5.0 && maxDist < 5.0) break;
            if (ease == -100) {
                return null;
            }
            --ease;
        }
        return ease;
    }
}

