/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;

public class LosslessImageBinDataReader {
    private final DataInputStream is;

    public LosslessImageBinDataReader(InputStream is) {
        this.is = new DataInputStream(is);
    }

    public BufferedImage readImage() throws IOException {
        int cnt;
        int sign1 = this.readEx();
        int sign2 = this.readEx();
        if (sign1 != 3 || sign2 != 5) {
            throw new IOException("Invalid image");
        }
        int rowSize = this.readUI16();
        int width = this.readUI16();
        int height = this.readUI16();
        long frameLeft = this.readUI32();
        long frameRight = this.readUI32();
        long frameTop = this.readUI32();
        long frameBottom = this.readUI32();
        int flags = this.readEx();
        boolean hasAlpha = (flags & 1) == 1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int variant = this.readEx();
        if (variant == 1) {
            int chunkLen;
            while ((chunkLen = this.readUI16()) != 0) {
                byte[] chunk = new byte[chunkLen];
                this.is.readFully(chunk);
                baos.write(chunk);
            }
        }
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(baos.toByteArray()));
        byte[] buf = new byte[4096];
        while ((cnt = iis.read(buf)) > 0) {
            baos2.write(buf, 0, cnt);
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        byte[] data = baos2.toByteArray();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int a = data[pos++] & 0xFF;
                int b = data[pos++] & 0xFF;
                int g = data[pos++] & 0xFF;
                int r = data[pos++] & 0xFF;
                if (a != 0 && a != 255) {
                    r = (int)Math.floor((float)r * 256.0f / (float)(--a));
                    g = (int)Math.floor((float)g * 256.0f / (float)a);
                    b = (int)Math.floor((float)b * 256.0f / (float)a);
                }
                int rgba = r + (g << 8) + (b << 16) + (a << 24);
                img.setRGB(x, y, rgba);
            }
        }
        return img;
    }

    private int readUI16() throws IOException {
        return this.readEx() + (this.readEx() << 8);
    }

    private long readUI32() throws IOException {
        return (long)(this.readEx() + (this.readEx() << 8) + (this.readEx() << 16) + (this.readEx() << 24)) & 0xFFFFFFFFL;
    }

    private int readEx() throws IOException {
        int ret = this.is.read();
        if (ret == -1) {
            throw new IOException("Premature end of the file reached");
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        File f = new File("in.bin");
        LosslessImageBinDataReader r = new LosslessImageBinDataReader(new FileInputStream(f));
        BufferedImage i = r.readImage();
        ImageIO.write((RenderedImage)i, "PNG", new File("out.png"));
    }
}

