/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.model.ConvertAVM2Item;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.AbstractGraphTargetVisitor;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetRecursiveVisitorInterface;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.BinaryOp;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.DuplicateSourceItem;
import com.jpexs.decompiler.graph.model.HasTempIndex;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.SetTemporaryItem;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.LinkedIdentityHashSet;
import com.jpexs.helpers.Reference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public abstract class GraphTargetItem
implements Serializable,
Cloneable {
    public static final int PRECEDENCE_PRIMARY = 0;
    public static final int PRECEDENCE_POSTFIX = 1;
    public static final int PRECEDENCE_UNARY = 2;
    public static final int PRECEDENCE_MULTIPLICATIVE = 3;
    public static final int PRECEDENCE_ADDITIVE = 4;
    public static final int PRECEDENCE_BITWISESHIFT = 5;
    public static final int PRECEDENCE_RELATIONAL = 6;
    public static final int PRECEDENCE_EQUALITY = 7;
    public static final int PRECEDENCE_BITWISEAND = 8;
    public static final int PRECEDENCE_BITWISEXOR = 9;
    public static final int PRECEDENCE_BITWISEOR = 10;
    public static final int PRECEDENCE_LOGICALAND = 11;
    public static final int PRECEDENCE_LOGICALOR = 12;
    public static final int PRECEDENCE_NULLCOALESCE = 13;
    public static final int PRECEDENCE_CONDITIONAL = 14;
    public static final int PRECEDENCE_ASSIGNMENT = 15;
    public static final int PRECEDENCE_COMMA = 16;
    public static final int NOPRECEDENCE = 17;
    private GraphSourceItem src;
    protected int precedence;
    private List<GraphSourceItemPos> moreSrc;
    public GraphPart firstPart;
    public GraphTargetItem value;
    private HighlightData srcData;
    public GraphSourceItem lineStartItem;
    protected int pos = 0;
    public GraphTargetDialect dialect;
    public int outputPos = -1;
    public int line;

    public GraphSourceItem getLineStartItem() {
        return this.lineStartItem;
    }

    public static GraphTargetItem simplifySomething(GraphTargetItem it, String implicitCoerce) {
        GraphTargetItem it2;
        if (it instanceof SimpleValue && implicitCoerce.isEmpty() && ((SimpleValue)((Object)it)).isSimpleValue()) {
            return it;
        }
        if (!(it.isCompileTime() || !implicitCoerce.isEmpty() && it.isConvertedCompileTime(new HashSet<GraphTargetItem>()))) {
            return it;
        }
        Object r = it.getResult();
        switch (implicitCoerce) {
            case "String": {
                r = EcmaScript.toString(r);
                break;
            }
            case "Number": {
                r = EcmaScript.toNumber(r);
                break;
            }
            case "int": {
                r = EcmaScript.toInt32(r);
                break;
            }
            case "Boolean": {
                r = EcmaScript.toBoolean(r);
            }
        }
        GraphTargetItem graphTargetItem = it2 = it.dialect == null ? null : it.dialect.valToItem(r);
        if (it2 == null) {
            return it;
        }
        return it2;
    }

    public GraphTargetItem simplify(String implicitCoerce) {
        return GraphTargetItem.simplifySomething(this, implicitCoerce);
    }

    public int getLine() {
        if (this.src != null) {
            return this.src.getLine();
        }
        return 0;
    }

    public String getFile() {
        if (this.src != null) {
            return this.src.getFile();
        }
        return null;
    }

    public GraphPart getFirstPart() {
        if (this.value == null) {
            return this.firstPart;
        }
        GraphPart ret = this.value.getFirstPart();
        if (ret == null) {
            return this.firstPart;
        }
        return ret;
    }

    public GraphTargetItem(GraphTargetDialect dialect) {
        this(dialect, null, null, 17);
    }

    public GraphTargetItem(GraphTargetDialect dialect, GraphSourceItem src, GraphSourceItem lineStartItem, int precedence) {
        this(dialect, src, lineStartItem, precedence, null);
    }

    public GraphTargetItem(GraphTargetDialect dialect, GraphSourceItem src, GraphSourceItem lineStartItem, int precedence, GraphTargetItem value) {
        this.dialect = dialect;
        this.src = src;
        this.lineStartItem = lineStartItem;
        this.precedence = precedence;
        this.value = value;
    }

    public GraphSourceItem getSrc() {
        return this.src;
    }

    public List<GraphSourceItemPos> getMoreSrc() {
        if (this.moreSrc == null) {
            this.moreSrc = new ArrayList<GraphSourceItemPos>();
        }
        return this.moreSrc;
    }

    protected HighlightData getSrcData() {
        if (this.srcData == null) {
            this.srcData = new HighlightData();
        }
        return this.srcData;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public List<GraphSourceItemPos> getNeededSources() {
        ArrayList<GraphSourceItemPos> ret = new ArrayList<GraphSourceItemPos>();
        ret.add(new GraphSourceItemPos(this.src, this.getPos()));
        if (this.moreSrc != null) {
            ret.addAll(this.moreSrc);
        }
        if (this.value != null) {
            ret.addAll(this.value.getNeededSources());
        }
        return ret;
    }

    public GraphTextWriter toStringSemicoloned(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (CancellableWorker.isInterrupted()) {
            throw new InterruptedException();
        }
        writer.startOffset(this.src, this.getLineStartItem(), this.getPos(), this.srcData);
        this.appendTry(writer, localData);
        if (this.needsSemicolon()) {
            writer.appendNoHilight(";");
        }
        writer.endOffset();
        return writer;
    }

    public boolean needsSemicolon() {
        return true;
    }

    public final GraphTextWriter toStringBoolean(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.toString(writer, localData, "Boolean", false);
    }

    public final GraphTextWriter toStringString(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.toString(writer, localData, "String", false);
    }

    public final GraphTextWriter toStringInt(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.toString(writer, localData, "int", false);
    }

    public final GraphTextWriter toStringNumber(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.toString(writer, localData, "Number", false);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public GraphTextWriter toString(GraphTextWriter writer, LocalData localData, String implicitCoerce, boolean noParenthesis) throws InterruptedException {
        if (CancellableWorker.isInterrupted()) {
            throw new InterruptedException();
        }
        writer.startOffset(this.src, this.getLineStartItem(), this.getPos(), this.srcData);
        this.appendTry(writer, localData, implicitCoerce, noParenthesis);
        writer.endOffset();
        return writer;
    }

    public GraphTextWriter toString(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.toString(writer, localData, "", false);
    }

    public String toString(LocalData localData) throws InterruptedException {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
        this.toString(writer, localData);
        writer.finishHilights();
        return writer.toString();
    }

    public abstract GraphTextWriter appendTo(GraphTextWriter var1, LocalData var2) throws InterruptedException;

    public GraphTextWriter appendNoParenthesis(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.appendTo(writer, localData);
    }

    public GraphTextWriter appendTry(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.appendTry(writer, localData, "", false);
    }

    public GraphTextWriter appendTry(GraphTextWriter writer, LocalData localData, String implicitCoerce, boolean noParenthesis) throws InterruptedException {
        GraphTargetItem t = this;
        if (!implicitCoerce.isEmpty() && localData.abc != null) {
            List<String> numberTypes = Arrays.asList("int", "uint", "Number");
            String returnTypeStr = t.returnType().toString();
            if (!(t.returnType().equals(TypeItem.UNBOUNDED) || implicitCoerce.equals(returnTypeStr) || numberTypes.contains(implicitCoerce) && numberTypes.contains(returnTypeStr) || implicitCoerce.equals("Boolean") && !returnTypeStr.equals("Function"))) {
                t = new ConvertAVM2Item(null, null, t, (GraphTargetItem)new TypeItem(implicitCoerce));
            }
        }
        if (!implicitCoerce.isEmpty() && Configuration.simplifyExpressions.get().booleanValue()) {
            t = t.simplify(implicitCoerce);
        }
        if (noParenthesis) {
            return t.appendNoParenthesis(writer, localData);
        }
        return t.appendTo(writer, localData);
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public boolean isCompileTime() {
        HashSet<GraphTargetItem> dependencies = new HashSet<GraphTargetItem>();
        if (!(this instanceof SimpleValue) || !((SimpleValue)((Object)this)).isSimpleValue()) {
            dependencies.add(this);
        }
        return this.isCompileTime(dependencies);
    }

    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return false;
    }

    public boolean isConvertedCompileTime(Set<GraphTargetItem> dependencies) {
        return this.isCompileTime();
    }

    public boolean hasSideEffect() {
        final Reference<Boolean> ref = new Reference<Boolean>(false);
        this.visitRecursively(new AbstractGraphTargetVisitor(this){
            final /* synthetic */ GraphTargetItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visit(GraphTargetItem item) {
                if (item.hasSideEffect()) {
                    ref.setVal(Boolean.TRUE);
                }
                return true;
            }
        });
        return ref.getVal();
    }

    public boolean isVariableComputed() {
        return false;
    }

    public Object getResult() {
        return null;
    }

    public Double getResultAsNumber() {
        return EcmaScript.toNumberAs2(this.getResult());
    }

    public String getResultAsString() {
        return EcmaScript.toString(this.getResult());
    }

    public Boolean getResultAsBoolean() {
        return EcmaScript.toBoolean(this.getResult());
    }

    public String toStringNoQuotes(LocalData localData) {
        try {
            HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
            this.toStringNoQuotes(writer, localData);
            writer.finishHilights();
            return writer.toString();
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
    }

    public GraphTextWriter toStringNoQuotes(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.startOffset(this.src, this.getLineStartItem(), this.getPos(), this.srcData);
        this.appendToNoQuotes(writer, localData);
        writer.endOffset();
        return writer;
    }

    public GraphTextWriter appendToNoQuotes(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.toString(writer, localData);
    }

    public GraphTargetItem getNotCoerced() {
        return this;
    }

    public GraphTargetItem getNotCoercedNoDup() {
        return this.getNotCoerced();
    }

    public GraphTargetItem getThroughRegister() {
        return this;
    }

    public boolean needsNewLine() {
        return false;
    }

    public boolean handlesNewLine() {
        return false;
    }

    public boolean hasSingleNewLineAround() {
        return false;
    }

    public GraphTextWriter toStringNL(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.startOffset(this.src, this.getLineStartItem(), this.getPos(), this.srcData);
        this.appendTry(writer, localData);
        if (this.needsNewLine()) {
            writer.newLine();
        }
        writer.endOffset();
        return writer;
    }

    public boolean isEmpty() {
        return false;
    }

    public GraphTargetItem getThroughNotCompilable() {
        return this;
    }

    public GraphTargetItem getThroughDuplicate() {
        return this;
    }

    public boolean valueEquals(GraphTargetItem target) {
        return this.equals(target);
    }

    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return new ArrayList<GraphSourceItem>();
    }

    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (!this.hasReturnValue()) {
            return this.toSource(localData, generator);
        }
        return generator.generateDiscardValue(localData, this);
    }

    protected List<GraphSourceItem> toSourceBinary(BinaryOp op, GraphSourceItem action) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        return ret;
    }

    public static List<GraphSourceItem> toSourceMerge(SourceGeneratorLocalData localData, SourceGenerator gen, Object ... tar) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        for (Object o : tar) {
            if (o == null) continue;
            if (o instanceof GraphTargetItem) {
                ret.addAll(((GraphTargetItem)o).toSource(localData, gen));
            }
            if (o instanceof GraphSourceItem) {
                ret.add((GraphSourceItem)o);
            }
            if (!(o instanceof List)) continue;
            List l = (List)o;
            for (Object o2 : l) {
                if (o2 instanceof GraphSourceItem) {
                    ret.add((GraphSourceItem)o2);
                }
                if (!(o2 instanceof GraphTargetItem)) continue;
                ret.addAll(((GraphTargetItem)o2).toSource(localData, gen));
            }
        }
        return ret;
    }

    public abstract boolean hasReturnValue();

    public List<GraphTargetItem> getAllSubItems() {
        final ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        this.visit(new AbstractGraphTargetVisitor(this){
            final /* synthetic */ GraphTargetItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visit(GraphTargetItem item) {
                if (item != null) {
                    ret.add(item);
                }
                return true;
            }
        });
        return ret;
    }

    public Set<GraphTargetItem> getAllSubItemsRecursively() {
        final HashSet<GraphTargetItem> ret = new HashSet<GraphTargetItem>();
        this.visitRecursively(new AbstractGraphTargetVisitor(this){
            final /* synthetic */ GraphTargetItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visit(GraphTargetItem item) {
                ret.add(item);
                return true;
            }
        });
        return ret;
    }

    public final void visitRecursively(final GraphTargetVisitorInterface visitor) {
        final LinkedIdentityHashSet visitedItems = new LinkedIdentityHashSet();
        this.visit(new AbstractGraphTargetVisitor(this){
            final /* synthetic */ GraphTargetItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visit(GraphTargetItem item) {
                if (item != null && !visitedItems.contains(item)) {
                    visitedItems.add(item);
                    if (visitor.visit(item)) {
                        item.visit(this);
                    }
                }
                return true;
            }
        });
    }

    public final void visitRecursivelyNoBlock(final GraphTargetRecursiveVisitorInterface visitor) {
        final HashSet visitedItems = new HashSet();
        final Stack<GraphTargetItem> parentStack = new Stack<GraphTargetItem>();
        parentStack.add(this);
        this.visitNoBlock(new AbstractGraphTargetVisitor(this){
            final /* synthetic */ GraphTargetItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean visit(GraphTargetItem item) {
                if (item != null && !visitedItems.contains(item)) {
                    visitedItems.add(item);
                    visitor.visit(item, parentStack);
                    parentStack.push(item);
                    item.visitNoBlock(this);
                    parentStack.pop();
                }
                return true;
            }
        });
    }

    public void visit(GraphTargetVisitorInterface visitor) {
        if (this.value != null) {
            visitor.visit(this.value);
        }
    }

    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
        this.visit(visitor);
    }

    public abstract GraphTargetItem returnType();

    public GraphTargetItem clone() {
        try {
            return (GraphTargetItem)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public GraphTargetItem invert(GraphSourceItem src) {
        return new NotItem(this.dialect, src, this.getLineStartItem(), this);
    }

    public GraphTextWriter appendCommands(GraphTargetItem prevLineItem, GraphTextWriter writer, LocalData localData, List<GraphTargetItem> commands, boolean asBlock) throws InterruptedException {
        int prevLine;
        boolean useLineInfo = false;
        int n = prevLine = prevLineItem == null ? 0 : prevLineItem.getLine();
        if (asBlock) {
            writer.startBlock();
        }
        boolean first = true;
        for (GraphTargetItem ti : commands) {
            if (ti.isEmpty()) continue;
            if (!first) {
                writer.newLine();
            }
            prevLine = ti.getLine();
            first = false;
            ti.toStringSemicoloned(writer, localData);
        }
        if (asBlock) {
            if (!first) {
                writer.newLine();
            }
            writer.endBlock();
        }
        return writer;
    }

    public GraphTextWriter appendBlock(GraphTargetItem prevLineItem, GraphTextWriter writer, LocalData localData, List<GraphTargetItem> commands) throws InterruptedException {
        this.appendCommands(prevLineItem, writer, localData, commands, true);
        return writer;
    }

    public long getAsLong() {
        return 0L;
    }

    public boolean isIdentical(GraphTargetItem other) {
        return this == other;
    }

    public static boolean objectsValueEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof GraphTargetItem && o2 instanceof GraphTargetItem) {
            GraphTargetItem gt1 = (GraphTargetItem)o1;
            GraphTargetItem gt2 = (GraphTargetItem)o2;
            return gt1.valueEquals(gt2);
        }
        if (o1 instanceof List && o2 instanceof List) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (GraphTargetItem.objectsValueEquals(l1.get(i), l2.get(i))) continue;
                return false;
            }
        }
        return o1.equals(o2);
    }

    public static void checkDup(TranslateStack stack, List<GraphTargetItem> output, GraphTargetItem dupSource, GraphTargetItem dup) {
        if (output.isEmpty()) {
            return;
        }
        if (!(output.get(output.size() - 1) instanceof SetTemporaryItem)) {
            return;
        }
        if (!((dupSource = dupSource.getNotCoercedNoDup()) instanceof DuplicateSourceItem)) {
            return;
        }
        if (!((dup = dup.getNotCoercedNoDup()) instanceof DuplicateItem)) {
            return;
        }
        DuplicateSourceItem ds = (DuplicateSourceItem)dupSource;
        DuplicateItem d = (DuplicateItem)dup;
        SetTemporaryItem st = (SetTemporaryItem)output.get(output.size() - 1);
        if (ds.tempIndex != d.tempIndex || d.tempIndex != st.tempIndex) {
            return;
        }
        output.remove(output.size() - 1);
        stack.moveToStack(output);
    }

    public static int checkDup2(GraphTargetItem item1, GraphTargetItem item2, List<GraphTargetItem> output, TranslateStack stack) {
        SetTemporaryItem st;
        if (item1 == item2) {
            return -1;
        }
        if (!(item1 instanceof DuplicateSourceItem && item2 instanceof DuplicateItem || item1 instanceof DuplicateItem && item2 instanceof DuplicateSourceItem)) {
            return -2;
        }
        if (((HasTempIndex)((Object)item1)).getTempIndex() != ((HasTempIndex)((Object)item2)).getTempIndex()) {
            return -2;
        }
        if (!output.isEmpty() && output.get(output.size() - 1) instanceof SetTemporaryItem && (st = (SetTemporaryItem)output.get(output.size() - 1)).getTempIndex() == ((HasTempIndex)((Object)item1)).getTempIndex()) {
            output.remove(output.size() - 1);
            stack.moveToStack(output);
        }
        return ((HasTempIndex)((Object)item1)).getTempIndex();
    }
}

