/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetDialect;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class CommaExpressionItem
extends GraphTargetItem {
    public List<GraphTargetItem> commands;

    public CommaExpressionItem(GraphTargetDialect dialect, GraphSourceItem src, GraphSourceItem lineStartIns, List<GraphTargetItem> commands) {
        super(dialect, src, lineStartIns, 16);
        this.commands = commands;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.commands);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.commands.isEmpty()) {
            return writer;
        }
        writer.append("(");
        this.appendNoParenthesis(writer, localData);
        writer.append(")");
        return writer;
    }

    @Override
    public GraphTextWriter appendNoParenthesis(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean first = true;
        for (GraphTargetItem t : this.commands) {
            if (t.isEmpty()) continue;
            if (!first) {
                writer.allowWrapHere().append(",");
            }
            t.toString(writer, localData);
            first = false;
        }
        return writer;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this, true);
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this, false);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return this.commands.isEmpty() ? TypeItem.UNBOUNDED : this.commands.get(this.commands.size() - 1).returnType();
    }
}

