/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.helpers.MemoryInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FakeMemoryInputStream
extends MemoryInputStream {
    private long pos;
    private final int maxLength = Integer.MAX_VALUE;
    private final InputStream is;

    public FakeMemoryInputStream(InputStream is) throws IOException {
        super(new byte[0]);
        this.is = is;
    }

    @Override
    public byte[] getAllRead() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek to negative position");
        }
        this.pos = pos;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.seek(0L);
    }

    @Override
    public int read() throws IOException {
        if (this.pos < (long)this.maxLength) {
            ++this.pos;
            return this.is.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.pos < (long)this.maxLength) {
            int readCount = this.is.read(bytes);
            this.pos += (long)readCount;
            return readCount;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }
}

