/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.types.FieldChangeObserver;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectionTools {
    private static final Logger logger = Logger.getLogger(ReflectionTools.class.getName());

    public static <E> Map<E, String> getConstNamesMap(Class<?> classWithConsts, Class<E> constsType, String matchRegexp) {
        HashMap<Object, String> ret = new HashMap<Object, String>();
        Field[] fs = classWithConsts.getDeclaredFields();
        Pattern p = Pattern.compile(matchRegexp);
        for (Field f : fs) {
            Matcher m = p.matcher(f.getName());
            if (!m.matches()) continue;
            try {
                String name = m.groupCount() > 0 ? m.group(1) : m.group(0);
                Object val = f.get(constsType);
                StringBuilder identName = new StringBuilder();
                boolean cap = false;
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (c == '_') {
                        cap = true;
                        continue;
                    }
                    if (cap) {
                        identName.append(c);
                        cap = false;
                        continue;
                    }
                    identName.append(Character.toLowerCase(c));
                }
                ret.put(val, identName.toString());
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Object getValue(Object obj, Field field) throws IllegalArgumentException, IllegalAccessException {
        Object value = field.get(obj);
        return value;
    }

    public static Object getValue(Object obj, Field field, int index) throws IllegalArgumentException, IllegalAccessException {
        if (index == -1) {
            return ReflectionTools.getValue(obj, field);
        }
        if (ReflectionTools.getFieldSubSize(obj, field) <= index) {
            return null;
        }
        Object value = field.get(obj);
        if (List.class.isAssignableFrom(field.getType())) {
            return ((List)value).get(index);
        }
        if (field.getType().isArray()) {
            return Array.get(value, index);
        }
        return value;
    }

    public static boolean needsIndex(Field field) {
        if (List.class.isAssignableFrom(field.getType())) {
            return true;
        }
        return field.getType().isArray();
    }

    public static int getFieldSubSize(Object obj, Field field) {
        Object val;
        try {
            val = field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return 0;
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return ((List)val).size();
        }
        if (field.getType().isArray()) {
            return Array.getLength(val);
        }
        return 0;
    }

    private static void notifyFieldChanged(Object obj, Field field) {
        if (obj != null && obj instanceof FieldChangeObserver) {
            ((FieldChangeObserver)obj).fieldChanged(field);
        }
    }

    public static void setValue(Object obj, Field field, Object newValue) throws IllegalArgumentException, IllegalAccessException {
        field.set(obj, newValue);
        ReflectionTools.notifyFieldChanged(obj, field);
    }

    public static void setValue(Object obj, Field field, int index, Object newValue) throws IllegalArgumentException, IllegalAccessException {
        if (index == -1) {
            ReflectionTools.setValue(obj, field, newValue);
            return;
        }
        Object value = field.get(obj);
        if (ReflectionTools.needsIndex(field) && index >= ReflectionTools.getFieldSubSize(obj, field)) {
            return;
        }
        if (List.class.isAssignableFrom(field.getType())) {
            ((List)value).set(index, newValue);
        } else if (field.getType().isArray()) {
            Array.set(value, index, newValue);
        } else {
            field.set(obj, newValue);
            ReflectionTools.notifyFieldChanged(obj, field);
        }
    }

    public static boolean canInstantiate(Class cls) {
        if (cls.isInterface()) {
            return false;
        }
        return !Modifier.isAbstract(cls.getModifiers());
    }

    public static boolean canInstantiateDefaultConstructor(Class<?> cls) {
        if (!ReflectionTools.canInstantiate(cls)) {
            return false;
        }
        try {
            cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
        return true;
    }

    public static boolean canAddToField(Object object, Field field) {
        if (List.class.isAssignableFrom(field.getType())) {
            ParameterizedType listType = (ParameterizedType)field.getGenericType();
            Class parameterClass = (Class)listType.getActualTypeArguments()[0];
            return ReflectionTools.canInstantiate(parameterClass);
        }
        if (field.getType().isArray()) {
            Object arrValue;
            try {
                arrValue = field.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.log(Level.SEVERE, null, ex);
                return false;
            }
            Class<?> componentClass = arrValue.getClass().getComponentType();
            if (componentClass.isPrimitive()) {
                return true;
            }
            return ReflectionTools.canInstantiate(componentClass);
        }
        return false;
    }

    public static Object newInstanceOf(Class<?> cls) throws InstantiationException, IllegalAccessException {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return 0;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return 0.0;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return 0L;
        }
        if (cls.isInterface()) {
            return null;
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            return null;
        }
        try {
            return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(ReflectionTools.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static boolean addToList(Object object, Field field, int index, Class<?> cls) {
        List list;
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        try {
            list = (List)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        ParameterizedType listType = (ParameterizedType)field.getGenericType();
        Class<?> parameterClass = (Class<?>)listType.getActualTypeArguments()[0];
        try {
            Object val = ReflectionTools.newInstanceOf(cls == null ? parameterClass : cls);
            if (val == null) {
                return false;
            }
            list.add(index, val);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public static Class<?> getFieldSubType(Object object, Field field) {
        if (field.getType().isArray()) {
            try {
                Object arrValue = field.get(object);
                return arrValue.getClass().getComponentType();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                return null;
            }
        }
        if (List.class.isAssignableFrom(field.getType())) {
            ParameterizedType listType = (ParameterizedType)field.getGenericType();
            return (Class)listType.getActualTypeArguments()[0];
        }
        return null;
    }

    public static boolean addToArray(Object object, Field field, int index, boolean notnull, Class<?> cls) {
        int i;
        Object arrValue;
        if (!field.getType().isArray()) {
            return false;
        }
        try {
            arrValue = field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        Class<?> componentClass = arrValue.getClass().getComponentType();
        Object val = null;
        if (!componentClass.isPrimitive()) {
            try {
                val = ReflectionTools.newInstanceOf(cls == null ? componentClass : cls);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                logger.log(Level.SEVERE, null, ex);
                return false;
            }
            if (val == null) {
                return false;
            }
        }
        int originalSize = Array.getLength(arrValue);
        Object copy = Array.newInstance(componentClass, originalSize + 1);
        for (i = 0; i < index; ++i) {
            Array.set(copy, i, Array.get(arrValue, i));
        }
        if (val != null) {
            Array.set(copy, index, val);
        }
        for (i = index; i < originalSize; ++i) {
            Array.set(copy, i + 1, Array.get(arrValue, i));
        }
        try {
            field.set(object, copy);
            ReflectionTools.notifyFieldChanged(object, field);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public static boolean addToField(Object object, Field field, int index, boolean notnull, Class<?> cls) {
        if (List.class.isAssignableFrom(field.getType())) {
            return ReflectionTools.addToList(object, field, index, cls);
        }
        if (field.getType().isArray()) {
            return ReflectionTools.addToArray(object, field, index, notnull, cls);
        }
        return false;
    }

    public static boolean removeFromField(Object object, Field field, int index) {
        if (List.class.isAssignableFrom(field.getType())) {
            return ReflectionTools.removeFromList(object, field, index);
        }
        if (field.getType().isArray()) {
            return ReflectionTools.removeFromArray(object, field, index);
        }
        return false;
    }

    public static boolean removeFromList(Object object, Field field, int index) {
        List list;
        try {
            list = (List)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        if (index < 0 || index >= list.size()) {
            return false;
        }
        list.remove(index);
        return true;
    }

    public static boolean removeFromArray(Object object, Field field, int index) {
        int i;
        Object arrValue;
        try {
            arrValue = field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        Class<?> componentClass = arrValue.getClass().getComponentType();
        int originalSize = Array.getLength(arrValue);
        Object copy = Array.newInstance(componentClass, originalSize - 1);
        int pos = 0;
        for (i = 0; i < index; ++i) {
            Array.set(copy, pos, Array.get(arrValue, i));
            ++pos;
        }
        for (i = index + 1; i < originalSize; ++i) {
            Array.set(copy, pos, Array.get(arrValue, i));
            ++pos;
        }
        try {
            field.set(object, copy);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    public static List<Field> getSwfFields(Class cls) {
        Field[] fields;
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field f : fields = cls.getFields()) {
            Internal inter;
            if (Modifier.isStatic(f.getModifiers()) || (inter = f.getAnnotation(Internal.class)) != null) continue;
            result.add(f);
        }
        for (Field f : fields = cls.getDeclaredFields()) {
            SWFField swfField;
            if (Modifier.isStatic(f.getModifiers()) || !Modifier.isPrivate(f.getModifiers()) || (swfField = f.getAnnotation(SWFField.class)) == null) continue;
            result.add(f);
        }
        return result;
    }
}

