/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class SerializableImage
implements Serializable {
    public static int TYPE_INT_ARGB = 2;
    public static int TYPE_INT_RGB = 1;
    public static int TYPE_INT_ARGB_PRE = 3;
    public static int TYPE_4BYTE_ABGR = 6;
    private BufferedImage image;
    private transient Graphics graphics;

    private SerializableImage() {
    }

    public SerializableImage(BufferedImage image) {
        this.image = image;
    }

    public SerializableImage(int width, int height, int imageType) {
        this.image = new BufferedImage(width, height, imageType);
    }

    public SerializableImage(int width, int height, int imageType, int[] pixels) {
        if (imageType != 3 && imageType != 1) {
            throw new Error("Unsupported image type: " + imageType);
        }
        this.image = new BufferedImage(width, height, imageType);
        this.image.getRaster().setDataElements(0, 0, width, height, pixels);
    }

    public SerializableImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        this.image = new BufferedImage(cm, raster, isRasterPremultiplied, properties);
    }

    public SerializableImage(int width, int height, int imageType, IndexColorModel cm) {
        this.image = new BufferedImage(width, height, imageType, cm);
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public BufferedImage getCompatibleBufferedImage() {
        BufferedImage img = this.getBufferedImage();
        if (GraphicsEnvironment.isHeadless()) {
            return img;
        }
        GraphicsConfiguration conf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (img.getColorModel().equals(conf.getColorModel())) {
            return img;
        }
        BufferedImage img2 = conf.createCompatibleImage(img.getWidth(), img.getHeight(), img.getTransparency());
        Graphics2D g2d = img2.createGraphics();
        g2d.drawImage((Image)img, 0, 0, null);
        return img2;
    }

    public void fillTransparent() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected Object clone() throws CloneNotSupportedException {
        SerializableImage retImage = new SerializableImage();
        retImage.image = this.image;
        return retImage;
    }

    public Graphics getGraphics() {
        if (this.graphics != null) {
            return this.graphics;
        }
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics = g;
        return this.graphics;
    }

    public int getType() {
        return this.image.getType();
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public int getRGB(int i, int i1) {
        return this.image.getRGB(i, i1);
    }

    public synchronized void setRGB(int i, int i1, int i2) {
        this.image.setRGB(i, i1, i2);
    }

    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    public WritableRaster getRaster() {
        return this.image.getRaster();
    }

    public String toString() {
        return this.image.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            ImageHelper.write(this.image, ImageFormat.PNG, out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.image = ImageHelper.read(in);
    }
}

