/*
 * Decompiled with CFR 0.152.
 */
package natorder;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class NaturalOrderComparator
implements Comparator {
    int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = NaturalOrderComparator.charAt(a, ia);
            char cb = NaturalOrderComparator.charAt(b, ib);
            if (!NaturalOrderComparator.isDigit(ca) && !NaturalOrderComparator.isDigit(cb)) {
                return bias;
            }
            if (!NaturalOrderComparator.isDigit(ca)) {
                return -1;
            }
            if (!NaturalOrderComparator.isDigit(cb)) {
                return 1;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            if (bias == 0) {
                if (ca < cb) {
                    bias = -1;
                } else if (ca > cb) {
                    bias = 1;
                }
            }
            ++ia;
            ++ib;
        }
    }

    public int compare(Object o1, Object o2) {
        String a = o1.toString();
        String b = o2.toString();
        int ia = 0;
        int ib = 0;
        int nza = 0;
        int nzb = 0;
        while (true) {
            int bias;
            nzb = 0;
            nza = 0;
            char ca = NaturalOrderComparator.charAt(a, ia);
            char cb = NaturalOrderComparator.charAt(b, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = NaturalOrderComparator.charAt(a, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = NaturalOrderComparator.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (bias = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return bias;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return NaturalOrderComparator.compareEqual(a, b, nza, nzb);
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    static boolean isDigit(char c) {
        return Character.isDigit(c) || c == '.' || c == ',';
    }

    static char charAt(String s, int i) {
        return i >= s.length() ? (char)'\u0000' : s.charAt(i);
    }

    static int compareEqual(String a, String b, int nza, int nzb) {
        if (nza - nzb != 0) {
            return nza - nzb;
        }
        if (a.length() == b.length()) {
            return a.compareTo(b);
        }
        return a.length() - b.length();
    }

    public static void main(String[] args) {
        String[] strings = new String[]{"1-2", "1-02", "1-20", "10-20", "fred", "jane", "pic01", "pic2", "pic02", "pic02a", "pic3", "pic4", "pic 4 else", "pic 5", "pic05", "pic 5", "pic 5 something", "pic 6", "pic   7", "pic100", "pic100a", "pic120", "pic121", "pic02000", "tom", "x2-g8", "x2-y7", "x2-y08", "x8-y8"};
        List<String> orig = Arrays.asList(strings);
        System.out.println("Original: " + orig);
        List<String> scrambled = Arrays.asList(strings);
        Collections.shuffle(scrambled);
        System.out.println("Scrambled: " + scrambled);
        Collections.sort(scrambled, new NaturalOrderComparator());
        System.out.println("Sorted: " + scrambled);
        NaturalOrderComparator.shuffle3000(scrambled);
        NaturalOrderComparator.compareSymmetric();
        NaturalOrderComparator.floatsWithCommas();
    }

    static void shuffle3000(List<? extends Object> scrambled) {
        Collections.shuffle(scrambled, new Random(3000L));
        Collections.sort(scrambled, new NaturalOrderComparator());
        System.out.println("Sorted: " + scrambled);
    }

    static void compareSymmetric() {
        NaturalOrderComparator naturalOrderComparator = new NaturalOrderComparator();
        int compare1 = naturalOrderComparator.compare("1-2", "1-02");
        int compare2 = naturalOrderComparator.compare("1-02", "1-2");
        System.out.println(compare1 + " == " + compare2);
        compare1 = naturalOrderComparator.compare("pic 5", "pic05");
        compare2 = naturalOrderComparator.compare("pic05", "pic 5");
        System.out.println(compare1 + " == " + compare2);
    }

    static void floatsWithCommas() {
        List<String> unSorted = Arrays.asList("0.9", "1.0c", "1.2", "1.3", "0.6", "1.1", "0.7", "0.3", "1.0b", "1.0", "0.8");
        System.out.println("Unsorted: " + unSorted);
        unSorted.sort(new NaturalOrderComparator());
        System.out.println("Sorted: " + unSorted);
    }
}

