/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

import com.jpexs.images.apng.AnimatedPngDecoder;
import com.jpexs.images.apng.data.AnimatedPngData;
import com.jpexs.images.apng.data.AnimationFrameData;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;

public class AnimatedPngIcon
implements Icon {
    private final AnimatedPngData apng;
    private final CopyOnWriteArrayList<WeakReference<Component>> hosts = new CopyOnWriteArrayList();
    private Timer timer;
    private int currentFrame = 0;
    private Long startTime = null;
    private int remainingNumPlays;

    public AnimatedPngIcon(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            this.apng = AnimatedPngDecoder.decode(fis);
        }
    }

    public AnimatedPngIcon(InputStream is) throws IOException {
        this.apng = AnimatedPngDecoder.decode(is);
    }

    public AnimatedPngIcon(AnimatedPngData apng) throws IOException {
        this.apng = apng;
    }

    @Override
    public int getIconWidth() {
        return this.apng.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.apng.getHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage img = this.apng.hasFrames() ? this.apng.getFrame(this.currentFrame).getImage() : this.apng.getBackupImage();
        g.drawImage(img, x, y, null);
        if (this.apng.getFrameCount() > 1) {
            this.registerHost(c);
            this.ensureRunning();
        }
    }

    private void registerHost(Component c) {
        for (WeakReference<Component> ref : this.hosts) {
            Component existing = (Component)ref.get();
            if (existing != c) continue;
            return;
        }
        this.hosts.add(new WeakReference<Component>(c));
    }

    private void ensureRunning() {
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    AnimatedPngIcon.this.onTick();
                }
            }, 20L, 20L);
        }
    }

    private void onTick() {
        if (this.startTime == null) {
            this.startTime = System.currentTimeMillis();
            this.currentFrame = 0;
            this.remainingNumPlays = this.apng.getNumPlays() == 0 ? -1 : this.apng.getNumPlays();
        }
        long currentTime = System.currentTimeMillis();
        long currentDelay = currentTime - this.startTime;
        int f = 0;
        long t = 0L;
        int newFrame = -1;
        for (AnimationFrameData fr : this.apng.getFrames()) {
            long d = fr.getDelayInMs();
            if (currentDelay >= t && currentDelay <= t + d) {
                newFrame = f;
                break;
            }
            t += d;
            ++f;
        }
        if (newFrame < 0) {
            if (this.remainingNumPlays > 0) {
                --this.remainingNumPlays;
            }
            if (this.remainingNumPlays == -1 || this.remainingNumPlays > 0) {
                newFrame = 0;
                this.startTime = currentTime;
            } else {
                return;
            }
        }
        this.currentFrame = newFrame;
        boolean anyAlive = false;
        for (WeakReference<Component> ref : this.hosts) {
            Component host = (Component)ref.get();
            if (host == null) {
                this.hosts.remove(ref);
                continue;
            }
            if (!host.isDisplayable()) {
                this.hosts.remove(ref);
                continue;
            }
            anyAlive = true;
            host.repaint();
        }
        if (!anyAlive) {
            this.stop();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

