/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng;

import com.jpexs.images.apng.Crc;
import com.jpexs.images.apng.chunks.Actl;
import com.jpexs.images.apng.chunks.Chunk;
import com.jpexs.images.apng.chunks.Fctl;
import com.jpexs.images.apng.chunks.Fdat;
import com.jpexs.images.apng.chunks.Idat;
import com.jpexs.images.apng.chunks.Iend;
import com.jpexs.images.apng.chunks.Ihdr;
import com.jpexs.images.apng.chunks.Plte;
import com.jpexs.images.apng.chunks.Text;
import com.jpexs.images.apng.chunks.Trns;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class PngInputStream
extends InputStream {
    private final InputStream is;

    public PngInputStream(InputStream is) {
        this.is = is;
    }

    public long readUnsignedInt() throws IOException {
        long ret = (this.readUnsignedByte() << 24) + (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
        return ret & 0xFFFFFFFFL;
    }

    public int readUnsignedShort() throws IOException {
        return (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public int readUnsignedByte() throws IOException {
        int ret = this.read();
        if (ret == -1) {
            throw new EOFException();
        }
        return ret;
    }

    public byte[] readBytes(int number) throws IOException {
        byte[] buffer = new byte[number];
        for (int pos = 0; pos < number; pos += this.is.read(buffer, pos, number - pos)) {
        }
        return buffer;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    public Chunk readChunk() throws IOException {
        Chunk ret;
        long calculatedCrc;
        long length = this.readUnsignedInt();
        byte[] chunkTypeBytes = this.readBytes(4);
        String chunkType = new String(chunkTypeBytes, StandardCharsets.US_ASCII);
        byte[] chunkData = length == 0L ? new byte[]{} : this.readBytes((int)length);
        long crc = this.readUnsignedInt();
        if (crc != (calculatedCrc = Crc.calculate(chunkTypeBytes, chunkData))) {
            throw new IOException("Invalid CRC value: " + calculatedCrc + " expected but " + crc + " found in chunk of type " + chunkType);
        }
        switch (chunkType) {
            case "IHDR": {
                ret = new Ihdr(chunkData);
                break;
            }
            case "IDAT": {
                ret = new Idat(chunkData);
                break;
            }
            case "PLTE": {
                ret = new Plte(chunkData);
                break;
            }
            case "IEND": {
                ret = new Iend(chunkData);
                break;
            }
            case "tRNS": {
                ret = new Trns(chunkData);
                break;
            }
            case "acTL": {
                ret = new Actl(chunkData);
                break;
            }
            case "fcTL": {
                ret = new Fctl(chunkData);
                break;
            }
            case "fdAT": {
                ret = new Fdat(chunkData);
                break;
            }
            case "tEXt": {
                ret = new Text(chunkData);
                break;
            }
            default: {
                ret = new Chunk(chunkType, chunkData);
            }
        }
        ret.parseData();
        return ret;
    }

    public List<Chunk> readChunkList() throws IOException {
        Chunk chunk;
        ArrayList<Chunk> ret = new ArrayList<Chunk>();
        do {
            chunk = this.readChunk();
            ret.add(chunk);
        } while (!(chunk instanceof Iend));
        return ret;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }
}

