/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng.chunks;

import com.jpexs.images.apng.PngInputStream;
import com.jpexs.images.apng.PngOutputStream;
import com.jpexs.images.apng.chunks.Chunk;
import java.io.IOException;

public class Actl
extends Chunk {
    public static final String TYPE = "acTL";
    private long numFrames;
    private long numPlays;

    public Actl(byte[] data) {
        super(TYPE, data);
    }

    public Actl(long numFrames, long numPlays) {
        super(TYPE);
        this.create(numFrames, numPlays);
    }

    private void create(long numFrames, long numPlays) {
        if (numFrames == 0L) {
            throw new IllegalArgumentException("Invalid numFrames 0");
        }
        this.numFrames = numFrames;
        this.numPlays = numPlays;
    }

    @Override
    public void parseData(PngInputStream pis) throws IOException {
        long numFrames = pis.readUnsignedInt();
        long numPlays = pis.readUnsignedInt();
        this.create(numFrames, numPlays);
    }

    @Override
    public void writeData(PngOutputStream os) throws IOException {
        os.writeUnsignedInt(this.numFrames);
        os.writeUnsignedInt(this.numPlays);
    }

    @Override
    public String toString() {
        return "[acTL numFrames=" + this.numFrames + " numPlays=" + this.numPlays + "]";
    }

    public long getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(long numFrames) {
        this.numFrames = numFrames;
    }

    public long getNumPlays() {
        return this.numPlays;
    }

    public void setNumPlays(long numPlays) {
        this.numPlays = numPlays;
    }
}

