/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.images.apng.data;

import com.jpexs.images.apng.data.AnimationFrameData;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnimatedPngData {
    private int width;
    private int height;
    private int numPlays;
    private BufferedImage backupImage;
    private List<AnimationFrameData> frames = new ArrayList<AnimationFrameData>();

    public AnimatedPngData(int width, int height, int numPlays, BufferedImage backupImage) {
        this(width, height, numPlays, backupImage, new ArrayList<AnimationFrameData>());
    }

    public AnimatedPngData(int width, int height, int numPlays, BufferedImage backupImage, List<AnimationFrameData> frames) {
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid width " + width);
        }
        if (height <= 0) {
            throw new IllegalArgumentException("Invalid height " + height);
        }
        this.width = width;
        this.height = height;
        this.numPlays = numPlays;
        this.backupImage = backupImage;
        this.frames = new ArrayList<AnimationFrameData>(frames);
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public List<AnimationFrameData> getFrames() {
        return new ArrayList<AnimationFrameData>(this.frames);
    }

    public void setFrames(List<AnimationFrameData> frames) {
        this.frames = new ArrayList<AnimationFrameData>(frames);
    }

    public boolean hasFrames() {
        return !this.frames.isEmpty();
    }

    public void addFrame(AnimationFrameData chunk) {
        this.frames.add(chunk);
    }

    public void addAllFrames(Collection<? extends AnimationFrameData> chunk) {
        this.frames.addAll(chunk);
    }

    public void addAllFrames(int index, Collection<? extends AnimationFrameData> chunk) {
        this.frames.addAll(index, chunk);
    }

    public void addFrame(int index, AnimationFrameData chunk) {
        this.frames.add(index, chunk);
    }

    public AnimationFrameData getFrame(int index) {
        return this.frames.get(index);
    }

    public AnimationFrameData removeFrame(int index) {
        return this.frames.remove(index);
    }

    public void clearFrames() {
        this.frames.clear();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getNumPlays() {
        return this.numPlays;
    }

    public void setNumPlays(int numPlays) {
        this.numPlays = numPlays;
    }

    public BufferedImage getBackupImage() {
        return this.backupImage;
    }

    public void setBackupImage(BufferedImage backupImage) {
        this.backupImage = backupImage;
    }
}

