/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class ByteArray<T extends ByteArray<T>> {
    private static final int COPY_BUFFER_SIZE = 8192;
    private boolean bound;
    private int storageLength;
    private int filledLength;
    private boolean growable;

    protected ByteArray(int n, int n2, boolean bl) {
        this.storageLength = n2;
        this.setFilledLength(n);
        this.growable = bl;
    }

    protected ByteArray(int n, int n2) {
        this(n, n2, false);
    }

    public int get(int n) {
        if (n < 0 || n >= this.filledLength) {
            return -1;
        }
        return this.internalGet(n) & 0xFF;
    }

    public int get(int n, byte[] byArray) {
        return this.get(n, byArray, 0, byArray.length);
    }

    public int get(int n, byte[] byArray, int n2, int n3) {
        if (n < 0 || n >= this.filledLength) {
            return 0;
        }
        int n4 = Math.min(n3, this.filledLength - n);
        return this.internalGet(n, byArray, n2, n4);
    }

    public int length() {
        return this.filledLength;
    }

    public int size() {
        return this.storageLength;
    }

    public final boolean growable() {
        return this.growable;
    }

    public int setFilledLength(int n) {
        this.filledLength = Math.min(n, this.storageLength);
        return this.filledLength;
    }

    public void put(int n, byte by) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("Attempt to write outside the bounds of the data.");
        }
        this.internalPut(n, by);
        this.filledLength = Math.max(this.filledLength, n + 1);
    }

    public int put(int n, byte[] byArray) {
        return this.put(n, byArray, 0, byArray.length);
    }

    public int put(int n, byte[] byArray, int n2, int n3) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException("Attempt to write outside the bounds of the data.");
        }
        int n4 = Math.min(n3, this.size() - n);
        int n5 = this.internalPut(n, byArray, n2, n4);
        this.filledLength = Math.max(this.filledLength, n + n5);
        return n5;
    }

    public int copyTo(ByteArray<? extends ByteArray<?>> byteArray) {
        return this.copyTo(byteArray, 0, this.length());
    }

    public int copyTo(ByteArray<? extends ByteArray<?>> byteArray, int n, int n2) {
        return this.copyTo(0, byteArray, n, n2);
    }

    public int copyTo(int n, ByteArray<? extends ByteArray<?>> byteArray, int n2, int n3) {
        byte[] byArray = new byte[8192];
        int n4 = 0;
        int n5 = 0;
        int n6 = Math.min(byArray.length, n3);
        while ((n4 = this.get(n5 + n2, byArray, 0, n6)) > 0) {
            int n7 = byteArray.put(n5 + n, byArray, 0, n4);
            n5 += n4;
            n6 = Math.min(byArray.length, n3 -= n4);
        }
        return n5;
    }

    public int copyTo(OutputStream outputStream) throws IOException {
        return this.copyTo(outputStream, 0, this.length());
    }

    public int copyTo(OutputStream outputStream, int n, int n2) throws IOException {
        byte[] byArray = new byte[8192];
        int n3 = 0;
        int n4 = 0;
        int n5 = Math.min(byArray.length, n2);
        while ((n3 = this.get(n4 + n, byArray, 0, n5)) > 0) {
            outputStream.write(byArray, 0, n3);
            n5 = Math.min(byArray.length, n2 - (n4 += n3));
        }
        return n4;
    }

    public void copyFrom(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[8192];
        int n2 = 0;
        int n3 = 0;
        int n4 = Math.min(byArray.length, n);
        while ((n2 = inputStream.read(byArray, 0, n4)) > 0) {
            if (this.put(n3, byArray, 0, n2) != n2) {
                throw new IOException("Error writing bytes.");
            }
            n3 += n2;
            n4 = Math.min(byArray.length, n -= n2);
        }
    }

    public void copyFrom(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while ((n = inputStream.read(byArray, 0, n3)) > 0) {
            if (this.put(n2, byArray, 0, n) != n) {
                throw new IOException("Error writing bytes.");
            }
            n2 += n;
        }
    }

    protected abstract void internalPut(int var1, byte var2);

    protected abstract int internalPut(int var1, byte[] var2, int var3, int var4);

    protected abstract int internalGet(int var1);

    protected abstract int internalGet(int var1, byte[] var2, int var3, int var4);

    public abstract void close();

    public String toString(int n, int n2) {
        if (n2 == -1) {
            n2 = this.length();
        }
        n2 = Math.min(n2, this.length());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[l=" + this.filledLength + ", s=" + this.size() + "]");
        if (n2 > 0) {
            stringBuilder.append("\n");
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.get(i + n);
            if (n3 < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(n3));
            stringBuilder.append(" ");
            if (i <= 0 || (i + 1) % 16 != 0) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(0, 0);
    }
}

